/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.swintegrity;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import se.ericsson.cello.configurationversion.file.dependency.proxy.UP_ListProxy;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.file.factory.BackupRestoreDomProxyFactory;
import se.ericsson.cello.configurationversion.verify.base.VerifyException;
import se.ericsson.cello.configurationversion.verify.base.VerifyProperties;
import se.ericsson.cello.configurationversion.verify.swintegrity.ChecksumController;
import se.ericsson.cello.configurationversion.verify.swintegrity.ChecksumErrorLoadModuleInformation;
import se.ericsson.cello.configurationversion.verify.swintegrity.LM_Data;
import se.ericsson.cello.configurationversion.verify.swintegrity.UP_LM_Relation;
import se.ericsson.cello.su.signedsw.SignedSoftwareUtils;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_OseProgramLoadClassValue;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.LM_AndSM_DestFilePathInformation;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageDataContainer;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.file.FileHandler;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SoftwareIntegrityVerifier {
    public SoftwareIntegrityVerifier() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SoftwareIntegrityVerifier()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getCorruptedLoadModules(String string, String string2, Collection collection, Collection collection2) throws VerifyException {
        Collection collection3;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "aPathToRestoreFiles: " + string + "\n\taCV_TmpPath: " + string2 + "\n\taMissingUPs: " + collection);
        }
        ProductDataContainer productDataContainer = null;
        ActivatedTypeOfUP activatedTypeOfUP = null;
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                UP_ListProxy uP_ListProxy = BackupRestoreDomProxyFactory.getInstance().getUP_ListProxy(string);
                productDataContainer = uP_ListProxy.getExecutingUP().getProductDataContainer();
                activatedTypeOfUP = uP_ListProxy.getExecutingUP().getActivatedTypeOfUP();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "theActivatedTypeOfUP: " + activatedTypeOfUP);
                }
                String string3 = SuLib.getUpgradeControlFileName(productDataContainer.getNumber(), productDataContainer.getRevision());
                String string4 = string + "/" + string3;
                DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(productDataContainer.getNumber(), productDataContainer.getRevision(), string4, "LoadModule");
                ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
                LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
                if (activatedTypeOfUP.isSelective() || activatedTypeOfUP.isAdapted()) {
                    productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
                } else if (activatedTypeOfUP.isHW_Sensitive()) {
                    object7 = new HW_SensitiveAdapter();
                    object6 = ((HW_SensitiveAdapter)object7).getRequiredLoadModules(new File(string4), productDataContainer.getNumber(), productDataContainer.getRevision(), activatedTypeOfUP.isDelta());
                    object5 = object6.iterator();
                    object4 = null;
                    while (object5.hasNext()) {
                        object4 = (ProductNumberAndRevision)object5.next();
                        productNumbersAndRevisions.addElement((ProductNumberAndRevision)object4);
                    }
                } else {
                    Trace.error(this.getClass(), "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "\n\ttheActivatedTypeOfUP might be wrong. \n\ttheActivatedTypeOfUP: " + activatedTypeOfUP + "\n\tProductNumbersAndRevisions: " + productNumbersAndRevisions);
                }
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "\n\ttheActivatedTypeOfUP: " + activatedTypeOfUP + "\n\ttheProductNumbersAndRevisions; " + productNumbersAndRevisions);
                }
                object7 = null;
                object6 = null;
                object5 = null;
                object7 = collection.iterator();
                object4 = null;
                ProductNumberAndRevision productNumberAndRevision = null;
                while (object7.hasNext()) {
                    object6 = (UpgradePackageDataContainer)object7.next();
                    object5 = ((UpgradePackageDataContainer)object6).getProductDataContainer();
                    object3 = SuLib.getUpgradeControlFileName(((ProductDataContainer)object5).getNumber(), ((ProductDataContainer)object5).getRevision());
                    object2 = UCF_ParserFacade.parseMainElement(string + "/" + (String)object3 + "Original", "LoadModule");
                    object4 = object2.getLoadModulesProxyInterface().getLoadModuleProxyInterfaces().iterator();
                    while (object4.hasNext()) {
                        object = (LoadModuleProxyInterface)object4.next();
                        productNumberAndRevision = new ProductNumberAndRevision(object.getProductNumber(), object.getProductRevision());
                        productNumbersAndRevisions.removeElement(productNumberAndRevision);
                    }
                }
                object3 = collection2.iterator();
                while (object3.hasNext()) {
                    productNumberAndRevision = (ProductNumberAndRevision)object3.next();
                    productNumbersAndRevisions.removeElement(productNumberAndRevision);
                }
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "FOR UP " + productDataContainer.getNumber() + "_" + productDataContainer.getRevision() + ": " + productNumbersAndRevisions.getElements().size() + " LoadModule(s) need to be checksum and " + collection2.size() + " LoadModule(s) are omitted.");
                    Trace.debug(this.getClass(), 40, "getCorruptedLoadModules(String aPathToRestoreFiles, String aCV_TmpPath, Collection aMissingUPs,  Collection aLoadModulesBeExculded)", "LoadModules need to be checksum: " + productNumbersAndRevisions.getElements().size() + "\n\tLoadModules need to be checksum: " + productNumbersAndRevisions);
                }
                object2 = this.checkSoftwareIntegrity(documentObjectProxyInterface, productNumbersAndRevisions, productDataContainer, string2);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getCorruptedLoadModules(String aPathToRestoreFiles)", "\n\ttheChecksumErrorLoadModuleInformations: " + object2);
                }
                object = this.parseAllUCFs(string, productDataContainer, uP_ListProxy.getBasedOnUPs());
                Collection collection4 = this.identifyUPsForEachListedLM(string, (HashMap)object, (Collection)object2, activatedTypeOfUP, productDataContainer);
                this.releaseSU_DOM((HashMap)object);
                collection3 = collection4;
                Object var24_27 = null;
                if (productDataContainer == null) return collection3;
            }
            catch (VerifyException verifyException) {
                throw verifyException;
            }
            catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
                throw new VerifyException(hW_SensitiveAdapterException.toString());
            }
            catch (ConfigurationVersionException configurationVersionException) {
                throw new VerifyException(configurationVersionException.toString());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "getCorruptedLoadModules(String aPathToRestoreFiles", "\n\taPathToRestoreFiles: " + string + "Throwable caught.", throwable);
                throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetCorruptedLoadModules(String aPathToRestoreFiles" + "\n\taPathToRestoreFiles: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            if (productDataContainer == null) throw throwable;
            try {
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(productDataContainer.getNumber(), productDataContainer.getRevision());
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable throwable) {
            // empty catch block
            return collection3;
        }
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(productDataContainer.getNumber(), productDataContainer.getRevision());
        return collection3;
    }

    private HashMap addLM_ToUP_LM_Relations(HashMap hashMap, ProductDataContainer productDataContainer, LM_Data lM_Data, ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation, ActivatedTypeOfUP activatedTypeOfUP, boolean bl) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLM_ToUP_LM_Relations(HashMap anUP_LM_RelationsMap, ProductDataContainer anUP_productData, LM_Data aCorruptedLM_Data, ChecksumErrorLoadModuleInformation aChecksumErrorLoadModuleInformation, ActivatedTypeOfUP anActivatedTypeOfUP, boolean anIsExecutingUP)", "anUP_LM_RelationsMap: " + hashMap + "\n\tanUP_productData: " + productDataContainer + "\n\taCorruptedLM_Data: " + lM_Data + "\n\taChecksumErrorLoadModuleInformation: " + checksumErrorLoadModuleInformation + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\tanIsExecutingUP: " + bl);
        }
        try {
            UP_LM_Relation uP_LM_Relation = (UP_LM_Relation)hashMap.get(productDataContainer.getNumber() + productDataContainer.getRevision());
            if (uP_LM_Relation != null) {
                this.addLM_ToUP_LM_Relations(uP_LM_Relation, lM_Data, checksumErrorLoadModuleInformation);
            } else {
                UP_LM_Relation uP_LM_Relation2 = new UP_LM_Relation(productDataContainer, activatedTypeOfUP, bl);
                this.addLM_ToUP_LM_Relations(uP_LM_Relation2, lM_Data, checksumErrorLoadModuleInformation);
                hashMap.put(productDataContainer.getNumber() + productDataContainer.getRevision(), uP_LM_Relation2);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addLM_ToUP_LM_Relations(HashMap anUP_LM_RelationsMap, ProductDataContainer anUP_productData, LM_Data aCorruptedLM_Data, ChecksumErrorLoadModuleInformation aChecksumErrorLoadModuleInformation, ActivatedTypeOfUP anActivatedTypeOfUP, boolean anIsExecutingUP)", "anUP_LM_RelationsMap: " + hashMap + "\n\tanUP_productData: " + productDataContainer + "\n\taCorruptedLM_Data: " + lM_Data + "\n\taChecksumErrorLoadModuleInformation: " + checksumErrorLoadModuleInformation + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\tanIsExecutingUP: " + bl + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\taddLM_ToUP_LM_Relations(HashMap anUP_LM_RelationsMap, ProductDataContainer anUP_productData, LM_Data aCorruptedLM_Data, ChecksumErrorLoadModuleInformation aChecksumErrorLoadModuleInformation, ActivatedTypeOfUP anActivatedTypeOfUP, boolean anIsExecutingUP)" + "\n\tanUP_LM_RelationsMap: " + hashMap + "\n\tanUP_productData: " + productDataContainer + "\n\taCorruptedLM_Data: " + lM_Data + "\n\taChecksumErrorLoadModuleInformation: " + checksumErrorLoadModuleInformation + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\tanIsExecutingUP: " + bl + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void addLM_ToUP_LM_Relations(UP_LM_Relation uP_LM_Relation, LM_Data lM_Data, ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation) throws UpgradeablePIU_HandlerException {
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLM_ToUP_LM_Relations(UP_LM_Relation anUP_LM_Relation, LM_Data aCorruptedLM_Data, ChecksumErrorLoadModuleInformation aChecksumErrorLoadModuleInformation)", "anUP_LM_Relation: " + uP_LM_Relation + "\n\taCorruptedLM_Data: " + lM_Data + "\n\taChecksumErrorLoadModuleInformation: " + checksumErrorLoadModuleInformation);
        }
        LM_Data lM_Data2 = lM_Data;
        if (lM_Data.isCriticalForRestore && (checksumErrorLoadModuleInformation.getIsSM_FileMissing() || checksumErrorLoadModuleInformation.getIsSM_ChecksumErrorDetected()) && (upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface()).getSignedUpgradeablePlugInUnits().isEmpty()) {
            if (!checksumErrorLoadModuleInformation.getIsLM_FileMissing() && !checksumErrorLoadModuleInformation.getIsLM_ChecksumErrorDetected()) {
                lM_Data2.isCriticalForRestore = false;
            } else {
                lM_Data2 = new LM_Data(lM_Data.productNumberAndRevision, false, lM_Data.installLMsDestFilePath, lM_Data.installSMsDestFilePath);
            }
        }
        if (checksumErrorLoadModuleInformation.getIsLM_FileMissing()) {
            uP_LM_Relation.addMissingLM(lM_Data);
        } else if (checksumErrorLoadModuleInformation.getIsLM_ChecksumErrorDetected()) {
            if (FileHandler.doesFilesExist(lM_Data.installLMsDestFilePath)) {
                uP_LM_Relation.addCorruptedLM(lM_Data);
            } else {
                uP_LM_Relation.addMissingLM(lM_Data);
            }
        }
        if (checksumErrorLoadModuleInformation.getIsSM_FileMissing()) {
            uP_LM_Relation.addMissingSM(lM_Data2);
        } else if (checksumErrorLoadModuleInformation.getIsSM_ChecksumErrorDetected()) {
            if (FileHandler.doesFilesExist(lM_Data2.installSMsDestFilePath)) {
                uP_LM_Relation.addCorruptedSM(lM_Data2);
            } else {
                uP_LM_Relation.addMissingSM(lM_Data2);
            }
        }
    }

    private Collection checkLMsExistsWhenNoChecksumSpecifiedInUCF(DocumentObjectProxyInterface documentObjectProxyInterface, Collection collection) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkLMsExistsWhenNoChecksumSpecifiedInUCF(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aProductNumberAndRevisionOfLoadModules)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + collection);
        }
        try {
            LinkedList<ChecksumErrorLoadModuleInformation> linkedList = new LinkedList<ChecksumErrorLoadModuleInformation>();
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            Collection collection2 = loadModulesProxyInterface.getDestPathsOfLM_AndSM_FilesWithNoChecksumSpecified(collection);
            Iterator iterator = collection2.iterator();
            LM_AndSM_DestFilePathInformation lM_AndSM_DestFilePathInformation = null;
            ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation = null;
            while (iterator.hasNext()) {
                lM_AndSM_DestFilePathInformation = (LM_AndSM_DestFilePathInformation)iterator.next();
                checksumErrorLoadModuleInformation = this.checkLM_AndSM_FilesExists(documentObjectProxyInterface, lM_AndSM_DestFilePathInformation);
                if (checksumErrorLoadModuleInformation == null) continue;
                linkedList.add(checksumErrorLoadModuleInformation);
            }
            return linkedList;
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkLMsExistsWhenNoChecksumSpecifiedInUCF(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aProductNumberAndRevisionOfLoadModules)", "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + collection + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tcheckLMsExistsWhenNoChecksumSpecifiedInUCF(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aProductNumberAndRevisionOfLoadModules)" + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + collection + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    private ChecksumErrorLoadModuleInformation checkLM_AndSM_FilesExists(DocumentObjectProxyInterface documentObjectProxyInterface, LM_AndSM_DestFilePathInformation lM_AndSM_DestFilePathInformation) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkLM_AndSM_FilesExists(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation);
        }
        try {
            Collection collection;
            ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation = null;
            Collection collection2 = this.getLM_OrSM_DestAbsoluteFilePaths(documentObjectProxyInterface, lM_AndSM_DestFilePathInformation, false);
            if (!FileHandler.doesFilesExist(collection2)) {
                checksumErrorLoadModuleInformation = new ChecksumErrorLoadModuleInformation(lM_AndSM_DestFilePathInformation.getProductNumberAndRevision());
                checksumErrorLoadModuleInformation.setLM_FileIsMissing();
            }
            if (!FileHandler.doesFilesExist(collection = this.getLM_OrSM_DestAbsoluteFilePaths(documentObjectProxyInterface, lM_AndSM_DestFilePathInformation, true))) {
                if (checksumErrorLoadModuleInformation == null) {
                    checksumErrorLoadModuleInformation = new ChecksumErrorLoadModuleInformation(lM_AndSM_DestFilePathInformation.getProductNumberAndRevision());
                }
                checksumErrorLoadModuleInformation.setSM_FileIsMissing();
            }
            return checksumErrorLoadModuleInformation;
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkLM_AndSM_FilesExists(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation)", "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tcheckLM_AndSM_FilesExists(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation)" + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    private Collection getLM_OrSM_DestAbsoluteFilePaths(DocumentObjectProxyInterface documentObjectProxyInterface, LM_AndSM_DestFilePathInformation lM_AndSM_DestFilePathInformation, boolean bl) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLM_OrSM_DestAbsoluteFilePaths(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation, boolean anIsSM_FileAbsolutePathsToBeRetreived)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation + "\n\tanIsSM_FileAbsolutePathsToBeRetreived: " + bl);
        }
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            Collection collection = null;
            String string = null;
            if (!bl) {
                collection = lM_AndSM_DestFilePathInformation.getLM_DestFilePaths();
            } else {
                collection = lM_AndSM_DestFilePathInformation.getSM_DestFilePaths();
                string = lM_AndSM_DestFilePathInformation.getSM_Extension();
            }
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                String string2 = null;
                LoadModuleProxyInterface loadModuleProxyInterface = lM_AndSM_DestFilePathInformation.getLoadModuleProxyInterface();
                String string3 = null;
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    string3 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(string2, loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
                    if (bl && !string3.endsWith("." + string)) {
                        string3 = string3 + "." + string;
                    }
                    linkedList.add(string3);
                }
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLM_OrSM_DestAbsoluteFilePaths(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation, boolean anIsSM_FileAbsolutePathsToBeRetreived)", "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation + "\n\tanIsSM_FileAbsolutePathsToBeRetreived: " + bl + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetLM_OrSM_DestAbsoluteFilePaths(DocumentObjectProxyInterface aDocumentObjectProxyInterface, LM_AndSM_DestFilePathInformation aLM_AndSM_DestFilePathInformation, boolean anIsSM_FileAbsolutePathsToBeRetreived)" + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLM_AndSM_DestFilePathInformation: " + lM_AndSM_DestFilePathInformation + "\n\tanIsSM_FileAbsolutePathsToBeRetreived: " + bl + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    private Collection checkSoftwareIntegrity(DocumentObjectProxyInterface documentObjectProxyInterface, ProductNumbersAndRevisions productNumbersAndRevisions, ProductDataContainer productDataContainer, String string) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkSoftwareIntegrity(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfLoadModules, ProductDataContainer aProductDataOfUP, String aCV_TmpPath)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumbersAndRevisionsOfLoadModules: " + productNumbersAndRevisions + "\n\taProductDataOfUP: " + productDataContainer + "\n\taCV_TmpPath: " + string);
        }
        try {
            VerifyProperties verifyProperties = new VerifyProperties();
            String string2 = string + "/" + verifyProperties.checksumFileName;
            ChecksumController checksumController = new ChecksumController();
            Collection collection = checksumController.checksumLoadModules(documentObjectProxyInterface, productNumbersAndRevisions.getElements(), productDataContainer, string2);
            Collection collection2 = this.checkLMsExistsWhenNoChecksumSpecifiedInUCF(documentObjectProxyInterface, productNumbersAndRevisions.getElements());
            collection = this.mergeChecksumErrorLoadModuleInformations(collection, collection2);
            return collection;
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkSoftwareIntegrity(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfLoadModules, ProductDataContainer aProductDataOfUP, String aCV_TmpPath)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumbersAndRevisionsOfLoadModules: " + productNumbersAndRevisions + "\n\taProductDataOfUP: " + productDataContainer + "\n\t:aCV_TmpPath: " + string + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tcheckSoftwareIntegrity(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfLoadModules, ProductDataContainer aProductDataOfUP, String aCV_TmpPath)" + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumbersAndRevisionsOfLoadModules: " + productNumbersAndRevisions + "\n\taProductDataOfUP: " + productDataContainer + "\n\taCV_TmpPath: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    private Collection mergeChecksumErrorLoadModuleInformations(Collection collection, Collection collection2) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "mergeChecksumErrorLoadModuleInformations(Collection aChecksumErrorLoadModuleInformations, Collection anAdditionalChecksumErrorLoadModuleInformations)", "aChecksumErrorLoadModuleInformations: " + collection + "\n\tanAdditionalChecksumErrorLoadModuleInformations: " + collection2);
        }
        try {
            if (collection.isEmpty()) {
                return collection2;
            }
            if (collection2.isEmpty()) {
                return collection;
            }
            LinkedList<ChecksumErrorLoadModuleInformation> linkedList = new LinkedList<ChecksumErrorLoadModuleInformation>();
            Iterator iterator = collection.iterator();
            ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation = null;
            ProductNumberAndRevision productNumberAndRevision = null;
            Iterator iterator2 = null;
            ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation2 = null;
            ProductNumberAndRevision productNumberAndRevision2 = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
            while (iterator.hasNext()) {
                checksumErrorLoadModuleInformation = (ChecksumErrorLoadModuleInformation)iterator.next();
                productNumberAndRevision = checksumErrorLoadModuleInformation.getProductNumberAndRevision();
                iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    checksumErrorLoadModuleInformation2 = (ChecksumErrorLoadModuleInformation)iterator2.next();
                    productNumberAndRevision2 = checksumErrorLoadModuleInformation2.getProductNumberAndRevision();
                    if (!productNumberAndRevision2.equals(productNumberAndRevision)) continue;
                    if (checksumErrorLoadModuleInformation2.getIsLM_FileMissing()) {
                        checksumErrorLoadModuleInformation.setLM_FileIsMissing();
                    }
                    if (checksumErrorLoadModuleInformation2.getIsSM_FileMissing()) {
                        checksumErrorLoadModuleInformation.setSM_FileIsMissing();
                    }
                    productNumbersAndRevisions.addElement(productNumberAndRevision2);
                }
                linkedList.add(checksumErrorLoadModuleInformation);
            }
            iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                checksumErrorLoadModuleInformation2 = (ChecksumErrorLoadModuleInformation)iterator2.next();
                productNumberAndRevision2 = checksumErrorLoadModuleInformation2.getProductNumberAndRevision();
                if (productNumbersAndRevisions.contains(productNumberAndRevision2)) continue;
                linkedList.add(checksumErrorLoadModuleInformation2);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "mergeChecksumErrorLoadModuleInformations(Collection aChecksumErrorLoadModuleInformations, Collection anAdditionalChecksumErrorLoadModuleInformations)", "aChecksumErrorLoadModuleInformations: " + collection + "\n\tanAdditionalChecksumErrorLoadModuleInformations: " + collection2 + "\n\tThrowable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tmergeChecksumErrorLoadModuleInformations(Collection aChecksumErrorLoadModuleInformations, Collection anAdditionalChecksumErrorLoadModuleInformations)" + "\n\taChecksumErrorLoadModuleInformations: " + collection + "\n\tanAdditionalChecksumErrorLoadModuleInformations: " + collection2 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProductNumbersAndRevisions collectAllLoadModules(String string, String string2, String string3) throws VerifyException {
        ProductNumbersAndRevisions productNumbersAndRevisions2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectAllLoadModules (String anUCF_Path, String aProductNumberOfUP, String aProductRevisionOfUP)", "anUCF_Path: " + string + "\n\taProductNumberOfUP: " + string2 + "\n\taProductRevisionOfUP: " + string3);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            ProductNumbersAndRevisions productNumbersAndRevisions;
            documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(string2, string3, string, "LoadModule");
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            productNumbersAndRevisions2 = productNumbersAndRevisions = loadModulesProxyInterface.getProductNumberAndRevisionOfLoadModules();
        }
        catch (Throwable throwable) {
            try {
                Trace.error(this.getClass(), "collectAllLoadModules(String anUCF_Path)", "anUCF_Path: " + string + "\n\tThrowable caught.", throwable);
                throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tcollectAllLoadModules(String anUCF_Path)" + "\n\tanUCF_Path: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
            catch (Throwable throwable2) {
                try {
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable2;
            }
        }
        try {
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
            return productNumbersAndRevisions2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return productNumbersAndRevisions2;
    }

    private LM_Data getLM_Data(String string, ProductDataContainer productDataContainer, ProductNumberAndRevision productNumberAndRevision) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLM_Data(String aPathToRestoreFiles, ProductDataContainer anUP_productData, ProductNumberAndRevision aProductNumberAndRevision)", "aPathToRestoreFiles: " + string + "\n\tanUP_productData: " + productDataContainer + "\n\taProductNumberAndRevision: " + productNumberAndRevision);
        }
        try {
            String string2 = SuLib.getOriginalUpgradeControlFileName(productDataContainer.getNumber(), productDataContainer.getRevision());
            String string3 = string + "/" + string2;
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(productDataContainer.getNumber(), productDataContainer.getRevision(), string3, "LoadModule");
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            LoadModuleProxyInterface loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
            boolean bl = false;
            if (loadModuleProxyInterface.getOseProgramLoadClass().equals(MoDataLM_OseProgramLoadClassValue.CoreOS) || loadModuleProxyInterface.getOseProgramLoadClass().equals(MoDataLM_OseProgramLoadClassValue.CoreDevice)) {
                bl = true;
            }
            Collection collection = SignedSoftwareUtils.getDestinationFilePaths(documentObjectProxyInterface, loadModuleProxyInterface, productNumberAndRevision);
            Collection collection2 = SignedSoftwareUtils.getSignedLoadModuleFilePaths(documentObjectProxyInterface, loadModuleProxyInterface, productNumberAndRevision);
            return new LM_Data(productNumberAndRevision, bl, collection, collection2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLM_Data(String aPathToRestoreFiles, ProductDataContainer anUP_productData, ProductNumberAndRevision aProductNumberAndRevision)", "aPathToRestoreFiles: " + string + "\n\tanUP_productData: " + productDataContainer + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tThrowable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetLM_Data(ProductDataContainer anUP_productData, ProductNumberAndRevision aProductNumberAndRevision)" + "\n\taPathToRestoreFiles: " + string + "\n\tanUP_productData: " + productDataContainer + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private ProductDataContainer getUP_ContainingLM(HashMap hashMap, ProductNumberAndRevision productNumberAndRevision) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUP_ContainingLM(HashMap anUP_LMsInformations, ProductNumberAndRevision aCorruptedLMsProductNumberAndRevision)", "anUP_LMsInformations: " + hashMap + "\n\taCorruptedLMsProductNumberAndRevision: " + productNumberAndRevision);
        }
        try {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            ProductDataContainer productDataContainer = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = null;
            while (iterator.hasNext()) {
                productDataContainer = (ProductDataContainer)iterator.next();
                productNumbersAndRevisions = (ProductNumbersAndRevisions)hashMap.get(productDataContainer);
                if (!productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                return productDataContainer;
            }
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetUP_ContainingLM(HashMap anUP_LMsInformations, ProductNumberAndRevision aCorruptedLMsProductNumberAndRevision)" + "\n\tFailed to locate an UP where the corrupted LM isa present (should not happen)." + "\n\tanUP_LMsInformations: " + hashMap + "\n\taCorruptedLMsProductNumberAndRevision: " + productNumberAndRevision);
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUP_ContainingLM(HashMap anUP_LMsInformations, ProductNumberAndRevision aCorruptedLMsProductNumberAndRevision)", "\n\tanUP_LMsInformations: " + hashMap + "\n\taCorruptedLMsProductNumberAndRevision: " + productNumberAndRevision + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetUP_ContainingLM(HashMap anUP_LMsInformations, ProductNumberAndRevision aCorruptedLMsProductNumberAndRevision)" + "\n\tanUP_LMsInformations: " + hashMap + "\n\taCorruptedLMsProductNumberAndRevision: " + productNumberAndRevision + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private Collection identifyUPsForEachListedLM(String string, HashMap hashMap, Collection collection, ActivatedTypeOfUP activatedTypeOfUP, ProductDataContainer productDataContainer) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "identifyUPsForEachListedLM(String aPathToRestoreFiles, HashMap anUP_LMsInformations, Collection aChecksumErrorLoadModuleInformations, ActivatedTypeOfUP anActivatedTypeOfUP, ProductDataContainer aProductDataOfExecutingUP)", "aPathToRestoreFiles: " + string + "\n\tanUP_LMsInformations: " + hashMap + "\n\taChecksumErrorLoadModuleInformations: " + collection + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\taProductDataOfExecutingUP: " + productDataContainer);
        }
        try {
            HashMap hashMap2 = new HashMap();
            Iterator iterator = collection.iterator();
            ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation = null;
            ProductDataContainer productDataContainer2 = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                checksumErrorLoadModuleInformation = (ChecksumErrorLoadModuleInformation)iterator.next();
                productDataContainer2 = this.getUP_ContainingLM(hashMap, checksumErrorLoadModuleInformation.getProductNumberAndRevision());
                LM_Data lM_Data = this.getLM_Data(string, productDataContainer2, checksumErrorLoadModuleInformation.getProductNumberAndRevision());
                bl = this.isTheSameUP(productDataContainer2, productDataContainer);
                hashMap2 = this.addLM_ToUP_LM_Relations(hashMap2, productDataContainer2, lM_Data, checksumErrorLoadModuleInformation, activatedTypeOfUP, bl);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "identifyUPsForEachListedLM(String aPathToRestoreFiles, HashMap anUP_LMsInformations, Collection aChecksumErrorLoadModuleInformations, ActivatedTypeOfUP anActivatedTypeOfUP, ProductDataContainer aProductDataOfExecutingUP)", "Returning - theUP_LM_RelationsMap.values(): " + hashMap2.values());
            }
            return hashMap2.values();
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "identifyUPsForEachListedLM(String aPathToRestoreFiles, HashMap anUP_LMsInformations, Collection aChecksumErrorLoadModuleInformations, ActivatedTypeOfUP anActivatedTypeOfUP, ProductDataContainer aProductDataOfExecutingUP)", "aPathToRestoreFiles: " + string + "\n\tanUP_LMsInformations: " + hashMap + "\n\taChecksumErrorLoadModuleInformations: " + collection + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\taProductDataOfExecutingUP: " + productDataContainer + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tidentifyUPsForEachListedLM(String aPathToRestoreFiles, HashMap anUP_LMsInformations, Collection aChecksumErrorLoadModuleInformations, ActivatedTypeOfUP anActivatedTypeOfUP, ProductDataContainer aProductDataOfExecutingUP)" + "\n\taPathToRestoreFiles: " + string + "\n\tanUP_LMsInformations: " + hashMap + "\n\taChecksumErrorLoadModuleInformations: " + collection + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP + "\n\taProductDataOfExecutingUP: " + productDataContainer + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean isTheSameUP(ProductDataContainer productDataContainer, ProductDataContainer productDataContainer2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isTheSameUP(ProductDataContainer anUP1, ProductDataContainer anUP2)", "anUP1: " + productDataContainer + "\n\tanUP2: " + productDataContainer2);
        }
        return productDataContainer.getNumber().equals(productDataContainer2.getNumber()) && productDataContainer.getRevision().equals(productDataContainer2.getRevision());
    }

    private void releaseSU_DOM(HashMap hashMap) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "releaseSU_DOM (HashMap anUP_LMsInformations)", "anUP_LMsInformations: " + hashMap);
        }
        try {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            ProductDataContainer productDataContainer = null;
            while (iterator.hasNext()) {
                productDataContainer = (ProductDataContainer)iterator.next();
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(productDataContainer.getNumber(), productDataContainer.getRevision());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "releaseSU_DOM (HashMap anUP_LMsInformations)", "anUP_LMsInformations: " + hashMap + "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\treleaseSU_DOM (HashMap anUP_LMsInformations)" + "\n\tanUP_LMsInformations: " + hashMap + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private HashMap parseAllUCFs(String string, ProductDataContainer productDataContainer, Collection collection) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseAllUCFs(String aPathToRestoreFiles, ProductDataContainer aProductDataOfExecutingUP, Collection anUpgradePackageDatasOfBasedOnUPs)", "aPathToRestoreFiles: " + string + "\n\taProductDataOfExecutingUP: " + productDataContainer + "\n\tanUpgradePackageDatasOfBasedOnUPs: " + collection);
        }
        try {
            HashMap<ProductDataContainer, ProductNumbersAndRevisions> hashMap = new HashMap<ProductDataContainer, ProductNumbersAndRevisions>();
            String string2 = SuLib.getOriginalUpgradeControlFileName(productDataContainer.getNumber(), productDataContainer.getRevision());
            String string3 = string + "/" + string2;
            ProductNumbersAndRevisions productNumbersAndRevisions = this.collectAllLoadModules(string3, productDataContainer.getNumber(), productDataContainer.getRevision());
            hashMap.put(productDataContainer, productNumbersAndRevisions);
            Iterator iterator = collection.iterator();
            UpgradePackageDataContainer upgradePackageDataContainer = null;
            ProductDataContainer productDataContainer2 = null;
            String string4 = null;
            String string5 = null;
            while (iterator.hasNext()) {
                upgradePackageDataContainer = (UpgradePackageDataContainer)iterator.next();
                productDataContainer2 = upgradePackageDataContainer.getProductDataContainer();
                string4 = SuLib.getOriginalUpgradeControlFileName(productDataContainer2.getNumber(), productDataContainer2.getRevision());
                string5 = string + "/" + string4;
                ProductNumbersAndRevisions productNumbersAndRevisions2 = this.collectAllLoadModules(string5, productDataContainer2.getNumber(), productDataContainer2.getRevision());
                hashMap.put(productDataContainer2, productNumbersAndRevisions2);
            }
            return hashMap;
        }
        catch (VerifyException verifyException) {
            throw verifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "parseAllUCFs(String aPathToRestoreFiles, ProductDataContainer aProductDataOfExecutingUP, Collection anUpgradePackageDatasOfBasedOnUPs)", "aPathToRestoreFiles: " + string + "\n\taProductDataOfExecutingUP: " + productDataContainer + "\n\tanUpgradePackageDatasOfBasedOnUPs: " + collection + "\n\tThrowable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tparseAllUCFs(String aPathToRestoreFiles, ProductDataContainer aProductDataOfExecutingUP, Collection anUpgradePackageDatasOfBasedOnUPs)" + "\n\taPathToRestoreFiles: " + string + "\n\taProductDataOfExecutingUP: " + productDataContainer + "\n\tanUpgradePackageDatasOfBasedOnUPs: " + collection + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

