/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.updependency;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.file.dependency.proxy.UP_ListProxy;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.UnexpectedXML_FileContentException;
import se.ericsson.cello.configurationversion.util.file.factory.BackupRestoreDomProxyFactory;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.configurationversion.verify.base.VerifyException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageDataContainer;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageInformation;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class UP_DependencyVerifier {
    public UP_DependencyVerifier() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UP_DependencyVerifier( )");
        }
    }

    public ProductDataContainer getExecutingUPs(String string) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingUPs(String aPathToRestoreFiles)", "aPathToRestoreFiles: " + string);
        }
        try {
            UP_ListProxy uP_ListProxy = BackupRestoreDomProxyFactory.getInstance().getUP_ListProxy(string);
            UpgradePackageDataContainer upgradePackageDataContainer = uP_ListProxy.getExecutingUP();
            ProductDataContainer productDataContainer = upgradePackageDataContainer.getProductDataContainer();
            return productDataContainer;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new VerifyException(configurationVersionException.toString());
        }
    }

    public Collection getMissingUPs(String string) throws VerifyException, UnexpectedXML_FileContentException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMissingUPs(String aPathToRestoreFiles)", "aPathToRestoreFiles: " + string);
        }
        LinkedList<UpgradePackageDataContainer> linkedList = new LinkedList<UpgradePackageDataContainer>();
        try {
            UP_ListProxy uP_ListProxy = BackupRestoreDomProxyFactory.getInstance().getUP_ListProxy(string);
            Collection collection = uP_ListProxy.getBasedOnUPs();
            UpgradePackageDataContainer upgradePackageDataContainer = uP_ListProxy.getExecutingUP();
            ProductDataContainer productDataContainer = upgradePackageDataContainer.getProductDataContainer();
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.UpgradePackageInformation, new UpgradePackageInformation(this, upgradePackageDataContainer.getProductDataContainer().getNumber(), upgradePackageDataContainer.getProductDataContainer().getRevision()));
            Iterator iterator = collection.iterator();
            UpgradePackageDataContainer upgradePackageDataContainer2 = null;
            ProductDataContainer productDataContainer2 = null;
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext()) {
                upgradePackageDataContainer2 = (UpgradePackageDataContainer)iterator.next();
                productDataContainer2 = upgradePackageDataContainer2.getProductDataContainer();
                upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(productDataContainer2.getNumber(), productDataContainer2.getRevision());
                if (upgradePackageMoExtended != null) continue;
                linkedList.add(upgradePackageDataContainer2);
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getMissingUPs(String aPathToRestoreFiles)", "Needed based-on UP is not present in node (i.e. it has been added to the list),\n\tproduct number: " + productDataContainer2.getNumber() + "\n\tproduct revision: " + productDataContainer2.getRevision());
            }
            upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(productDataContainer.getNumber(), productDataContainer.getRevision());
            if (upgradePackageMoExtended == null) {
                linkedList.add(upgradePackageDataContainer);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getMissingUPs(String aPathToRestoreFiles)", "Needed executing UP is not present in node (i.e. it has been added to the list),\n\tproduct number: " + productDataContainer.getNumber() + "\n\tproduct revision: " + productDataContainer.getRevision());
                }
            }
            return linkedList;
        }
        catch (UnexpectedXML_FileContentException unexpectedXML_FileContentException) {
            throw unexpectedXML_FileContentException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new VerifyException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMissingUPs(String aPathToRestoreFiles)", "Throwable caught.", throwable);
            throw new VerifyException("Class name: " + this.getClass().getName() + "\n\tgetMissingUPs(String aPathToRestoreFiles)" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

