/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.classloader;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.su.classloader.DynClassPathException;
import se.ericsson.cello.su.classloader.SU_ClassLoader;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.DynamicClass;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class DynamicClassLoaderCentral {
    public static final int INSTALL_SEQUENCE = 1;
    public static final int VERIFY_SEQUENCE = 2;
    public static final int UPGRADE_SEQUENCE = 3;
    private static final String SLASH = "/";
    private static final String JAVA_DIR = "java";
    private static final String INSTALL_DIR = "install";
    private static final DynamicClassLoaderCentral myInstance = new DynamicClassLoaderCentral();
    private SU_ClassLoader mySU_ClassLoader = null;
    private HashMap myDynClassesObjectsMap = new HashMap();

    private DynamicClassLoaderCentral() {
    }

    public static synchronized DynamicClassLoaderCentral getInstance() {
        return myInstance;
    }

    public void addToDynamicClassPath(UpgradePackageMoExtended upgradePackageMoExtended, Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addToDynamicClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aLoadJavaLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taLoadJavaLM_MOs: " + collection);
        }
        try {
            Collection collection2 = this.getDynClasspath(upgradePackageMoExtended);
            Collection collection3 = this.filterAlreadyLoadedLMs(collection, collection2);
            if (!collection3.isEmpty()) {
                this.addToDynClassPath(upgradePackageMoExtended, collection2, collection3);
            }
        }
        catch (DynClassPathException dynClassPathException) {
            throw dynClassPathException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addToDynamicClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aLoadJavaLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taLoadJavaLM_MOs: " + collection + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public void loadLoadModulesInDynClassPath(UpgradePackageMoExtended upgradePackageMoExtended) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadLoadModulesInDynClassPath(UpgradePackageMoExtended anUsedUP_Mo)", "\n\tanUsedUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            Collection collection = this.getDynClasspath(upgradePackageMoExtended);
            if (collection.isEmpty()) {
                return;
            }
            this.addLoadModulesToClassLoader(collection);
            this.createInstancesAndInitiate(collection);
            Trace.log1(this.getClass(), "loadLoadModulesInDynClassPath(UpgradePackageMoExtended anUsedUP_Mo)", "The following load modules have been dynamically loaded to the Jvm dyn class path: " + collection);
        }
        catch (DynClassPathException dynClassPathException) {
            throw dynClassPathException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "loadLoadModulesInDynClassPath(UpgradePackageMoExtended anUsedUP_Mo)", "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public void loadLoadModules(Collection collection, UpgradePackageMoExtended upgradePackageMoExtended, Collection collection2) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadLoadModules(Collection aNotLoadedLoadModuleMoSU_Accesses, UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath)", "aNotLoadedLoadModuleMoSU_Accesses: " + collection + "\n\tanUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection2);
        }
        try {
            this.addLoadModulesToClassLoader(collection);
            this.createInstancesAndInitiate(collection);
            this.addToDynClassPath(upgradePackageMoExtended, collection2, collection);
        }
        catch (DynClassPathException dynClassPathException) {
            throw dynClassPathException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "loadLoadModules(Collection aNotLoadedLoadModuleMoSU_Accesses, UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath)", "aNotLoadedLoadModuleMoSU_Accesses: " + collection + "\n\tanUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection2 + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public void unloadLoadModules(Collection collection, UpgradePackageMoExtended upgradePackageMoExtended) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unloadLoadModules(Collection aLoadModuleMoSU_Accesses, UpgradePackageMoExtended anUsedUP_Mo)", "aLoadModuleMoSU_Accesses: " + collection + "\n\tanUsedUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            Collection collection2 = this.getDynClasspath(upgradePackageMoExtended);
            Collection collection3 = this.filterNotLoadedLMs(collection, collection2);
            if (collection3.isEmpty()) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "unloadLoadModules(Collection aLoadModuleMoSU_Accesses, UpgradePackageMoExtended anUsedUP_Mo)", "The LMs requested to be unloaded: " + collection + "The loaded LMs: " + collection3 + "Since no LMs are loaded the request to unload is ignored.");
                }
                return;
            }
            this.requestForTermination(collection3);
            this.removeFromDynClassPath(upgradePackageMoExtended, collection2, collection3);
            this.garbageCollectClassLoaderIfValid(upgradePackageMoExtended);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "unloadLoadModules(Collection aLoadModuleMoSU_Accesses, UpgradePackageMoExtended anUsedUP_Mo)", "aLoadModuleMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public void unloadAllLoadModules(UpgradePackageMoExtended upgradePackageMoExtended) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "unloadAllLoadModules(UpgradePackageMoExtended anUsedUP_Mo)", "anUsedUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            Collection collection = this.getDynClasspath(upgradePackageMoExtended);
            if (collection.isEmpty()) {
                return;
            }
            Trace.log1(this.getClass(), "unloadAllLoadModules(UpgradePackageMoExtended anUsedUP_Mo)", "Requesting for unload of following dynamical AUEs: " + collection);
            this.requestForTermination(collection);
            this.removeFromDynClassPath(upgradePackageMoExtended, collection, collection);
            this.garbageCollectClassLoaderIfValid(upgradePackageMoExtended);
            Trace.log1(this.getClass(), "unloadAllLoadModules(UpgradePackageMoExtended anUsedUP_Mo)", "The AUEs have now been unloaded");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "unloadAllLoadModules(UpgradePackageMoExtended anUsedUP_Mo)", "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private void addLoadModulesToClassLoader(Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLoadModulesToClassLoader(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection);
        }
        try {
            URL[] uRLArray = this.getURLs(collection);
            if (this.mySU_ClassLoader == null) {
                this.mySU_ClassLoader = new SU_ClassLoader(uRLArray);
            } else {
                this.mySU_ClassLoader.addURLs(uRLArray);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addLoadModulesToClassLoader(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private void createInstancesAndInitiate(Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection);
        }
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            Iterator iterator = collection.iterator();
            DynamicClass dynamicClass = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                String string = loadModuleMoSU_Access.getDynamicClassName(null);
                if (string.length() > 0) {
                    Class clazz;
                    Object t;
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "Attempts to load the class: '" + string + "'" + "\n\ttheLM_Mo: " + loadModuleMoSU_Access);
                    }
                    if ((t = (clazz = this.mySU_ClassLoader.loadClass(loadModuleMoSU_Access.getDynamicClassName(null))).newInstance()) instanceof DynamicClass) {
                        dynamicClass = (DynamicClass)t;
                        dynamicClass.init();
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "Class dynamically loaded and initiated\n\ttheLM_Mo: " + loadModuleMoSU_Access + "\n\ttheDynamicClass: " + dynamicClass);
                        }
                    } else {
                        Trace.info(this.getClass(), "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "The load module that has been dynamically loaded into the Jvm is not implementing the interface DynamicClass i.e.\n\tNot possible to initiate the class instance\n\ttheLM_Mo: " + loadModuleMoSU_Access + "\n\ttheDynamicClassObject: " + t);
                    }
                    this.myDynClassesObjectsMap.put(loadModuleMoSU_Access, t);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "The load module didn't have any DynamicClass definition defined and is therefor not explicitly loaded (assuming it is used by other dynamically AUEs)\n\ttheDynamicClassName: '" + string + "'" + "\n\ttheLM_Mo: " + loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "myDynClassesObjectsMap: " + this.myDynClassesObjectsMap);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "";
            if (loadModuleMoSU_Access != null) {
                try {
                    string = loadModuleMoSU_Access.getDynamicClassName(null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Trace.info(this.getClass(), "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "The class to be loaded dynamically was not found.\n\ttheLM_Mo: " + loadModuleMoSU_Access + "\n\ttheDynamicClass: " + string);
            throw new DynClassPathException("Failed to load, create an instance of the class or that the init() operation in the dynamic AUE returned an exception.\n\tThe Load Module that caused this problem is: " + collection + "\n\tThrowable: " + classNotFoundException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createInstancesAndInitiate(Collection aLoadModuleMoSU_Accesses)", "Failed to load, create an instance of the class or that the init() operation in the dynamic AUE returned an exception.\n\tThe LM that caused this problem is: " + collection + "\n\tThrowable caught", throwable);
            throw new DynClassPathException("Failed to load, create an instance of the class or that the init() operation in the dynamic AUE returned an exception.\n\tThe Load Module that caused this problem is: " + collection + "\n\tThrowable: " + throwable.toString());
        }
    }

    private void requestForTermination(Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForTermination(Collection aLoadModuleMoSU_Accesses)", "aLoadModuleMoSU_Accesses: " + collection);
        }
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            Iterator iterator = collection.iterator();
            Object var4_5 = null;
            DynamicClass dynamicClass = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                var4_5 = this.myDynClassesObjectsMap.remove(loadModuleMoSU_Access);
                if (var4_5 instanceof DynamicClass) {
                    dynamicClass = var4_5;
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "requestForTermination(Collection aLoadModuleMoSU_Accesses)", "terminate to be invoked on a dynamic load module\n\ttheLM_Mo: " + loadModuleMoSU_Access + "\n\ttheDynamicClass: " + dynamicClass);
                    }
                    dynamicClass.terminate();
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "requestForTermination(Collection aLoadModuleMoSU_Accesses)", "Operation terminate() has been invoked on the dynamic AUE.\n\tThe Load Module Mo: " + loadModuleMoSU_Access + "\n\tThe Load Module product number: " + loadModuleMoSU_Access.getProductNumber(null) + "\n\tThe Load Module revision: " + loadModuleMoSU_Access.getProductRevision(null) + "\n\ttheDynamicClass: " + dynamicClass);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "requestForTermination(Collection aLoadModuleMoSU_Accesses)", "The dynamically object to be removed was not of type DynamicClass: " + var4_5);
            }
        }
        catch (Throwable throwable) {
            String string = "";
            String string2 = "";
            try {
                if (loadModuleMoSU_Access != null) {
                    string = loadModuleMoSU_Access.getProductNumber(null);
                    string2 = loadModuleMoSU_Access.getProductRevision(null);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            Trace.error(this.getClass(), "requestForTermination(Collection aLoadModuleMoSU_Accesses)", "Failed to terminate a dynamically loaded AUE due to an exception is caught from the AUE itself\n\tThe Load Module that caused this problem is: " + loadModuleMoSU_Access + "\n\tThe Load Module product nymber: " + string + "\n\tThe Load Module revision: " + string2 + "\n\tThrowable caught", throwable);
            throw new DynClassPathException("Failed to terminate a dynamically loaded AUE due to an exception is caught from the AUE itself\n\tThe Load Module that caused this problem is: " + loadModuleMoSU_Access + "\n\tThe Load Module product nymber: " + string + "\n\tThe Load Module revision: " + string2 + "\n\tThrowable: " + throwable.toString());
        }
    }

    private URL[] getURLs(Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getURLs(Collection aLMsToBeAdded)", "aLMsToBeAdded: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            URL[] uRLArray = new URL[collection.size()];
            int n = 0;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            File file = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                file = this.selectLM_FilePath(loadModuleMoSU_Access.getLoadModuleFilePath(null));
                uRLArray[n] = file.toURI().toURL();
                ++n;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getURLs(Collection aLMsToBeAdded)", "RETURNS - theURLs: " + SuLib.toString(uRLArray));
            }
            return uRLArray;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getURLs(Collection aLMsToBeAdded)", "aLMsToBeAdded: " + collection + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private File selectLM_FilePath(String string) {
        String string2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectLM_FilePath(String aLM_FilePath)", "aLM_FilePath: " + string);
        }
        int n = string.lastIndexOf(SLASH);
        File file = new File(string);
        if (n != -1 && (string2 = string.substring(0, n)).endsWith("/java")) {
            File file2;
            String string3 = string2 + SLASH + INSTALL_DIR + string.substring(n, string.length());
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "selectLM_FilePath(LoadModuleMoSU_Access aLM_MO)", "theTmpJavaInstallPath: " + string3);
            }
            if ((file2 = new File(string3)).exists()) {
                file = file2;
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectLM_FilePath(LoadModuleMoSU_Access aLM_MO)", "REURNS - theFileToUse: " + SuLib.toString(file));
        }
        return file;
    }

    public Collection filterAlreadyLoadedLMs(Collection collection, Collection collection2) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterAlreadyLoadedLMs(Collection aLoadModuleMoSU_Accesses, Collection aCurrentDynClassPath)", "aLoadModuleMoSU_Accesses: " + collection + "\n\taCurrentDynClassPath: " + collection2);
        }
        try {
            Iterator iterator = collection.iterator();
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                if (!collection2.contains(loadModuleMoSU_Access)) {
                    linkedList.add(loadModuleMoSU_Access);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "addLoadModulesToDynClassPath(Collection aLoadModuleMoSU_Accesses, int aSequenceType, UpgradePackageMoExtended anUsedUP_Mo)", "The LM MO already added to dynamic class path (ignored)\n\ttheLM_MO: " + loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "filterAlreadyLoadedLMs(Collection aLoadModuleMoSU_Accesses, Collection aCurrentDynClassPath)", "RETURNS - theNotLoadedLM_MOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "filterAlreadyLoadedLMs(Collection aLoadModuleMoSU_Accesses, Collection aCurrentDynClassPath)", "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private Collection filterNotLoadedLMs(Collection collection, Collection collection2) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterNotLoadedLMs(Collection aLoadModuleMoSU_Accesses, Collection aCurrentDynClassPath)", "aLoadModuleMoSU_Accesses: " + collection + "\n\taCurrentDynClassPath: " + collection2);
        }
        Iterator iterator = collection.iterator();
        LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        while (iterator.hasNext()) {
            loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
            if (collection2.contains(loadModuleMoSU_Access)) {
                linkedList.add(loadModuleMoSU_Access);
                continue;
            }
            if (!Trace.valid(this.getClass(), 20)) continue;
            Trace.debug(this.getClass(), 20, "filterNotLoadedLMs(Collection aLoadModuleMoSU_Accesses, int aSequenceType, UpgradePackageMoExtended anUsedUP_Mo)", "The LM MO do not exists in the dynamic class path (ignored)\n\ttheLM_MO: " + loadModuleMoSU_Access);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterNotLoadedLMs(Collection aLoadModuleMoSU_Accesses, Collection aCurrentDynClassPath)", "RETURNS - theLoadedLM_MOs: " + linkedList);
        }
        return linkedList;
    }

    private void garbageCollectClassLoaderIfValid(UpgradePackageMoExtended upgradePackageMoExtended) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "garbageCollectClassLoaderIfValid()");
        }
        try {
            ManagedObject[] managedObjectArray = upgradePackageMoExtended.getDynamicClassPath(null);
            if (this.mySU_ClassLoader == null) {
                return;
            }
            if (managedObjectArray.length == 0) {
                this.mySU_ClassLoader = null;
                System.gc();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "garbageCollectClassLoaderIfValid()", "SU Class loader unloaded.");
                }
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "garbageCollectClassLoaderIfValid()", "Current dynamic class path: " + SuLib.toString(managedObjectArray) + "\n\t");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "garbageCollectClassLoaderIfValid()", "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public Collection getDynClasspath(UpgradePackageMoExtended upgradePackageMoExtended) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDynClasspath(UpgradePackageMoExtended anUsedUP_Mo)", "anUsedUP_Mo: " + upgradePackageMoExtended);
        }
        try {
            ManagedObject[] managedObjectArray = upgradePackageMoExtended.getDynamicClassPath(null);
            LinkedList<LoadModuleMoSU_Access> linkedList = new LinkedList<LoadModuleMoSU_Access>();
            for (int i = 0; i < managedObjectArray.length; ++i) {
                linkedList.add((LoadModuleMoSU_Access)managedObjectArray[i]);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getDynClasspath(UpgradePackageMoExtended anUsedUP_Mo)", "RETURNS - theLM_MOs: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDynClasspath(UpgradePackageMoExtended anUsedUP_Mo)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\tThrowable caught", throwable);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private void addToDynClassPath(UpgradePackageMoExtended upgradePackageMoExtended, Collection collection, Collection collection2) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addToDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aNewLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection + "\n\taNewLM_MOs: " + collection2);
        }
        Control control = null;
        try {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(collection2);
            linkedList.addAll(collection);
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[linkedList.size()];
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_AccessArray[n] = (LoadModuleMoSU_Access)iterator.next();
                ++n;
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            upgradePackageMoExtended.setDynamicClassPath((ManagedObject[])loadModuleMoSU_AccessArray, coordinator);
            Transaction.commit(control);
            Trace.log1(this.getClass(), "addToDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aNewLM_MOs)", "Dynamic class path updated.\n\tOld class path: " + collection + "\n\tnew class path: " + linkedList);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addToDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aNewLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection + "\n\taNewLM_MOs: " + collection2 + "\n\tThrowable caught", throwable);
            Transaction.rollback(control);
            throw new DynClassPathException(throwable.toString());
        }
    }

    public URL[] getURLs() throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getURLs()");
        }
        if (this.mySU_ClassLoader != null) {
            return this.mySU_ClassLoader.getURLs();
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getURLs()", "No SU class loader exists.");
        }
        return new URL[0];
    }

    public Package[] getPackages() throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPackages()");
        }
        if (this.mySU_ClassLoader != null) {
            return this.mySU_ClassLoader.getPackages();
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getURLs()", "No SU class loader exists.");
        }
        return new Package[0];
    }

    public void setDynClassPath(UpgradePackageMoExtended upgradePackageMoExtended, Collection collection) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aDynamicClassPath)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taDynamicClassPath: " + collection);
        }
        Control control = null;
        try {
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[collection.size()];
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_AccessArray[n] = (LoadModuleMoSU_Access)iterator.next();
                ++n;
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            upgradePackageMoExtended.setDynamicClassPath((ManagedObject[])loadModuleMoSU_AccessArray, coordinator);
            Transaction.commit(control);
            Trace.log1(this.getClass(), "setDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aDynamicClassPath, Collection aNewLM_MOs)", "Dynamic class path updated.\n\taDynamicClassPath: " + collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aDynamicClassPath, Collection aNewLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taDynamicClassPath: " + collection + "\n\tThrowable caught", throwable);
            Transaction.rollback(control);
            throw new DynClassPathException(throwable.toString());
        }
    }

    private void removeFromDynClassPath(UpgradePackageMoExtended upgradePackageMoExtended, Collection collection, Collection collection2) throws DynClassPathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeFromDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aRemovedLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection + "\n\taRemovedLM_MOs: " + collection2);
        }
        Control control = null;
        try {
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(collection);
            linkedList.removeAll(collection2);
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[linkedList.size()];
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                loadModuleMoSU_AccessArray[n] = (LoadModuleMoSU_Access)iterator.next();
                ++n;
            }
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            upgradePackageMoExtended.setDynamicClassPath((ManagedObject[])loadModuleMoSU_AccessArray, coordinator);
            Transaction.commit(control);
            Trace.log1(this.getClass(), "removeFromDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aRemovedLM_MOs)", "Dynamic class path updated.\n\tOld class path: " + collection + "\n\tnew class path: " + linkedList);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeFromDynClassPath(UpgradePackageMoExtended anUsedUP_Mo, Collection aCurrentDynClassPath, Collection aRemovedLM_MOs)", "anUsedUP_Mo: " + upgradePackageMoExtended + "\n\taCurrentDynClassPath: " + collection + "\n\taRemovedLM_MOs: " + collection2 + "\n\tThrowable caught", throwable);
            Transaction.rollback(control);
            throw new DynClassPathException(throwable.toString());
        }
    }
}

