/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.base.ConverterActionType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class AddMoConverterAction
extends ConverterActionBase {
    private String myParentLdn = null;
    private String myId = null;

    public AddMoConverterAction(String string, String string2) {
        super(ConverterActionType.ADD_MO);
        this.myParentLdn = string;
        this.myId = string2;
    }

    protected void execute(Collection collection, String string, Integer n) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(Collection aMoDatas, String aMoTypeName, Integer aNewMoDataRevision)", "Number of MoDatas: " + collection.size() + "\n\taMoTypeName: " + string + "\n\taNewMoDataRevision: " + n);
        }
        try {
            String string2 = this.createMoLdn(string);
            if (this.isAlreadyCreated(collection, string2)) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(Collection aMoDatas, String aMoTypeName, Integer aNewMoDataRevision)", "The MO has already been created.theMoLdn: " + string2);
                }
                return;
            }
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MoData moData = new MoData(string2, string, true, coordinator);
            ConverterAttributeBase converterAttributeBase = null;
            Iterator iterator = this.myConverterAttributes.iterator();
            while (iterator.hasNext()) {
                converterAttributeBase = (ConverterAttributeBase)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Adding new attribute to the new MO: " + converterAttributeBase);
                }
                moData.registerPersistentAttr(converterAttributeBase.getPersistentAttribute());
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Setting MoData revision in the new MO: " + n);
            }
            moData.setRevision(n.intValue());
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            collection.add(moData);
            control.getTerminator().commit();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute(MoData aMoData)", "Failed to add new MoData to MoDatas, throwable caught.\n\tParent ldn: " + this.myParentLdn + "\n\tMotypeName: " + string + "\n\tMoID: " + this.myId, throwable);
            throw new SuConvertActionException("Failed to add new MoData to MoDatas, throwable caught. Throwable info: " + throwable);
        }
    }

    public String getParentLdn() {
        return this.myParentLdn;
    }

    public String getId() {
        return this.myId;
    }

    private String createMoLdn(String string) {
        return this.myParentLdn + "," + string + "=" + this.myId;
    }

    private boolean isAlreadyCreated(Collection collection, String string) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((MoData)iterator.next()).getLocalDistinguishedName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String toString() {
        return super.toString() + "\n\tmyId: " + this.myId + "\n\tmyParentLdn: " + this.myParentLdn;
    }
}

