/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class BooleanConverterAttribute
extends ConverterAttributeBase {
    private Boolean myValue = null;

    public BooleanConverterAttribute(String string) {
        super(ConverterAttributeType.BOOLEAN, string);
    }

    public BooleanConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.BOOLEAN, string, bl);
    }

    public BooleanConverterAttribute(String string, Boolean bl, Boolean bl2) {
        super(ConverterAttributeType.BOOLEAN, string, bl2);
        this.myValue = bl;
    }

    public BooleanConverterAttribute(BooleanAttribute booleanAttribute) {
        super(ConverterAttributeType.BOOLEAN, booleanAttribute.getName(), new Boolean(booleanAttribute.isAVCNotifier()));
        this.myValue = new Boolean(booleanAttribute.getValue(null));
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new BooleanAttribute(this.myName, this.myIsAVC_Notifier.booleanValue(), this.myValue.booleanValue());
    }

    public String getValueAsString() {
        return this.myValue.toString();
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPreviousValue(String aLdn, Attribute theAttribute)", "aLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = new Boolean(attribute.isAVCNotifier());
        this.myPreviousValues.put(string, new Boolean(((BooleanAttribute)attribute).getValue(null)));
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = this.myPreviousValues.get(string).toString();
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValue + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

