/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class IntegerConverterAttribute
extends ConverterAttributeBase {
    private Integer myValue = null;

    public IntegerConverterAttribute(String string) {
        super(ConverterAttributeType.INTEGER, string);
    }

    public IntegerConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.INTEGER, string, bl);
    }

    public IntegerConverterAttribute(String string, Integer n, Boolean bl) {
        super(ConverterAttributeType.INTEGER, string, bl);
        this.myValue = n;
    }

    public IntegerConverterAttribute(IntegerAttribute integerAttribute) {
        super(ConverterAttributeType.INTEGER, integerAttribute.getName(), new Boolean(integerAttribute.isAVCNotifier()));
        this.myValue = new Integer(integerAttribute.getValue(null));
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new IntegerAttribute(this.myName, this.myIsAVC_Notifier.booleanValue(), this.myValue.intValue());
    }

    public String getValueAsString() {
        return this.myValue.toString();
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPreviousValue(Attribute theAttribute)", "theAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = new Boolean(attribute.isAVCNotifier());
        this.myPreviousValues.put(string, new Integer(((IntegerAttribute)attribute).getValue(null)));
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = this.myPreviousValues.get(string).toString();
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValue + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

