/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ReferenceConverterAttribute
extends ConverterAttributeBase {
    private String myLdn = null;

    public ReferenceConverterAttribute(String string) {
        super(ConverterAttributeType.REFERENCE, string);
    }

    public ReferenceConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.REFERENCE, string, bl);
    }

    public ReferenceConverterAttribute(String string, String string2, Boolean bl) {
        super(ConverterAttributeType.REFERENCE, string, bl);
        this.myLdn = string2;
    }

    public ReferenceConverterAttribute(ReferenceAttribute referenceAttribute) {
        super(ConverterAttributeType.REFERENCE, referenceAttribute.getName(), new Boolean(referenceAttribute.isAVCNotifier()));
        this.myLdn = referenceAttribute.getReferenceAsLDN();
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        return new ReferenceAttribute(this.myName, this.myLdn, this.myIsAVC_Notifier.booleanValue());
    }

    public String getValueAsString() {
        return this.myLdn;
    }

    public void addPreviousValue(String string, Attribute attribute) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreviousValue(String aMoLdn, Attribute theAttribute)", "aMoLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = new Boolean(attribute.isAVCNotifier());
        this.myPreviousValues.put(string, ((ReferenceAttribute)attribute).getReferenceAsLDN());
    }

    public String getPreviousValueAsString(String string) throws ConverterAttributeException {
        String string2 = null;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            string2 = (String)this.myPreviousValues.get(string);
        } else {
            string2 = this.getValueAsString();
        }
        return string2;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myLdn + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

