/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.su.convert.attribute.BooleanConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.attribute.FloatConverterAttribute;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.LongConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class StructConverterAttribute
extends ConverterAttributeBase {
    private LinkedList myValues = new LinkedList();

    public StructConverterAttribute(String string) {
        super(ConverterAttributeType.STRUCT, string);
    }

    public StructConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.STRUCT, string, bl);
    }

    public StructConverterAttribute(String string, LinkedList linkedList, Boolean bl) {
        super(ConverterAttributeType.STRUCT, string, bl);
        this.myValues = linkedList;
    }

    public StructConverterAttribute(StructAttribute structAttribute) throws ConverterAttributeException {
        super(ConverterAttributeType.STRUCT, structAttribute.getName(), new Boolean(structAttribute.isAVCNotifier()));
        Struct struct = structAttribute.getValue(null);
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = null;
            try {
                object = struct.getValue(stringArray[i]);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "StructConverterAttribute(StructAttribute aStructAttribute)", "Throwable caught when trying to get member value.\n\tStruct name: " + this.myName + "\n\tMember name: " + stringArray[i], throwable);
                throw new ConverterAttributeException("Throwable caught when trying to get member value. Struct attribute name: " + this.myName + ". " + "Throwable: " + throwable);
            }
            this.myValues.add(this.getConverterAttribute(stringArray[i], object));
        }
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        StructAttribute structAttribute = new StructAttribute(this.myName, this.myIsAVC_Notifier.booleanValue());
        ConverterAttributeBase converterAttributeBase = null;
        Iterator iterator = this.myValues.iterator();
        while (iterator.hasNext()) {
            converterAttributeBase = (ConverterAttributeBase)iterator.next();
            structAttribute.addElement(converterAttributeBase.getPersistentAttribute());
        }
        return structAttribute;
    }

    public LinkedList getValues() {
        return this.myValues;
    }

    public LinkedList getPreviousValues(String string) throws ConverterAttributeException {
        LinkedList linkedList = this.myValues;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            linkedList = (LinkedList)this.myPreviousValues.get(string);
        }
        return linkedList;
    }

    private ConverterAttributeBase getConverterAttribute(String string, Object object) throws ConverterAttributeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConverterAttribute(String aName, Object anObject)", "aName: " + string + "\n\tanObject: " + object);
        }
        ConverterAttributeBase converterAttributeBase = null;
        if (object instanceof Boolean) {
            BooleanAttribute booleanAttribute = new BooleanAttribute(string, false, ((Boolean)object).booleanValue());
            converterAttributeBase = new BooleanConverterAttribute(booleanAttribute);
        } else if (object instanceof Float) {
            FloatAttribute floatAttribute = new FloatAttribute(string, false, ((Float)object).floatValue());
            converterAttributeBase = new FloatConverterAttribute(floatAttribute);
        } else if (object instanceof Integer) {
            IntegerAttribute integerAttribute = new IntegerAttribute(string, false, ((Integer)object).intValue());
            converterAttributeBase = new IntegerConverterAttribute(integerAttribute);
        } else if (object instanceof Long) {
            LongAttribute longAttribute = new LongAttribute(string, false, ((Long)object).longValue());
            converterAttributeBase = new LongConverterAttribute(longAttribute);
        } else if (object instanceof String) {
            StringAttribute stringAttribute = new StringAttribute(string, false, (String)object);
            converterAttributeBase = new StringConverterAttribute(stringAttribute);
        } else {
            Trace.error(this.getClass(), "getConverterAttribute(String aName, Object anObject)", "Unknown attribute type received in struct.\n\tSequence attribute name: " + this.myName + "\n\tanObject class name: " + object.getClass().getName());
            throw new ConverterAttributeException("Unknown attribute type received in sequence. SequenceAttributeName: " + this.myName);
        }
        converterAttributeBase.setName(string);
        return converterAttributeBase;
    }

    public void addPreviousValue(String string, Attribute attribute) throws ConverterAttributeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPreviousValue(Attribute theAttribute)", "aMoLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = new Boolean(attribute.isAVCNotifier());
        LinkedList<ConverterAttributeBase> linkedList = new LinkedList<ConverterAttributeBase>();
        Struct struct = ((StructAttribute)attribute).getValue(null);
        String[] stringArray = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = null;
            try {
                object = struct.getValue(stringArray[i]);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "setPreviousValue(Attribute theAttribute)", "Throwable caught when trying to get member value.\n\tStruct name: " + this.myName + "\n\tMember name: " + stringArray[i], throwable);
                throw new ConverterAttributeException("Throwable caught when trying to get member value. Struct attribute name: " + this.myName + ". " + "Throwable: " + throwable);
            }
            linkedList.add(this.getConverterAttribute(stringArray[i], object));
        }
        this.myPreviousValues.put(string, linkedList);
    }

    public String getPreviousValueAsString(String string) {
        return null;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValues + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

