/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public abstract class ConverterStepBase {
    protected LinkedList myConverterActions = new LinkedList();
    protected String typeName = null;
    protected Integer fromVersion = null;
    protected Integer toVersion = null;
    protected final String EMPTY_STRING = "";

    public ConverterStepBase(String string, Integer n, Integer n2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ConverterStepBase(String aTypeName, Integer aFromVersion, Integer aToVersion)", "aTypeName: " + string + "\n\taFromVersion: " + n + "\n\taToVersion: " + n2);
        }
        this.typeName = string;
        this.fromVersion = n;
        this.toVersion = n2;
    }

    public void execute(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(Collection aMoDatas)", "Number of MoDatas: " + collection.size());
        }
        this.executeConvertActions(this.removeAlreadyConvertedMoData(collection));
    }

    public abstract boolean prepareConvert(Collection var1) throws SuConvertActionException;

    private Collection removeAlreadyConvertedMoData(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeConvertedMoData(aMoDatas)");
        }
        Vector<MoData> vector = new Vector<MoData>();
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (moData.getRevision() != this.toVersion.intValue()) {
                vector.add(moData);
                continue;
            }
            if (!Trace.valid(this.getClass(), 20)) continue;
            Trace.debug(this.getClass(), 20, "removeConvertedMoData(aMoDatas)", "The MoData revision is the same as the toVersion, i.e. it has already been converted.\n\tThe MoData ldn: " + moData.getLocalDistinguishedName() + "\n\tThe MoData revision: " + moData.getRevision() + "\n\tThe toVersion: " + this.toVersion);
        }
        return vector;
    }

    protected void executeConvertActions(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeConvertActions(Collection aMoDatas)", "myConverterActions: " + this.myConverterActions);
        }
        ConverterActionBase converterActionBase = null;
        Iterator iterator = this.getConverterActions().iterator();
        while (iterator.hasNext()) {
            converterActionBase = (ConverterActionBase)iterator.next();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "executeConvertActions(Collection aMoDatas)", "Calling execute on ConverterAction\n\ttheConverterAction: " + converterActionBase);
            }
            converterActionBase.execute(collection, this.typeName, this.toVersion);
        }
    }

    public LinkedList getConverterActions() {
        return this.myConverterActions;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getFromVersion() {
        return this.fromVersion;
    }

    public Integer getToVersion() {
        return this.toVersion;
    }

    public String toString() {
        return "\n\ttypeName: " + this.typeName + "\n\tfromVersion: " + this.fromVersion + "\n\ttoVersion: " + this.toVersion + "\n\tconvertActions: " + this.myConverterActions;
    }
}

