/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.su.convert.base.ConverterStepBase;
import se.ericsson.cello.su.convert.base.UpgradeConvertFileInfoContainer;
import se.ericsson.cello.su.convert.base.UpgradeConvertInfoContainer;
import se.ericsson.cello.su.convert.base.UpgradeConvertStepCollector;
import se.ericsson.cello.su.convert.base.UpgradeConvertStepInfoContainer;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.su.convert.exception.SuConvertFileHandlerException;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.convert.file.handler.UnConvertFileHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradeMoDataConvertHandler {
    public UpgradeMoDataConvertHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeMoDataConvertHandler()");
        }
    }

    public boolean convert(UpgradeConvertInfoContainer upgradeConvertInfoContainer) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convert(UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "anUpgradeConvertInfoContainer: " + upgradeConvertInfoContainer);
        }
        Collection collection = new Vector();
        Set set = upgradeConvertInfoContainer.getOldMoDataRevisions().keySet();
        Set set2 = upgradeConvertInfoContainer.getNewMoDataRevisions().keySet();
        Integer n = null;
        Integer n2 = null;
        String string = null;
        Iterator iterator = upgradeConvertInfoContainer.getAllMoDataTypeNames().iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            n = null;
            n2 = null;
            string = (String)iterator.next();
            if (set.contains(string)) {
                n = (Integer)upgradeConvertInfoContainer.getOldMoDataRevisions().get(string);
                n2 = set2.contains(string) ? (Integer)upgradeConvertInfoContainer.getNewMoDataRevisions().get(string) : new Integer(0);
            } else {
                bl = false;
            }
            if (!bl) continue;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "convert(UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "Found a SU MO TypeName. Check if convert needed.\n\ttheMoDataTypeName: " + string + "\n\ttheOldMoDataVersion: " + n + "\n\ttheNewMoDataVersion: " + n2);
            }
            if (n.equals(n2)) continue;
            collection = this.addStepInfo(collection, new UpgradeConvertStepInfoContainer(string, n, n2));
        }
        if (set.size() < set2.size()) {
            String string2 = null;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                if (set.contains(string2)) continue;
                collection = this.addStepInfo(collection, new UpgradeConvertStepInfoContainer(string2, new Integer(0), (Integer)upgradeConvertInfoContainer.getNewMoDataRevisions().get(string2)));
            }
        }
        return this.convert(collection, upgradeConvertInfoContainer);
    }

    private boolean convert(Collection collection, UpgradeConvertInfoContainer upgradeConvertInfoContainer) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "convert(Collection theConvertStepInfoContainers, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "theConvertStepInfoContainers: " + collection);
        }
        UpgradeConvertStepCollector upgradeConvertStepCollector = null;
        UpgradeConvertStepInfoContainer upgradeConvertStepInfoContainer = null;
        LinkedList linkedList = new LinkedList();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                upgradeConvertStepInfoContainer = (UpgradeConvertStepInfoContainer)iterator.next();
                upgradeConvertStepCollector = new UpgradeConvertStepCollector();
                linkedList.addAll(upgradeConvertStepCollector.getConvertStepsToBeExecuted(upgradeConvertStepInfoContainer));
            }
        }
        catch (SuConvertActionException suConvertActionException) {
            throw new SuConverterException("Class: " + this.getClass() + "\n\tMethod: convert(Collection theConvertStepInfoContainers, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)" + "\n\tMessage: Exception caught when collecting steps." + "\n\tException info: " + suConvertActionException);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "convert(Collection theConvertStepInfoContainers, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "Throwable caught when collecting steps.\n\ttheConvertStepInfoContainer: " + upgradeConvertStepInfoContainer, throwable);
            throw new SuConverterException("Class: " + this.getClass() + "\n\tMethod: convert(Collection theConvertStepInfoContainers, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)" + "\n\tMessage: Throwable caught when collecting steps." + "\n\ttheConvertStepInfoContainer: " + upgradeConvertStepInfoContainer + "\n\tThrowable: " + throwable);
        }
        if (linkedList.isEmpty()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "convert(Collection theConvertStepInfoContainers, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "No convert steps found. No conversion of persistent data in System Upgrade related MOs will be executed.");
            }
            return false;
        }
        return this.executeConvertSteps(linkedList, upgradeConvertInfoContainer);
    }

    private boolean executeConvertSteps(Collection collection, UpgradeConvertInfoContainer upgradeConvertInfoContainer) throws SuConverterException {
        Trace.log1(this.getClass(), "executeConvertSteps(Collection theConverterSteps, UpgradeConvertInfoContainer anUpgradeConvertInfoContainer)", "Starting to execute convert steps for System Upgrade related MOs.\n\tThe number of ConvertSteps that will be executed: " + collection.size() + "\n\tanUpgradeConvertInfoContainer: " + upgradeConvertInfoContainer + "\n\ttheConverterSteps: " + collection);
        boolean bl = false;
        ConverterStepBase converterStepBase = null;
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                converterStepBase = (ConverterStepBase)iterator.next();
                if (converterStepBase.prepareConvert(upgradeConvertInfoContainer.getMoDatas())) {
                    Trace.log1(this.getClass(), "executeConvertSteps(Collection theConverterSteps)", "Convert Step requested to be executed last. Execution of convert steps is put on hold until all other converters has executed.");
                    bl = true;
                    break;
                }
                Trace.log1(this.getClass(), "executeConvertSteps(Collection theConverterSteps)", "Starting to execute step.\n\tType: " + converterStepBase.getTypeName() + "\n\tFromVersion: " + converterStepBase.getFromVersion() + "\n\tToVersion: " + converterStepBase.getToVersion());
                if (Trace.valid(this.getClass(), 23)) {
                    Trace.debug(this.getClass(), 23, "executeConvertSteps(Collection theConvertSteps)", "The step to be executed: " + converterStepBase);
                }
                long l = System.currentTimeMillis();
                converterStepBase.executeConvertActions(upgradeConvertInfoContainer.getMoDatas());
                long l2 = System.currentTimeMillis();
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "executeConvertSteps(Collection theConverterSteps)", "Convert Step executed successfully.\n\tExecution time: " + (l2 - l) + " ms.");
            }
            if (!bl) {
                this.handleRecordConvertToFile(collection);
            }
        }
        catch (SuConvertActionException suConvertActionException) {
            throw new SuConverterException("Exception caught when calling execute on ConvertStep.\n\ttheConvertStep: " + converterStepBase + "\n\tException info: " + suConvertActionException);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "runConvertActions(Collection theConvertSteps)", "Throwable caught when converting SU MoData.\n\ttheConvertStep: " + converterStepBase, throwable);
            throw new SuConverterException("Throwable caught when calling execute on ConvertStep. Throwable: " + throwable);
        }
        return bl;
    }

    private Collection addStepInfo(Collection collection, UpgradeConvertStepInfoContainer upgradeConvertStepInfoContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addStepInfo(theConvertStepInfoContainers, aConvertStepInfoContainer)", "theConvertStepInfoContainers: " + collection + "\n\taConvertStepInfoContainer: " + upgradeConvertStepInfoContainer);
        }
        boolean bl = false;
        UpgradeConvertStepInfoContainer upgradeConvertStepInfoContainer2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            upgradeConvertStepInfoContainer2 = (UpgradeConvertStepInfoContainer)iterator.next();
            if (!upgradeConvertStepInfoContainer2.isEqual(upgradeConvertStepInfoContainer)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "addStepInfo(Collection theConvertStepInfoContainers, ConvertStepInfoContainer aConvertStepInfoContainer)", "Adding convertion step: " + upgradeConvertStepInfoContainer);
            }
            collection.add(upgradeConvertStepInfoContainer);
        }
        return collection;
    }

    private void handleRecordConvertToFile(Collection collection) throws SuConverterException {
        if (UpgradeConvertFileInfoContainer.getRecordConvertToFile()) {
            Trace.info(this.getClass(), "runConvertActions(theConvertSteps)", "Record convert to file is needed. Starting to write unconvert information to file: " + UpgradeConvertFileInfoContainer.getUnConvertFilePath());
            try {
                UnConvertFileHandler unConvertFileHandler = new UnConvertFileHandler(UpgradeConvertFileInfoContainer.getUnConvertFileDirPath(), UpgradeConvertFileInfoContainer.getUnConvertFileName());
                unConvertFileHandler.storeUnConvertInformation(collection);
            }
            catch (SuConvertFileHandlerException suConvertFileHandlerException) {
                throw new SuConverterException("Class: " + this.getClass() + "\n\tMethod: runConvertActions(Collection theConvertSteps)" + "\n\tMessage: Exception caught when trying to write unconvert info to file." + "\n\ttheConvertSteps: " + collection + "\n\tException info: " + suConvertFileHandlerException);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "runConvertActions(Collection theConvertSteps)", "Throwable caught when trying to write unconvert info to file.\n\ttheConvertSteps: " + collection, throwable);
                throw new SuConverterException("Class: " + this.getClass() + "\n\tMethod: runConvertActions(Collection theConvertSteps)" + "\n\tMessage: Exception caught when trying to write unconvert info to file." + "\n\ttheConvertSteps: " + collection + "\n\tThrowable: " + throwable);
            }
            Trace.info(this.getClass(), "runConvertActions(theConvertSteps)", "All unconvert info has been written to file: " + UpgradeConvertFileInfoContainer.getUnConvertFilePath());
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "runConvertActions(theConvertSteps)", "Record convert to file is NOT required, information how to unconvert will not be generated.");
        }
    }
}

