/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.db;

import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.su.convert.db.ConvertDbTableVersion;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageStringHandler;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradeConvertDataBaseHandler {
    public static boolean suConverterTempTableExist() throws SuConverterException {
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 20)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 20, "suConverterTempTableExist()");
        }
        boolean bl = true;
        if (UpgradeConvertDataBaseHandler.getConvertDbTableToBeUsed().equals(ConvertDbTableVersion.VERSION_UNKNOWN)) {
            bl = false;
        }
        return bl;
    }

    public static HashMap getDbTableInformation(ConvertDbTableVersion convertDbTableVersion) throws DbAccessException {
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 20)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 20, "getDbTableInformation(ConvertDbTableVersion aConvertDbTableVersion)aConvertDbTableVersion: " + convertDbTableVersion);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        if (convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_2)) {
            string = "suconvertertemptable_02";
        } else if (convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_1)) {
            string = "suconvertertemptable_01";
        } else if (convertDbTableVersion.equals(ConvertDbTableVersion.VERSION_0)) {
            string = "suconvertertemptable_00";
        } else {
            return hashMap;
        }
        DbStringWrapper dbStringWrapper = new DbStringWrapper(string);
        dbStringWrapper.connectToDatabase();
        int[] nArray = dbStringWrapper.retrieveAllPrimaryKeys();
        String string2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            string2 = dbStringWrapper.retrieveRow(nArray[i]);
            hashMap.put(UpgradeDB_StorageStringHandler.getAttributeName(string2), UpgradeDB_StorageStringHandler.getAttributeValue(string2));
        }
        dbStringWrapper.disconnectFromDatabase();
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 21)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 21, "getDbTableInformation()", "Returning - theDbTableInformation: " + hashMap);
        }
        return hashMap;
    }

    public static void setDbTableInformation(HashMap hashMap) throws SuConverterException {
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 20)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 20, "setDbTableInformation(aDbTableInformation)", "aDbTableInformation: " + hashMap);
        }
        UpgradeConvertDataBaseHandler.deleteTable("suconvertertemptable_02");
        try {
            DbStringWrapper dbStringWrapper = new DbStringWrapper("suconvertertemptable_02");
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            int n = control.getCoordinator().getTransactionID();
            Iterator iterator = hashMap.keySet().iterator();
            int n2 = 0;
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)hashMap.get(string);
                dbStringWrapper.createRow(n, n2, UpgradeDB_StorageStringHandler.createDB_String(string, string2));
                ++n2;
            }
            control.getTerminator().commit();
        }
        catch (Exception exception) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "setDB_TableAttributes(boolean aRecordConvertToFile, boolean aRemoveTableAfterRestart, HashMap aSuMoDataRevisions)", "Exception caught when trying to set SU DB table information.", exception);
            throw new SuConverterException("Exception caught when trying to set SU DB table information.");
        }
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 21)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 21, "setDbTableInformation(aDbTableInformation)", "The information has been stored in the DataBase table: suconvertertemptable_02");
        }
    }

    public static void deleteAllConvertTables() throws SuConverterException {
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 20)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 20, "deleteAllConvertTables()");
        }
        UpgradeConvertDataBaseHandler.deleteTable("suconvertertemptable_00");
        UpgradeConvertDataBaseHandler.deleteTable("suconvertertemptable_01");
        UpgradeConvertDataBaseHandler.deleteTable("suconvertertemptable_02");
    }

    public static void deleteTable(String string) throws SuConverterException {
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 20)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 20, "deleteTable(String aTableName)", "aTableName: " + string);
        }
        try {
            if (DbStringWrapper.tableExists((String)string)) {
                if (Trace.valid(UpgradeConvertDataBaseHandler.class, 22)) {
                    Trace.debug(UpgradeConvertDataBaseHandler.class, 22, "deleteTable(String aTableName)", "The SU temp table exist, trying to delete it.\n\taTableName: " + string);
                }
                DbStringWrapper dbStringWrapper = new DbStringWrapper(string);
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                int n = control.getCoordinator().getTransactionID();
                dbStringWrapper.deleteTable(n);
                control.getTerminator().commit();
            } else if (Trace.valid(UpgradeConvertDataBaseHandler.class, 22)) {
                Trace.debug(UpgradeConvertDataBaseHandler.class, 22, "deleteTable(String aTableName)", "The SU temp table does not exist.\n\taTableName: " + string);
            }
        }
        catch (DbAccessException dbAccessException) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "deleteTable(String aTableName)", "DbAccessException caught when trying to delete table.aTableName: " + string, dbAccessException);
            throw new SuConverterException("Exception caught when trying to delete table. Exception info: " + (Object)((Object)dbAccessException));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "deleteTable(String aTableName)", "TransactionRolledBackException exception caught when trying to delete table.", transactionRolledBackException);
            throw new SuConverterException("TransactionRolledBackException caught when trying to delete table. Exception info: " + (Object)((Object)transactionRolledBackException));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "deleteTable(String aTableName)", "InactiveTransactionException exception caught when trying to delete table.", inactiveTransactionException);
            throw new SuConverterException("TransactionRolledBackException caught when trying to delete table. Exception info: " + (Object)((Object)inactiveTransactionException));
        }
        catch (Throwable throwable) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "deleteTable(String aTableName)", "Throwable caught when trying to delete table.", throwable);
            throw new SuConverterException("Throwable caught when trying to delete table. Exception info: " + throwable);
        }
    }

    public static ConvertDbTableVersion getConvertDbTableToBeUsed() throws SuConverterException {
        ConvertDbTableVersion convertDbTableVersion = ConvertDbTableVersion.VERSION_UNKNOWN;
        try {
            if (DbStringWrapper.tableExists((String)"suconvertertemptable_02")) {
                convertDbTableVersion = ConvertDbTableVersion.VERSION_2;
            } else if (DbStringWrapper.tableExists((String)"suconvertertemptable_01")) {
                convertDbTableVersion = ConvertDbTableVersion.VERSION_1;
            } else if (DbStringWrapper.tableExists((String)"suconvertertemptable_00")) {
                convertDbTableVersion = ConvertDbTableVersion.VERSION_0;
            }
        }
        catch (DbAccessException dbAccessException) {
            Trace.error(UpgradeConvertDataBaseHandler.class, "getConvertDbTableToBeUsed()", "DbAccessException caught when trying to find latest version of ConvertDbTable.", dbAccessException);
            throw new SuConverterException("DbAccessException caught when trying to find version of ConvertDbTable. Exception info: " + (Object)((Object)dbAccessException));
        }
        if (Trace.valid(UpgradeConvertDataBaseHandler.class, 21)) {
            Trace.debug(UpgradeConvertDataBaseHandler.class, 21, "getConvertDbTableToBeUsed()", "Returning - theConvertDbTableVersion: " + convertDbTableVersion);
        }
        return convertDbTableVersion;
    }
}

