/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.file.proxy;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.file.parser.XML_ParserFactory;
import se.ericsson.cello.su.convert.actions.AddAttributeConverterAction;
import se.ericsson.cello.su.convert.actions.AddMoConverterAction;
import se.ericsson.cello.su.convert.actions.DeleteAttributeConverterAction;
import se.ericsson.cello.su.convert.actions.DeleteMoConverterAction;
import se.ericsson.cello.su.convert.actions.ReplaceLdnConverterAction;
import se.ericsson.cello.su.convert.actions.SetAttributeConverterAction;
import se.ericsson.cello.su.convert.attribute.BooleanConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.attribute.FloatConverterAttribute;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.LongConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ReferenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.SequenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StructConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.base.ConverterActionType;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.base.ConverterStepBase;
import se.ericsson.cello.su.convert.base.SystemCreated_ConvertStep;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.su.convert.exception.SuConvertFileHandlerException;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.convert.file.parser.UnConvertStepElement;
import se.ericsson.cello.su.convert.file.parser.UnConvertStepsElement;
import se.ericsson.cello.su.convert.file.parser.action.AddAttributeElement;
import se.ericsson.cello.su.convert.file.parser.action.AddMoElement;
import se.ericsson.cello.su.convert.file.parser.action.DeleteAttributeElement;
import se.ericsson.cello.su.convert.file.parser.action.DeleteMoElement;
import se.ericsson.cello.su.convert.file.parser.action.ReplaceLdnElement;
import se.ericsson.cello.su.convert.file.parser.action.SetAttributeElement;
import se.ericsson.cello.su.convert.file.parser.action.UnConvertActionInterface;
import se.ericsson.cello.su.convert.file.parser.attribute.BooleanAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.FloatAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.IntegerAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.LongAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.ReferenceAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.SequenceAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.StringAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.StructAttributeElement;
import se.ericsson.cello.su.convert.file.parser.attribute.UnConvertAttributeInterface;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.su.xmlparser.base.XmlElement;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ConverterFileProxy {
    private UnConvertStepsElement myUnConvertStepsElement = null;

    public ConverterFileProxy() {
        this.myUnConvertStepsElement = new UnConvertStepsElement();
    }

    public ConverterFileProxy(String string) throws SuConvertFileHandlerException {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ConverterFileProxy(String aFilePathToUnConvertFile)", "aFilePathToUnConvertFile: " + string);
        }
        if (!(file = new File(string)).exists()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "ConverterFileProxy(String aFilePathToUnConvertFile)", "The UnConvertFile does not exist, creating empty root element.\n\ttheUnConvertFile: " + file);
            }
            this.myUnConvertStepsElement = new UnConvertStepsElement();
        }
        try {
            XML_RootElement xML_RootElement = XML_ParserFactory.instance().parseFile(string, true);
            if (!(xML_RootElement instanceof UnConvertStepsElement)) {
                String string2 = "undefined";
                if (xML_RootElement != null) {
                    string2 = xML_RootElement.getClass().getName();
                }
                throw new SuConvertFileHandlerException("Illegal type of XML file given as input parameter,\n\tConverterFileProxy(String aFilePathToUnConvertFile)\n\tGiven XML file: " + file + "\n\tRoot element type in this file: " + string2);
            }
            this.myUnConvertStepsElement = (UnConvertStepsElement)xML_RootElement;
        }
        catch (SuConvertFileHandlerException suConvertFileHandlerException) {
            throw suConvertFileHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "ConverterFileProxy(String aFilePathToUnConvertFile)", "Throwable caught.\n\ttheUnConvertFile: " + file, throwable);
            throw new SuConvertFileHandlerException("Class name: " + this.getClass().getName() + "\n\tConverterFileProxy(String aFilePathToUnConvertFile)" + "\n\tThrowable caught." + "\n\ttheUnConvertFile: " + file + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void createUnConvertStepsElement(Collection collection) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUnConvertStepsElement(Collection aConverterSteps)", "aConverterSteps: " + collection);
        }
        this.myUnConvertStepsElement = new UnConvertStepsElement();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.myUnConvertStepsElement.addUnConvertStepElement(this.createUnConvertStepElement((ConverterStepBase)iterator.next()));
        }
    }

    private UnConvertStepElement createUnConvertStepElement(ConverterStepBase converterStepBase) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUnConvertStepElement(ConverterStepBase aConverterStep)", "aConverterStep: " + converterStepBase);
        }
        String string = converterStepBase.getToVersion().toString();
        String string2 = converterStepBase.getFromVersion().toString();
        UnConvertStepElement unConvertStepElement = new UnConvertStepElement(string, string2, converterStepBase.getTypeName());
        LinkedList linkedList = (LinkedList)converterStepBase.getConverterActions().clone();
        while (!linkedList.isEmpty()) {
            unConvertStepElement.addUnConvertActionElements(this.createUnConvertActionElements((ConverterActionBase)linkedList.removeLast()));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createUnConvertStepElement(ConverterStepBase aConverterStep)", "Returning - theUnConvertStepElement: " + unConvertStepElement);
        }
        return unConvertStepElement;
    }

    private Collection createUnConvertActionElements(ConverterActionBase converterActionBase) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUnConvertActionElements(ConverterActionBase aConverterActionBase)", "aConverterAction: " + converterActionBase);
        }
        LinkedList<XmlElement> linkedList = new LinkedList<XmlElement>();
        if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.ADD_ATTRIBUTE)) {
            LinkedList linkedList2 = this.createUnConvertAttributeElements(converterActionBase.getConverterAttributes());
            linkedList.add(new DeleteAttributeElement(converterActionBase.getMoLdn(), linkedList2));
        } else if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.DELETE_ATTRIBUTE)) {
            ConverterAttributeBase converterAttributeBase = null;
            Iterator iterator = null;
            String string = null;
            Iterator iterator2 = converterActionBase.getConverterAttributes().iterator();
            while (iterator2.hasNext()) {
                converterAttributeBase = (ConverterAttributeBase)iterator2.next();
                iterator = converterAttributeBase.getPreviousValueLdns().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    linkedList.add(new AddAttributeElement(string, this.createUnConvertAttributeElement(converterAttributeBase, string)));
                }
            }
        } else if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.SET_ATTRIBUTE)) {
            SetAttributeConverterAction setAttributeConverterAction = (SetAttributeConverterAction)converterActionBase;
            ConverterAttributeBase converterAttributeBase = null;
            Iterator iterator = null;
            String string = null;
            Iterator iterator3 = converterActionBase.getConverterAttributes().iterator();
            while (iterator3.hasNext()) {
                converterAttributeBase = (ConverterAttributeBase)iterator3.next();
                iterator = converterAttributeBase.getPreviousValueLdns().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    linkedList.add(new SetAttributeElement(string, this.createUnConvertAttributeElement(converterAttributeBase, string), setAttributeConverterAction.getUpdateMoDataRevision()));
                }
            }
        } else if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.DELETE_MO)) {
            DeleteMoConverterAction deleteMoConverterAction = (DeleteMoConverterAction)converterActionBase;
            LinkedList linkedList3 = this.createUnConvertAttributeElements(deleteMoConverterAction.getConverterAttributes());
            linkedList.add(new AddMoElement(deleteMoConverterAction.getParentLdn(), deleteMoConverterAction.getId(), linkedList3));
        } else if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.ADD_MO)) {
            AddMoConverterAction addMoConverterAction = (AddMoConverterAction)converterActionBase;
            linkedList.add(new DeleteMoElement(addMoConverterAction.getParentLdn(), addMoConverterAction.getId()));
        } else if (converterActionBase.getConverterActionType().isEqualTo(ConverterActionType.REPLACE_LDN)) {
            ReplaceLdnConverterAction replaceLdnConverterAction = (ReplaceLdnConverterAction)converterActionBase;
            linkedList.add(new ReplaceLdnElement(replaceLdnConverterAction.getMoLdn(), replaceLdnConverterAction.getNewMoLdn()));
        } else {
            Trace.error(this.getClass(), "createUnConvertActionElement(ConverterActionBase aConverterActionBase)", "Unknown ConverterAction received.\n\taConverterAction: " + converterActionBase);
            throw new SuConverterException("Unknown ConverterAction received when creating XML structure.");
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createUnConvertActionElement(ConverterActionBase aConverterActionBase)", "Returning - theUnConvertActions: " + linkedList);
        }
        return linkedList;
    }

    private LinkedList createUnConvertAttributeElements(LinkedList linkedList) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUnConvertAttributeElements(LinkedList aConverterAttributes)", "aConverterAttributes: " + linkedList);
        }
        LinkedList<UnConvertAttributeInterface> linkedList2 = new LinkedList<UnConvertAttributeInterface>();
        LinkedList linkedList3 = (LinkedList)linkedList.clone();
        ConverterAttributeBase converterAttributeBase = null;
        while (!linkedList3.isEmpty()) {
            converterAttributeBase = (ConverterAttributeBase)linkedList3.removeLast();
            linkedList2.add(this.createUnConvertAttributeElement(converterAttributeBase, null));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createUnConvertAttributeElements(LinkedList aConverterAttributes)", "Returning - theUnConverterElements: " + linkedList2);
        }
        return linkedList2;
    }

    private UnConvertAttributeInterface createUnConvertAttributeElement(ConverterAttributeBase converterAttributeBase, String string) throws SuConverterException {
        XmlElement xmlElement;
        block14: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "createUnConvertAttributeElement(ConverterAttributeBase aConverterAttribute, String aMoLdn)", "aConverterAttribute: " + converterAttributeBase + "\n\taMoLdn " + string);
            }
            xmlElement = null;
            try {
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.BOOLEAN)) {
                    xmlElement = new BooleanAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.FLOAT)) {
                    xmlElement = new FloatAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.INTEGER)) {
                    xmlElement = new IntegerAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.LONG)) {
                    xmlElement = new LongAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.REFERENCE)) {
                    xmlElement = new ReferenceAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.SEQUENCE)) {
                    LinkedList<UnConvertAttributeInterface> linkedList = new LinkedList<UnConvertAttributeInterface>();
                    Iterator iterator = ((SequenceConverterAttribute)converterAttributeBase).getPreviousValues(string).iterator();
                    while (iterator.hasNext()) {
                        linkedList.add(this.createUnConvertAttributeElement((ConverterAttributeBase)iterator.next(), null));
                    }
                    xmlElement = new SequenceAttributeElement(converterAttributeBase.getName(), linkedList, converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.STRING)) {
                    xmlElement = new StringAttributeElement(converterAttributeBase.getName(), converterAttributeBase.getPreviousValueAsString(string), converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                if (converterAttributeBase.getConvertAttributeType().isEqualTo(ConverterAttributeType.STRUCT)) {
                    LinkedList<UnConvertAttributeInterface> linkedList = new LinkedList<UnConvertAttributeInterface>();
                    Iterator iterator = ((StructConverterAttribute)converterAttributeBase).getPreviousValues(string).iterator();
                    while (iterator.hasNext()) {
                        linkedList.add(this.createUnConvertAttributeElement((ConverterAttributeBase)iterator.next(), null));
                    }
                    xmlElement = new StructAttributeElement(converterAttributeBase.getName(), linkedList, converterAttributeBase.getPreviousIsAVC_NotifierAsString());
                    break block14;
                }
                Trace.error(this.getClass(), "createUnConvertAttributeElement(ConverterAttributeBase aConverterAttribute)", "Unknown converter attribute received.\n\taConverterAttribute: " + converterAttributeBase);
                throw new SuConverterException("Unknown converter attribute received. ConvertAttributeType: " + converterAttributeBase.getConvertAttributeType().getValue());
            }
            catch (ConverterAttributeException converterAttributeException) {
                throw new SuConverterException("ConverterAttributeException caught when trying to create UnConvertAttribute element: " + converterAttributeException);
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createUnConvertAttributeElement(ConverterAttributeBase aConverterAttribute)", "Returning - theUnConvertAttribute: " + xmlElement);
        }
        return xmlElement;
    }

    public LinkedList getConverterSteps() throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConverterSteps()");
        }
        LinkedList<ConverterStepBase> linkedList = new LinkedList<ConverterStepBase>();
        Iterator iterator = this.myUnConvertStepsElement.getUnConvertStepElements().iterator();
        while (iterator.hasNext()) {
            linkedList.add(this.createConverterStep((UnConvertStepElement)iterator.next()));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getUnConvertSteps()", "Returning - theConverterSteps: " + linkedList);
        }
        return linkedList;
    }

    private ConverterStepBase createConverterStep(UnConvertStepElement unConvertStepElement) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createConverterStep(UnConvertStepElement anUnConvertStepElement)", "aUnConverterStepElement: " + unConvertStepElement);
        }
        SystemCreated_ConvertStep systemCreated_ConvertStep = new SystemCreated_ConvertStep(unConvertStepElement.getMoType(), new Integer(unConvertStepElement.getFromVersion()), new Integer(unConvertStepElement.getToVersion()));
        systemCreated_ConvertStep.addConverterActions(this.createConvertActions(unConvertStepElement.getConverterActionElements()));
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createConverterStep(UnConvertStepElement anUnConvertStepElement)", "Returning - theConverterStep: " + systemCreated_ConvertStep);
        }
        return systemCreated_ConvertStep;
    }

    private Collection createConvertActions(Collection collection) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createConvertActions(Collection aConverterActionElements)", "aConverterActionElements" + collection);
        }
        LinkedList<ConverterActionBase> linkedList = new LinkedList<ConverterActionBase>();
        UnConvertActionInterface unConvertActionInterface = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConverterActionBase converterActionBase;
            Object object;
            unConvertActionInterface = (UnConvertActionInterface)iterator.next();
            if (unConvertActionInterface instanceof AddAttributeElement) {
                object = new AddAttributeConverterAction(unConvertActionInterface.getMoLdn());
                linkedList.add(this.createAttributeConverterAction((ConverterActionBase)object, unConvertActionInterface.getAttributeElements()));
                continue;
            }
            if (unConvertActionInterface instanceof DeleteAttributeElement) {
                object = new DeleteAttributeConverterAction(unConvertActionInterface.getMoLdn());
                linkedList.add(this.createAttributeConverterAction((ConverterActionBase)object, unConvertActionInterface.getAttributeElements()));
                continue;
            }
            if (unConvertActionInterface instanceof SetAttributeElement) {
                object = (SetAttributeElement)unConvertActionInterface;
                converterActionBase = new SetAttributeConverterAction(unConvertActionInterface.getMoLdn(), ((SetAttributeElement)object).getUpdateMoDataRevision());
                linkedList.add(this.createAttributeConverterAction(converterActionBase, unConvertActionInterface.getAttributeElements()));
                continue;
            }
            if (unConvertActionInterface instanceof AddMoElement) {
                object = (AddMoElement)unConvertActionInterface;
                converterActionBase = new AddMoConverterAction(((AddMoElement)object).getParentLDN(), ((AddMoElement)object).getId());
                linkedList.add(this.createAttributeConverterAction(converterActionBase, unConvertActionInterface.getAttributeElements()));
                continue;
            }
            if (unConvertActionInterface instanceof DeleteMoElement) {
                object = (DeleteMoElement)unConvertActionInterface;
                linkedList.add(new DeleteMoConverterAction(((DeleteMoElement)object).getParentLDN(), ((DeleteMoElement)object).getId()));
                continue;
            }
            if (unConvertActionInterface instanceof ReplaceLdnElement) {
                object = (ReplaceLdnElement)unConvertActionInterface;
                linkedList.add(new ReplaceLdnConverterAction(((ReplaceLdnElement)object).getOldMoLdn(), ((ReplaceLdnElement)object).getNewMoLdn()));
                continue;
            }
            Trace.error(this.getClass(), "createConvertActions(Collection aConverterActionElements", "Unknown un convert element received.\n\ttheUnConvertAction: " + unConvertActionInterface);
            throw new SuConverterException("Unknown un convert element received. theUnConvertAction: " + unConvertActionInterface);
        }
        return linkedList;
    }

    private ConverterActionBase createAttributeConverterAction(ConverterActionBase converterActionBase, Collection collection) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributeConverterAction( ConverterActionBase aConverterActionBase, Collection anAttributeElements)", "aConverterActionBase: " + converterActionBase + "\n\tanAddAttributeElement: " + collection);
        }
        UnConvertAttributeInterface unConvertAttributeInterface = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            unConvertAttributeInterface = (UnConvertAttributeInterface)iterator.next();
            converterActionBase.addConverterAttribute(this.createConverterAttribute(unConvertAttributeInterface));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createAttributeConverterAction( ConverterActionBase aConverterActionBase, Collection anAttributeElements)", "Returning - aConverterActionBase: " + converterActionBase);
        }
        return converterActionBase;
    }

    private ConverterAttributeBase createConverterAttribute(UnConvertAttributeInterface unConvertAttributeInterface) throws SuConverterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createConverterAttribute(UnConvertAttributeInterface anUnConverterAttribute)", "anUnConverterAttribute: " + unConvertAttributeInterface);
        }
        if (unConvertAttributeInterface instanceof BooleanAttributeElement) {
            return new BooleanConverterAttribute(unConvertAttributeInterface.getName(), new Boolean(unConvertAttributeInterface.getValue()), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof FloatAttributeElement) {
            return new FloatConverterAttribute(unConvertAttributeInterface.getName(), new Float(unConvertAttributeInterface.getValue()), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof IntegerAttributeElement) {
            return new IntegerConverterAttribute(unConvertAttributeInterface.getName(), new Integer(unConvertAttributeInterface.getValue()), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof LongAttributeElement) {
            return new LongConverterAttribute(unConvertAttributeInterface.getName(), new Long(unConvertAttributeInterface.getValue()), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof ReferenceAttributeElement) {
            return new ReferenceConverterAttribute(unConvertAttributeInterface.getName(), unConvertAttributeInterface.getValue(), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof SequenceAttributeElement) {
            LinkedList<ConverterAttributeBase> linkedList = new LinkedList<ConverterAttributeBase>();
            Iterator iterator = ((SequenceAttributeElement)unConvertAttributeInterface).getAttributeElements().iterator();
            while (iterator.hasNext()) {
                linkedList.add(this.createConverterAttribute((UnConvertAttributeInterface)iterator.next()));
            }
            return new SequenceConverterAttribute(unConvertAttributeInterface.getName(), linkedList, new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof StringAttributeElement) {
            return new StringConverterAttribute(unConvertAttributeInterface.getName(), unConvertAttributeInterface.getValue(), new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        if (unConvertAttributeInterface instanceof StructAttributeElement) {
            LinkedList<ConverterAttributeBase> linkedList = new LinkedList<ConverterAttributeBase>();
            Iterator iterator = ((StructAttributeElement)unConvertAttributeInterface).getAttributeElements().iterator();
            while (iterator.hasNext()) {
                linkedList.add(this.createConverterAttribute((UnConvertAttributeInterface)iterator.next()));
            }
            return new StructConverterAttribute(unConvertAttributeInterface.getName(), linkedList, new Boolean(unConvertAttributeInterface.getIsAvcNotifier()));
        }
        Trace.error(this.getClass(), "createConverterAttribute(UnConverterAttributeInterface anUnConverterAttribute)", "Unknown converter attribute received.\n\tanUnConverterAttribute: " + unConvertAttributeInterface);
        throw new SuConverterException("Unknown converter attribute received. theUnConvertActionElement: " + unConvertAttributeInterface);
    }

    public void print(PrintStream printStream) throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.myUnConvertStepsElement.validate();
        this.myUnConvertStepsElement.print(printStream);
    }
}

