/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.step;

import java.io.File;
import se.ericsson.cello.configurationversion.create.CV_ProgramConfigurationCollector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.convert.step.TriggerEvent;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.upgradepackage.control.UpgradeController;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.updatelms.UpdateLoadModuleMOsController;
import se.ericsson.cello.upgradepackage.upgrade.UpdateAttributeInPiuTypeData;
import se.ericsson.cello.upgradepackage.upgrade.UpdateAttributesInSubrackProdType;
import se.ericsson.cello.upgradepackage.upgrade.UpgradePackageUpgrader;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;

public class SU_TriggerHandler
implements Runnable {
    private UpgradeMaster myUpgradeMaster = null;
    private File myUCF = null;
    private UpgradePackageUpgrader myUpgradePackageUpgrader = null;
    private UpgradeParticipator myUpgradeParticipator = null;
    private UpgradePackageMoExtended myUpgradePackageMo = null;
    private BlockingQueue myQueue = new BlockingQueue();
    private static final String CMA_DELAY_TRIGGER = "CMA_delay_";

    public SU_TriggerHandler(UpgradeMaster upgradeMaster, File file, UpgradeParticipator upgradeParticipator, UpgradePackageMoExtended upgradePackageMoExtended, UpgradePackageUpgrader upgradePackageUpgrader) {
        this.myUpgradeMaster = upgradeMaster;
        this.myUCF = file;
        this.myUpgradeParticipator = upgradeParticipator;
        this.myUpgradePackageMo = upgradePackageMoExtended;
        this.myUpgradePackageUpgrader = upgradePackageUpgrader;
        new Thread((Runnable)this, "SU_TriggerHandler").start();
    }

    public void triggerIndicated(String string) {
        TriggerEvent triggerEvent = new TriggerEvent(this, string);
        this.myQueue.enqueue((Object)triggerEvent);
    }

    public void run() {
        boolean bl = true;
        TriggerEvent triggerEvent = null;
        try {
            triggerEvent = (TriggerEvent)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + triggerEvent);
            }
            if (triggerEvent.getTriggerName().equalsIgnoreCase("INITIATE")) {
                Object object;
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                jvmMO_HandlerInterface.logMemoryInformation();
                Trace.log1(this.getClass(), "run()", "Following tasks will be performed:\n\t- Update of Load Module MO's\n\t- Re-configuration of programs\n\t- Update upgradeable PIUs with wildcard product revision\n\t- Update Subracks with SubrackProdType information.\n\t- Updating other loader name information");
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "All existing MO's of type LoadModule are updated with data from the Upgrade Control File (UCF).");
                }
                if (bl = this.updateLoadModuleMOs(false)) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run()", "Re-configuration of programs for the TO version.");
                    }
                    bl = this.doReconfigurePrograms();
                }
                if (bl) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run()", "Update upgradeable PIUs with wildcard product revision.");
                    }
                    object = ServiceFinder.getUpgradeablePIU_HandlerInterface();
                    bl = object.updateUpgradeablePIUSWithProductData();
                }
                if (bl) {
                    bl = this.configureJVM_PIUsWithWildcards();
                }
                if (bl) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run()", "Update Subracks with SubrackProdType information.");
                    }
                    object = ServiceFinder.getSubrackMO_HandlerInterface();
                    bl = object.updateSubrackWithSubrackProdTypeData();
                }
                jvmMO_HandlerInterface.logMemoryInformation();
            } else if (triggerEvent.getTriggerName().equalsIgnoreCase("CONVERT")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Activate the CV program information collector");
                }
                CV_ProgramConfigurationCollector.instance().activate();
                CV_ProgramConfigurationCollector.instance().update();
            } else if (triggerEvent.getTriggerName().equalsIgnoreCase("PRELOAD")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Activate the CV program information collector");
                }
                if (!CV_ProgramConfigurationCollector.instance().isActive()) {
                    CV_ProgramConfigurationCollector.instance().activate();
                    CV_ProgramConfigurationCollector.instance().update();
                }
            } else if (triggerEvent.getTriggerName().equalsIgnoreCase("FINISH")) {
                SubrackMO_HandlerInterface subrackMO_HandlerInterface;
                UpdateAttributesInSubrackProdType updateAttributesInSubrackProdType;
                UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface;
                UpdateAttributeInPiuTypeData updateAttributeInPiuTypeData;
                Trace.log1(this.getClass(), "run()", "Following tasks will be performed:\n\t- Update of Load Module MO's\n\t- Update of PiuType MO's\n\t- Update upgradeable PIUs with wildcard product revision\n\t- Update of SubrackProdType MO's\n\t- Update Subracks with SubrackProdType information.\n\t- Un-used RPUs are deleted.");
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                jvmMO_HandlerInterface.logMemoryInformation();
                if (!this.doDeleteOldPrograms()) {
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "All existing MO's of type LoadModule are updated with data from the Upgrade Control File (UCF).");
                }
                if (!this.updateLoadModuleMOs(true)) {
                    bl = false;
                }
                if (!(updateAttributeInPiuTypeData = new UpdateAttributeInPiuTypeData(this.myUpgradePackageMo.getDocumentNumber(null), this.myUpgradePackageMo.getDocumentRevision(null), this.myUCF.getAbsolutePath())).doUpdateAttributes()) {
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Configure JVM PIU RO's with wildcard product number and revision (valid when JVM != Core MP).");
                }
                if (!this.configureJVM_PIUsWithWildcards()) {
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Update upgradeable PIU RO's with wildcard product revision.");
                }
                if (!(upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface()).updateUpgradeablePIUSWithProductData()) {
                    bl = false;
                }
                if (!(updateAttributesInSubrackProdType = new UpdateAttributesInSubrackProdType(this.myUpgradePackageMo.getDocumentNumber(null), this.myUpgradePackageMo.getDocumentRevision(null), this.myUCF.getAbsolutePath())).doUpdateAttributes()) {
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Update Subracks RO's with SubrackProdType information.");
                }
                if (!(subrackMO_HandlerInterface = ServiceFinder.getSubrackMO_HandlerInterface()).updateSubrackWithSubrackProdTypeData()) {
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Un-used RPUs are deleted.");
                }
                RPU_MO_HandlerInterface rPU_MO_HandlerInterface = ServiceFinder.getRPU_MO_HandlerInterface();
                rPU_MO_HandlerInterface.deleteNotUsedRPUs();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Update the CV program imformation collector.");
                }
                CV_ProgramConfigurationCollector.instance().update();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Update UCF checksums (if needed).");
                }
                if (bl && !this.updateUCF_Checksums()) {
                    bl = false;
                }
            } else if (triggerEvent.getTriggerName().startsWith(CMA_DELAY_TRIGGER)) {
                String string = triggerEvent.getTriggerName().substring(CMA_DELAY_TRIGGER.length(), triggerEvent.getTriggerName().length());
                try {
                    long l = new Long(string);
                    Trace.log1(this.getClass(), "run()", "Starts to wait " + l + " seconds as specified in the UCF.");
                    TimeHandler.sleep(l * 1000L);
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.warning(this.getClass(), "run()", "No delay was done due to the trigger didn't match completely with the delay format.");
                }
            } else if (triggerEvent.getTriggerName().startsWith("CONFIRMED")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Update the CV program imformation collector.");
                }
                if (!CV_ProgramConfigurationCollector.instance().isUpToDate()) {
                    CV_ProgramConfigurationCollector.instance().update();
                }
            }
            if (bl) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Sending trigger further on to UpgradePackageUpgrader.");
                }
                if (this.myUpgradePackageUpgrader != null) {
                    bl = this.myUpgradePackageUpgrader.triggerIndication(this.myUpgradeMaster, triggerEvent.getTriggerName());
                }
            }
            this.myUpgradeMaster.triggerConfirmed(this.myUpgradeParticipator, triggerEvent.getTriggerName(), bl);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Error during execution of the received trigger type.\n\tThrowable message: " + throwable.getMessage() + "\n\tmaster instance class name: " + this.myUpgradeMaster + "\n\tTrigger name: " + triggerEvent.getTriggerName(), throwable);
        }
    }

    private boolean doReconfigurePrograms() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doReconfigurePrograms( )");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doReconfigurePrograms( )", "Reconfiguration of programs is executed for each upgradeable PlugInUnit i.e.\n\t\tprograms that will not be valid after the upgrade are set to 'disabled' while new programs are created and set to 'enabled'.");
        }
        try {
            String[] stringArray = UpgradeController.upgradeRegistry().getPlugInUnitMoTypeNames();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            MoIterator moIterator = null;
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            Control control = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doReconfigurePrograms( )", "PlugInUnit type name: " + stringArray[i]);
                }
                if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                while (moIterator.hasMoreElements()) {
                    try {
                        genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                        if (this.isCppPiuOrCppFan(genericUpgradeablePlugInUnit)) {
                            control = null;
                            genericUpgradeablePlugInUnit.actionReconfigureProgramPrepare(null);
                            continue;
                        }
                        control = Transaction.create();
                        genericUpgradeablePlugInUnit.actionReconfigureProgramPrepare(Transaction.getCoordinator(control));
                        Transaction.commit(control);
                    }
                    catch (ProgramMO_HandlerException programMO_HandlerException) {
                        Transaction.rollback(control);
                        return false;
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "doReconfigurePrograms()", "Throwable caught when calling method 'actionReconfigureProgramPrepare(..)' in upgradeable PlugInUnit,\n\tupgradeable PlugInUnit type name: " + stringArray[i], throwable);
                        Transaction.rollback(control);
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "doReconfigurePrograms()", "Exception caught when reconfiguring Programs", exception);
            return false;
        }
        return true;
    }

    private boolean configureJVM_PIUsWithWildcards() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configureJVM_PIUsWithWildcards()");
        }
        try {
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            if (!pIU_MO_HandlerInterface.isSU_VersionSupported("SU_2")) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "Configure JVM MP with wildcard's (reset any old not relevant wildcard PIU(s) and update new wildcard PIU(s)).");
                }
                UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
                upgradeablePIU_HandlerInterface.updateUpgradeablePIUsWhereProductNumberIsWildcard();
                pIU_MO_HandlerInterface.configureJVM_PIUsWithWildcards();
                return true;
            }
            return true;
        }
        catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "configureJVM_PIUsWithWildcards()", "PIU_MO_HandlerException: " + (Object)((Object)pIU_MO_HandlerException));
            }
            return false;
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "configureJVM_PIUsWithWildcards()", "UpgradeablePIU_HandlerException: " + (Object)((Object)upgradeablePIU_HandlerException));
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "configureJVM_PIUsWithWildcards()", "Throwable caught at ...", throwable);
            return false;
        }
    }

    private boolean doDeleteOldPrograms() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doDeleteOldPrograms( )", "Programs that are not valid anymore after the upgrade are deleted i.e.\n\t\tall programs with startstate set to 'disabled'.");
        }
        try {
            String[] stringArray = UpgradeController.upgradeRegistry().getPlugInUnitMoTypeNames();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            MoIterator moIterator = null;
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            Control control = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doDeleteOldPrograms( )", "PlugInUnit type name: " + stringArray[i]);
                }
                if ((moIterator = MoRepository.instance().lookupType(stringArray[i])) == null) continue;
                this.myUpgradePackageMo.oneLoopToRemoveBegin();
                while (moIterator.hasMoreElements()) {
                    try {
                        genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)moIterator.nextMo();
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "doDeleteOldPrograms( )", "theUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit.getLocalDistinguishedName());
                        }
                        if (this.isCppPiuOrCppFan(genericUpgradeablePlugInUnit)) {
                            control = null;
                            genericUpgradeablePlugInUnit.actionRemoveDisabledPrograms(null);
                            continue;
                        }
                        control = Transaction.create();
                        genericUpgradeablePlugInUnit.actionRemoveDisabledPrograms(Transaction.getCoordinator(control));
                        Transaction.commit(control);
                    }
                    catch (Exception exception) {
                        try {
                            String string = "null";
                            if (genericUpgradeablePlugInUnit != null) {
                                string = genericUpgradeablePlugInUnit.getLocalDistinguishedName();
                            }
                            Trace.error(this.getClass(), "doDeleteOldPrograms( )", "Failed to delete an old programs for an upgradeable plug in unit.\n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tLocal Distinguished Name of the plugInUnit: " + string, exception);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        Transaction.rollback(control);
                        return false;
                    }
                }
                control = Transaction.create();
                this.myUpgradePackageMo.oneLoopToRemoveFinished(Transaction.getCoordinator(control));
                Transaction.commit(control);
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "doDeleteOldPrograms()", "Error when trying to delete old programs on plug in unit's", exception);
            return false;
        }
        return true;
    }

    private boolean updateLoadModuleMOs(boolean bl) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateLoadModuleMOs(boolean aDoRefreshFileState)", "aRefreshFileState: " + bl);
        }
        UpdateLoadModuleMOsController updateLoadModuleMOsController = new UpdateLoadModuleMOsController();
        return updateLoadModuleMOsController.updateLoadModuleMOs(this.myUpgradePackageMo.getDocumentNumber(null), this.myUpgradePackageMo.getDocumentRevision(null), this.myUCF, bl);
    }

    private boolean isCppPiuOrCppFan(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCppPiuOrCppFan(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
            return true;
        }
        return genericUpgradeablePlugInUnit instanceof FanMoSU_Access;
    }

    private boolean updateUCF_Checksums() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateUCF_Checksums( )");
        }
        Control control = null;
        try {
            ChecksumHandler checksumHandler;
            ChecksumFileResultInterface checksumFileResultInterface;
            if (!this.myUpgradePackageMo.getOrigUcfChecksum(null).equals("")) {
                return true;
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "updateUCF_Checksums( )", "UCF checksums need to be calculated and set in UP MO.");
            }
            if ((checksumFileResultInterface = (checksumHandler = new ChecksumHandler()).checksumUCF(this.myUpgradePackageMo.getOriginalUpgradeControlFilePath(null))).getChecksumOK()) {
                ChecksumFileResultInterface checksumFileResultInterface2 = checksumHandler.checksumUCF(this.myUpgradePackageMo.getUpgradeControlFilePath(null));
                if (checksumFileResultInterface2.getChecksumOK()) {
                    control = Transaction.create();
                    this.myUpgradePackageMo.setOriginalUcfChecksum(checksumFileResultInterface.getChecksum(), Transaction.getCoordinator(control));
                    this.myUpgradePackageMo.setCurrentUcfChecksum(checksumFileResultInterface2.getChecksum(), Transaction.getCoordinator(control));
                    Transaction.commit(control);
                    return true;
                }
                Trace.error(this.getClass(), "updateUCF_Checksums( )", "Calculation of checksum for current UCF failed,\n\terrorInformation: " + checksumFileResultInterface2.getErrorInfo());
                return false;
            }
            Trace.error(this.getClass(), "updateUCF_Checksums( )", "Calculation of checksum for orig UCF failed,\n\terrorInformation: " + checksumFileResultInterface.getErrorInfo());
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateUCF_Checksums( )", "Throwable caught when trying to calculate and set UCF checksums.", throwable);
            Transaction.rollback(control);
            return false;
        }
    }
}

