/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.step;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.su.convert.actions.AddAttributeConverterAction;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterStepBase;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class UpgradePackage_9000_14100_Step
extends ConverterStepBase {
    public UpgradePackage_9000_14100_Step() {
        super("UpgradePackage", new Integer(9000), new Integer(14100));
    }

    public boolean prepareConvert(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareConvert(Collection aMoDatas)");
        }
        if (!this.isCorrectMoDataRevision(collection)) {
            return true;
        }
        this.createAttributesToBeAdded(collection);
        return false;
    }

    private boolean isCorrectMoDataRevision(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCorrectMoDataRevision(Collection aMoDatas)");
        }
        String string = "Some UpgradePackage MOs has unknown MoData revision, the SU converter will be put last in the MoDataConverter list. UP information: ";
        boolean bl = true;
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!moData.getMoTypeName().equals("UpgradePackage") || moData.getRevision() >= 9000) continue;
            bl = false;
            string = string + "\n\tUP ldn " + moData.getLocalDistinguishedName() + " MoData revision: " + moData.getRevision();
        }
        if (!bl) {
            Trace.log1(this.getClass(), "isCorrectMoDataRevision(Collection aMoDatas)", string);
        }
        return bl;
    }

    private void createAttributesToBeAdded(Collection collection) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeAdded(Collection aMoDatas)");
        }
        AddAttributeConverterAction addAttributeConverterAction = new AddAttributeConverterAction();
        addAttributeConverterAction.addConverterAttribute(new StringConverterAttribute("origUcfChecksum", "", new Boolean(false)));
        addAttributeConverterAction.addConverterAttribute(new StringConverterAttribute("ucfChecksum", "", new Boolean(false)));
        addAttributeConverterAction.addConverterAttribute(new IntegerConverterAttribute("NSI_ElementPresent", new Integer(-1), new Boolean(false)));
        this.myConverterActions.add(addAttributeConverterAction);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createAttributesToBeAdded(Collection aMoDatas)", "myConverterActions: " + this.myConverterActions);
        }
    }
}

