/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.swinstall;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.Collection;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.su.froproxy.cv.interfaces.ChecksumListResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaSswInstallCertReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSswInstallCertRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSswUninstallCertReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSswUninstallCertRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwChecksumFileReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwChecksumFileRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwChecksumListReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwChecksumListRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallCancelReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallDiskSpaceCheckReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallDiskSpaceCheckRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallFileReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallFileReq3;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallFileRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallListReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallListReq3;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallListRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallRemove2Req;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallRemove2Rsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallRemoveReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallRemoveRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallUploadFileReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallUploadFileReq3;
import se.ericsson.cello.su.froproxy.swinstall.OsaSwInstallUploadFileRsp;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfCfm;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfCfmInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfErrorInd;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfErrorIndInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfRej;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfRejInformation;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfReq;
import se.ericsson.cello.su.froproxy.swinstall.OsaVerifySswConfRspInformation;
import se.ericsson.cello.su.froproxy.swinstall.UpgradeStatusHolder;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallDiskSpaceCheckResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallListResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallRemoveResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallUploadFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.SswInstallCertResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.SswUninstallCertResultInformation;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class OsaSwInstallProxy
extends FroProxy
implements ServiceSubscriber,
OsaSwInstallProxyAccess {
    public static final int CELLO_SWINSTALL_DONE = 6;
    private static int SW_INSTALL_GET_UCF_TIMEOUT = 900000;
    private static int SW_INSTALL_LM_TIMEOUT = 0x6DDD00;
    private static int SW_INSTALL_LM_TIMEOUT_AT_UPGRADE = 3000000;
    private static int SW_CHECKSUM_TIMEOUT = 0x6DDD00;
    private static int SSW_TIMEOUT = 0x6DDD00;
    private static int DELETE_LM_FILES_TIMEOUT = 300000;
    private static String OSA_SW_INSTALL_PROC_NAME = "OSA_SWINSTALL_SERVICE_NAME";
    public static final int SW_MAX_IPADDRESS_SIZE = 256;
    public static final int SW_MAX_PATH_SIZE = 256;
    public static final int SW_MAX_ERRORINFO_SIZE = 256;
    private static final String PROTOCOL_VERSION_R1E = "R1E";
    private static final String PROTOCOL_VERSION_R2A = "R2A";
    private static final String PROTOCOL_VERSION_R3A = "R3A";
    private static final String PROTOCOL_VERSION_R4A = "R4A";
    private static final String PROTOCOL_VERSION_R5A = "R5A";
    private static final String PROTOCOL_VERSION_R6A = "R6A";
    private static final String[] PROTOCOL_VERSIONS = new String[]{"R6A", "R5A", "R4A", "R3A", "R2A", "R1E"};
    private static final String[] SUPPORTED_VERSIONS_R1E = new String[]{"SU_1"};
    private static final String[] SUPPORTED_VERSIONS_R2A = new String[]{"SU_1", "SU_2"};
    private static final String[] SUPPORTED_VERSIONS_R3A = new String[]{"SU_1", "SU_2", "SU_3"};
    private static final String[] SUPPORTED_VERSIONS_R4A = new String[]{"SU_1", "SU_2", "SU_3", "SU_4"};
    private static final String[] SUPPORTED_VERSIONS_R5A = new String[]{"SU_1", "SU_2", "SU_3", "SU_4", "SU_5"};
    private static final String[] SUPPORTED_VERSIONS_R6A = new String[]{"SU_1", "SU_2", "SU_3", "SU_4", "SU_5", "SU_6"};
    private static final String[] NO_VERSION_SUPPORTED = new String[0];
    private static OsaSwInstallProxy instance = null;
    private PVSession session = null;
    private NameServerWrapper nameServerWrapper = null;

    private OsaSwInstallProxy() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OsaSwInstallProxy()");
        }
        this.subscribeService();
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentlySupportedVersions()");
        }
        try {
            String[] stringArray = null;
            String string = this.session.obtainSession().getProtocolVersion();
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getCurrentlySupportedVersions()", "theProtocolVersion: " + string);
            }
            if (string.equals(PROTOCOL_VERSION_R6A)) {
                stringArray = SUPPORTED_VERSIONS_R6A;
            } else if (string.equals(PROTOCOL_VERSION_R5A)) {
                stringArray = SUPPORTED_VERSIONS_R5A;
            } else if (string.equals(PROTOCOL_VERSION_R4A)) {
                stringArray = SUPPORTED_VERSIONS_R4A;
            } else if (string.equals(PROTOCOL_VERSION_R3A)) {
                stringArray = SUPPORTED_VERSIONS_R3A;
            } else if (string.equals(PROTOCOL_VERSION_R2A)) {
                stringArray = SUPPORTED_VERSIONS_R2A;
            } else if (string.equals(PROTOCOL_VERSION_R1E)) {
                stringArray = SUPPORTED_VERSIONS_R1E;
            } else {
                Trace.warning(this.getClass(), "getCurrentlySupportedVersions( )", "Unexpected protocol version returned by cv fro at pv negotiation.\n\tExpected protocol version: R1E or R2A or R3A or R4A or R5A or R6A\n\tReturned protocol version: " + string);
                stringArray = NO_VERSION_SUPPORTED;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getCurrentlySupportedVersions()", "RETURNS - theSupportedVersions: " + SuLib.toString(stringArray));
            }
            return stringArray;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "getCurrentlySupportedVersions( )", "FroNotAccessibleException\n\tsession: " + this.session, froNotAccessibleException);
            throw new SU_ConditionalException("getCurrentlySupportedVersions( )\n\tFroNotAccessibleException caught when trying to get protocol version returned by cv fro at pv negotiation.\n\ttFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCurrentlySupportedVersions( )", "Throwable\n\tsession: " + this.session, throwable);
            throw new SU_ConditionalException("getCurrentlySupportedVersions( )\n\tThrowable caught when trying to get protocol version returned by cv fro at pv negotiation.\n\tThrowable: " + throwable);
        }
    }

    public ChecksumListResultInformation receiveOsaSwChecksumListRsp() throws FroNotAccessibleException {
        OsaSwChecksumListRsp osaSwChecksumListRsp;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "receiveOsaSwChecksumListRsp( )");
        }
        if ((osaSwChecksumListRsp = (OsaSwChecksumListRsp)SignalHelper.receive((Class)OsaSwChecksumListRsp.class, (int)SW_CHECKSUM_TIMEOUT)) == null) {
            Trace.error(this.getClass(), "receiveOsaSwChecksumListRsp( )", "Receive of OsaSwChecksumListRsp probably timed out");
            throw new FroNotAccessibleException("receiveOsaSwChecksumListRsp( )\n\tReceive of OsaSwChecksumListRsp probably timed out\n\ttheOsaSwChecksumListRsp: " + (Object)((Object)osaSwChecksumListRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new ChecksumListResultInformation(osaSwChecksumListRsp.getChecksumOk(), osaSwChecksumListRsp.getErrorInfo(), osaSwChecksumListRsp.getLoadModuleId(), osaSwChecksumListRsp.getFilePath(), osaSwChecksumListRsp.getPiuLinkHandlerName(), osaSwChecksumListRsp.getTypeOfResponse());
    }

    public InstallRemoveResultInformation sendOsaSwInstallRemoveReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallRemoveReq(String srcFile)", "aSrcFile: " + string);
        }
        OsaSwInstallRemoveReq osaSwInstallRemoveReq = new OsaSwInstallRemoveReq(MaoFroTypeConverter.string2byteArray((String)string, (int)256));
        OsaSwInstallRemoveRsp osaSwInstallRemoveRsp = (OsaSwInstallRemoveRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallRemoveReq, (Class)OsaSwInstallRemoveRsp.class, (int)DELETE_LM_FILES_TIMEOUT);
        if (osaSwInstallRemoveRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallRemoveReq(String srcFile)", "Receive of theOsaSwInstallRemoveRsp probably timed out");
            throw new FroNotAccessibleException("sendOsaSwInstallRemoveReq(String srcFile)\n\tReceive of theOsaSwInstallRemoveRsp probably timed out\n\ttheOsaSwInstallRemoveRsp: " + (Object)((Object)osaSwInstallRemoveRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallRemoveResultInformation(osaSwInstallRemoveRsp.getResult());
    }

    public InstallRemoveResultInformation sendOsaSwInstallRemove2Req(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallRemove2Req(String aSrcFile)", "aSrcFile: " + string);
        }
        OsaSwInstallRemove2Req osaSwInstallRemove2Req = new OsaSwInstallRemove2Req(MaoFroTypeConverter.string2byteArray((String)string, (int)256));
        OsaSwInstallRemove2Rsp osaSwInstallRemove2Rsp = (OsaSwInstallRemove2Rsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallRemove2Req, (Class)OsaSwInstallRemove2Rsp.class, (int)DELETE_LM_FILES_TIMEOUT);
        if (osaSwInstallRemove2Rsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallRemove2Req(String srcFile)", "Receive of theOsaSwInstallRemove2Rsp probably timed out");
            throw new FroNotAccessibleException("sendOsaSwInstallRemove2Req(String srcFile)\n\tReceive of theOsaSwInstallRemove2Rsp probably timed out\n\ttheOsaSwInstallRemove2Rsp: " + (Object)((Object)osaSwInstallRemove2Rsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallRemoveResultInformation(osaSwInstallRemove2Rsp.getResult());
    }

    public InstallFileResultInformation sendOsaSwInstallFileReq(String string, String string2, String string3, String string4, String string5) throws FroNotAccessibleException {
        block7: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5);
            }
            try {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Waiting 1 s. to make sure that no old rsp signal exists.");
                }
                SignalHelper.receive((Class)OsaSwInstallFileRsp.class, (int)1000);
            }
            catch (Throwable throwable) {
                if (!Trace.valid(this.getClass(), 22)) break block7;
                Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Throwable data: " + throwable.toString());
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Converting received input data to signal format.");
        }
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)20);
        byte[] byArray2 = MaoFroTypeConverter.string2byteArray((String)string2, (int)20);
        byte[] byArray3 = MaoFroTypeConverter.string2byteArray((String)string3, (int)256);
        byte[] byArray4 = MaoFroTypeConverter.string2byteArray((String)string4, (int)256);
        byte[] byArray5 = MaoFroTypeConverter.string2byteArray((String)string5, (int)256);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Sending signal OsaSwInstallFileReq.");
        }
        OsaSwInstallFileReq osaSwInstallFileReq = new OsaSwInstallFileReq(byArray, byArray2, byArray3, byArray4, byArray5);
        OsaSwInstallFileRsp osaSwInstallFileRsp = (OsaSwInstallFileRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallFileReq, (Class)OsaSwInstallFileRsp.class, (int)SW_INSTALL_GET_UCF_TIMEOUT);
        if (osaSwInstallFileRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5 + "\n\tReceive of OsaSwInstallFileRsp probably timed out");
            throw new FroNotAccessibleException("sendOsaSwInstallFileReq(String user_id, String password, String ipAddress, String srcFile, String destFile)\n\tReceive of OsaSwInstallFileRsp probably timed out\n\ttheOsaSwInstallFileRsp: " + (Object)((Object)osaSwInstallFileRsp), "\n\tuser_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5 + OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallFileResultInformation(osaSwInstallFileRsp.getResult());
    }

    public InstallFileResultInformation sendOsaSwInstallFileReq3(String string, String string2, String string3, String string4, String string5) throws FroNotAccessibleException {
        block7: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5);
            }
            try {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Waiting 1 s. to make sure that no old rsp signal exists.");
                }
                SignalHelper.receive((Class)OsaSwInstallFileRsp.class, (int)1000);
            }
            catch (Throwable throwable) {
                if (!Trace.valid(this.getClass(), 22)) break block7;
                Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Throwable data: " + throwable.toString());
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Converting received input data to signal format.");
        }
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)255);
        byte[] byArray2 = MaoFroTypeConverter.string2byteArray((String)string2, (int)20);
        byte[] byArray3 = MaoFroTypeConverter.string2byteArray((String)string3, (int)256);
        byte[] byArray4 = MaoFroTypeConverter.string2byteArray((String)string4, (int)256);
        byte[] byArray5 = MaoFroTypeConverter.string2byteArray((String)string5, (int)256);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "Sending signal OsaSwInstallFileReq3.");
        }
        OsaSwInstallFileReq3 osaSwInstallFileReq3 = new OsaSwInstallFileReq3(byArray, byArray2, byArray3, byArray4, byArray5);
        OsaSwInstallFileRsp osaSwInstallFileRsp = (OsaSwInstallFileRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallFileReq3, (Class)OsaSwInstallFileRsp.class, (int)SW_INSTALL_GET_UCF_TIMEOUT);
        if (osaSwInstallFileRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5 + "\n\tReceive of OsaSwInstallFileRsp probably timed out");
            throw new FroNotAccessibleException("sendOsaSwInstallFileReq3(String user_id, String password, String ipAddress, String srcFile, String destFile)\n\tReceive of OsaSwInstallFileRsp probably timed out\n\ttheOsaSwInstallFileRsp: " + (Object)((Object)osaSwInstallFileRsp), "\n\tuser_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tsrcFile: " + string4 + "\n\tdestFile: " + string5 + OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallFileResultInformation(osaSwInstallFileRsp.getResult(), osaSwInstallFileRsp.getErrorInfo());
    }

    public void sendAsynchOsaSwChecksumListReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendAsynchOsaSwChecksumListReq(String aChecksumListFilePath)", "aChecksumListFilePath: " + string);
        }
        byte[] byArray = SuLib.convertStringToByteArray(string, 256);
        OsaSwChecksumListReq osaSwChecksumListReq = new OsaSwChecksumListReq(byArray);
        try {
            SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwChecksumListReq);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return;
        }
    }

    public ChecksumFileResultInterface sendOsaSwChecksumFileReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwChecksumFileReq(String aFilePath)", "aFilePath: " + string);
        }
        OsaSwChecksumFileReq osaSwChecksumFileReq = new OsaSwChecksumFileReq(string, 256);
        OsaSwChecksumFileRsp osaSwChecksumFileRsp = (OsaSwChecksumFileRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwChecksumFileReq, (Class)OsaSwChecksumFileRsp.class, (int)SW_INSTALL_GET_UCF_TIMEOUT);
        if (osaSwChecksumFileRsp != null) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 20, "sendOsaSwChecksumFileReq(String aFilePath)", "Response on signal OsaSwChecksumFileReq.\n\tresult: " + osaSwChecksumFileRsp.getResult() + "\n\tchecksum: " + osaSwChecksumFileRsp.getChecksum() + "\n\tfilePath: " + osaSwChecksumFileRsp.getFilePath() + "\n\terrorInfo: " + osaSwChecksumFileRsp.getErrorInfo());
            }
            return osaSwChecksumFileRsp;
        }
        Trace.error(this.getClass(), "sendOsaSwChecksumFileReq(String aFilePath)", "Receive of OsaSwChecksumFileRsp probably timed out\n\taFilePath: " + string);
        throw new FroNotAccessibleException("sendOsaSwChecksumFileReq(String aFilePath)\n\tReceive of OsaSwChecksumFileRsp probably timed out\n\taFilePath: " + string + "\n\tOsaSwInstallDiskSpaceCheckRsp: " + osaSwChecksumFileRsp, OSA_SW_INSTALL_PROC_NAME);
    }

    public void sendAsynchOsaSwInstallListReq(String string, String string2, String string3, String string4) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendAsynchOsaSwInstallListReq(String user_id, String password, String ipAddress, String llist)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tllist: " + string4);
        }
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)20);
        byte[] byArray2 = MaoFroTypeConverter.string2byteArray((String)string2, (int)20);
        byte[] byArray3 = MaoFroTypeConverter.string2byteArray((String)string3, (int)256);
        byte[] byArray4 = MaoFroTypeConverter.string2byteArray((String)string4, (int)256);
        OsaSwInstallListReq osaSwInstallListReq = new OsaSwInstallListReq(byArray, byArray2, byArray3, byArray4);
        try {
            SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallListReq);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return;
        }
    }

    public void sendAsynchOsaSwInstallListReq3(String string, String string2, String string3, String string4) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendAsynchOsaSwInstallListReq3(String user_id, String password, String ipAddress, String llist)", "user_id: " + string + "\n\tpassword: *****" + "\n\tipAddress: " + string3 + "\n\tllist: " + string4);
        }
        byte[] byArray = MaoFroTypeConverter.string2byteArray((String)string, (int)255);
        byte[] byArray2 = MaoFroTypeConverter.string2byteArray((String)string2, (int)20);
        byte[] byArray3 = MaoFroTypeConverter.string2byteArray((String)string3, (int)256);
        byte[] byArray4 = MaoFroTypeConverter.string2byteArray((String)string4, (int)256);
        OsaSwInstallListReq3 osaSwInstallListReq3 = new OsaSwInstallListReq3(byArray, byArray2, byArray3, byArray4);
        try {
            SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallListReq3);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return;
        }
    }

    public boolean sendOsaSwInstallCancelReq() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallCancelReq( )");
        }
        OsaSwInstallCancelReq osaSwInstallCancelReq = new OsaSwInstallCancelReq();
        try {
            SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallCancelReq);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return false;
        }
        return true;
    }

    public InstallListResultInformation receiveOsaSwInstallListRsp() throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "receiveOsaSwInstallListRsp()");
        }
        OsaSwInstallListRsp osaSwInstallListRsp = null;
        osaSwInstallListRsp = UpgradeStatusHolder.getInstance().IsUpgradeOngoing() ? (OsaSwInstallListRsp)SignalHelper.receive((Class)OsaSwInstallListRsp.class, (int)SW_INSTALL_LM_TIMEOUT_AT_UPGRADE) : (OsaSwInstallListRsp)SignalHelper.receive((Class)OsaSwInstallListRsp.class, (int)SW_INSTALL_LM_TIMEOUT);
        if (osaSwInstallListRsp == null) {
            Trace.error(this.getClass(), "receiveOsaSwInstallListRsp()", "Receive of theOsaSwInstallListRsp probably timed out");
            throw new FroNotAccessibleException("receiveOsaSwInstallListRsp()\n\tReceive of theOsaSwInstallListRsp probably timed out\n\ttheOsaSwInstallListRsp: " + (Object)((Object)osaSwInstallListRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallListResultInformation(osaSwInstallListRsp.getResult(), osaSwInstallListRsp.getType(), osaSwInstallListRsp.getErrorInfo(), osaSwInstallListRsp.getlmId(), osaSwInstallListRsp.getlmPath());
    }

    public static synchronized OsaSwInstallProxy instance() {
        if (Trace.valid(OsaSwInstallProxy.class, 20)) {
            Trace.debug(OsaSwInstallProxy.class, 20, "subscribeService()");
        }
        if (instance == null) {
            instance = new OsaSwInstallProxy();
        }
        return instance;
    }

    public void subscribeService() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "subscribeService()");
        }
        this.nameServerWrapper = new NameServerWrapper(OSA_SW_INSTALL_PROC_NAME, (ServiceSubscriber)this);
        this.session = new PVSession(OSA_SW_INSTALL_PROC_NAME, PROTOCOL_VERSIONS, "swInstall", 1550);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "subscribeService()", "this.session: " + this.session);
        }
    }

    public void signalReceived(InSignal inSignal) {
    }

    public void serviceAdded(String string) {
    }

    public void serviceAdded() {
    }

    public void serviceRemoved() {
        super.serviceRemoved(OSA_SW_INSTALL_PROC_NAME);
    }

    public InstallUploadFileResultInformation sendOsaSwInstallUploadFileReq(String string, String string2, String string3, String string4, String string5) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallUploadFileReq(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)", "anUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5);
        }
        OsaSwInstallUploadFileReq osaSwInstallUploadFileReq = new OsaSwInstallUploadFileReq(string, string2, string3, string4, string5);
        OsaSwInstallUploadFileRsp osaSwInstallUploadFileRsp = (OsaSwInstallUploadFileRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallUploadFileReq, (Class)OsaSwInstallUploadFileRsp.class, (int)1200000);
        if (osaSwInstallUploadFileRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallUploadFileReq(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)", "Receive of theOsaSwInstallUploadFileRsp probably timed out\n\tanUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5);
            throw new FroNotAccessibleException("sendOsaSwInstallUploadFileReq(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)\n\tReceive of theOsaSwInstallUploadFileRsp probably timed out\n\tanUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5 + "\n\ttheOsaSwInstallUploadFileRsp: " + (Object)((Object)osaSwInstallUploadFileRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallUploadFileResultInformation(osaSwInstallUploadFileRsp.getResult(), osaSwInstallUploadFileRsp.getErrorInfo());
    }

    public void sendOsaVerifySSW_ConfReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaVerifySSW_ConfReq(String aFilePath)", "aFilePath: " + string);
        }
        byte[] byArray = SuLib.convertStringToByteArray(string, 256);
        OsaVerifySswConfReq osaVerifySswConfReq = new OsaVerifySswConfReq(byArray);
        try {
            SignalHelper.send((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaVerifySswConfReq);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "sendOsaVerifySSW_ConfReq(String aFilePath)", "aFilePath: " + string, froNotAccessibleException);
        }
    }

    public OsaVerifySswConfRspInformation receiveOsaVerifySswConfRsp() throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 3)) {
            Trace.debug("receiveOsaVerifySswConfRsp()");
        }
        Class[] classArray = new Class[]{OsaVerifySswConfCfm.class, OsaVerifySswConfErrorInd.class, OsaVerifySswConfRej.class};
        Signal signal = SignalHelper.receiveAttached((OseProcess)this.session.obtainSession().getFroProcess(), (Class[])classArray, (int)SSW_TIMEOUT);
        OsaVerifySswConfRspInformation osaVerifySswConfRspInformation = null;
        if (signal instanceof OsaVerifySswConfCfm) {
            osaVerifySswConfRspInformation = new OsaVerifySswConfCfmInformation();
        } else if (signal instanceof OsaVerifySswConfErrorInd) {
            OsaVerifySswConfErrorInd osaVerifySswConfErrorInd = (OsaVerifySswConfErrorInd)signal;
            osaVerifySswConfRspInformation = new OsaVerifySswConfErrorIndInformation(osaVerifySswConfErrorInd.getErrorInfo(), osaVerifySswConfErrorInd.getFilePath(), osaVerifySswConfErrorInd.getPiuLinkHandlerName(), osaVerifySswConfErrorInd.getIndicationErrorReason());
        } else if (signal instanceof OsaVerifySswConfRej) {
            OsaVerifySswConfRej osaVerifySswConfRej = (OsaVerifySswConfRej)signal;
            osaVerifySswConfRspInformation = new OsaVerifySswConfRejInformation(osaVerifySswConfRej.getErrorInfo());
        }
        return osaVerifySswConfRspInformation;
    }

    public InstallUploadFileResultInformation sendOsaSwInstallUploadFileReq3(String string, String string2, String string3, String string4, String string5) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallUploadFileReq3(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)", "anUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5);
        }
        OsaSwInstallUploadFileReq3 osaSwInstallUploadFileReq3 = new OsaSwInstallUploadFileReq3(string, string2, string3, string4, string5);
        OsaSwInstallUploadFileRsp osaSwInstallUploadFileRsp = (OsaSwInstallUploadFileRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallUploadFileReq3, (Class)OsaSwInstallUploadFileRsp.class, (int)1200000);
        if (osaSwInstallUploadFileRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallUploadFileReq3(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)", "Receive of theOsaSwInstallUploadFileRsp probably timed out\n\tanUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5);
            throw new FroNotAccessibleException("sendOsaSwInstallUploadFileReq3(String anUserId, String aPassword, String aIpAddress, String aSrcFile, String aDestFile)\n\tReceive of theOsaSwInstallUploadFileRsp probably timed out\n\tanUserId: " + string + "\n\taIpAddress: " + string3 + "\n\taPassword: " + "******" + "\n\taSrcFile: " + string4 + "\n\taDestFile: " + string5 + "\n\ttheOsaSwInstallUploadFileRsp: " + (Object)((Object)osaSwInstallUploadFileRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        return new InstallUploadFileResultInformation(osaSwInstallUploadFileRsp.getResult(), osaSwInstallUploadFileRsp.getErrorInfo());
    }

    public InstallDiskSpaceCheckResultInformation sendOsaSwInstallDiskSpaceCheckReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallDiskSpaceCheckReq(String aLoadListFilePath)", "aLoadListFilePath: " + string);
        }
        OsaSwInstallDiskSpaceCheckReq osaSwInstallDiskSpaceCheckReq = new OsaSwInstallDiskSpaceCheckReq(string, 256);
        OsaSwInstallDiskSpaceCheckRsp osaSwInstallDiskSpaceCheckRsp = (OsaSwInstallDiskSpaceCheckRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSwInstallDiskSpaceCheckReq, (Class)OsaSwInstallDiskSpaceCheckRsp.class, (int)1200000);
        if (osaSwInstallDiskSpaceCheckRsp == null) {
            Trace.error(this.getClass(), "sendOsaSwInstallDiskSpaceCheckReq(String aLoadListFilePath)", "Receive of OsaSwInstallDiskSpaceCheckRsp probably timed out\n\taLoadListFilePath: " + string);
            throw new FroNotAccessibleException("sendOsaSwInstallDiskSpaceCheckReq(String aLoadListFilePath)\n\tReceive of OsaSwInstallDiskSpaceCheckRsp probably timed out\n\taLoadListFilePath: " + string + "\n\tOsaSwInstallDiskSpaceCheckRsp: " + (Object)((Object)osaSwInstallDiskSpaceCheckRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 20, "sendOsaSwInstallDiskSpaceCheckReq(String aLoadListFilePath)", "Response on signal OsaSwInstallDiskSpaceCheckReq.\n\tresult: " + osaSwInstallDiskSpaceCheckRsp.getResult() + "\n\terrorInfo: " + osaSwInstallDiskSpaceCheckRsp.getErrorInfo());
        }
        return new InstallDiskSpaceCheckResultInformation(osaSwInstallDiskSpaceCheckRsp.getResult(), osaSwInstallDiskSpaceCheckRsp.getErrorInfo());
    }

    public SswInstallCertResultInformation sendOsaSswInstallCertReq(int n, int n2, int n3, Collection collection) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSswInstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "aReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection);
        }
        OsaSswInstallCertReq osaSswInstallCertReq = new OsaSswInstallCertReq(n, n2, n3, collection);
        OsaSswInstallCertRsp osaSswInstallCertRsp = (OsaSswInstallCertRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSswInstallCertReq, (Class)OsaSswInstallCertRsp.class, (int)1200000);
        if (osaSswInstallCertRsp == null) {
            Trace.error(this.getClass(), "sendOsaSswInstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "Receive of OsaSswInstallCertRsp probably timed out\n\taReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection);
            throw new FroNotAccessibleException("sendOsaSswInstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)\n\tReceive of OsaSswInstallCertRsp probably timed out\n\taReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection + "\n\tOsaSswInstallCertRsp: " + (Object)((Object)osaSswInstallCertRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 20, "sendOsaSswInstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "Response on signal OsaSswInstallCertReq.\n\treferenceId: " + osaSswInstallCertRsp.getReferenceId() + "\n\tresult: " + osaSswInstallCertRsp.getResult() + "\n\terrorInfo: " + osaSswInstallCertRsp.getErrorInfo());
        }
        return new SswInstallCertResultInformation(osaSswInstallCertRsp.getReferenceId(), osaSswInstallCertRsp.getResult(), osaSswInstallCertRsp.getErrorInfo());
    }

    public SswUninstallCertResultInformation sendOsaSswUninstallCertReq(int n, int n2, int n3, Collection collection) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaSswUninstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "aReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection);
        }
        OsaSswUninstallCertReq osaSswUninstallCertReq = new OsaSswUninstallCertReq(n, n2, n3, collection);
        OsaSswUninstallCertRsp osaSswUninstallCertRsp = (OsaSswUninstallCertRsp)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaSswUninstallCertReq, (Class)OsaSswUninstallCertRsp.class, (int)1200000);
        if (osaSswUninstallCertRsp == null) {
            Trace.error(this.getClass(), "sendOsaSswUninstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "Receive of OsaSswUninstallCertRsp probably timed out\n\taReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection);
            throw new FroNotAccessibleException("sendOsaSswUninstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)\n\tReceive of OsaSswUninstallCertRsp probably timed out\n\taReferenceId: " + n + "\n\tanSmn: " + n2 + "\n\tanApn: " + n3 + "\n\taCertsAndCRLs: " + collection + "\n\tOsaSswUninstallCertRsp: " + (Object)((Object)osaSswUninstallCertRsp), OSA_SW_INSTALL_PROC_NAME);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 20, "sendOsaSswUninstallCertReq(int aReferenceId, int anSmn, int anApn, Collection aCertsAndCRLs)", "Response on signal OsaSswUninstallCertReq.\n\treferenceId: " + osaSswUninstallCertRsp.getReferenceId() + "\n\tresult: " + osaSswUninstallCertRsp.getResult() + "\n\terrorInfo: " + osaSswUninstallCertRsp.getErrorInfo());
        }
        return new SswUninstallCertResultInformation(osaSswUninstallCertRsp.getReferenceId(), osaSswUninstallCertRsp.getResult(), osaSswUninstallCertRsp.getErrorInfo());
    }

    public String toString() {
        return "nameServerWrapper: " + this.nameServerWrapper;
    }
}

