/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.froproxy.upi;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.property.PropertyChangeSupport;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.su.froproxy.upi.OsaUpi2PiuNoRollbackReq;
import se.ericsson.cello.su.froproxy.upi.OsaUpiAueConfirmedInd;
import se.ericsson.cello.su.froproxy.upi.OsaUpiAueProgressInd;
import se.ericsson.cello.su.froproxy.upi.OsaUpiAueSubscribedInd;
import se.ericsson.cello.su.froproxy.upi.OsaUpiChangeErrorEscCfm;
import se.ericsson.cello.su.froproxy.upi.OsaUpiChangeErrorEscReq;
import se.ericsson.cello.su.froproxy.upi.OsaUpiGetTriggerProgressCfm;
import se.ericsson.cello.su.froproxy.upi.OsaUpiPiuNoRollbackCfm;
import se.ericsson.cello.su.froproxy.upi.OsaUpiPiuNoRollbackReq;
import se.ericsson.cello.su.froproxy.upi.OsaUpiResetRollbackCfm;
import se.ericsson.cello.su.froproxy.upi.OsaUpiResetRollbackReq;
import se.ericsson.cello.su.froproxy.upi.OsaUpiSetSuperTimerCfm;
import se.ericsson.cello.su.froproxy.upi.OsaUpiSetSuperTimerReq;
import se.ericsson.cello.su.froproxy.upi.OsaUpiStartUpgradeTriggCfm2;
import se.ericsson.cello.su.froproxy.upi.OsaUpiStartUpgradeTriggReq;
import se.ericsson.cello.su.froproxy.upi.UpgradeTriggerResultInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ConfirmedInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ConfirmedWithWarningInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_FailureInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_Information;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ProgressInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_SubscribedInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_TimeoutInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.OsaUpiProxyAccess;
import se.ericsson.cello.su.froproxy.upi.interfaces.TriggerListener;
import se.ericsson.cello.su.froproxy.upi.interfaces.UPI_ProxyPropertyName;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SlotDataAPN_SMN_Container;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class OsaUpiProxy
extends FroProxy
implements ServiceSubscriber,
OsaUpiProxyAccess {
    public int OSA_UPI_MAX_TRIGGER_SUBSPEC_SIZE = 32;
    public static final int CELLO_MAX_PRODUCT_NUMBER_LENGTH = 25;
    public static final int CELLO_MAX_PRODUCT_REVISION_LENGTH = 8;
    public static final int UCI_CLIENT_NAME_LENGTH = 32;
    public static final int UCI_MESSAGE_LENGTH = 256;
    private static final String PROTOCOL_VERSION_CELLO_6000_R1C = "R1C";
    private static final String PROTOCOL_VERSION_CELLO_7_LSV34_1_R1D = "R1D";
    private static final String PROTOCOL_VERSION_LATEST = "R1D";
    private static final String[] SUPPORTED_VERSIONS_R1C = new String[]{"SU_1"};
    private static final String[] SUPPORTED_VERSIONS_R1D = new String[]{"SU_1", "SU_2"};
    private static final String[] NO_VERSION_SUPPORTED = new String[0];
    private NameServerWrapper nameServerWrapper = null;
    private PVSession session = null;
    private static OsaUpiProxy instance = null;
    private static String OSA_UPI_PROC_NAME = "CELLO_UPGRADE_CONTROL_SERVER";
    private int REQUEST_OK = 1;
    private PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
    private CmaSignalPort mySignalPort = null;
    private TriggerListener myTriggerListener = null;
    private Collection myAUEsThatHasReturnedA_Response = new HashSet();

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentlySupportedVersions( )");
        }
        try {
            String string = this.session.obtainSession().getProtocolVersion();
            if (string.equals("R1D")) {
                return SUPPORTED_VERSIONS_R1D;
            }
            if (string.equals(PROTOCOL_VERSION_CELLO_6000_R1C)) {
                return SUPPORTED_VERSIONS_R1C;
            }
            Trace.warning(this.getClass(), "getCurrentlySupportedVersions( )", "Unexpected protocol version returned by cv fro at pv negotiation.\n\tExpected protocol version: R1D or R1C\n\tReturned protocol version: " + string);
            return NO_VERSION_SUPPORTED;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw new SU_ConditionalException("getCurrentlySupportedVersions( )\n\tFroNotAccessibleException caught when trying to get protocol version returned by cv fro at pv negotiation.\n\ttFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException));
        }
    }

    public void addPropertyChangeListener(UPI_ProxyPropertyName uPI_ProxyPropertyName, PropertyChangeListener propertyChangeListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPropertyChangeListener(String anUPI_ProxyPropertyName, PropertyChangeListener aPropertyChangeListener)", "\n\tanUPI_ProxyPropertyName: " + uPI_ProxyPropertyName + "\n\taPropertyChangeListener: " + propertyChangeListener);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(uPI_ProxyPropertyName.getValue(), propertyChangeListener);
    }

    public void removePropertyChangeListener(UPI_ProxyPropertyName uPI_ProxyPropertyName, PropertyChangeListener propertyChangeListener) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removePropertyChangeListener(String anUPI_ProxyPropertyName, PropertyChangeListener aPropertyChangeListener)", "\n\tanUPI_ProxyPropertyName: " + uPI_ProxyPropertyName + "\n\taPropertyChangeListener: " + propertyChangeListener);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(uPI_ProxyPropertyName.getValue(), propertyChangeListener);
    }

    public boolean sendOsaUpiChangeErrorEscReq(int n) {
        OsaUpiChangeErrorEscCfm osaUpiChangeErrorEscCfm;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiChangeErrorEscReq(int escalation)", "escalation: " + n);
        }
        OsaUpiChangeErrorEscReq osaUpiChangeErrorEscReq = new OsaUpiChangeErrorEscReq(n);
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiChangeErrorEscReq( int escalation )", "Sending signal OsaUpiChangeErrorEscReq\n\tescalation: " + n);
            }
            osaUpiChangeErrorEscCfm = (OsaUpiChangeErrorEscCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpiChangeErrorEscReq, (Class)OsaUpiChangeErrorEscCfm.class);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiChangeErrorEscReq( int escalation )", "Response signal OsaUpiChangeErrorEscCfm is received.");
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return false;
        }
        if (osaUpiChangeErrorEscCfm == null) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaUpiChangeErrorEscReq(int escalation)", "Receive of OsaUpiChangeErrorEscCfm probably timed out\n\tescalation: " + n);
            }
            return false;
        }
        return osaUpiChangeErrorEscCfm.success == this.REQUEST_OK;
    }

    public OsaUpiGetTriggerProgressCfm sendOsaUpiGetTriggerProgressReq() throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiGetTriggerProgressReq( )");
        }
        FroEmptySignal froEmptySignal = new FroEmptySignal(66635);
        return (OsaUpiGetTriggerProgressCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froEmptySignal, (Class)OsaUpiGetTriggerProgressCfm.class);
    }

    public boolean sendOsaUpiPiuNoRollbackReq(Vector vector) {
        OsaUpiPiuNoRollbackCfm osaUpiPiuNoRollbackCfm;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiPiuNoRollbackListReq(Vector aSlotDataAPN_SMN_Containers)", "aSlotDataAPN_SMN_Containers: " + vector);
        }
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector.size()];
        Iterator iterator = vector.iterator();
        SlotDataAPN_SMN_Container slotDataAPN_SMN_Container = null;
        int n = 0;
        while (iterator.hasNext()) {
            slotDataAPN_SMN_Container = (SlotDataAPN_SMN_Container)iterator.next();
            nArray[n] = slotDataAPN_SMN_Container.getSwitchModuleNumber();
            nArray2[n] = slotDataAPN_SMN_Container.getAsciiPortNumber();
            ++n;
        }
        OsaUpiPiuNoRollbackReq osaUpiPiuNoRollbackReq = new OsaUpiPiuNoRollbackReq(nArray, nArray2);
        try {
            osaUpiPiuNoRollbackCfm = (OsaUpiPiuNoRollbackCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpiPiuNoRollbackReq, (Class)OsaUpiPiuNoRollbackCfm.class);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return false;
        }
        if (osaUpiPiuNoRollbackCfm == null) {
            Trace.error(this.getClass(), "sendOsaUpiPiuNoRollbackReq(Vector aSlotDataAPN_SMN_Containers)", "Receive of OsaUpiPiuNoRollbackCfm probably timed out\n\taSlotDataAPN_SMN_Containers: " + vector);
            return false;
        }
        if (osaUpiPiuNoRollbackCfm.success == this.REQUEST_OK) {
            return true;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaUpiPiuNoRollbackReq(Vector aSlotDataAPN_SMN_Containers)", "Receive of OsaUpiPiuNoRollbackCfm indicated failure (ignored).\n\taSlotDataAPN_SMN_Containers: " + vector);
        }
        return true;
    }

    public boolean sendOsaUpi2PiuNoRollbackReq(Collection collection) {
        OsaUpiPiuNoRollbackCfm osaUpiPiuNoRollbackCfm;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpi2PiuNoRollbackReq(Collection aPiuFroId)", "aPiuFroIds: " + collection);
        }
        OsaUpi2PiuNoRollbackReq osaUpi2PiuNoRollbackReq = new OsaUpi2PiuNoRollbackReq(collection);
        try {
            osaUpiPiuNoRollbackCfm = (OsaUpiPiuNoRollbackCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpi2PiuNoRollbackReq, (Class)OsaUpiPiuNoRollbackCfm.class);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return false;
        }
        if (osaUpiPiuNoRollbackCfm == null) {
            Trace.error(this.getClass(), "sendOsaUpi2PiuNoRollbackReq(Collection aPiuFroId)", "Receive of OsaUpiPiuNoRollbackCfm probably timed out\n\taPiuFroIds: " + collection);
            return false;
        }
        if (osaUpiPiuNoRollbackCfm.success == this.REQUEST_OK) {
            return true;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Collection aPiuFroId)", "Receive of OsaUpiPiuNoRollbackCfm indicated failure (will be ignored).\n\taPiuFroIds: " + collection);
        }
        return true;
    }

    public boolean sendOsaUpiSetSuperTimerReq(long l) {
        OsaUpiSetSuperTimerCfm osaUpiSetSuperTimerCfm;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiSetSuperTimerReq(long time)", "time: " + l);
        }
        OsaUpiSetSuperTimerReq osaUpiSetSuperTimerReq = new OsaUpiSetSuperTimerReq(l);
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiSetSuperTimerReq(long time)", "Sends signal OsaUpiSetSuperTimerReq to the OsaUPI FRO proc.");
            }
            osaUpiSetSuperTimerCfm = (OsaUpiSetSuperTimerCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpiSetSuperTimerReq, (Class)OsaUpiSetSuperTimerCfm.class);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiSetSuperTimerReq(long time)", "Response signal OsaUpiSetSuperTimerCfm is received.");
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "sendOsaUpiSetSuperTimerReq(long time)", "FroNotAccessibleException caught: " + froNotAccessibleException.toString(), froNotAccessibleException);
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendOsaUpiSetSuperTimerReq(long time)", "Throwable caught: " + throwable.toString(), throwable);
            return false;
        }
        if (osaUpiSetSuperTimerCfm == null) {
            Trace.error(this.getClass(), "sendOsaUpiSetSuperTimerReq(long time)", "Receive of OsaUpiSetSuperTimerCfm probably timed out\n\ttime: " + l);
            return false;
        }
        return osaUpiSetSuperTimerCfm.getResult() == this.REQUEST_OK;
    }

    public void sendOsaUpiStartUpgradeTriggReq(String string, long l, TriggerListener triggerListener) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener )", "triggerSubSpec: " + string + "\n\ttimeout: " + l + "\n\taTriggerListener: " + triggerListener);
        }
        OsaUpiStartUpgradeTriggReq osaUpiStartUpgradeTriggReq = new OsaUpiStartUpgradeTriggReq(MaoFroTypeConverter.string2byteArray((String)string, (int)this.OSA_UPI_MAX_TRIGGER_SUBSPEC_SIZE), l);
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener)", "Sending signal OsaUpiStartUpgradeTriggReq\n\ttriggerSubSpec: " + string);
            }
            this.mySignalPort.addSignalObserver((SignalObserver)this, OsaUpiStartUpgradeTriggCfm2.class);
            OseProcess oseProcess = PortManager.instance().getOseProcess();
            this.myTriggerListener = triggerListener;
            SignalHelper.sendWithSender((OseProcess)this.session.obtainSession().getFroProcess(), (OseProcess)oseProcess, (Signal)osaUpiStartUpgradeTriggReq);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener)", "Trigger has been sent\n\ttriggerSubSpec: " + string);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener)", "FroNotAccessibleException caught " + froNotAccessibleException.toString(), froNotAccessibleException);
            this.mySignalPort.removeSignalObserver((SignalObserver)this, OsaUpiStartUpgradeTriggCfm2.class);
            throw new FroNotAccessibleException("sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener)\n\tSending triggers to subscribed C-AUE's, \n\tUPI FRO not accessible.\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l, OSA_UPI_PROC_NAME);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Throwable caught: " + throwable.toString(), throwable);
            this.mySignalPort.removeSignalObserver((SignalObserver)this, OsaUpiStartUpgradeTriggCfm2.class);
            throw new FroNotAccessibleException("sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout, TriggerListener aTriggerListener)\n\tSending triggers to subscribed C-AUE's, \n\tThrowable caught.\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l, OSA_UPI_PROC_NAME);
        }
    }

    public UpgradeTriggerResultInformation sendOsaUpiStartUpgradeTriggReq(String string, long l) throws FroNotAccessibleException {
        OsaUpiStartUpgradeTriggCfm2 osaUpiStartUpgradeTriggCfm2;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "triggerSubSpec: " + string + "\n\ttimeout: " + l);
        }
        OsaUpiStartUpgradeTriggReq osaUpiStartUpgradeTriggReq = new OsaUpiStartUpgradeTriggReq(MaoFroTypeConverter.string2byteArray((String)string, (int)this.OSA_UPI_MAX_TRIGGER_SUBSPEC_SIZE), l);
        int n = 6000000;
        if (l != 0L) {
            n = new Long((l + 30L) * 1000L).intValue();
        }
        try {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Sending signal OsaUpiStartUpgradeTriggReq\n\ttriggerSubSpec: " + string);
            }
            osaUpiStartUpgradeTriggCfm2 = (OsaUpiStartUpgradeTriggCfm2)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpiStartUpgradeTriggReq, (Class)OsaUpiStartUpgradeTriggCfm2.class, (int)n);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Response signal OsaUpiStartUpgradeTriggCfm2 is received (WAITING 40 s. for IND to be handled).");
            }
            TimeHandler.sleep(40000L);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Response signal OsaUpiStartUpgradeTriggCfm2 has been received and 40 s. has elapsed.");
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "FroNotAccessibleException caught " + froNotAccessibleException.toString(), froNotAccessibleException);
            throw new FroNotAccessibleException("sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)\n\tSending triggers to subscribed C-AUE's, \n\tUPI FRO not accessible.\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l, OSA_UPI_PROC_NAME);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Throwable caught: " + throwable.toString(), throwable);
            throw new FroNotAccessibleException("sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)\n\tSending triggers to subscribed C-AUE's, \n\tThrowable caught.\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l, OSA_UPI_PROC_NAME);
        }
        if (osaUpiStartUpgradeTriggCfm2 == null) {
            Trace.error(this.getClass(), "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Receive of OsaUpiStartUpgradeTriggCfm2 probably timed out\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l);
            throw new FroNotAccessibleException("sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)\n\tSending triggers to subscribed C-AUE's, \n\tUPI FRO not accessible.\n\ttriggerSubSpec: " + string + "\n\ttimeout: " + l + "\n\tretSig: " + (Object)((Object)osaUpiStartUpgradeTriggCfm2), OSA_UPI_PROC_NAME);
        }
        return new UpgradeTriggerResultInformation(osaUpiStartUpgradeTriggCfm2.getResult(), osaUpiStartUpgradeTriggCfm2.getNoOfNotReady(), osaUpiStartUpgradeTriggCfm2.getSizeOfNameList(), osaUpiStartUpgradeTriggCfm2.getNameList());
    }

    public boolean sendOsaUpiResetRollbackReq() {
        OsaUpiResetRollbackCfm osaUpiResetRollbackCfm;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiResetRollbackReq( )");
        }
        OsaUpiResetRollbackReq osaUpiResetRollbackReq = new OsaUpiResetRollbackReq();
        try {
            osaUpiResetRollbackCfm = (OsaUpiResetRollbackCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)osaUpiResetRollbackReq, (Class)OsaUpiResetRollbackCfm.class);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            return false;
        }
        if (osaUpiResetRollbackCfm == null) {
            Trace.error(this.getClass(), "sendOsaUpiResetRollbackReq( )", "Receive of OsaUpiResetRollbackCfm probably timed out");
            return false;
        }
        if (osaUpiResetRollbackCfm.success == this.REQUEST_OK) {
            return true;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaUpiResetRollbackReq()", "Receive of OsaUpiResetRollbackCfm indicated failure (ignored).");
        }
        return true;
    }

    public static synchronized OsaUpiProxy instance() {
        if (instance == null) {
            instance = new OsaUpiProxy();
        }
        return instance;
    }

    private OsaUpiProxy() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OsaUpiProxy()");
        }
        this.subscribeService();
        this.mySignalPort = CmaPortManager.instance();
        this.mySignalPort.addSignalObserver((SignalObserver)this, OsaUpiAueSubscribedInd.class);
        this.mySignalPort.addSignalObserver((SignalObserver)this, OsaUpiAueProgressInd.class);
        this.mySignalPort.addSignalObserver((SignalObserver)this, OsaUpiAueConfirmedInd.class);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "OsaUpiProxy()", "Added as subscriber to signals OsaUpiAueSubscribedInd, OsaUpiAueProgressInd and OsaUpiAueConfirmedInd");
        }
    }

    public void subscribeService() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "subscribeService", "PV-negotiation with PV: R1D");
        }
        this.session = new PVSession(OSA_UPI_PROC_NAME, "R1D", PROTOCOL_VERSION_CELLO_6000_R1C, PROTOCOL_VERSION_CELLO_6000_R1C, "Upi", 1549);
        this.nameServerWrapper = new NameServerWrapper(OSA_UPI_PROC_NAME, (ServiceSubscriber)this);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "subscribeService()", "Added subscription for OsaUPI proxy.");
        }
    }

    public void signalReceived(InSignal inSignal) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "signalReceived(enea.ose.system.InSignal anInsignal)", "anInsignal: " + inSignal);
        }
        try {
            if (inSignal instanceof OsaUpiAueSubscribedInd) {
                OsaUpiAueSubscribedInd osaUpiAueSubscribedInd = (OsaUpiAueSubscribedInd)inSignal;
                AUE_SubscribedInformation aUE_SubscribedInformation = new AUE_SubscribedInformation(osaUpiAueSubscribedInd.getProductNumber(), osaUpiAueSubscribedInd.getProductRevision(), osaUpiAueSubscribedInd.getAUE_Name());
                this.myPropertyChangeSupport.firePropertyChange(UPI_ProxyPropertyName.AUE_Subscribed.getValue(), (Object)"", (Object)aUE_SubscribedInformation);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "FIRE's the property: " + UPI_ProxyPropertyName.AUE_Subscribed.getValue() + "\n\tProperty information: " + aUE_SubscribedInformation);
                }
            } else if (inSignal instanceof OsaUpiAueProgressInd) {
                OsaUpiAueProgressInd osaUpiAueProgressInd = (OsaUpiAueProgressInd)inSignal;
                AUE_ProgressInformation aUE_ProgressInformation = new AUE_ProgressInformation(osaUpiAueProgressInd.getAUE_Name(), osaUpiAueProgressInd.getAdditionalInformation());
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "C-AUE trigger progress information.\n\tC-AUE name: " + osaUpiAueProgressInd.getAUE_Name() + "\n\tAdditional Info: " + osaUpiAueProgressInd.getAdditionalInformation());
                }
                this.myPropertyChangeSupport.firePropertyChange(UPI_ProxyPropertyName.AUE_Progress.getValue(), (Object)"", (Object)aUE_ProgressInformation);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "FIRE's the property: " + UPI_ProxyPropertyName.AUE_Progress.getValue() + "\n\tProperty information: " + aUE_ProgressInformation);
                }
            } else if (inSignal instanceof OsaUpiAueConfirmedInd) {
                OsaUpiAueConfirmedInd osaUpiAueConfirmedInd = (OsaUpiAueConfirmedInd)inSignal;
                AUE_Information aUE_Information = null;
                String string = null;
                if (osaUpiAueConfirmedInd.getResult() == 4) {
                    aUE_Information = new AUE_ConfirmedWithWarningInformation(osaUpiAueConfirmedInd.getAUE_Name(), osaUpiAueConfirmedInd.getAdditionalInformation());
                    string = "C-AUE trigger result - Confirmation with warning.";
                } else if (osaUpiAueConfirmedInd.getResult() == 2) {
                    aUE_Information = new AUE_FailureInformation(osaUpiAueConfirmedInd.getAUE_Name(), osaUpiAueConfirmedInd.getAdditionalInformation());
                    string = "C-AUE trigger result - Failure.";
                    Trace.log1(this.getClass(), "signalReceived(enea.ose.system.InSignal anInsignal)", string + "\n\tC-AUE name: " + osaUpiAueConfirmedInd.getAUE_Name() + "\n\tAdditional Info: " + osaUpiAueConfirmedInd.getAdditionalInformation());
                } else if (osaUpiAueConfirmedInd.getResult() == 1) {
                    aUE_Information = new AUE_TimeoutInformation(osaUpiAueConfirmedInd.getAUE_Name(), osaUpiAueConfirmedInd.getAdditionalInformation());
                    string = "C-AUE trigger result - Timeout.";
                } else if (osaUpiAueConfirmedInd.getResult() == 0) {
                    aUE_Information = new AUE_ConfirmedInformation(osaUpiAueConfirmedInd.getAUE_Name(), osaUpiAueConfirmedInd.getAdditionalInformation());
                    string = "C-AUE trigger result - Confirmed.";
                } else {
                    Trace.info(this.getClass(), "signalReceived(enea.ose.system.InSignal anInsignal)", "Unexpected signal result received (ignored)\n\tResult: " + osaUpiAueConfirmedInd.getResult());
                }
                if (aUE_Information != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", string + "\n\tC-AUE name: " + osaUpiAueConfirmedInd.getAUE_Name() + "\n\tAdditional Info: " + osaUpiAueConfirmedInd.getAdditionalInformation());
                    }
                    this.myPropertyChangeSupport.firePropertyChange(UPI_ProxyPropertyName.AUE_Confirmed.getValue(), (Object)"", (Object)aUE_Information);
                    this.myAUEsThatHasReturnedA_Response.add(osaUpiAueConfirmedInd.getAUE_Name());
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "FIRE's the property: " + UPI_ProxyPropertyName.AUE_Confirmed.getValue() + "\n\tProperty information: " + aUE_Information);
                    }
                }
            } else if (inSignal instanceof OsaUpiStartUpgradeTriggCfm2) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "sendOsaUpiStartUpgradeTriggReq(String triggerSubSpec, long timeout)", "Response signal OsaUpiStartUpgradeTriggCfm2 is received.");
                }
                this.mySignalPort.removeSignalObserver((SignalObserver)this, OsaUpiStartUpgradeTriggCfm2.class);
                OsaUpiStartUpgradeTriggCfm2 osaUpiStartUpgradeTriggCfm2 = (OsaUpiStartUpgradeTriggCfm2)inSignal;
                UpgradeTriggerResultInformation upgradeTriggerResultInformation = new UpgradeTriggerResultInformation(osaUpiStartUpgradeTriggCfm2.getResult(), osaUpiStartUpgradeTriggCfm2.getNoOfNotReady(), osaUpiStartUpgradeTriggCfm2.getSizeOfNameList(), osaUpiStartUpgradeTriggCfm2.getNameList());
                if (osaUpiStartUpgradeTriggCfm2.getResult() == 2 || osaUpiStartUpgradeTriggCfm2.getResult() == 1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(osaUpiStartUpgradeTriggCfm2.getNameList(), ";");
                    String string = null;
                    while (stringTokenizer.hasMoreElements()) {
                        string = stringTokenizer.nextToken();
                        if (this.myAUEsThatHasReturnedA_Response.contains(string)) continue;
                        String string2 = "C-AUE trigger result - Failure (timeout).";
                        AUE_FailureInformation aUE_FailureInformation = new AUE_FailureInformation(string, "Timeout in C-AUE (i.e. the C-AUE has not confirmed the trigger within specified time)");
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "Response signal OsaUpiStartUpgradeTriggCfm2 is received.\n\tC-AUE name: " + string + "\n\tAdditional Info: " + string2 + " (i.e. the C-AUE has not confirmed the trigger within specified time)");
                        }
                        this.myPropertyChangeSupport.firePropertyChange(UPI_ProxyPropertyName.AUE_Confirmed.getValue(), (Object)"", (Object)aUE_FailureInformation);
                    }
                }
                if (this.myTriggerListener != null) {
                    this.myTriggerListener.triggerResponse(upgradeTriggerResultInformation);
                    this.myTriggerListener = null;
                    this.myAUEsThatHasReturnedA_Response.clear();
                } else {
                    Trace.info(this.getClass(), "signalReceived(enea.ose.system.InSignal anInsignal)", "Unexpected trigger response received from Resource Layer (ignored) i.e. no client waiting for this signal.\n\tReceived signal: OsaUpiStartUpgradeTriggCfm2\n\ttheUpgradeTriggerResultInformation: " + upgradeTriggerResultInformation);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "signalReceived(enea.ose.system.InSignal anInsignal)", "Unexpected signal received (ignored): " + inSignal + "\n\tSignal name: " + inSignal.getClass().getName());
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "signalReceived(enea.ose.system.InSignal anInsignal)", "Throwable caught (if signal is OsaUpiStartUpgradeTriggCfm2 the trigger timer supervision will timeout and result in a rollback, otherwise it is ignored).\n\tanInsignal: " + inSignal + "\n\tThrowable data: " + throwable);
        }
    }

    public void serviceAdded(String string) {
    }

    public void serviceAdded() {
    }

    public void serviceRemoved() {
        super.serviceRemoved(OSA_UPI_PROC_NAME);
    }

    public String getResultMsg(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "CELLO_UPI_OK";
                break;
            }
            case 1: {
                string = "CELLO_UPI_TIMEOUT";
                break;
            }
            case 2: {
                string = "CELLO_UPI_AUE_FAILURE";
                break;
            }
            case 3: {
                string = "CELLO_UPI_SWITCHOVER";
                break;
            }
            case 4: {
                string = "CELLO_UPI_AUE_WARNING";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + n;
            }
        }
        return string;
    }

    public String toString() {
        return "nameServerWrapper: " + this.nameServerWrapper;
    }
}

