/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.swproductinventory.control;

import java.util.Properties;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceException;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceListenerInterface;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceStatusObserver;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceStatusObserverFactory;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceStatusInformationEvent;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.swproductinventory.control.SW_ProductInventoryInfoFileHandler;
import se.ericsson.cello.su.swproductinventory.control.ServiceStatusInformationContainer;
import se.ericsson.cello.su.swproductinventory.control.SwPiPropFileHandlerException;
import se.ericsson.cello.su.swproductinventory.timer.SendLastUpPiTimer;
import se.ericsson.cello.su.swproductinventory.timer.SwPiTimerConstants;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.swmanagement.suaccess.SwManagementMoSU_Access;
import se.ericsson.cello.swmanagement.swmaccess.LoadModuleFileStateChangeInformation;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.StateValueChangeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpLoadModuleListChangeInformation;

public class SW_ProductInventoryController
implements PropertyChangeListener,
CelloConfigurationServiceListenerInterface {
    private static SW_ProductInventoryController myInstance = null;
    private static String SERVICE_TYPE_PROP_NAME = "ServiceType";
    private static String SERVICE_SUB_TYPE_PROP_NAME = "ServiceSubType";
    private static String IS_EXECUTING_PROP_NAME = "IsExecuting";
    private static String UP_STATE_CHANGE_PROP_NAME = "UpStateChange";
    private static String LOADMODULE_LIST_CHANGE_PROP_NAME = "LoadModuleListChange";
    private static String LOADMODULE_INSTALL_STATE_CHANGE_PROP_NAME = "LoadModuleInstallStateChange";
    private static String OLD_UP_STATE_PROP_NAME = "OldUP_State";
    private static String NEW_UP_STATE_PROP_NAME = "NewUP_State";
    private static String ALWAYS_SEND_LAST_UPPI_CHANGE_PROP_NAME = "AlwaysSendLastUpPiChange";
    private SendLastUpPiTimer mySendLastUpPiTimer = null;
    private static int DEFAULT_INT_VALUE = -1;
    private static boolean DEFAULT_BOOL_VALUE = false;
    private static int UNSET_INT_VALUE = DEFAULT_INT_VALUE;
    private boolean myServiceInformationReceived = false;
    private boolean myUpStateChange = false;
    private boolean myLoadModuleListChange = false;
    private boolean myLoadModuleInstallStateChange = false;
    private int myOldUP_State = -1;
    private int myNewUP_State = -1;
    private boolean myUP_DeletedOrCreated = false;
    private boolean myAlwaysSendLastUpPiChange = false;
    private ServiceStatusInformationContainer myCurrentExecutingService = null;

    private SW_ProductInventoryController() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SW_ProductInventoryController()");
        }
        try {
            SW_ProductInventoryInfoFileHandler.createSwPiInfoFileDir();
        }
        catch (SwPiPropFileHandlerException swPiPropFileHandlerException) {
            Trace.error(this.getClass(), "SW_ProductInventoryController()", "Failed to create directory for SW product inventory information file. SwPiPropFileHandlerException caught.", (Throwable)((Object)swPiPropFileHandlerException));
        }
        this.initiateWorkingAttributes();
        CelloConfigurationServiceStatusObserver celloConfigurationServiceStatusObserver = CelloConfigurationServiceStatusObserverFactory.instance().createObserver();
        try {
            celloConfigurationServiceStatusObserver.addAsListener(this);
        }
        catch (CelloConfigurationServiceException celloConfigurationServiceException) {
            Trace.error(this.getClass(), "SW_ProductInventoryController()", "Exception caught when adding as listener for CS up and running. Will not be able to handle information stored in SW ProductInventory Information file.", (Throwable)((Object)celloConfigurationServiceException));
            try {
                SW_ProductInventoryInfoFileHandler.deleteSwPiInformationFile();
            }
            catch (SwPiPropFileHandlerException swPiPropFileHandlerException) {
                Trace.error(this.getClass(), "SW_ProductInventoryController()", "Failed to delete SW Product Inventory information file, exception caught.", (Throwable)((Object)celloConfigurationServiceException));
            }
        }
    }

    public static SW_ProductInventoryController instance() {
        if (myInstance == null) {
            myInstance = new SW_ProductInventoryController();
        }
        return myInstance;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof ServiceStatusInformationEvent) {
                this.handleServiceStatusInformationEvent((ServiceStatusInformationEvent)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof StateValueChangeInformation) {
                this.handleStateValueChangeInformation((StateValueChangeInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof UpLoadModuleListChangeInformation) {
                this.handleUpLoadModuleListChangeInformation((UpLoadModuleListChangeInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof LoadModuleFileStateChangeInformation) {
                this.handleLoadModuleFileStateChangeInformation((LoadModuleFileStateChangeInformation)propertyChangeEvent.getNewValue());
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent, false);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught, message: " + throwable.toString(), throwable);
        }
    }

    private void handleServiceStatusInformationEvent(ServiceStatusInformationEvent serviceStatusInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleServiceStatusInformationEvent(ServiceStatusInformationEvent aServiceStatusInformationEvent)", "aServiceStatusInformationEvent: " + serviceStatusInformationEvent);
        }
        this.myServiceInformationReceived = true;
        ServiceStatusInformationContainer serviceStatusInformationContainer = new ServiceStatusInformationContainer(serviceStatusInformationEvent.isExecuting, serviceStatusInformationEvent.serviceType, serviceStatusInformationEvent.serviceSubType);
        if (serviceStatusInformationContainer.getIsExecuting()) {
            this.handleServiceStarted(serviceStatusInformationContainer);
        } else {
            this.handleServiceStopped(serviceStatusInformationContainer);
        }
    }

    private void handleServiceStarted(ServiceStatusInformationContainer serviceStatusInformationContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleServiceStarted(ServiceStatusInformationContainer aReceivedService)", "aReceivedServiceStatusInformationContainer: " + serviceStatusInformationContainer);
        }
        this.stopSendLastUpPiTimer();
        if (!this.myCurrentExecutingService.getIsExecuting()) {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleServiceStarted(ServiceStatusInformationContainer aReceivedService)", serviceStatusInformationContainer.getServiceType() + "-" + serviceStatusInformationContainer.getServiceSubType() + " start event received when no other service is executing.");
            }
            this.myCurrentExecutingService = serviceStatusInformationContainer;
            this.storeCurrentInfoToFileIfNeeded();
        } else if (!this.myCurrentExecutingService.isServiceTypeInfoEqual(serviceStatusInformationContainer)) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleServiceStarted(ServiceStatusInformationContainer aReceivedService)", "New service has started before event received that the current service has stopped. Resetting working attributes.\n\tmyCurrentExecutingService: " + this.myCurrentExecutingService + "\n\taReceivedService: " + serviceStatusInformationContainer);
            }
            this.resetWorkingAttributes();
            this.myCurrentExecutingService = serviceStatusInformationContainer;
            this.storeCurrentInfoToFileIfNeeded();
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "handleServiceStarted(ServiceStatusInformationContainer aReceivedService)", "Same service has busymarked twice, probably after a restart. Normal case ignore.\n\taReceivedService: " + serviceStatusInformationContainer);
        }
    }

    private void handleServiceStopped(ServiceStatusInformationContainer serviceStatusInformationContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleServiceStopped(ServiceStatusInformationContainer aReceivedServiceStatusInformationContainer)", "aReceivedServiceStatusInformationContainer: " + serviceStatusInformationContainer);
        }
        if (this.myCurrentExecutingService.getIsExecuting()) {
            if (this.myCurrentExecutingService.isServiceTypeInfoEqual(serviceStatusInformationContainer)) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "handleServiceStopped(ServiceStatusInformationContainer aReceivedService)", serviceStatusInformationContainer.getServiceType() + "-" + serviceStatusInformationContainer.getServiceSubType() + " stop event received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " is executing.");
                }
                if (serviceStatusInformationContainer.getServiceSubType().equals(ServiceSubType.deleteUP.getValue()) || serviceStatusInformationContainer.getServiceSubType().equals(ServiceSubType.createUP.getValue())) {
                    this.myUP_DeletedOrCreated = true;
                }
                this.myCurrentExecutingService = serviceStatusInformationContainer;
                this.sendLastUpPiChangeIfNeeded();
            } else {
                Trace.error(this.getClass(), "handleServiceStopped(ServiceStatusInformationContainer aReceivedService)", "New service has ended without indication that is has been started received.\n\tcurrentExecutingService: " + this.myCurrentExecutingService + "\n\taReceivedService: " + serviceStatusInformationContainer);
            }
        } else {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleServiceStopped(ServiceStatusInformationContainer aReceivedService)", "Service stopped received when no service is executing, ignored.");
            }
            this.myCurrentExecutingService = new ServiceStatusInformationContainer(false, ServiceType.None, ServiceSubType.none);
        }
    }

    private void handleStateValueChangeInformation(StateValueChangeInformation stateValueChangeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleStateValueChangeInformation(StateValueChangeInformation aStateValueChangeInformation)", "aStateValueChangeInformation: " + stateValueChangeInformation);
        }
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "handleStateValueChangeInformation(StateValueChangeInformation aStateValueChangeInformation)", "StateValueChangeInformation received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " executing." + " Old state: " + stateValueChangeInformation.getOldStateValue() + " new state: " + stateValueChangeInformation.getNewStateValue());
        }
        try {
            if (this.myOldUP_State == UNSET_INT_VALUE) {
                this.myOldUP_State = stateValueChangeInformation.getOldStateValue();
            }
            this.myNewUP_State = stateValueChangeInformation.getNewStateValue();
            this.storeCurrentInfoToFileIfNeeded();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleStateValueChangeInformation(StateValueChangeInformation aStateValueChangeInformation)", "Failed to update the UP state in SW Product Inventory information file, throwable caught.", throwable);
        }
    }

    private void handleUpLoadModuleListChangeInformation(UpLoadModuleListChangeInformation upLoadModuleListChangeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpLoadModuleListChangeInformation( UpLoadModuleListChangeInformation anUpLoadModuleListChangeInformation)anUpLoadModuleListChangeInformation: " + upLoadModuleListChangeInformation);
        }
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "handleServiceStatusInformationEvent(ServiceStatusInformationEvent aServiceStatusInformationEvent)", "UpLoadModuleListChangeInformation received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " executing.");
        }
        if (!this.myLoadModuleListChange) {
            this.myLoadModuleListChange = true;
            this.storeCurrentInfoToFileIfNeeded();
        }
    }

    private void handleLoadModuleFileStateChangeInformation(LoadModuleFileStateChangeInformation loadModuleFileStateChangeInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleLoadModuleFileStateChangeInformation(LoadModuleFileStateChangeInformation aLoadModuleFileStateChangeInformation)aLoadModuleFileStateChangeInformation: " + loadModuleFileStateChangeInformation);
        }
        if (!this.myLoadModuleInstallStateChange) {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleLoadModuleFileStateChangeInformation(LoadModuleFileStateChangeInformation aLoadModuleFileStateChangeInformation)", "LoadModuleFileStateChangeInformation received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " executing." + " Printing swpi info to file.");
            }
            this.myLoadModuleInstallStateChange = true;
        }
        if (this.myCurrentExecutingService.getIsExecuting()) {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleLoadModuleFileStateChangeInformation(LoadModuleFileStateChangeInformation aLoadModuleFileStateChangeInformation)", "LoadModuleFileStateChangeInformation received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " executing." + " LoadModule filestate is changed by SU logic, ignored for now.");
            }
            this.storeCurrentInfoToFileIfNeeded();
        } else {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleLoadModuleFileStateChangeInformation(LoadModuleFileStateChangeInformation aLoadModuleFileStateChangeInformation)", "LoadModuleFileStateChangeInformation received when service " + this.myCurrentExecutingService.getServiceType() + "-" + this.myCurrentExecutingService.getServiceSubType() + " executing." + " LoadModule MO with fileState INSTALLED is created or deleted manually, starting sendLastUpPiChange timer.");
            }
            this.sendLastUpPiChangeIfNeeded();
        }
    }

    private void startSendLastUpPiTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startSendLastUpPiTimer()");
        }
        if (this.mySendLastUpPiTimer != null) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "startSendLastUpPiTimer()", "Time already active, restarting it.");
            }
            this.mySendLastUpPiTimer.updateTimerDuration(SwPiTimerConstants.SEND_LAST_UPPI_CHANGE_WAIT_VALUE);
        } else {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "startSendLastUpPiTimer()", "Creating new timer.");
            }
            this.mySendLastUpPiTimer = new SendLastUpPiTimer(SwPiTimerConstants.SEND_LAST_UPPI_CHANGE_WAIT_VALUE);
            this.mySendLastUpPiTimer.startTimer();
        }
    }

    private void stopSendLastUpPiTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopSendLastUpPiTimer()");
        }
        if (this.mySendLastUpPiTimer != null) {
            this.mySendLastUpPiTimer.stopTimer();
            this.mySendLastUpPiTimer = null;
        }
    }

    private int getIntFromString(String string, String string2) {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getIntegerFromString(String aPropertyName, String aStringValue)aPropertyName: " + string + "\n\taStringValue. " + string2);
        }
        Integer n = new Integer(DEFAULT_INT_VALUE);
        try {
            if (string2 != null) {
                n = new Integer(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(this.getClass(), "getIntegerFromString(String aPropertyName, String aStringValue)", "NumberFormatException caught when trying to convert property string value to Integer.\n\taPropertyName: \n\taStringValue: " + string2);
        }
        return n;
    }

    private boolean getBooleanFromString(String string, String string2) {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getBooleanFromString(String aPropertyName, String aStringValue)aPropertyName: " + string + "\n\taStringValue. " + string2);
        }
        Boolean bl = new Boolean(DEFAULT_BOOL_VALUE);
        try {
            if (string2 != null) {
                bl = new Boolean(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(this.getClass(), "getIntegerFromString(String aPropertyName, String aStringValue)", "NumberFormatException caught when trying to convert property string value to Boolean.\n\taPropertyName: \n\taStringValue: " + string2);
        }
        return bl;
    }

    private void storeCurrentInfoToFileIfNeeded() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "storeCurrentInfoToFileIfNeeded()");
        }
        try {
            SW_ProductInventoryInfoFileHandler.printInfoToFileIfNeeded(this.createSwPiInfoTable());
        }
        catch (SwPiPropFileHandlerException swPiPropFileHandlerException) {
            Trace.error(this.getClass(), "storeInformationToFile()", "Failed to update SW Product Inventory information file with current information, exception caught.", (Throwable)((Object)swPiPropFileHandlerException));
        }
    }

    private Properties createSwPiInfoTable() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSwPiInfoTable()");
        }
        Properties properties = new Properties();
        properties.setProperty(SERVICE_TYPE_PROP_NAME, this.myCurrentExecutingService.getServiceType());
        properties.setProperty(SERVICE_SUB_TYPE_PROP_NAME, this.myCurrentExecutingService.getServiceSubType());
        properties.setProperty(IS_EXECUTING_PROP_NAME, this.myCurrentExecutingService.getIsExecutingAsString());
        properties.setProperty(UP_STATE_CHANGE_PROP_NAME, Boolean.toString(this.myUpStateChange));
        properties.setProperty(LOADMODULE_LIST_CHANGE_PROP_NAME, Boolean.toString(this.myLoadModuleListChange));
        properties.setProperty(LOADMODULE_INSTALL_STATE_CHANGE_PROP_NAME, Boolean.toString(this.myLoadModuleInstallStateChange));
        properties.setProperty(OLD_UP_STATE_PROP_NAME, Integer.toString(this.myOldUP_State));
        properties.setProperty(NEW_UP_STATE_PROP_NAME, Integer.toString(this.myNewUP_State));
        properties.setProperty(ALWAYS_SEND_LAST_UPPI_CHANGE_PROP_NAME, Boolean.toString(this.myAlwaysSendLastUpPiChange));
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createSwPiInfoTable()", "Returning - theSwPiInfoTable: " + properties);
        }
        return properties;
    }

    private void sendLastUpPiChangeIfNeeded() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendLastUpPiChangeIfNeeded()");
        }
        if (this.myOldUP_State != this.myNewUP_State) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendLastUpPiChangeIfNeeded()", "\n\tA service has stopped that has updated the state attribute. (lastUpPiChange shall be updated)\n\tmyOldUP_State: " + this.myOldUP_State + "\n\tmyNewUP_State: " + this.myNewUP_State);
            }
            this.myAlwaysSendLastUpPiChange = true;
        } else if (this.myLoadModuleListChange) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendLastUpPiChangeIfNeeded()", "\n\tA service has stopped that has updated LoadModule attribute. (lastUpPiChange shall be updated)\n\tmyLoadModuleListChange: " + this.myLoadModuleListChange);
            }
            this.myAlwaysSendLastUpPiChange = true;
        } else if (this.myLoadModuleInstallStateChange) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendLastUpPiChangeIfNeeded()", "\n\tA service has stopped that has updated LoadModule attribute. (lastUpPiChange shall be updated)\n\tmyLoadModuleInstallStateChange: " + this.myLoadModuleInstallStateChange);
            }
            this.myAlwaysSendLastUpPiChange = true;
        } else if (this.myUP_DeletedOrCreated) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendLastUpPiChangeIfNeeded()", "\n\tA service has stopped that has created or deleted an UP MO");
            }
            this.myAlwaysSendLastUpPiChange = true;
        }
        this.storeCurrentInfoToFileIfNeeded();
        if (this.myAlwaysSendLastUpPiChange) {
            this.startSendLastUpPiTimer();
        }
    }

    private void initiateWorkingAttributes() {
        String string;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "initiateWorkingAttributes()");
        }
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ServiceStatus, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.StateValueChanged, this);
        ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.LoadModuleListChanged, this);
        MoFactory moFactory = MoFactoryMgr.instance().lookup("LoadModule");
        if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", (Object)moFactory)) {
            PropertyChangeHandler.instance().addPropertyChangeListener("LoadModuleFileStateChange", (PropertyChangeListener)this);
        }
        Properties properties = new Properties();
        try {
            properties = SW_ProductInventoryInfoFileHandler.getSwProductInventoryInfoFromFile();
        }
        catch (SwPiPropFileHandlerException swPiPropFileHandlerException) {
            Trace.error(this.getClass(), "SW_ProductInventoryController()", "Failed to load SW product Inventory information from file, exception caught. (Default values will be used.)", (Throwable)((Object)swPiPropFileHandlerException));
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "initiateWorkingAttributes()", "theStoredSwProductInventoryInfo: " + properties);
        }
        this.myUpStateChange = this.getBooleanFromString(UP_STATE_CHANGE_PROP_NAME, properties.getProperty(UP_STATE_CHANGE_PROP_NAME));
        this.myLoadModuleListChange = this.getBooleanFromString(LOADMODULE_LIST_CHANGE_PROP_NAME, properties.getProperty(LOADMODULE_LIST_CHANGE_PROP_NAME));
        this.myLoadModuleInstallStateChange = this.getBooleanFromString(LOADMODULE_INSTALL_STATE_CHANGE_PROP_NAME, properties.getProperty(LOADMODULE_INSTALL_STATE_CHANGE_PROP_NAME));
        this.myOldUP_State = this.getIntFromString(OLD_UP_STATE_PROP_NAME, properties.getProperty(OLD_UP_STATE_PROP_NAME));
        this.myNewUP_State = this.getIntFromString(NEW_UP_STATE_PROP_NAME, properties.getProperty(NEW_UP_STATE_PROP_NAME));
        this.myAlwaysSendLastUpPiChange = this.getBooleanFromString(ALWAYS_SEND_LAST_UPPI_CHANGE_PROP_NAME, properties.getProperty(ALWAYS_SEND_LAST_UPPI_CHANGE_PROP_NAME));
        boolean bl = this.getBooleanFromString(IS_EXECUTING_PROP_NAME, properties.getProperty(IS_EXECUTING_PROP_NAME));
        String string2 = properties.getProperty(SERVICE_TYPE_PROP_NAME);
        if (string2 == null) {
            string2 = ServiceType.None.getValue();
        }
        if ((string = properties.getProperty(SERVICE_SUB_TYPE_PROP_NAME)) == null) {
            string = ServiceSubType.none.getValue();
        }
        this.myCurrentExecutingService = new ServiceStatusInformationContainer(bl, string2, string);
    }

    private void resetWorkingAttributes() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "resetWorkingAttributes()");
        }
        try {
            SW_ProductInventoryInfoFileHandler.deleteSwPiInformationFile();
        }
        catch (SwPiPropFileHandlerException swPiPropFileHandlerException) {
            Trace.error(this.getClass(), "resetWorkingAttributes()", "Failed to delete SW Product Inventory information file, exception caught.", (Throwable)((Object)swPiPropFileHandlerException));
        }
        this.myUpStateChange = DEFAULT_BOOL_VALUE;
        this.myLoadModuleListChange = DEFAULT_BOOL_VALUE;
        this.myLoadModuleInstallStateChange = DEFAULT_BOOL_VALUE;
        this.myOldUP_State = DEFAULT_INT_VALUE;
        this.myNewUP_State = DEFAULT_INT_VALUE;
        this.myCurrentExecutingService = new ServiceStatusInformationContainer(false, ServiceType.None, ServiceSubType.none);
        this.myUP_DeletedOrCreated = DEFAULT_BOOL_VALUE;
        this.myServiceInformationReceived = DEFAULT_BOOL_VALUE;
    }

    public synchronized void csUpAndRunning() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "csUpAndRunning()");
        }
        this.myAlwaysSendLastUpPiChange = true;
        if (this.myServiceInformationReceived) {
            if (this.myCurrentExecutingService.getIsExecuting()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "csUpAndRunning()", "Service information event that a service has started has been received before CS up notification.\n\tFlag that lastUpPiChange shall be sent are stored in file and wait for service stop.");
                }
                this.storeCurrentInfoToFileIfNeeded();
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "csUpAndRunning()", "Service information event that a service has stopped has been received before CS up notification.\n\tStarting lastUpPi timer thread.");
                }
                this.sendLastUpPiChangeIfNeeded();
            }
        } else {
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "csUpAndRunning()", "No service has started before CS is up and running. Starting lastUpPi timer thread.");
            }
            this.sendLastUpPiChangeIfNeeded();
        }
    }

    public synchronized void sendLastUpPiTimerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendLastUpPiTimerAction(TimerEvent aTimerEvent)", "aTimerEvent: " + timerEvent);
        }
        this.setLastUpPiChange();
        if (this.mySendLastUpPiTimer != null) {
            this.mySendLastUpPiTimer.stopTimer();
            this.mySendLastUpPiTimer = null;
        }
        this.myAlwaysSendLastUpPiChange = DEFAULT_BOOL_VALUE;
        this.resetWorkingAttributes();
    }

    public boolean isSwPiTimerRunning() {
        boolean bl = false;
        if (this.mySendLastUpPiTimer != null) {
            bl = true;
        }
        return bl;
    }

    private void setLastUpPiChange() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setLastUpPiChange()");
        }
        MoFactory moFactory = MoFactoryMgr.instance().lookup("SwManagement");
        SwManagementMoSU_Access swManagementMoSU_Access = (SwManagementMoSU_Access)((SingletonMoFactory)moFactory).getMo();
        try {
            swManagementMoSU_Access.actionLastUpPiChange(null);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "setLastUpPiChange()", "The attribute lastUpPiChange has been updated successfully.");
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "setLastUpPiChange()", "Exception caught when trying to set LastUpPiChange.", moAccessException);
        }
    }
}

