/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.verify.diskhealthcheck;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.managedelement.suaccess.DiskHealthCheckResultFileSystemInformation;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.su.timerforverification.VerificationTimer;
import se.ericsson.cello.su.timerforverification.VerificationTimerController;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.su.uci.verify.diskhealthcheck.DiskHealthCheckException;
import se.ericsson.cello.su.uci.verify.diskhealthcheck.FileSystemHealthCheckControllerInterface;
import se.ericsson.cello.su.uci.verify.diskhealthcheck.UP_HealthCheckCorruptInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerifyingChecksumForLMsInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class DiskHealthCheckController
implements TimerListener,
Runnable,
PropertyChangeListener,
FileSystemHealthCheckControllerInterface {
    private Object myDiskHealthCheckResultFileSystemInformation = null;
    private boolean myIsME_SupportingFileSystemHealthCheck = true;
    private boolean myIsUP_HealthCheckExecuted = false;
    private Collection myCorruptedUPs = new LinkedList();
    private Throwable myAnyCaughtThrowable = null;
    private Timer myTimer = null;
    private static final long FIFTY_MINUTES = 3000000L;
    private boolean myIsTimedOut = false;
    private static final String EMPTY_STRING = "";
    private String myUP_DocumentNumber = null;
    private String myUP_DocumentRevision = null;

    public DiskHealthCheckController() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "DiskHealthCheckController()");
        }
    }

    private boolean isHealthCheckStoping(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHealthCheckStoping(String anUP_DocumentNumber, String anUP_DocumentRevision)", "anUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        boolean bl = false;
        try {
            Iterator iterator = this.myCorruptedUPs.iterator();
            UP_HealthCheckCorruptInformation uP_HealthCheckCorruptInformation = null;
            ProductNumberAndRevision productNumberAndRevision = null;
            while (iterator.hasNext()) {
                uP_HealthCheckCorruptInformation = (UP_HealthCheckCorruptInformation)iterator.next();
                productNumberAndRevision = new ProductNumberAndRevision(uP_HealthCheckCorruptInformation.getUP_Mo().getDocumentNumber(null), uP_HealthCheckCorruptInformation.getUP_Mo().getDocumentRevision(null));
                if (!productNumberAndRevision.equals(string, string2)) continue;
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isHealthCheckStoping(String anUP_DocumentNumber, String anUP_DocumentRevision)", "RETURNS - theIsStoping: " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isHealthCheckStoping(String anUP_DocumentNumber, String anUP_DocumentRevision)", "anUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2, throwable);
            return bl;
        }
    }

    private boolean isHealthCheckExecuted() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHealthCheckExecuted()");
        }
        boolean bl = false;
        if (this.myIsUP_HealthCheckExecuted && this.getDiskHealthCheckResultFileSystemInformation() != null) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHealthCheckExecuted()", "RETURNS - theIsHealthCheckExecuted: " + bl);
        }
        return bl;
    }

    private boolean isHealthCheckResultOk() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHealthCheckResultOk()");
        }
        boolean bl = false;
        if (this.myIsUP_HealthCheckExecuted && this.myCorruptedUPs.isEmpty() && this.getDiskHealthCheckResultFileSystemInformation() != null && this.getDiskHealthCheckResultFileSystemInformation().getResultCode() == DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_OK) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isHealthCheckResultOk()", "\n\tmyCorruptedUPs: " + this.myCorruptedUPs + "\n\tmyDiskHealthCheckResultFileSystemInformation: " + this.getDiskHealthCheckResultFileSystemInformation() + "\n\tRETURNS - theIsHealthCheckResultOk: " + bl);
        }
        return bl;
    }

    private ActionResultData createActionResultData(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createActionResultData(String aMessage)", "aMessage: " + string);
        }
        if (this.myAnyCaughtThrowable != null) {
            string = string + "\n\tReported problem: " + this.myAnyCaughtThrowable;
        }
        String string2 = "No corrupted Upgrade Packages";
        if (this.myIsUP_HealthCheckExecuted) {
            if (!this.myCorruptedUPs.isEmpty()) {
                string2 = "Corrupted Upgrade Packages: " + this.myCorruptedUPs;
            }
        } else {
            string2 = "No UP health check result available";
        }
        ActionResultData actionResultData = null;
        if (this.getDiskHealthCheckResultFileSystemInformation() == null && !this.myIsUP_HealthCheckExecuted) {
            String string3 = "\n\tNo file system health check result available";
            if (!this.myIsME_SupportingFileSystemHealthCheck) {
                string3 = "The file system health check could not be requested due to the ManagedElement MA do not support this function in current release.";
            }
            actionResultData = new ActionResultData(ActionResultInformationEnum.UNSPECIFIED, string + string3 + "\n\t" + string2);
        } else if (this.getDiskHealthCheckResultFileSystemInformation() == null) {
            ActionResultInformationEnum actionResultInformationEnum = ActionResultInformationEnum.UNSPECIFIED;
            if (!this.myCorruptedUPs.isEmpty()) {
                string2 = "The corrupted Upgrade Packages are: " + this.myCorruptedUPs;
                actionResultInformationEnum = ActionResultInformationEnum.DISK_HEALTH_CHECK_ERROR_DETECTED;
            }
            String string4 = "\n\tNo file system health check result available";
            if (!this.myIsME_SupportingFileSystemHealthCheck) {
                string4 = "The file system health check could not be requested due to the ManagedElement MA do not support this function in current release.";
            }
            actionResultData = new ActionResultData(actionResultInformationEnum, string + string4 + "\n\t" + string2);
        } else if (!this.myIsUP_HealthCheckExecuted) {
            ActionResultInformationEnum actionResultInformationEnum = ActionResultInformationEnum.UNSPECIFIED;
            if (this.getDiskHealthCheckResultFileSystemInformation().getResultCode() == DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_NOK || this.getDiskHealthCheckResultFileSystemInformation().getResultCode() == DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_ABORTED_NOK) {
                actionResultInformationEnum = ActionResultInformationEnum.DISK_HEALTH_CHECK_ERROR_DETECTED;
            }
            actionResultData = new ActionResultData(actionResultInformationEnum, string + this.getDiskHealthCheckResultFileSystemInformation() + "\n\t" + string2);
        } else {
            ActionResultInformationEnum actionResultInformationEnum = ActionResultInformationEnum.UNSPECIFIED;
            if (!this.myCorruptedUPs.isEmpty() || this.getDiskHealthCheckResultFileSystemInformation().getResultCode() != DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_OK) {
                if (!this.myCorruptedUPs.isEmpty() || this.getDiskHealthCheckResultFileSystemInformation().getResultCode() == DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_NOK || this.getDiskHealthCheckResultFileSystemInformation().getResultCode() == DiskHealthCheckResultFileSystemInformation.FS_HEALTHCHECK_ABORTED_NOK) {
                    actionResultInformationEnum = ActionResultInformationEnum.DISK_HEALTH_CHECK_ERROR_DETECTED;
                    actionResultData = new ActionResultData(actionResultInformationEnum, string + this.getDiskHealthCheckResultFileSystemInformation() + "\n\t" + string2);
                } else {
                    actionResultData = new ActionResultData(actionResultInformationEnum, string + this.getDiskHealthCheckResultFileSystemInformation() + "\n\t" + string2);
                }
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createActionResultData(String aMessage)", "RETURNS - theActionResultData: " + actionResultData);
        }
        return actionResultData;
    }

    private ActionResultData createActionResultData() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createActionResultData()");
        }
        return this.createActionResultData(EMPTY_STRING);
    }

    public VerificationResult requestDiskHealthCheck(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestDiskHealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        try {
            this.myUP_DocumentNumber = string;
            this.myUP_DocumentRevision = string2;
            new Thread((Runnable)this, "DiskHealthCheckController").start();
            this.waitForUP_AndFileSystemHealthCheckToComplete();
            VerificationResult verificationResult = new VerificationResult(this.isHealthCheckStoping(string, string2), this.isHealthCheckExecuted(), this.isHealthCheckResultOk(), this.createActionResultData());
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "requestDiskHealthCheck()", "RETURNS - theVerificationResult: " + verificationResult);
            }
            return verificationResult;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "requestDiskHealthCheck()", "Throwable caught", throwable);
            VerificationResult verificationResult = new VerificationResult(false, this.isHealthCheckExecuted(), this.isHealthCheckResultOk(), this.createActionResultData(throwable.toString()));
            return verificationResult;
        }
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        try {
            this.myTimer = new Timer(3000000L);
            this.myTimer.addListener(this);
            this.myTimer.startTimer();
            this.addAsListener();
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            managedElementMO_HandlerInterface.requestForDiskHealthCheck(this);
            if (!this.myIsME_SupportingFileSystemHealthCheck) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerifyingChecksumForLMsInformation(this));
            }
            this.myCorruptedUPs = this.doExecuteUP_HealthCheck(this.myUP_DocumentNumber, this.myUP_DocumentRevision);
            if (this.getDiskHealthCheckResultFileSystemInformation() != null || !this.myIsME_SupportingFileSystemHealthCheck) {
                Trace.debug(this.getClass(), 22, "requestDiskHealthCheck()", "UP and File System health check have been completed.");
                this.notifyDiskHealthCheckIsFinished();
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "run()", "Waiting for File System health check to be finished.");
            }
        }
        catch (DiskHealthCheckException diskHealthCheckException) {
            this.myAnyCaughtThrowable = diskHealthCheckException;
            this.removeAsListener();
            this.notifyDiskHealthCheckIsFinished();
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            this.myAnyCaughtThrowable = managedElementMO_HandlerException;
            this.removeAsListener();
            this.notifyDiskHealthCheckIsFinished();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Throwable caught when running health check on existing UpgradePackage MO's");
            this.myAnyCaughtThrowable = throwable;
            this.removeAsListener();
            this.notifyDiskHealthCheckIsFinished();
        }
    }

    private Collection doExecuteUP_HealthCheck(String string, String string2) throws DiskHealthCheckException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doExecuteUP_HealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "anUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2);
        }
        try {
            LinkedList<UP_HealthCheckCorruptInformation> linkedList = new LinkedList<UP_HealthCheckCorruptInformation>();
            UP_HealthCheckCorruptInformation uP_HealthCheckCorruptInformation = null;
            Collection collection = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMOs();
            Iterator iterator = collection.iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                uP_HealthCheckCorruptInformation = upgradePackageMoExtended.verifyLMsAndUcfChecksums(string, string2);
                if (uP_HealthCheckCorruptInformation != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "doExecuteUP_HealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "Health check executed with on UP: " + upgradePackageMoExtended + "\n\ttheUP_HealthCheckCorruptInformations: " + linkedList);
                    }
                    linkedList.add(uP_HealthCheckCorruptInformation);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "doExecuteUP_HealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "Health check executed with on UP: " + upgradePackageMoExtended + "\n\tNo corrupt information found.");
            }
            VerificationTimer verificationTimer = VerificationTimerController.instance().getVerificationTimer(string, string2);
            if (verificationTimer != null && Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doExecuteUP_HealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "For UP " + string + "_" + string2 + ", " + verificationTimer.getLoadModulesThatHaveBeenChecksumed().size() + " LoadModule(s) are omitted during DiskHealthCheck checksum. ");
            }
            this.setIsUP_HealthCheckPerformed(true);
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "doExecuteUP_HealthCheck(String anUP_DocumentNumber, String anUP_DocumentRevision)", "Throwable caught when running health check on existing UpgradePackage MO's");
            throw new DiskHealthCheckException(throwable.toString());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent getPropertyName: " + propertyChangeEvent.getPropertyName() + "\n\taPropertyChangeEvent new value: " + propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getNewValue() instanceof DiskHealthCheckResultFileSystemInformation) {
            this.myDiskHealthCheckResultFileSystemInformation = (DiskHealthCheckResultFileSystemInformation)propertyChangeEvent.getNewValue();
            this.removeAsListener();
            this.diskCheckOfFileSystemFinished();
        } else {
            Trace.warning(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unexpected property received (ignored)\n\taPropertyChangeEvent getPropertyName: " + propertyChangeEvent.getPropertyName() + "\n\taPropertyChangeEvent new value: " + propertyChangeEvent.getNewValue());
        }
    }

    private void addAsListener() throws ManagedElementMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener()");
        }
        if (ServiceFinder.getManagedElementMO_HandlerInterface().isSU_VersionSupported("SU_2")) {
            PropertyChangeHandler.instance().addPropertyChangeListener("FileSystemHealthCheckProperty", (PropertyChangeListener)this);
        } else if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener()", "Not possible to add as listener due to ME do not support this function.");
        }
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener()");
        }
        try {
            if (ServiceFinder.getManagedElementMO_HandlerInterface().isSU_VersionSupported("SU_2")) {
                PropertyChangeHandler.instance().removePropertyChangeListener("FileSystemHealthCheckProperty", (PropertyChangeListener)this);
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "addAsListener()", "Not possible to remove as listener due to ME do not support this function.");
            }
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            Trace.info(this.getClass(), "removeAsListener()", "Failed to remove as listener (ignored)");
        }
    }

    public void diskCheckOfFileSystemNotSupported() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "diskCheckOfFileSystemNotSupported()");
        }
        this.myIsME_SupportingFileSystemHealthCheck = false;
        this.diskCheckOfFileSystemFinished();
    }

    private void diskCheckOfFileSystemFinished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "diskCheckOfFileSystemFinished()");
        }
        if (this.myTimer != null) {
            this.myTimer.removeListener(this);
            this.myTimer.stopTimer();
            this.myTimer = null;
        }
        if (!this.myIsTimedOut) {
            if (this.isUP_HealthCheckPerformed()) {
                this.notifyDiskHealthCheckIsFinished();
            } else if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "diskCheckOfFileSystemFinished()", "Wait for UP health check to be finished.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "diskCheckOfFileSystemFinished()", "File system disk health check result received after time out (ignored).");
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent aTimerEvent)", "aTimerEvent: " + timerEvent);
        }
        if (this.getDiskHealthCheckResultFileSystemInformation() == null && !this.isUP_HealthCheckPerformed()) {
            this.setDiskHealthCheckResultFileSystemInformation(new DiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation.HEALTHCHECK_TIMEOUT, "Time out occured while waiting for response from the Disk Health Check of the File System Function and also the UP Health check function"));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "timerAction(TimerEvent aTimerEvent)", "Time out occured while waiting for response from the Disk Health Check of the File System Function and also the UP Health check function.");
            }
        } else if (this.getDiskHealthCheckResultFileSystemInformation() == null) {
            this.setDiskHealthCheckResultFileSystemInformation(new DiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation.HEALTHCHECK_TIMEOUT, "Time out occured while waiting for response from the Disk Health Check of the File System Function"));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "timerAction(TimerEvent aTimerEvent)", "Time out occured while waiting for response from the Disk Health Check of the File System Function.");
            }
        } else if (!this.isUP_HealthCheckPerformed()) {
            this.setDiskHealthCheckResultFileSystemInformation(new DiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation.HEALTHCHECK_TIMEOUT, "Time out occured while waiting for response from the UP Health check function"));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "timerAction(TimerEvent aTimerEvent)", "Time out occured while waiting for response from the Disk Health Check of the File System Function.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "timerAction(TimerEvent aTimerEvent)", "Time out occured after that the Disk Health Check function has been completed.");
        }
        this.myTimer = null;
        this.myIsTimedOut = true;
        this.notifyDiskHealthCheckIsFinished();
        this.removeAsListener();
    }

    private synchronized void waitForUP_AndFileSystemHealthCheckToComplete() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForUP_AndFileSystemHealthCheckToComplete() - Before wait()");
        }
        try {
            this.wait();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"waitForUP_AndFileSystemHealthCheckToComplete()", (String)"Throwable caught while waiting for response from ME FRO for disk health check result", (Throwable)throwable);
        }
    }

    private synchronized void notifyDiskHealthCheckIsFinished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyDiskHealthCheckIsFinished() - Before notify()");
        }
        try {
            this.notify();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"notifyDiskHealthCheckIsFinished()", (String)"Throwable caught while waiting for response from ME FRO for disk health check result", (Throwable)throwable);
        }
    }

    private synchronized boolean isUP_HealthCheckPerformed() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUP_HealthCheckPerformed()");
        }
        return this.myIsUP_HealthCheckExecuted;
    }

    private synchronized void setIsUP_HealthCheckPerformed(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsUP_HealthCheckPerformed(boolean anIsUP_HealthCheckPerformed)", "anIsUP_HealthCheckPerformed: " + bl);
        }
        this.myIsUP_HealthCheckExecuted = bl;
    }

    private synchronized DiskHealthCheckResultFileSystemInformation getDiskHealthCheckResultFileSystemInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDiskHealthCheckResultFileSystemInformation()");
        }
        if (this.myDiskHealthCheckResultFileSystemInformation != null) {
            return (DiskHealthCheckResultFileSystemInformation)this.myDiskHealthCheckResultFileSystemInformation;
        }
        return null;
    }

    private synchronized void setDiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation diskHealthCheckResultFileSystemInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setDiskHealthCheckResultFileSystemInformation(DiskHealthCheckResultFileSystemInformation aDiskHealthCheckResultFileSystemInformation)", "aDiskHealthCheckResultFileSystemInformation: " + diskHealthCheckResultFileSystemInformation);
        }
        this.myDiskHealthCheckResultFileSystemInformation = diskHealthCheckResultFileSystemInformation;
    }
}

