/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.verify.javaheap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.uci.control.SequenceToBeExecutedInformationEvent;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.su.uci.verify.javaheap.JavaHeapSizeSpecificationInformation;
import se.ericsson.cello.su.util.javaheap.JavaHeapSizeConsistencyInformations;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoireProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelperException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.VerifyUpgradeWindowException;

public class JavaHeapController {
    private String myUP_ProdNo = null;
    private String myUP_Rev = null;
    private String myUCF_Path = null;
    private SequenceToBeExecutedInformationEvent mySequenceToBeExecutedInformationEvent = null;

    public JavaHeapController(String string, String string2, String string3, SequenceToBeExecutedInformationEvent sequenceToBeExecutedInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "JavaHeapController(String anUP_ProdNo, String anUP_Rev, String anUCF_Path)", "anUP_ProdNo: " + string + "\n\tanUP_Rev: " + string2 + "\n\tanUCF_Path: " + string3 + "\n\taSequenceToBeExecutedInformationEvent: " + sequenceToBeExecutedInformationEvent);
        }
        this.myUP_ProdNo = string;
        this.myUP_Rev = string2;
        this.myUCF_Path = string3;
        this.mySequenceToBeExecutedInformationEvent = sequenceToBeExecutedInformationEvent;
    }

    public VerificationResult execute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute()");
        }
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = this.getDocumentObjectProxyInterface(this.myUCF_Path, this.myUP_ProdNo, this.myUP_Rev);
            JavaHeapSizeSpecificationInformation javaHeapSizeSpecificationInformation = this.checkJavaHeapConsistencyBetweenRepertoiresAndUpgradeSequences(documentObjectProxyInterface);
            if (javaHeapSizeSpecificationInformation.getVerificationResult().isStopping) {
                return javaHeapSizeSpecificationInformation.getVerificationResult();
            }
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = null;
            String string2 = null;
            String string3 = null;
            if (configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null) != null) {
                string = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getUP_CompatibilityIndex(null);
                string2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getDocumentNumber(null);
                string3 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getDocumentRevision(null);
            } else {
                string = documentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
                string2 = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber;
                string3 = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision;
            }
            ValidSequencesInformation validSequencesInformation = documentObjectProxyInterface.getValidSequences(string2, string3, string);
            if (validSequencesInformation.isAnyUpgradeVariantSupported()) {
                Collection collection = validSequencesInformation.getAllFirstSupportedSequenceInformations(true);
                SequenceInformation sequenceInformation = (SequenceInformation)collection.iterator().next();
                String string4 = sequenceInformation.currentCase;
                Collection collection2 = new HashSet();
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                LinkedList linkedList = jvmMO_HandlerInterface.getJVM_SlotsList();
                Iterator iterator = linkedList.iterator();
                SlotMoSU_Access slotMoSU_Access = null;
                SwAllocationHelper swAllocationHelper = new SwAllocationHelper();
                while (iterator.hasNext()) {
                    slotMoSU_Access = (SlotMoSU_Access)iterator.next();
                    collection2.addAll(swAllocationHelper.getConnectedRepertoirNames((SwAllocationMoSU_Access)slotMoSU_Access.getSwAllocation(null)));
                }
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "execute()", "Connected JVM repertoires before repertoire replacements: " + collection2);
                }
                collection2 = documentObjectProxyInterface.getRepertoireNamesToBeUsed(collection2, string4);
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "execute()", "Connected JVM repertoires after repertoire replacements: " + collection2);
                }
                return this.ensureThatJavaHeapSpecifiedInRepertoiresAreConsistent(documentObjectProxyInterface, collection2, javaHeapSizeSpecificationInformation);
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "execute()", "From version not supported and hence no idea to analyze the javaHeapSize attribute consistency in the UCF.");
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (ParserFactoryException parserFactoryException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "ParserFactoryException caught (returns OK): " + parserFactoryException);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "UpgradeControlFileNotFoundException caught (returns OK): " + upgradeControlFileNotFoundException);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "UpgradeControlFileNotFoundException caught (returns OK): " + upgradeControlFileParserException);
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (VerifyUpgradeWindowException verifyUpgradeWindowException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "UpgradeControlFileNotFoundException caught (returns OK): " + (Object)((Object)verifyUpgradeWindowException));
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "JvmMO_HandlerException caught (returns OK): " + (Object)((Object)jvmMO_HandlerException));
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (SwAllocationHelperException swAllocationHelperException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "SwAllocationHelperException caught (returns OK): " + (Object)((Object)swAllocationHelperException));
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "SwAllocationHelperException caught (returns OK): " + (Object)((Object)moAccessException));
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute()", "Throwable caught (ignored, returns OK): ", throwable);
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
    }

    private JavaHeapSizeSpecificationInformation checkJavaHeapConsistencyBetweenRepertoiresAndUpgradeSequences(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkJavaHeapConsistencyBetweenRepertoiresAndUpgradeSequences(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        boolean bl = false;
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        if (repertoiresProxyInterface.isJavaHeapSizeSpecifiedInAnyPiuTypeRef()) {
            bl = true;
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            if (upgradeSequencesProxyInterface.isJavaHeapSizeSpecified()) {
                ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.JAVA_HEAP_SIZE_INCONSISTENCY, "Attribute javaHeapSize is only allowed to be specified in either Repertoire elements or in UpgradeSequence elements in the UCF. This UCF has this attribute specified in at least one Repertoire and one UpgradeSequence element.");
                VerificationResult verificationResult = new VerificationResult(true, false, actionResultData);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "checkJavaHeapConsistencyBetweenRepertoiresAndUpgradeSequences(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "RETURNS - theVerificationResult: " + verificationResult);
                }
                return new JavaHeapSizeSpecificationInformation(bl, verificationResult);
            }
        }
        return new JavaHeapSizeSpecificationInformation(bl, new VerificationResult(true));
    }

    private VerificationResult ensureThatJavaHeapSpecifiedInRepertoiresAreConsistent(DocumentObjectProxyInterface documentObjectProxyInterface, Collection collection, JavaHeapSizeSpecificationInformation javaHeapSizeSpecificationInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ensureThatJavaHeapSpecifiedInRepertoiresAreConsistent(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aConnectedJvmRepertoireNames, JavaHeapSizeSpecificationInformation aJavaHeapSizeSpecificationInformation)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taConnectedJvmRepertoireNames: " + collection + "\n\taJavaHeapSizeSpecificationInformation: " + javaHeapSizeSpecificationInformation);
        }
        if (javaHeapSizeSpecificationInformation.isJavaHeapSpecifiedInAnyRepertoire()) {
            RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
            Iterator iterator = collection.iterator();
            String string = null;
            RepertoireProxyInterface repertoireProxyInterface = null;
            Collection collection2 = null;
            JavaHeapSizeConsistencyInformations javaHeapSizeConsistencyInformations = new JavaHeapSizeConsistencyInformations(collection);
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                repertoireProxyInterface = repertoiresProxyInterface.getRepertoireProxyInterface(string);
                collection2 = repertoireProxyInterface.getAllPiuTypeRefInformations();
                javaHeapSizeConsistencyInformations.addPiuTypeRefs(collection2, string);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "ensureThatJavaHeapSpecifiedInRepertoiresAreConsistent(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aConnectedJvmRepertoireNames, JavaHeapSizeSpecificationInformation aJavaHeapSizeSpecificationInformation)", "theJavaHeapSizeConsistencyInformations: " + javaHeapSizeConsistencyInformations);
            }
            return javaHeapSizeConsistencyInformations.getInconsistencyInformations();
        }
        return new VerificationResult(true);
    }

    public DocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2, String string3) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        try {
            MainElementHolder mainElementHolder = new MainElementHolder();
            mainElementHolder.add("Repertoire");
            mainElementHolder.add("UpgradeWindow");
            mainElementHolder.add("UpCompatibilityIndex");
            mainElementHolder.add("ExplicitReplacement");
            mainElementHolder.add("UpgradeSequence");
            mainElementHolder.add("UpdateSequence");
            DocumentObjectProxyInterface documentObjectProxyInterface = UpgradeControlFileParserFactory.instance().getDocumentObjectProxyInterface(string, string2, string3, false);
            return documentObjectProxyInterface;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "Throwable caught when searching for a document object for the specific upgrade package, anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tThrowable message: " + throwable, throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tThrowable message: " + throwable);
        }
    }
}

