/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.upgradedbstorage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbStringWrapper;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageData;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerInterface;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageStringHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDbStorage;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class UpgradeDB_StorageHandler
implements UpgradeDB_StorageHandlerInterface {
    public static final String SU_DYNAMIC_TABLE_00 = "sudynamictable_00";
    private static UpgradeDB_StorageHandlerInterface myInstance = new UpgradeDB_StorageHandler();
    private boolean myIsInitiated = false;
    private DbStringWrapper myDbStringWrapper = null;
    private HashMap myAttributes = new HashMap();
    private HashMap myPrimaryKeys = new HashMap();

    public static synchronized UpgradeDB_StorageHandlerInterface instance() {
        return myInstance;
    }

    public synchronized String getAttribute(String string) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAttribute(String anAttributeName)", "anAttributeName: " + string);
        }
        this.initiateDB_Handling();
        String string2 = (String)this.myAttributes.get(string);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getAttribute(String anAttributeName)", "Returning - theAttributeValue: " + string2);
        }
        this.logReturnedData("getAttribute", string, string2);
        return string2;
    }

    public Collection getAttributeNames() throws UpgradeDB_StorageHandlerException {
        this.initiateDB_Handling();
        return this.myAttributes.keySet();
    }

    public synchronized String removeAttribute(String string) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAttribute(String anAttributeName)", "anAttributeName: " + string);
        }
        try {
            this.initiateDB_Handling();
            String string2 = (String)this.myAttributes.get(string);
            if (string2 != null) {
                Integer n = (Integer)this.myPrimaryKeys.get(string);
                this.deleteRowInDB_Table(n);
                this.myAttributes.remove(string);
                this.myPrimaryKeys.remove(string);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "removeAttribute(String anAttributeName)", "Returning - theAttributeValue: " + string2);
            }
            this.logReturnedData("removeAttribute", string, string2);
            return string2;
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            throw upgradeDB_StorageHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeAttribute(String anAttributeName)", "anAttributeName: " + string + "\n\tThrowable caught.", throwable);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tremoveAttribute(String anAttributeName)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public synchronized UpgradeDB_StorageData removeAttributes() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAttributes( )");
        }
        try {
            this.initiateDB_Handling();
            UpgradeDB_StorageData upgradeDB_StorageData = new UpgradeDB_StorageData((HashMap)this.myAttributes.clone(), (HashMap)this.myPrimaryKeys.clone());
            if (!this.myAttributes.isEmpty()) {
                this.deleteDB_Table();
                this.myDbStringWrapper = new DbStringWrapper(SU_DYNAMIC_TABLE_00);
                this.myAttributes.clear();
                this.myPrimaryKeys.clear();
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "removeAttributes( )", "Returning - theUpgradeDB_StorageData: " + upgradeDB_StorageData);
            }
            this.logReturnedData("removeAttributes", upgradeDB_StorageData);
            return upgradeDB_StorageData;
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            throw upgradeDB_StorageHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeAttributes( )", "Throwable caught.", throwable);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tremoveAttributes( )" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public synchronized void restoreAttributes(UpgradeDB_StorageData upgradeDB_StorageData) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreAttributes(UpgradeDB_StorageData anUpgradeDB_StorageData)", "anUpgradeDB_StorageData: " + upgradeDB_StorageData);
        }
        try {
            HashMap hashMap;
            HashMap hashMap2;
            this.initiateDB_Handling();
            if (this.myAttributes.isEmpty()) {
                hashMap2 = upgradeDB_StorageData.getAttributes();
                Iterator iterator = hashMap2.keySet().iterator();
                String string = null;
                String string2 = null;
                hashMap = upgradeDB_StorageData.getPrimaryKeys();
                Integer n = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    string2 = (String)hashMap2.get(string);
                    n = (Integer)hashMap.get(string);
                    this.createRowInDB_Table(n, string, string2);
                }
            } else {
                Trace.error(this.getClass(), "restoreAttributes(UpgradeDB_StorageData anUpgradeDB_StorageData)", "anUpgradeDB_StorageData: " + upgradeDB_StorageData + "\n\tNot allowed method call, database table is not empty." + "\n\tmyAttributes: " + this.myAttributes);
                throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\trestoreAttributes(UpgradeDB_StorageData anUpgradeDB_StorageData)" + "\n\tNot allowed method call, database table is not empty.");
            }
            this.myAttributes = hashMap2;
            this.myPrimaryKeys = hashMap;
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            throw upgradeDB_StorageHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "restoreAttributes(UpgradeDB_StorageData anUpgradeDB_StorageData)", "anUpgradeDB_StorageData: " + upgradeDB_StorageData + "\n\tThrowable caught.", throwable);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\trestoreAttributes(UpgradeDB_StorageData anUpgradeDB_StorageData)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    public synchronized String setAttribute(String string, String string2) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAttribute(String anAttributeName, String anAttributeValue)", "anAttributeName: " + string + "\n\tanAttributeValue: " + string2);
        }
        try {
            this.initiateDB_Handling();
            String string3 = (String)this.myAttributes.get(string);
            Integer n = null;
            if (string3 == null) {
                n = this.getFirstAvailablePrimaryKey();
                this.createRowInDB_Table(n, string, string2);
                this.myPrimaryKeys.put(string, n);
            } else {
                n = (Integer)this.myPrimaryKeys.get(string);
                this.updateRowInDB_Table(n, string, string2);
            }
            this.myAttributes.put(string, string2);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "setAttribute(String anAttributeName, String anAttributeValue)", "Returning - theOldAttributeValue: " + string3);
            }
            this.logReturnedData("setAttribute", string, string2, string3);
            return string3;
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            throw upgradeDB_StorageHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setAttribute(String anAttributeName, String anAttributeValue)", "anAttributeName: " + string + "\n\tanAttributeValue: " + string2 + "\n\tThrowable caught.", throwable);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tsetAttribute(String anAttributeName, String anAttributeValue)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initiateDB_Handling() throws UpgradeDB_StorageHandlerException {
        boolean bl;
        block12: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "initiateDB_Handling( )");
            }
            bl = false;
            if (this.myIsInitiated) break block12;
            if (this.myDbStringWrapper == null) {
                this.myDbStringWrapper = UpgradeDbStorage.instance();
            }
            this.myDbStringWrapper.connectToDatabase();
            bl = true;
            int[] nArray = this.myDbStringWrapper.retrieveAllPrimaryKeys();
            if (nArray != null && nArray.length > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.retrieveAndStoreRowDataFromDB_Table(nArray[i]);
                }
            }
            this.myIsInitiated = true;
        }
        Object var5_6 = null;
        if (!bl) return;
        try {
            this.myDbStringWrapper.disconnectFromDatabase();
            return;
        }
        catch (DbAccessException dbAccessException) {
            Trace.error(this.getClass(), "initiateDB_Handling( )", "Throwable caught when trying to disconnect from database.", dbAccessException);
        }
        return;
        {
            catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                throw upgradeDB_StorageHandlerException;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "initiateDB_Handling( )", "Throwable caught.", throwable);
                throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tinitiateDB_Handling( )" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!bl) throw throwable;
            try {
                this.myDbStringWrapper.disconnectFromDatabase();
                throw throwable;
            }
            catch (DbAccessException dbAccessException) {
                Trace.error(this.getClass(), "initiateDB_Handling( )", "Throwable caught when trying to disconnect from database.", dbAccessException);
            }
            throw throwable;
        }
    }

    private void retrieveAndStoreRowDataFromDB_Table(int n) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "retrieveAndStoreRowDataFromDB_Table(int aPrimaryKey)", "aPrimaryKey: " + n);
        }
        try {
            String string = this.myDbStringWrapper.retrieveRow(n);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "retrieveAndStoreRowDataFromDB_Table(int aPrimaryKey)", "theAttributeNameAndValue: " + string);
            }
            String string2 = UpgradeDB_StorageStringHandler.getAttributeName(string);
            String string3 = UpgradeDB_StorageStringHandler.getAttributeValue(string);
            this.myAttributes.put(string2, string3);
            this.myPrimaryKeys.put(string2, new Integer(n));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "retrieveAndStoreRowDataFromDB_Table(int aPrimaryKey)", "aPrimaryKey: " + n + "\n\tThrowable caught.", throwable);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tretrieveAndStoreRowDataFromDB_Table(int aPrimaryKey)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private void deleteRowInDB_Table(Integer n) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteRowInDB_Table(Integer aPrimaryKey)", "aPrimaryKey: " + n);
        }
        Control control = null;
        try {
            control = Transaction.create();
            int n2 = control.getCoordinator().getTransactionID();
            this.myDbStringWrapper.deleteRow(n2, n.intValue());
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteRowInDB_Table(Integer aPrimaryKey)", "aPrimaryKey: " + n + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tdeleteRowInDB_Table(Integer aPrimaryKey)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private void deleteDB_Table() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteDB_Table( )");
        }
        Control control = null;
        try {
            control = Transaction.create();
            int n = control.getCoordinator().getTransactionID();
            this.myDbStringWrapper.deleteTable(n);
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteDB_Table( )", "Throwable caught.", throwable);
            Transaction.rollback(control);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tdeleteDB_Table( )" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private void createRowInDB_Table(Integer n, String string, String string2) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)", "aPrimaryKey: " + n + "\n\tanAttributeName: " + string + "\n\tanAttributeValue: " + string2);
        }
        Control control = null;
        try {
            control = Transaction.create();
            int n2 = control.getCoordinator().getTransactionID();
            this.myDbStringWrapper.createRow(n2, n.intValue(), UpgradeDB_StorageStringHandler.createDB_String(string, string2));
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)", "aPrimaryKey: " + n + "\n\tanAttributeName: " + string + "\n\tanAttributeValue: " + string2 + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tcreateRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private Integer getFirstAvailablePrimaryKey() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFirstAvailablePrimaryKey( )");
        }
        Integer n = null;
        for (int i = 0; i < this.myPrimaryKeys.size() + 1 && this.myPrimaryKeys.containsValue(n = new Integer(i)); ++i) {
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getFirstAvailablePrimaryKey( )", "Returning - thePrimaryKey: " + n);
        }
        return n;
    }

    private void updateRowInDB_Table(Integer n, String string, String string2) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)", "aPrimaryKey: " + n + "\n\tanAttributeName: " + string + "\n\tanAttributeValue: " + string2);
        }
        Control control = null;
        try {
            control = Transaction.create();
            int n2 = control.getCoordinator().getTransactionID();
            this.myDbStringWrapper.updateRow(n2, n.intValue(), UpgradeDB_StorageStringHandler.createDB_String(string, string2));
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)", "aPrimaryKey: " + n + "\n\tanAttributeName: " + string + "\n\tanAttributeValue: " + string2 + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new UpgradeDB_StorageHandlerException("Class name: " + this.getClass().getName() + "\n\tupdateRowInDB_Table(Integer aPrimaryKey, String anAttributeName, String anAttributeValue)" + "\n\tThrowable caught," + "\n\tThrowable info: " + throwable.toString());
        }
    }

    private void logReturnedData(String string, UpgradeDB_StorageData upgradeDB_StorageData) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "logReturnedData(String aMethodName, String aReturnedUpgradeDB_StorageData)", string + " is returning: " + upgradeDB_StorageData);
        }
    }

    private void logReturnedData(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "logReturnedData(String aMethodName, String anAttributeName, String aReturnedString)", string + " " + string2 + " is returning: " + string3);
        }
    }

    private void logReturnedData(String string, String string2, String string3, String string4) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "logReturnedData(String aMethodName, String anAttributeName, String anAttributeValue, String aReturnedString)", string + " " + string2 + "=" + string3 + " is returning: " + string4);
        }
    }
}

