/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.upgradedbstorage;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandler;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.verify.ssw.CrlAndCertificateLM_InfoContainer;

public class UpgradeDB_StorageUtil {
    private static final String PROGRAMS_CERT_CRL = "programsCertCrl";
    private static final String EXECUTED_FROM_STATE = "executedFromState";
    private static final String UPGRADE_WITH_STOP = "upgradeWithStop";
    private static final String NAME_OF_CREATED_SU_CV = "nameOfCreatedSuCv";
    private static final String NEW_ACTIVE_UP_PRODUCT_NUMBER = "newActiveUpProdNo";
    private static final String NEW_ACTIVE_UP_PRODUCT_REVISION = "newActiveUpProdRev";
    private static final String TRIGGER_SUSPEND_PM = "SUSPEND_PM";
    private static final String TRIGGER_RESUME_PM_AT_STOP = "RESUME_PM_AT_STOP";
    private static final String LOADED_CERT_INFO = "loadedCertInfo";
    private static final char SMN_APN_SEPARATOR = '_';
    private static final char FILE_PATH_SEPARATOR = ';';
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static UpgradeDB_StorageHandlerInterface myUpgradeDB_StorageHandler = UpgradeDB_StorageHandler.instance();

    public static void deleteCertCrlPrograms() throws UpgradeDB_StorageHandlerException {
        if (UpgradeDB_StorageUtil.existsCertCrlPrograms()) {
            myUpgradeDB_StorageHandler.removeAttribute(PROGRAMS_CERT_CRL);
            UpgradeDB_StorageUtil.logUpgradeDB("remove PROGRAMS_CERT_CRL");
        }
    }

    public static boolean existsCertCrlPrograms() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(PROGRAMS_CERT_CRL) != null;
    }

    public static String getCertCrlPrograms() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(PROGRAMS_CERT_CRL);
    }

    public static void saveCertCrlPrograms(String string) throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(PROGRAMS_CERT_CRL, string);
    }

    public static void saveExecutedFromState() throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(EXECUTED_FROM_STATE, TRUE);
    }

    public static void changeExecutedFromStateTo_ToState() throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(EXECUTED_FROM_STATE, FALSE);
    }

    public static boolean isExecutedFromState() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(EXECUTED_FROM_STATE) != null && myUpgradeDB_StorageHandler.getAttribute(EXECUTED_FROM_STATE).equalsIgnoreCase(TRUE);
    }

    public static boolean isExecutedFromStateExisting() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(EXECUTED_FROM_STATE) != null;
    }

    public static void saveUpgradeWithStop() throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(UPGRADE_WITH_STOP, TRUE);
    }

    public static void saveNameOfCreatedSU_CV(String string) throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(NAME_OF_CREATED_SU_CV, string);
    }

    public static void saveNewActiveUP_ProductNumber(String string) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "saveNewActiveUP_ProductNumber(String aProductNumber)", "aProductNumber: " + string);
        }
        myUpgradeDB_StorageHandler.setAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER, string);
    }

    public static void saveNewActiveUP_ProductRevision(String string) throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "saveNewActiveUP_ProductRevision(String aProductRevision)", "aProductRevision: " + string);
        }
        myUpgradeDB_StorageHandler.setAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION, string);
    }

    public static void saveSuspendPM(boolean bl) throws UpgradeDB_StorageHandlerException {
        if (bl) {
            myUpgradeDB_StorageHandler.setAttribute(TRIGGER_SUSPEND_PM, TRUE);
        } else {
            myUpgradeDB_StorageHandler.setAttribute(TRIGGER_SUSPEND_PM, FALSE);
        }
    }

    public static void saveResumePM_AtStop(boolean bl) throws UpgradeDB_StorageHandlerException {
        if (bl) {
            myUpgradeDB_StorageHandler.setAttribute(TRIGGER_RESUME_PM_AT_STOP, TRUE);
        } else {
            myUpgradeDB_StorageHandler.setAttribute(TRIGGER_RESUME_PM_AT_STOP, FALSE);
        }
    }

    public static boolean isLoadedCertInfoExisting(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) throws UpgradeDB_StorageHandlerException {
        String string = UpgradeDB_StorageUtil.getLoadedCertInfoAttrName(crlAndCertificateLM_InfoContainer);
        return myUpgradeDB_StorageHandler.getAttribute(string) != null;
    }

    public static void saveLoadedCertInfo(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.setAttribute(UpgradeDB_StorageUtil.getLoadedCertInfoAttrName(crlAndCertificateLM_InfoContainer), UpgradeDB_StorageUtil.getFilePathsString(crlAndCertificateLM_InfoContainer));
    }

    public static Collection getAllLoadedCertInfo() throws UpgradeDB_StorageHandlerException {
        Vector<CrlAndCertificateLM_InfoContainer> vector = new Vector<CrlAndCertificateLM_InfoContainer>(1);
        Iterator iterator = UpgradeDB_StorageUtil.getLoadedCertInfoAttrNames().iterator();
        while (iterator.hasNext()) {
            vector.add(UpgradeDB_StorageUtil.createLoadedCertInfo((String)iterator.next()));
        }
        return vector;
    }

    public static void removeAllLoadedCertInfo() throws UpgradeDB_StorageHandlerException {
        Iterator iterator = UpgradeDB_StorageUtil.getLoadedCertInfoAttrNames().iterator();
        while (iterator.hasNext()) {
            myUpgradeDB_StorageHandler.removeAttribute((String)iterator.next());
        }
    }

    public static void removeLoadedCertInfo(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.removeAttribute(UpgradeDB_StorageUtil.getLoadedCertInfoAttrName(crlAndCertificateLM_InfoContainer));
    }

    public static boolean isUpgradeWithStopExisting() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(UPGRADE_WITH_STOP) != null;
    }

    public static boolean isUpgradeWithStop() throws UpgradeDB_StorageHandlerException {
        return UpgradeDB_StorageUtil.isUpgradeWithStopExisting() && myUpgradeDB_StorageHandler.getAttribute(UPGRADE_WITH_STOP).equalsIgnoreCase(TRUE);
    }

    public static boolean isNameOfCreatedSU_CV_Existing() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(NAME_OF_CREATED_SU_CV) != null;
    }

    public static String getNameOfCreatedSU_CV() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(NAME_OF_CREATED_SU_CV);
    }

    public static String getNewActiveUP_ProductNumber() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "getNewActiveUP_ProductNumber()");
        }
        return myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER);
    }

    public static String getNewActiveUP_ProductRevision() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "getNewActiveUP_ProductRevision()");
        }
        return myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION);
    }

    public static boolean isSuspendPM_Existed() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(TRIGGER_SUSPEND_PM) != null;
    }

    public static boolean isSuspendPM() throws UpgradeDB_StorageHandlerException {
        return UpgradeDB_StorageUtil.isSuspendPM_Existed() && myUpgradeDB_StorageHandler.getAttribute(TRIGGER_SUSPEND_PM).equalsIgnoreCase(TRUE);
    }

    public static boolean isResumePM_AtStop() throws UpgradeDB_StorageHandlerException {
        return myUpgradeDB_StorageHandler.getAttribute(TRIGGER_RESUME_PM_AT_STOP) != null && myUpgradeDB_StorageHandler.getAttribute(TRIGGER_RESUME_PM_AT_STOP).equalsIgnoreCase(TRUE);
    }

    public static boolean isNewActiveUP_Existing() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "isNewActiveUP_Existing()");
        }
        return myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER) != null && myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION) != null;
    }

    public static void removeUpgradeWithStop() throws UpgradeDB_StorageHandlerException {
        if (UpgradeDB_StorageUtil.isUpgradeWithStopExisting()) {
            myUpgradeDB_StorageHandler.removeAttribute(UPGRADE_WITH_STOP);
            UpgradeDB_StorageUtil.logUpgradeDB("remove UpgradeWithStop .... ");
        }
    }

    public static void removeNewActiveUP() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(UpgradeDB_StorageUtil.class, 20)) {
            Trace.debug(UpgradeDB_StorageUtil.class, 20, "removeNewActiveUP()");
        }
        if (UpgradeDB_StorageUtil.isNewActiveUP_Existing()) {
            myUpgradeDB_StorageHandler.removeAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER);
            myUpgradeDB_StorageHandler.removeAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION);
            UpgradeDB_StorageUtil.logUpgradeDB("remove newActiveUP .... ");
        }
    }

    public static void removeNameOfCreatedSU_CV() throws UpgradeDB_StorageHandlerException {
        if (UpgradeDB_StorageUtil.isNameOfCreatedSU_CV_Existing()) {
            myUpgradeDB_StorageHandler.removeAttribute(NAME_OF_CREATED_SU_CV);
            UpgradeDB_StorageUtil.logUpgradeDB("remove NameOfCreatedSU_CV .... ");
        }
    }

    public static void removeSuspendPM() throws UpgradeDB_StorageHandlerException {
        if (UpgradeDB_StorageUtil.isSuspendPM()) {
            myUpgradeDB_StorageHandler.removeAttribute(TRIGGER_SUSPEND_PM);
            UpgradeDB_StorageUtil.logUpgradeDB("remove SuspendPm .... ");
        }
    }

    public static void removeResumePM_AtStop() throws UpgradeDB_StorageHandlerException {
        if (UpgradeDB_StorageUtil.isResumePM_AtStop()) {
            myUpgradeDB_StorageHandler.removeAttribute(TRIGGER_RESUME_PM_AT_STOP);
            UpgradeDB_StorageUtil.logUpgradeDB("remove ResumePmAtStop .... ");
        }
    }

    public static void removeExecutedFromState() throws UpgradeDB_StorageHandlerException {
        myUpgradeDB_StorageHandler.removeAttribute(EXECUTED_FROM_STATE);
        UpgradeDB_StorageUtil.logUpgradeDB("remove ExecutedFromState .... ");
    }

    public static void logUpgradeDB(String string) {
        block3: {
            try {
                if (Trace.valid(UpgradeDB_StorageUtil.class, 40)) {
                    Trace.debug("logUpgradeDB(String msg)", string + "\n\t" + EXECUTED_FROM_STATE + " is " + myUpgradeDB_StorageHandler.getAttribute(EXECUTED_FROM_STATE) + "\n\t" + UPGRADE_WITH_STOP + " is " + myUpgradeDB_StorageHandler.getAttribute(UPGRADE_WITH_STOP) + "\n\t" + NAME_OF_CREATED_SU_CV + " is " + myUpgradeDB_StorageHandler.getAttribute(NAME_OF_CREATED_SU_CV) + "\n\t" + TRIGGER_SUSPEND_PM + " is " + myUpgradeDB_StorageHandler.getAttribute(TRIGGER_SUSPEND_PM) + "\n\t" + TRIGGER_RESUME_PM_AT_STOP + " is " + myUpgradeDB_StorageHandler.getAttribute(TRIGGER_RESUME_PM_AT_STOP) + "\n\t" + NEW_ACTIVE_UP_PRODUCT_NUMBER + " is " + myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER) + "\n\t" + NEW_ACTIVE_UP_PRODUCT_REVISION + " is " + myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION));
                }
            }
            catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                if (!Trace.valid(UpgradeDB_StorageUtil.class, 40)) break block3;
                Trace.debug(UpgradeDB_StorageUtil.class, 40, "logUpgradeDB()", "It is not possible to fetch attributes of UpgradeDB_StorageAssuming that RESUME PM AT STOP, SUSPEND PM or Upgrade With Stop are not saved i.e. return FALSE\n\tUpgradeDB_StorageHandlerException caught: " + upgradeDB_StorageHandlerException.toString());
            }
        }
    }

    public static void logUpgradeDB() {
        block3: {
            try {
                if (Trace.valid(UpgradeDB_StorageUtil.class, 40)) {
                    Trace.debug("logUpgradeDB()", "Upgrade DB data :\n\texecutedFromState is " + myUpgradeDB_StorageHandler.getAttribute(EXECUTED_FROM_STATE) + "\n\t" + UPGRADE_WITH_STOP + " is " + myUpgradeDB_StorageHandler.getAttribute(UPGRADE_WITH_STOP) + "\n\t" + NAME_OF_CREATED_SU_CV + " is " + myUpgradeDB_StorageHandler.getAttribute(NAME_OF_CREATED_SU_CV) + "\n\t" + TRIGGER_SUSPEND_PM + " is " + myUpgradeDB_StorageHandler.getAttribute(TRIGGER_SUSPEND_PM) + "\n\t" + TRIGGER_RESUME_PM_AT_STOP + " is " + myUpgradeDB_StorageHandler.getAttribute(TRIGGER_RESUME_PM_AT_STOP) + "\n\t" + NEW_ACTIVE_UP_PRODUCT_NUMBER + " is '" + myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_NUMBER) + "'" + "\n\t" + NEW_ACTIVE_UP_PRODUCT_REVISION + " is '" + myUpgradeDB_StorageHandler.getAttribute(NEW_ACTIVE_UP_PRODUCT_REVISION) + "'");
                }
            }
            catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
                if (!Trace.valid(UpgradeDB_StorageUtil.class, 40)) break block3;
                Trace.debug(UpgradeDB_StorageUtil.class, 40, "logUpgradeDB()", "It is not possible to fetch attributes of UpgradeDB_StorageAssuming that RESUME PM AT STOP, SUSPEND PM or Upgrade With Stop are not saved i.e. return FALSE\n\tUpgradeDB_StorageHandlerException caught: " + upgradeDB_StorageHandlerException.toString());
            }
        }
    }

    private static Collection getLoadedCertInfoAttrNames() throws UpgradeDB_StorageHandlerException {
        Vector<String> vector = new Vector<String>(1);
        Iterator iterator = myUpgradeDB_StorageHandler.getAttributeNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(LOADED_CERT_INFO)) continue;
            vector.add(string);
        }
        return vector;
    }

    private static CrlAndCertificateLM_InfoContainer createLoadedCertInfo(String string) throws UpgradeDB_StorageHandlerException {
        String[] stringArray = StringHandler.splitString('_', string);
        Integer n = new Integer(stringArray[1]);
        Integer n2 = new Integer(stringArray[2]);
        String[] stringArray2 = StringHandler.splitString(';', myUpgradeDB_StorageHandler.getAttribute(string));
        Vector<String> vector = new Vector<String>(1);
        for (int i = 0; i < stringArray2.length; ++i) {
            vector.add(stringArray2[i]);
        }
        return new CrlAndCertificateLM_InfoContainer(n, n2, vector);
    }

    private static String getLoadedCertInfoAttrName(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        String string = "loadedCertInfo_" + crlAndCertificateLM_InfoContainer.getSMN() + '_' + crlAndCertificateLM_InfoContainer.getAPN();
        return string;
    }

    private static String getFilePathsString(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        String string = "";
        Iterator iterator = crlAndCertificateLM_InfoContainer.getFilePaths().iterator();
        while (iterator.hasNext()) {
            if (!string.equals("")) {
                string = string + ';' + iterator.next();
                continue;
            }
            string = (String)iterator.next();
        }
        return string;
    }
}

