/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.util.javaheap;

public class JavaHeapSizeConsistencyInformation {
    private Integer mySelectedJavaHeapSize = null;
    private Integer myMaxSpecifiedJavaHeapSize = null;
    private String myPiuTypeProductNumber = null;
    private String myPiuTypeProductRevision = null;
    private boolean myIsJavaHeapSizeAlwaysSpecified = true;
    private String myRepertoireName = null;
    private boolean myIsJavaHeapSizeAlwaysRequired = true;

    public JavaHeapSizeConsistencyInformation(String string, String string2, Integer n, boolean bl) {
        this.myPiuTypeProductNumber = string;
        this.myPiuTypeProductRevision = string2;
        this.myIsJavaHeapSizeAlwaysRequired = bl;
        if (n != null) {
            this.mySelectedJavaHeapSize = n;
            this.myMaxSpecifiedJavaHeapSize = n;
        } else {
            this.myIsJavaHeapSizeAlwaysSpecified = false;
        }
    }

    public JavaHeapSizeConsistencyInformation(String string, String string2, Integer n, String string3) {
        this.myPiuTypeProductNumber = string;
        this.myPiuTypeProductRevision = string2;
        this.myRepertoireName = string3;
        if (n != null) {
            this.mySelectedJavaHeapSize = n;
            this.myMaxSpecifiedJavaHeapSize = n;
        } else {
            this.myIsJavaHeapSizeAlwaysSpecified = false;
        }
    }

    public boolean isJavaHeapSizeAlwaysRequired() {
        return this.myIsJavaHeapSizeAlwaysRequired;
    }

    public String getRepertoireName() {
        return this.myRepertoireName;
    }

    public Integer getSelectedJavaHeapSize() {
        return this.mySelectedJavaHeapSize;
    }

    public Integer getMaxSpecifiedJavaHeapSize() {
        return this.myMaxSpecifiedJavaHeapSize;
    }

    public String getPiuTypeProductNumber() {
        return this.myPiuTypeProductNumber;
    }

    public String getPiuTypeRevision() {
        return this.myPiuTypeProductRevision;
    }

    public boolean isJavaHeapSizeSpecified() {
        return this.mySelectedJavaHeapSize != null;
    }

    public boolean isJavaHeapSizeSpecificationInconsistent() {
        if (this.myIsJavaHeapSizeAlwaysRequired) {
            if (this.mySelectedJavaHeapSize != this.myMaxSpecifiedJavaHeapSize) {
                return true;
            }
            return this.mySelectedJavaHeapSize != null && !this.myIsJavaHeapSizeAlwaysSpecified;
        }
        return this.mySelectedJavaHeapSize != this.myMaxSpecifiedJavaHeapSize;
    }

    public boolean isJavaHeapSizeAlwaysSpecified() {
        return this.myIsJavaHeapSizeAlwaysSpecified;
    }

    public void setSpecifiedJavaHeapSize(Integer n) {
        if (n == null) {
            this.myIsJavaHeapSizeAlwaysSpecified = false;
            return;
        }
        if (this.mySelectedJavaHeapSize == null) {
            this.mySelectedJavaHeapSize = n;
            this.myMaxSpecifiedJavaHeapSize = n;
            return;
        }
        if (this.mySelectedJavaHeapSize > n) {
            this.defineMaxSpecified(this.mySelectedJavaHeapSize);
            this.mySelectedJavaHeapSize = n;
        } else {
            this.defineMaxSpecified(n);
        }
    }

    private void defineMaxSpecified(Integer n) {
        if (this.myMaxSpecifiedJavaHeapSize != null) {
            if (this.myMaxSpecifiedJavaHeapSize < n) {
                this.myMaxSpecifiedJavaHeapSize = n;
            }
        } else {
            this.myMaxSpecifiedJavaHeapSize = n;
        }
    }

    public String toString() {
        return "\n\tmySelectedJavaHeapSize: " + this.mySelectedJavaHeapSize + "\n\tmyPiuTypeProductNumber: " + this.myPiuTypeProductNumber + "\n\tmyPiuTypeProductRevision: " + this.myPiuTypeProductRevision + "\n\tmyMaxSpecifiedJavaHeapSize: " + this.myMaxSpecifiedJavaHeapSize + "\n\tmyIsJavaHeapSizeAlwaysSpecified: " + this.myIsJavaHeapSizeAlwaysSpecified + "\n\tmyIsJavaHeapSizeAlwaysRequired: " + this.myIsJavaHeapSizeAlwaysRequired;
    }
}

