/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser;

import java.io.File;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.mao.UpgradeTrace;

public class ControlFileErrorHandler
implements ErrorHandler {
    private File myHandleToControlFile = null;

    public ControlFileErrorHandler(File file) {
        String string = null;
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ControlFileErrorHandler(File anHandleToControlFile)", (String)("anHandleToControlFile: " + string));
        }
        this.myHandleToControlFile = file;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"warning(SAXParseException exception)", (String)("exception: \n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
        }
        String string = null;
        if (this.myHandleToControlFile != null) {
            string = this.myHandleToControlFile.getAbsolutePath();
        }
        UpgradeTrace.warning(this.getClass(), (String)"warning(SAXParseException exception)", (String)("The parsed XML file '" + string + "' contains a minor fault i.e. the fault is not stopping the parsing." + "\n\tWarning message: " + "\n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"error(SAXParseException exception)", (String)("\texception: \n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
        }
        String string = null;
        if (this.myHandleToControlFile != null) {
            string = this.myHandleToControlFile.getAbsolutePath();
        }
        UpgradeTrace.warning(this.getClass(), (String)"error(SAXParseException exception)", (String)("The parsed XML file '" + string + "' contains a validation error i.e. the error is not of fatal nature (the parsing will continue)." + "\n\tError message: " + "\n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"fatalError(SAXParseException exception)", (String)("\texception: \n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
        }
        String string = null;
        if (this.myHandleToControlFile != null) {
            string = this.myHandleToControlFile.getAbsolutePath();
        }
        UpgradeTrace.warning(this.getClass(), (String)"fatalError(SAXParseException exception)", (String)("The parsed XML file '" + string + "' contains a fatal error i.e. the XML file is not well-formed (the parsing is stopped)." + "\n\tFatal Error message: " + "\n\t\tSystem ID: " + sAXParseException.getSystemId() + "\n\t\tPublic ID: " + sAXParseException.getPublicId() + "\n\t\tLine number: " + sAXParseException.getLineNumber() + "\n\t\tColumn number: " + sAXParseException.getColumnNumber()));
        throw sAXParseException;
    }

    public void cleanup() {
        this.myHandleToControlFile = null;
    }
}

