/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.sudom.extsuif.proxy.interfaces.SU_DOM_ListenerInterface;
import se.ericsson.cello.sudom.parser.ControlFileDocumentHandler;
import se.ericsson.cello.sudom.parser.ControlFileErrorHandler;
import se.ericsson.cello.sudom.parser.InvalidMainElementNameException;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.MainElementNames;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.ParserInformation;
import se.ericsson.cello.sudom.parser.ParserKeyInformation;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.OptimizeInterface;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxy;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxy;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;

public class UpgradeControlFileParserFactory {
    private static String ParserClass = "com.microstar.xml.SAXDriver";
    private static UpgradeControlFileParserFactory myInstance = null;
    private Collection mySU_DOM_ListenerInterfaces = new HashSet();
    private Hashtable myParsers = new Hashtable();

    private UpgradeControlFileParserFactory() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"UpgradeControlFileParserFactory()");
        }
        myInstance = this;
    }

    public void addAsListener(SU_DOM_ListenerInterface sU_DOM_ListenerInterface) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addAsListener(SU_DOM_ListenerInterface aSU_DOM_ListenerInterface)", (String)("aSU_DOM_ListenerInterface: " + sU_DOM_ListenerInterface));
        }
        this.mySU_DOM_ListenerInterfaces.add(sU_DOM_ListenerInterface);
    }

    public void print() {
        Enumeration enumeration = this.myParsers.keys();
        String string = null;
        ParserInformation parserInformation = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            parserInformation = (ParserInformation)this.myParsers.get(string);
            UpgradeTrace.log1(this.getClass(), (String)"toString()", (String)("theParserKey: " + string + "theParserInformation: " + parserInformation));
        }
    }

    public void removeAsListener(SU_DOM_ListenerInterface sU_DOM_ListenerInterface) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeAsListener(SU_DOM_ListenerInterface aSU_DOM_ListenerInterface)", (String)("aSU_DOM_ListenerInterface: " + sU_DOM_ListenerInterface));
        }
        this.mySU_DOM_ListenerInterfaces.remove(sU_DOM_ListenerInterface);
    }

    private DocumentObjectUpgradePackage getDocumentObjectForUpgradePackage(String string, String string2) throws ParserFactoryException {
        String string3 = "getDocumentObjectForUpgradePackage(String aProductNumber, String aRevision)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string3, (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\tmyParsers: " + this.myParsers));
        }
        try {
            ParserInformation parserInformation;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)string3, (String)("The stored document objects for Upgrade Package are:: \n\tmyParsers: " + this.myParsers));
            }
            if ((parserInformation = (ParserInformation)this.myParsers.get(string + "_" + string2)) != null) {
                ControlFileDocumentHandler controlFileDocumentHandler = parserInformation.getControlFileDocumentHandler();
                if (controlFileDocumentHandler != null) {
                    return controlFileDocumentHandler.getDocumentObjectForUpgradePackage();
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)string3, (String)("Exception caught when searching for a document object for the specific upgrade package, \n\tProduct number: " + string + "\n\tProduct revision: " + string2 + "." + "\n\tException message: " + exception.getMessage()), (Throwable)exception);
            throw new ParserFactoryException("Exception caught when searching for a document object for the specific upgrade package, \n\tProduct number: " + string + "\n\tProduct revision: " + string2 + "." + "\n\tException message: " + exception.getMessage());
        }
    }

    public DocumentObjectUpgradePackage getDocumentObjectForUpgradePackage(ParserKeyInformation parserKeyInformation) throws ParserFactoryException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDocumentObjectForUpgradePackage(ParserKeyInformation aParserKeyInformation)", (String)("aParserKeyInformation: " + parserKeyInformation + "\n\tmyParsers: " + this.myParsers));
        }
        return this.getDocumentObjectForUpgradePackage(parserKeyInformation.getProductNumber(), parserKeyInformation.getProductRevision());
    }

    public DocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2, String string3, boolean bl) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        String string4 = "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision, boolean anIsValidationRequired)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string4, (String)("anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanIsValidationRequired: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        try {
            ParserKeyInformation parserKeyInformation = this.parseControlFile(string, bl);
            DocumentObjectUpgradePackage documentObjectUpgradePackage = UpgradeControlFileParserFactory.instance().getDocumentObjectForUpgradePackage(parserKeyInformation);
            return new DocumentObjectProxy(documentObjectUpgradePackage);
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string4, (String)("Throwable caught when searching for a document object for the specific upgrade package, anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanIsValidationRequired: " + bl + "\n\tmyParsers: " + this.myParsers + "\n\tThrowable message: " + throwable), (Throwable)throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tThrowable message: " + throwable);
        }
    }

    public DocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        String string2 = "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, MainElementHolder aMainElementHolder, boolean anValidationIsNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("anAbsolutePathToControlFile: " + string + "\n\taMainElementHolder: " + mainElementHolder + "\n\tanValidationIsNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        try {
            ParserKeyInformation parserKeyInformation = UpgradeControlFileParserFactory.instance().parseMainElements(string, mainElementHolder, bl);
            DocumentObjectUpgradePackage documentObjectUpgradePackage = UpgradeControlFileParserFactory.instance().getDocumentObjectForUpgradePackage(parserKeyInformation);
            return new DocumentObjectProxy(documentObjectUpgradePackage);
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("Throwable caught when searching for a document object for the specific upgrade package, \n\taMainElementHolder: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\tmyParsers: " + this.myParsers + "\n\tThrowable message: " + throwable), (Throwable)throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tThrowable message: " + throwable);
        }
    }

    public DocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2, String string3, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        String string4 = "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision, MainElementHolder aMainElementHolder, boolean anIsValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string4, (String)("anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\taMainElementHolder: " + mainElementHolder + "\n\tanIsValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        ParserKeyInformation parserKeyInformation = null;
        try {
            UpgradeControlFileParserFactory upgradeControlFileParserFactory = UpgradeControlFileParserFactory.instance();
            parserKeyInformation = upgradeControlFileParserFactory.parseMainElements(new ParserKeyInformation(string2, string3), string, mainElementHolder, bl);
            ParserInformation parserInformation = (ParserInformation)this.myParsers.get(parserKeyInformation.getKey());
            if (parserInformation.getOptimizedDocumentObjectProxyInterface() == null) {
                DocumentObjectUpgradePackage documentObjectUpgradePackage = upgradeControlFileParserFactory.getDocumentObjectForUpgradePackage(parserKeyInformation);
                parserInformation.setOptimizedDocumentObjectProxyInterface(new OptimizedDocumentObjectProxy(documentObjectUpgradePackage));
            }
            if (parserKeyInformation.isParsed() && parserInformation.getOptimizedDocumentObjectProxyInterface().isOptimized()) {
                parserInformation.getOptimizedDocumentObjectProxyInterface().optimize();
            }
            return parserInformation.getOptimizedDocumentObjectProxyInterface();
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string4, (String)("Throwable caught when searching for a document object for the specific upgrade package, \n\tProduct number: " + string2 + "\n\tProduct revision: " + string3 + "." + "\n\taMainElementHolder: " + mainElementHolder + "\n\tanIsValidationNeeded: " + bl + "\n\tanAbsolutePathToControlFile: " + string + "\n\ttheParserKeyInformation: " + parserKeyInformation + "\n\tmyParsers: " + this.myParsers + "\n\tThrowable message: " + throwable), (Throwable)throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tProduct number: " + string2 + "\n\tProduct revision: " + string3 + "." + "\n\tThrowable message: " + throwable);
        }
    }

    public OptimizedDocumentObjectProxyInterface getOptimizedDocumentObjectProxyInterface(String string, String string2, String string3, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        String string4 = "getOptimizedDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision, MainElementHolder aMainElementHolder, boolean anIsValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string4, (String)("anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\taMainElementHolder: " + mainElementHolder + "\n\tanIsValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        try {
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = (OptimizedDocumentObjectProxyInterface)this.getDocumentObjectProxyInterface(string, string2, string3, mainElementHolder, bl);
            ((OptimizeInterface)((Object)optimizedDocumentObjectProxyInterface)).optimize();
            return optimizedDocumentObjectProxyInterface;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string4, (String)("Throwable caught when searching for a document object for the specific upgrade package, \n\tProduct number: " + string2 + "\n\tProduct revision: " + string3 + "." + "\n\tThrowable message: " + throwable), (Throwable)throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tProduct number: " + string2 + "\n\tProduct revision: " + string3 + "." + "\n\tThrowable message: " + throwable);
        }
    }

    public String[] getParserKeys() {
        if (UpgradeTrace.valid((Class)UpgradeControlFileParserFactory.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeControlFileParserFactory.class, (int)25, (String)"getParserKeys()");
        }
        Set set = this.myParsers.keySet();
        Iterator iterator = set.iterator();
        String[] stringArray = new String[set.size()];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
        }
        UpgradeTrace.log1((Class)UpgradeControlFileParserFactory.class, (String)"getParserKeys()", (String)("myParserKeys: " + stringArray + "\n\n\tmyParsers: " + this.myParsers));
        return stringArray;
    }

    public static UpgradeControlFileParserFactory instance() {
        if (UpgradeTrace.valid((Class)UpgradeControlFileParserFactory.class, (int)25)) {
            UpgradeTrace.debug((Class)UpgradeControlFileParserFactory.class, (int)25, (String)"instance()");
        }
        if (myInstance == null) {
            new UpgradeControlFileParserFactory();
        }
        if (UpgradeTrace.valid((Class)UpgradeControlFileParserFactory.class, (int)27)) {
            UpgradeTrace.debug((Class)UpgradeControlFileParserFactory.class, (int)27, (String)"instance()", (String)("myInstance: " + myInstance));
        }
        return myInstance;
    }

    public ParserKeyInformation parseControlFile(String string, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"parseControlFile(String anAbsolutePathToControlFile, boolean aValidationNeeded)", (String)("\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        MainElementHolder mainElementHolder = MainElementNames.getAll();
        return this.parseMainElements(string, mainElementHolder, bl);
    }

    public ParserKeyInformation parseControlFile(ParserKeyInformation parserKeyInformation, String string, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        String string2 = "parseControlFile(ParserKeyInformation aParserKeyInformation, String anAbsolutePathToControlFile, boolean aValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("aParserKeyInformation: " + parserKeyInformation + "\t\nanAbsolutePathToControlFile: " + string + "\t\naValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        MainElementHolder mainElementHolder = MainElementNames.getAll();
        return this.parseMainElements(parserKeyInformation, string, mainElementHolder, bl);
    }

    public DocumentObjectUpgradePackage parseMainElementsNoSave(String string, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        String string2 = "parseMainElementsNoSave(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        MainElementHolder mainElementHolder = MainElementNames.getAll();
        return this.parseMainElementsNoSave(string, mainElementHolder, bl);
    }

    public DocumentObjectUpgradePackage parseMainElementsNoSave(String string, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        File file;
        String string2 = "parseMainElementsNoSave(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\taValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        if (!(file = new File(string)).exists()) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("The upgrade control file at absolute path '" + string + "' is not found." + "\n\taValidationNeeded: " + bl));
            throw new UpgradeControlFileNotFoundException("The upgrade control file at absolute path '" + string + "' is not found.");
        }
        try {
            DocumentObjectUpgradePackage documentObjectUpgradePackage;
            if (!mainElementHolder.contains("ProductData")) {
                mainElementHolder.add(MainElementNames.get("ProductData"));
            }
            if (!mainElementHolder.contains("Transform")) {
                mainElementHolder.add(MainElementNames.get("Transform"));
            }
            Parser parser = this.createParser();
            ControlFileDocumentHandler controlFileDocumentHandler = new ControlFileDocumentHandler(file, mainElementHolder, bl);
            ControlFileErrorHandler controlFileErrorHandler = new ControlFileErrorHandler(file);
            parser.setDocumentHandler(controlFileDocumentHandler);
            parser.setErrorHandler(controlFileErrorHandler);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("START (NO SAVE OF PARSER KEY) PARSING THE UCF\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\n\tmyParsers: " + this.myParsers));
            }
            this.startParsing(parser, file);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)"STOP (NO SAVE OF PARSER KEY) PARSING THE UCF");
            }
            if ((documentObjectUpgradePackage = controlFileDocumentHandler.getDocumentObjectForUpgradePackage()) == null) {
                UpgradeTrace.error(this.getClass(), (String)string2, (String)("No document object did exist for UpgradePackage.\n\tThe upgrade control file is " + string));
                throw new UpgradeControlFileParserException("No document object did exist for UpgradePackage.\n\tThe upgrade control file is " + string);
            }
            return documentObjectUpgradePackage;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tUpgradeControlFileParserException info: " + upgradeControlFileParserException));
            }
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("Throwable caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl), (Throwable)throwable);
            throw new UpgradeControlFileParserException("Throwable caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tThrowable message: " + throwable.getMessage());
        }
    }

    public ParserKeyInformation parseMainElements(String string, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        File file;
        String string2 = "parseMainElements(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("anAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\taValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        if (!(file = new File(string)).exists()) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("The upgrade control file at absolute path '" + string + "' is not found." + "\n\taValidationNeeded: " + bl));
            throw new UpgradeControlFileNotFoundException("The upgrade control file at absolute path '" + string + "' is not found.");
        }
        try {
            DocumentObjectUpgradePackage documentObjectUpgradePackage;
            if (!mainElementHolder.contains("ProductData")) {
                mainElementHolder.add(MainElementNames.get("ProductData"));
            }
            if (!mainElementHolder.contains("Transform")) {
                mainElementHolder.add(MainElementNames.get("Transform"));
            }
            Parser parser = this.createParser();
            ControlFileDocumentHandler controlFileDocumentHandler = new ControlFileDocumentHandler(file, mainElementHolder, bl);
            ControlFileErrorHandler controlFileErrorHandler = new ControlFileErrorHandler(file);
            parser.setDocumentHandler(controlFileDocumentHandler);
            parser.setErrorHandler(controlFileErrorHandler);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("START PARSING THE UCF (NO KEY GIVEN)\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\n\tmyParsers: " + this.myParsers));
            }
            this.startParsing(parser, file);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)"STOP PARSING THE UCF");
            }
            if ((documentObjectUpgradePackage = controlFileDocumentHandler.getDocumentObjectForUpgradePackage()) == null) {
                UpgradeTrace.error(this.getClass(), (String)string2, (String)("No document object did exist for UpgradePackage. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string));
                throw new UpgradeControlFileParserException("No document object did exist for UpgradePackage. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string);
            }
            ProductData productData = documentObjectUpgradePackage.getProductData();
            if (productData == null) {
                UpgradeTrace.error(this.getClass(), (String)string2, (String)("No Product Data was stored for the upgrade package document object. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string));
                throw new UpgradeControlFileParserException("No Product Data was stored for the upgrade package document object. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string);
            }
            String string3 = productData.getNumberRaw();
            String string4 = productData.getRevisionRaw();
            if (string3 != null && string4 != null) {
                String string5;
                ParserInformation parserInformation;
                if (this.myParsers == null) {
                    this.myParsers = new Hashtable(1);
                }
                if ((parserInformation = (ParserInformation)this.myParsers.get(string5 = string3 + "_" + string4)) != null) {
                    boolean bl2 = false;
                    if (parserInformation.getHandleToUCF().getAbsolutePath().equals(file.getAbsolutePath())) {
                        bl2 = true;
                    }
                    Iterator iterator = this.mySU_DOM_ListenerInterfaces.iterator();
                    SU_DOM_ListenerInterface sU_DOM_ListenerInterface = null;
                    boolean bl3 = true;
                    while (iterator.hasNext()) {
                        sU_DOM_ListenerInterface = (SU_DOM_ListenerInterface)iterator.next();
                        if (bl2 || sU_DOM_ListenerInterface.isAllowedToRelease(string3, string4)) continue;
                        UpgradeTrace.log1(this.getClass(), (String)"parseMainElements(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)", (String)("The parsed UCF is not allowed to modify since it is used by SU DOM Listener i.e. no update of the existing parser keys:\n\taProductNumber: " + string3 + "\n\taRevision: " + string4 + "\n\ttheIsUCF_PathSame: " + bl2 + "\n\ttheSU_DOM_ListenerInterface.isAllowedToRelease(theProductNumber, theProductRevision): " + sU_DOM_ListenerInterface.isAllowedToRelease(string3, string4) + "\n\tDecided by class: " + sU_DOM_ListenerInterface));
                        bl3 = false;
                        break;
                    }
                    if (bl3) {
                        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                            UpgradeTrace.debug(this.getClass(), (int)25, (String)"parseMainElements(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)", (String)("An UCF has been parsed without input keys. The parsed UCF is already known and adding it anyhow to myParsers\n\ttheUP_ProductNumber: " + string3 + "\n\ttheUP_ProductRevision: " + string4 + "\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\taValidationNeeded: " + bl + "\n\ttheIsUCF_PathSame: " + bl2 + "\n\tThe stored (already existing) theParserInformation: " + parserInformation));
                        }
                        this.myParsers.put(string5, new ParserInformation(string3, string4, parser, controlFileDocumentHandler, controlFileErrorHandler, file, mainElementHolder));
                    }
                } else {
                    if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                        UpgradeTrace.debug(this.getClass(), (int)25, (String)"parseMainElements(String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)", (String)("An UCF has been parsed without input keys. The parsed UCF is NOT known and adding it to myParsers\n\ttheUP_ProductNumber: " + string3 + "\n\ttheUP_ProductRevision: " + string4 + "\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\taValidationNeeded: " + bl + "\n\tThe stored (already existing) theParserInformation: " + parserInformation));
                    }
                    this.myParsers.put(string5, new ParserInformation(string3, string4, parser, controlFileDocumentHandler, controlFileErrorHandler, file, mainElementHolder));
                }
                return new ParserKeyInformation(string3, string4, true);
            }
            UpgradeTrace.info(this.getClass(), (String)string2, (String)("Either the product number or product revision of parsed UP was not specified. Can't store the parser data in attribute myParsers.\n\ttheProductNumber: " + string3 + "\n\ttheProductRevision: " + string4 + "\n\tThe upgrade control file is " + string));
            throw new UpgradeControlFileParserException("Either the product number or product revision of parsed UP was not specified. Can't store the parser data in attribute myParsers.\n\ttheProductNumber: " + string3 + "\n\ttheProductRevision: " + string4 + "\n\tThe upgrade control file is " + string);
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tUpgradeControlFileParserException info: " + upgradeControlFileParserException));
            }
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("Throwable caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl), (Throwable)throwable);
            throw new UpgradeControlFileParserException("Throwable caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tThrowable message: " + throwable.getMessage());
        }
    }

    public ParserKeyInformation parseMainElements(ParserKeyInformation parserKeyInformation, String string, MainElementHolder mainElementHolder, boolean bl) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        File file;
        String string2 = "parseMainElements(ParserKeyInformation aParserKeyInformation, String anAbsolutePathToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("aParserKeyInformation: " + parserKeyInformation + "\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\taValidationNeeded: " + bl + "\n\tmyParsers: " + this.myParsers));
        }
        if (!(file = new File(string)).exists()) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("The upgrade control file at absolute path '" + string + "' is not found." + "\n\taValidationNeeded: " + bl));
            throw new UpgradeControlFileNotFoundException("The upgrade control file at absolute path '" + string + "' is not found.");
        }
        try {
            DocumentObjectUpgradePackage documentObjectUpgradePackage;
            String string3 = parserKeyInformation.getKey();
            ParserInformation parserInformation = (ParserInformation)this.myParsers.get(string3);
            if (parserInformation != null) {
                MainElementHolder mainElementHolder2 = parserInformation.filterNewMainElementsToBeParsed(mainElementHolder);
                if (mainElementHolder2.size() == 0) {
                    if (UpgradeTrace.valid(this.getClass(), (int)29)) {
                        UpgradeTrace.debug(this.getClass(), (int)29, (String)string2, (String)("No main elements need to be parsed in the Upgrade Control File '" + string + "'" + "\n\ti.e. the requested main elements already have been parsed."));
                    }
                    parserKeyInformation.setParsed(false);
                } else {
                    if (UpgradeTrace.valid(this.getClass(), (int)29)) {
                        UpgradeTrace.debug(this.getClass(), (int)29, (String)string2, (String)("The following main elements in Upgrade Control File '" + string + "' will be parsed:" + "\n\ttheNameOfMainElementsToBeParsed: " + mainElementHolder2));
                    }
                    if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                        UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("START RE-PARSING THE UCF\n\taParserKeyInformation: " + parserKeyInformation + "\n\tanAbsolutePathToControlFile: " + string + "\n\taNameOfMainElementsToBeParsed (requested): " + mainElementHolder + "\n\ttheNameOfMainElementsToBeParsed (to be...): " + mainElementHolder2 + "\n\n\tmyParsers: " + this.myParsers));
                    }
                    ControlFileDocumentHandler controlFileDocumentHandler = parserInformation.getControlFileDocumentHandler();
                    controlFileDocumentHandler.setMainElements(mainElementHolder2);
                    this.startParsing(parserInformation.getParser(), new File(string));
                    parserKeyInformation.setParsed(true);
                    parserInformation.addNewParsedMainElements(mainElementHolder2);
                    if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                        UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)"STOP PARSING THE UCF");
                    }
                }
                return parserKeyInformation;
            }
            if (UpgradeTrace.valid(this.getClass(), (int)29)) {
                UpgradeTrace.debug(this.getClass(), (int)29, (String)string2, (String)("No parser exist for productnumber: " + parserKeyInformation.getProductNumber() + " and revision: " + parserKeyInformation.getProductRevision() + ", creating one." + "\n\taNameOfMainElementsToBeParsed: " + mainElementHolder));
            }
            if (!mainElementHolder.contains("ProductData")) {
                mainElementHolder.add(MainElementNames.get("ProductData"));
            }
            if (!mainElementHolder.contains("Transform")) {
                mainElementHolder.add(MainElementNames.get("Transform"));
            }
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)("START NEW PARSING THE UCF\n\taParserKeyInformation: " + parserKeyInformation + "\n\tanAbsolutePathToControlFile: " + string + "\n\n\tmyParsers: " + this.myParsers));
            }
            Parser parser = this.createParser();
            ControlFileDocumentHandler controlFileDocumentHandler = new ControlFileDocumentHandler(file, mainElementHolder, bl);
            ControlFileErrorHandler controlFileErrorHandler = new ControlFileErrorHandler(file);
            parser.setDocumentHandler(controlFileDocumentHandler);
            parser.setErrorHandler(controlFileErrorHandler);
            this.startParsing(parser, file);
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)string2, (String)"STOP PARSING THE UCF");
            }
            if ((documentObjectUpgradePackage = controlFileDocumentHandler.getDocumentObjectForUpgradePackage()) == null) {
                UpgradeTrace.warning(this.getClass(), (String)string2, (String)("No document object did exist for UpgradePackage. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string));
                throw new UpgradeControlFileParserException("No document object did exist for UpgradePackage. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string);
            }
            ProductData productData = documentObjectUpgradePackage.getProductData();
            if (productData == null) {
                UpgradeTrace.warning(this.getClass(), (String)string2, (String)("No Product Data was stored for the upgrade package document object. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string));
                throw new UpgradeControlFileParserException("No Product Data was stored for the upgrade package document object. Can't store the parser data in attribute myParsers.\n\tThe upgrade control file is " + string);
            }
            String string4 = productData.getNumberRaw();
            String string5 = productData.getRevisionRaw();
            if (string4 != null && string5 != null) {
                if (this.myParsers == null) {
                    this.myParsers = new Hashtable(1);
                }
                this.myParsers.put(string4 + "_" + string5, new ParserInformation(string4, string5, parser, controlFileDocumentHandler, controlFileErrorHandler, file, mainElementHolder));
                return new ParserKeyInformation(string4, string5, true);
            }
            UpgradeTrace.info(this.getClass(), (String)string2, (String)("Either the product number or product revision of parsed UP was not specified. Can't store the parser data in attribute myParsers.\n\ttheProductNumber: " + string4 + "\n\ttheProductRevision: " + string5 + "\n\tThe upgrade control file is " + string));
            throw new UpgradeControlFileParserException("Either the product number or product revision of parsed UP was not specified. Can't store the parser data in attribute myParsers.\n\ttheProductNumber: " + string4 + "\n\ttheProductRevision: " + string5 + "\n\tThe upgrade control file is " + string);
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            UpgradeTrace.log1(this.getClass(), (String)string2, (String)("Exception caught (UpgradeControlFileParserException) when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + upgradeControlFileParserException.toString()));
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)string2, (String)("Throwable caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl), (Throwable)throwable);
            throw new UpgradeControlFileParserException("Exception caught when parsing requested main elements of the upgrade control file. \n\taNameOfMainElementsToBeParsed: " + mainElementHolder + "\n\tanAbsolutePathToControlFile: " + string + "\n\taValidationNeeded: " + bl + "\n\tException message: " + throwable.getMessage());
        }
    }

    public synchronized void removeMainElementsForUpgradePackageExceptFor(String string, String string2, MainElementHolder mainElementHolder) throws InvalidMainElementNameException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeMainElementsForUpgradePackageExceptFor(String aProductNumber, String aRevision, MainElementHolder aMainElementHolder)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taMainElementHolder: " + mainElementHolder));
        }
        MainElementHolder mainElementHolder2 = MainElementNames.getAll();
        mainElementHolder2.remove(mainElementHolder);
        this.removeMainElementsForUpgradePackage(string, string2, mainElementHolder2);
    }

    public synchronized void removeMainElementsForUpgradePackage(String string, String string2, MainElementHolder mainElementHolder) throws InvalidMainElementNameException {
        ParserInformation parserInformation;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeMainElementsForUpgradePackage(String aProductNumber, String aRevision, MainElementHolder aMainElementHolder)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taMainElementHolder: " + mainElementHolder));
        }
        if ((parserInformation = (ParserInformation)this.myParsers.get(string + "_" + string2)) != null) {
            DocumentObjectProxy documentObjectProxy = new DocumentObjectProxy(parserInformation.getControlFileDocumentHandler().getDocumentObjectForUpgradePackage());
            if (mainElementHolder.contains("BasedOn")) {
                documentObjectProxy.setBasedOn(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("BasedOn"));
            }
            if (mainElementHolder.contains("CommonPiuTypeList")) {
                documentObjectProxy.setCommonPiuTypeList(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("CommonPiuTypeList"));
            }
            if (mainElementHolder.contains("CppUpVersion")) {
                documentObjectProxy.setCPP_UP_Version(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("CppUpVersion"));
            }
            if (mainElementHolder.contains("DeltaAddition")) {
                documentObjectProxy.setDeltaAdditions(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("DeltaAddition"));
            }
            if (mainElementHolder.contains("ExplicitAddition")) {
                documentObjectProxy.setExplicitAdditions(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("ExplicitAddition"));
            }
            if (mainElementHolder.contains("ExplicitReplacement")) {
                documentObjectProxy.setExplicitReplacement(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("ExplicitReplacement"));
            }
            if (mainElementHolder.contains("InstallSequence")) {
                documentObjectProxy.setInstallSequences(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("InstallSequence"));
            }
            if (mainElementHolder.contains("InstallUp")) {
                documentObjectProxy.setInstallUp(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("InstallUp"));
            }
            if (mainElementHolder.contains("LoadModule")) {
                documentObjectProxy.setLoadModules(new Vector());
                parserInformation.removeParsedMainElement(MainElementNames.get("LoadModule"));
            }
            if (mainElementHolder.contains("ManagedElement")) {
                documentObjectProxy.setManagedElement(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("ManagedElement"));
            }
            if (mainElementHolder.contains("MandatoryPiuTypeList")) {
                documentObjectProxy.setMandatoryPiuTypeList(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("MandatoryPiuTypeList"));
            }
            if (mainElementHolder.contains("NodeTypeSpecificPiuTypeList")) {
                documentObjectProxy.setNodeTypeSpecificPiuTypeList(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("NodeTypeSpecificPiuTypeList"));
            }
            if (mainElementHolder.contains("PiuType")) {
                documentObjectProxy.setPiuTypes(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("PiuType"));
            }
            if (mainElementHolder.contains("ProductData")) {
                documentObjectProxy.setProductData(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("ProductData"));
            }
            if (mainElementHolder.contains("Repertoire")) {
                documentObjectProxy.setRepertoires(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("Repertoire"));
            }
            if (mainElementHolder.contains("SubrackProdType")) {
                documentObjectProxy.setSubrackProdTypes(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("SubrackProdType"));
            }
            if (mainElementHolder.contains("Transform")) {
                documentObjectProxy.setTransform(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("Transform"));
            }
            if (mainElementHolder.contains("UpCompatibilityIndex")) {
                documentObjectProxy.setUP_CompatibilityIndex(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("UpCompatibilityIndex"));
            }
            if (mainElementHolder.contains("UpdateSequence")) {
                documentObjectProxy.setUpdateSequence(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("UpdateSequence"));
            }
            if (mainElementHolder.contains("UpgradeLogic")) {
                documentObjectProxy.setUpgradeLogic(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("UpgradeLogic"));
            }
            if (mainElementHolder.contains("UpgradeSequence")) {
                documentObjectProxy.setUpgradeSequence(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("UpgradeSequence"));
            }
            if (mainElementHolder.contains("UpgradeWindow")) {
                documentObjectProxy.setUpgradeWindow(null);
                parserInformation.removeParsedMainElement(MainElementNames.get("UpgradeWindow"));
            }
            if (mainElementHolder.contains("VerifySequence")) {
                documentObjectProxy.setVerifySequences(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("VerifySequence"));
            }
            if (mainElementHolder.contains("VerifyUpdateSequence")) {
                documentObjectProxy.setVerifyUpdateSequences(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("VerifyUpdateSequence"));
            }
            if (mainElementHolder.contains("VerifyUpgradeSequence")) {
                documentObjectProxy.setVerifyUpgradeSequences(new Vector(1));
                parserInformation.removeParsedMainElement(MainElementNames.get("VerifyUpgradeSequence"));
            }
        }
    }

    public synchronized void removeDocumentObjectForUpgradePackage(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeDocumentObjectForUpgradePackage(String aProductNumber, String aRevision)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2));
        }
        this.removeDocumentObjectForUpgradePackage(string, string2, false);
    }

    public synchronized void removeDocumentObjectForUpgradePackage(String string, String string2, boolean bl) {
        String string3;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeDocumentObjectForUpgradePackage(String aProductNumber, String aRevision, boolean aForcedRemove)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taForcedRemove: " + bl));
        }
        if (this.myParsers.containsKey(string3 = string + "_" + string2)) {
            Object object;
            if (!bl) {
                object = this.mySU_DOM_ListenerInterfaces.iterator();
                SU_DOM_ListenerInterface sU_DOM_ListenerInterface = null;
                while (object.hasNext()) {
                    sU_DOM_ListenerInterface = (SU_DOM_ListenerInterface)object.next();
                    if (sU_DOM_ListenerInterface.isAllowedToRelease(string, string2)) continue;
                    try {
                        String[] stringArray = sU_DOM_ListenerInterface.getMainElementNamesNotAllowedToRelease(string, string2);
                        MainElementHolder mainElementHolder = MainElementNames.getMainElementNames(stringArray);
                        this.removeMainElementsForUpgradePackageExceptFor(string, string2, mainElementHolder);
                        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeDocumentObjectForUpgradePackage(String aProductNumber, String aRevision, boolean aForcedRemove)", (String)("NOT ALLOWED TO RELEASE the SU DOM with following product data:\n\taProductNumber: " + string + "\n\taRevision: " + string2 + "\n\tmyParsers: " + this.myParsers));
                        }
                    }
                    catch (Throwable throwable) {
                        UpgradeTrace.info(this.getClass(), (String)"removeDocumentObjectForUpgradePackage(String aProductNumber, String aRevision, boolean aForcedRemove)", (String)("Failed to release unneccessary main elements from SU DOM (ignored)\n\taProductNumber: " + string + "\n\taRevision: " + string2 + "\n\tException info: " + throwable));
                    }
                    return;
                }
            }
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeDocumentObjectForUpgradePackage(String aProductNumber, String aRevision, boolean aForcedRemove)", (String)("REMOVING DOCUMENT OBJECT FOR UCF \n\taProductNumber: " + string + "\n\taRevision: " + string2 + "\n\tmyParsers: " + this.myParsers + "\n\taForcedRemove: " + bl));
            }
            if (((ParserInformation)(object = (ParserInformation)this.myParsers.remove(string3))).getControlFileDocumentHandler() != null) {
                ((ParserInformation)object).getControlFileDocumentHandler().cleanup();
            }
            if (((ParserInformation)object).getControlFileErrorHandler() != null) {
                ((ParserInformation)object).getControlFileErrorHandler().cleanup();
            }
            ((ParserInformation)object).setParser(null);
            ((ParserInformation)object).setControlFileDocumentHandler(null);
            ((ParserInformation)object).setControlFileErrorHandler(null);
            ((ParserInformation)object).setHandleToUCF(null);
        }
    }

    public void removeNotNeededDocumentObjectForUpgradePackages() {
        Iterator iterator = this.myParsers.values().iterator();
        ParserInformation parserInformation = null;
        LinkedList<ParserInformation> linkedList = new LinkedList<ParserInformation>();
        while (iterator.hasNext()) {
            parserInformation = (ParserInformation)iterator.next();
            linkedList.add(parserInformation);
        }
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            parserInformation = (ParserInformation)iterator2.next();
            this.removeDocumentObjectForUpgradePackage(parserInformation.getUP_ProductNumber(), parserInformation.getUP_ProductRevision());
        }
    }

    private Parser createParser() throws UpgradeControlFileParserException {
        String string = "createParser()";
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createParser()");
        }
        try {
            return ParserFactory.makeParser(ParserClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            UpgradeTrace.error(this.getClass(), (String)string, (String)("Thrown when trying to load in a class through its string name,\nbut no definition for the class with the specified name could be found.\nProbably occured when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassNotFoundException: " + classNotFoundException.getMessage()), (Throwable)classNotFoundException);
            throw new UpgradeControlFileParserException("Thrown when trying to load in a class through its string name,\nbut no definition for the class with the specified name could be found.\nProbably occured when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            UpgradeTrace.error(this.getClass(), (String)string, (String)("Thrown when trying to load in a class, but the currently executing method does\nnot have access to the definition of the specified class, beacuse the class is not public\nor in an other package.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanIllegalAccessException: " + illegalAccessException.getMessage()), (Throwable)illegalAccessException);
            throw new UpgradeControlFileParserException("Thrown when trying to load in a class, but the currently executing method does\nnot have access to the definition of the specified class, beacuse the class is not public\nor in an other package.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanIllegalAccessException: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            UpgradeTrace.error(this.getClass(), (String)string, (String)("Thrown when trying to create an instance of a class using the newInstance\nmethod in class Class, but the specified class object cannot be instantiated beacuse\nit is an interface or is an abstract class.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanInstantiationException: " + instantiationException.getMessage()), (Throwable)instantiationException);
            throw new UpgradeControlFileParserException("Thrown when trying to create an instance of a class using the newInstance\nmethod in class Class, but the specified class object cannot be instantiated beacuse\nit is an interface or is an abstract class.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanInstantiationException: " + instantiationException.getMessage());
        }
        catch (ClassCastException classCastException) {
            UpgradeTrace.error(this.getClass(), (String)string, (String)("An attempt has been made to cast an object to a subclass of which it is not an instance.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassCastException: " + classCastException.getMessage()), (Throwable)classCastException);
            throw new UpgradeControlFileParserException("An attempt has been made to cast an object to a subclass of which it is not an instance.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\taClassCastException: " + classCastException.getMessage());
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)string, (String)("An error detected when trying to create a new parser.\n\tParserClass: " + ParserClass + "\n\tanException: " + exception.getMessage()), (Throwable)exception);
            throw new UpgradeControlFileParserException("An error detected when trying to create a new parser.\nRaised when requesting the ParserFactory to instantiate a new parser.\n\tParserClass: " + ParserClass + "\n\tanException: " + exception.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private void startParsing(Parser parser, File file) throws UpgradeControlFileParserException {
        block17: {
            FileReader fileReader;
            String string;
            block16: {
                string = "startParsing(Parser aParser, File aHandleToControlFile)";
                if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                    UpgradeTrace.debug(this.getClass(), (int)25, (String)string, (String)("aHandleToControlFile (absolute path): " + StringUtils.toString(file)));
                }
                if (file == null || !file.exists()) {
                    UpgradeTrace.error(this.getClass(), (String)string, (String)("The UCF do not exist on given absolute path.\n\taHandleToControlFile (absolute path): " + StringUtils.toString(file)));
                    throw new UpgradeControlFileParserException("The UCF do not exist on given absolute path.\n\taHandleToControlFile (absolute path): " + StringUtils.toString(file));
                }
                fileReader = null;
                fileReader = new FileReader(file);
                if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                    UpgradeTrace.debug(this.getClass(), (int)27, (String)string, (String)"A File handle has been OPENED for the UCF.");
                }
                parser.parse(new InputSource(fileReader));
                if (!UpgradeTrace.valid(this.getClass(), (int)27)) break block16;
                UpgradeTrace.debug(this.getClass(), (int)27, (String)string, (String)"The requested main elements in UCF has been parsed.");
            }
            Object var7_5 = null;
            if (fileReader == null) break block17;
            try {
                fileReader.close();
                if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                    UpgradeTrace.debug(this.getClass(), (int)27, (String)string, (String)"A File handle has been CLOSED to the UCF.");
                }
                break block17;
            }
            catch (IOException iOException) {
                UpgradeTrace.error(this.getClass(), (String)string, (String)("An error occured when trying to close the handle to the UCF. This might result in new errors due to this error.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanException message: " + iOException.getMessage()), (Throwable)iOException);
            }
            break block17;
            {
                catch (ValidateException validateException) {
                    if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                        UpgradeTrace.debug(this.getClass(), (int)27, (String)string, (String)("ValidateException info: " + validateException));
                    }
                    throw new UpgradeControlFileParserException("An error detected during parsing of the Upgrade Package Control File.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanException info: " + validateException);
                }
                catch (IOException iOException) {
                    UpgradeTrace.error(this.getClass(), (String)string, (String)("An error (IOException) detected during parsing of the Upgrade Package Control File.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanIOException message: " + iOException.getMessage()), (Throwable)iOException);
                    throw new UpgradeControlFileParserException("An error detected during parsing of the Upgrade Package Control File.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanIOException message: " + iOException);
                }
                catch (Throwable throwable) {
                    UpgradeTrace.warning(this.getClass(), (String)string, (String)("An error (Throwable) detected during parsing of the Upgrade Package Control File.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\taThrowable message: " + throwable));
                    throw new UpgradeControlFileParserException("An error detected during parsing of the Upgrade Package Control File.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanException message: " + throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (fileReader != null) {
                    try {
                        fileReader.close();
                        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                            UpgradeTrace.debug(this.getClass(), (int)27, (String)string, (String)"A File handle has been CLOSED to the UCF.");
                        }
                    }
                    catch (IOException iOException) {
                        UpgradeTrace.error(this.getClass(), (String)string, (String)("An error occured when trying to close the handle to the UCF. This might result in new errors due to this error.\n\taHandleToControlFile: " + file.getAbsolutePath() + "\n\tanException message: " + iOException.getMessage()), (Throwable)iOException);
                    }
                }
                throw throwable;
            }
        }
    }
}

