/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.ExplicitReplacement;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpu;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpuAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAddition;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAdditionAttributeName;
import se.ericsson.cello.sudom.parser.dom.transform.Value;

public class ExplicitReplacementTransformer {
    public static final String RpuAdditionPath = "UpgradePackage/ExplicitReplacement/RpuAddition";
    public static final String NewRpuPath = "UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        if (value.getElementPath().equals(RpuAdditionPath)) {
            this.transformRpuAdditionAttribute(value, documentObjectUpgradePackage);
        } else if (value.getElementPath().equals(NewRpuPath)) {
            this.transformNewRpuAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformRpuAdditionAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformPiuTypeLoadListDataAdditionAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRpuAdditions(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        RpuAddition rpuAddition = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            if (value.getAttributeName().equals(RpuAdditionAttributeName.ModifyExisting.getValue())) {
                if (rpuAddition.getModifyExisting() == null || !rpuAddition.getModifyExisting().equals(value.getFrom())) continue;
                rpuAddition.setModifyExisting(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformPiuTypeLoadListDataAdditionAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getRpuAdditions(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRpuAdditions(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getExplicitReplacement();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        ExplicitReplacement explicitReplacement = null;
        while (iterator.hasNext()) {
            explicitReplacement = (ExplicitReplacement)iterator.next();
            linkedList.addAll(explicitReplacement.getRpuAdditions());
        }
        return linkedList;
    }

    private void transformNewRpuAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformNewRpuAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getNewRpus(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        NewRpu newRpu = null;
        while (iterator.hasNext()) {
            newRpu = (NewRpu)iterator.next();
            if (value.getAttributeName().equals(NewRpuAttributeName.ReverseRelations.getValue())) {
                if (newRpu.getReverseRelations() == null || !newRpu.getReverseRelations().equals(value.getFrom())) continue;
                newRpu.setReverseRelations(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(NewRpuAttributeName.Normalisation.getValue())) {
                if (newRpu.getNormalisation() == null || !newRpu.getNormalisation().equals(value.getFrom())) continue;
                newRpu.setNormalisation(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(NewRpuAttributeName.Replication.getValue())) {
                if (newRpu.getReplication() == null || !newRpu.getReplication().equals(value.getFrom())) continue;
                newRpu.setReplication(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(NewRpuAttributeName.SwitchOver.getValue())) {
                if (newRpu.getSwitchOver() == null || !newRpu.getSwitchOver().equals(value.getFrom())) continue;
                newRpu.setSwitchOver(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(NewRpuAttributeName.OneLegged.getValue())) {
                if (newRpu.getOneLegged() == null || !newRpu.getOneLegged().equals(value.getFrom())) continue;
                newRpu.setOneLegged(value.getTo());
                continue;
            }
            if (value.getAttributeName().equals(NewRpuAttributeName.CreateOnlyIfNotExisting.getValue())) {
                if (newRpu.getCreateOnlyIfNotExisting() == null || !newRpu.getCreateOnlyIfNotExisting().equals(value.getFrom())) continue;
                newRpu.setCreateOnlyIfNotExisting(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformNewRpuAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getNewRpus(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getRpuAdditions(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getRpuAdditions(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        RpuAddition rpuAddition = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            linkedList.addAll(rpuAddition.getNewRpus());
        }
        return linkedList;
    }
}

