/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.helpers.LocatorImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.ExplicitAdditionTransformer;
import se.ericsson.cello.sudom.parser.control.transform.ExplicitReplacementTransformer;
import se.ericsson.cello.sudom.parser.control.transform.InstallSequenceTransformer;
import se.ericsson.cello.sudom.parser.control.transform.LoadModuleTransformer;
import se.ericsson.cello.sudom.parser.control.transform.ManagedElementTransformer;
import se.ericsson.cello.sudom.parser.control.transform.PiuTypeTransformer;
import se.ericsson.cello.sudom.parser.control.transform.ProductDataTransformer;
import se.ericsson.cello.sudom.parser.control.transform.RepertoireTransformer;
import se.ericsson.cello.sudom.parser.control.transform.SubrackProdTypeTransformer;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.control.transform.UpgradeSequenceTransformer;
import se.ericsson.cello.sudom.parser.control.transform.UpgradeWindowTransformer;
import se.ericsson.cello.sudom.parser.control.transform.VerifySequenceTransformer;
import se.ericsson.cello.sudom.parser.control.transform.VerifyUpgradeSequenceTransformer;
import se.ericsson.cello.sudom.parser.dom.AttributeValidationInterface;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.explicitaddition.PiuTypeLoadListDataAdditionAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpuAttributeName;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAdditionAttributeName;
import se.ericsson.cello.sudom.parser.dom.installsequence.PreUpgradeSuAttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.piutype.PiuTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.transform.TransformSubElementName;
import se.ericsson.cello.sudom.parser.dom.transform.Value;
import se.ericsson.cello.sudom.parser.dom.transform.ValueAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootJvmUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootNodeUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RebootPiuUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.RunProgramsAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftPiuUpgradeAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.SoftSequenceAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.PreUpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradewindow.UpgradeCaseAttributeName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class TransformController {
    public static final String ProductDataPath = "UpgradePackage/ProductData";
    public static final String CppUpVersionPath = "UpgradePackage/CppUpVersion";
    public static final String ManagedElementPath = "UpgradePackage/ManagedElement";
    public static final String UpgradeWindowPath = "UpgradePackage/UpgradeWindow";
    public static final String PiuTypePath = "UpgradePackage/PiuType";
    public static final String SubrackProdTypePath = "UpgradePackage/SubrackProdType";
    public static final String RepertoirePath = "UpgradePackage/Repertoire";
    public static final String ExplicitAdditionPath = "UpgradePackage/ExplicitAddition";
    public static final String ExplicitReplacementPath = "UpgradePackage/ExplicitReplacement";
    public static final String InstallSequencePath = "UpgradePackage/InstallSequence";
    public static final String VerifySequencePath = "UpgradePackage/VerifySequence";
    public static final String VerifyUpgradeSequencePath = "UpgradePackage/VerifyUpgradeSequence";
    public static final String UpgradeSequencePath = "UpgradePackage/UpgradeSequence";
    public static final String LoadModulePath = "UpgradePackage/LoadModule";
    public static final String FRONT_SLASH = "/";
    private HashMap myAttributeNameValidators = new HashMap();

    public TransformController() {
        this.buildMaps();
    }

    public void execute(DocumentObjectUpgradePackage documentObjectUpgradePackage, Collection collection) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        if (documentObjectUpgradePackage.isTransformUnknownValues()) {
            Iterator iterator = collection.iterator();
            Value value = null;
            while (iterator.hasNext()) {
                value = (Value)iterator.next();
                this.validateTransformValue(value, documentObjectUpgradePackage);
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                value = (Value)iterator.next();
                this.transformValue(value, documentObjectUpgradePackage);
            }
        }
    }

    private void validateTransformValue(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("validateTransformValue(Transform aTransformElement)aTransformValueElement: " + value));
        }
        if (value.getElementPath().endsWith(FRONT_SLASH)) {
            String string = "Upgrade control file error,\n\tillegal attribute value: " + ValueAttributeName.ElementPath.getValue() + " = \"" + value.getElementPath() + "\"" + " found in element of type " + TransformSubElementName.Value + "." + "\n\tMust not end with front slash (/)";
            UpgradeTrace.info(this.getClass(), (String)"validate(String aValue, Locator aLocator )", (String)string);
            throw new TransformException(string);
        }
    }

    private void transformValue(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("transformValue(Transform aTransformElement)aTransformValueElement: " + value));
        }
        if (this.isTransformNeeded(value)) {
            if (value.getElementPath().startsWith(LoadModulePath)) {
                new LoadModuleTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(ProductDataPath)) {
                new ProductDataTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(ManagedElementPath)) {
                new ManagedElementTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(UpgradeWindowPath)) {
                new UpgradeWindowTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(PiuTypePath)) {
                new PiuTypeTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(SubrackProdTypePath)) {
                new SubrackProdTypeTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(RepertoirePath)) {
                new RepertoireTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(ExplicitAdditionPath)) {
                new ExplicitAdditionTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(ExplicitReplacementPath)) {
                new ExplicitReplacementTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(InstallSequencePath)) {
                new InstallSequenceTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(VerifySequencePath)) {
                new VerifySequenceTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(VerifyUpgradeSequencePath)) {
                new VerifyUpgradeSequenceTransformer().execute(value, documentObjectUpgradePackage);
            } else if (value.getElementPath().startsWith(UpgradeSequencePath)) {
                new UpgradeSequenceTransformer().execute(value, documentObjectUpgradePackage);
            } else {
                UpgradeTrace.info(this.getClass(), (String)"transformValue(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo() + "\n\tmyAttributeNameValidators: " + this.myAttributeNameValidators + "\n\taTransformValueElement.getElementPath() + FRONT_SLASH + aTransformValueElement.getAttributeName(): " + value.getElementPath() + FRONT_SLASH + value.getAttributeName()));
            }
        }
    }

    private boolean isTransformNeeded(Value value) throws TransformException {
        AttributeValidationInterface attributeValidationInterface;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isTransformNeeded(Value aTransformValueElement)", (String)("aTransformValueElement: " + value));
        }
        if ((attributeValidationInterface = (AttributeValidationInterface)this.myAttributeNameValidators.get(value.getElementPath() + FRONT_SLASH + value.getAttributeName())) == null) {
            UpgradeTrace.info(this.getClass(), (String)"transformValue(Transform aTransformElement)", (String)("The attribute to be transformed is not known (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo() + "\n\tmyAttributeNameValidators: " + this.myAttributeNameValidators + "\n\taTransformValueElement.getElementPath() + FRONT_SLASH + aTransformValueElement.getAttributeName(): " + value.getElementPath() + FRONT_SLASH + value.getAttributeName()));
            return false;
        }
        try {
            attributeValidationInterface.validate(value.getFrom(), new LocatorImpl(), true);
            return false;
        }
        catch (ValidateException validateException) {
            try {
                attributeValidationInterface.validate(value.getTo(), new LocatorImpl(), true);
                return true;
            }
            catch (ValidateException validateException2) {
                throw new TransformException("Transformation to the new TO value not possible since this value is not known by SU function\n\t" + validateException2.toString());
            }
        }
    }

    private void buildMaps() {
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/MoDataLM/" + MoDataLM_AttributeName.LoaderName.getValue(), MoDataLM_AttributeName.LoaderName);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/ModataLM/" + MoDataLM_AttributeName.LoaderName.getValue(), MoDataLM_AttributeName.LoaderName);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/MoDataLM/" + MoDataLM_AttributeName.Preload.getValue(), MoDataLM_AttributeName.Preload);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/ModataLM/" + MoDataLM_AttributeName.Preload.getValue(), MoDataLM_AttributeName.Preload);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/MoDataLM/" + MoDataLM_AttributeName.OseProgramLoadClass.getValue(), MoDataLM_AttributeName.OseProgramLoadClass);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/ModataLM/" + MoDataLM_AttributeName.OseProgramLoadClass.getValue(), MoDataLM_AttributeName.OseProgramLoadClass);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/MoDataLM/" + MoDataLM_AttributeName.MaxExecInstancesNode.getValue(), MoDataLM_AttributeName.MaxExecInstancesNode);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/ModataLM/" + MoDataLM_AttributeName.MaxExecInstancesNode.getValue(), MoDataLM_AttributeName.MaxExecInstancesNode);
        this.myAttributeNameValidators.put("UpgradePackage/LoadModule/InstallLM/" + InstallLM_AttributeName.Directory.getValue(), InstallLM_AttributeName.Directory);
        this.myAttributeNameValidators.put("UpgradePackage/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/ManagedElement/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/CppUpVersion/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeWindow/OldUpgradePackage/UpgradeCase/" + UpgradeCaseAttributeName.Type.getValue(), UpgradeCaseAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeWindow/OldUpgradePackage/PreUpgradeCase/" + PreUpgradeCaseAttributeName.Type.getValue(), PreUpgradeCaseAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/PiuType/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/PiuType/PiuTypeData/" + PiuTypeDataAttributeName.DefaultPiuRole.getValue(), PiuTypeDataAttributeName.DefaultPiuRole);
        this.myAttributeNameValidators.put("UpgradePackage/PiuType/PiuTypeData/" + PiuTypeDataAttributeName.DefAllowedSeqRestarts.getValue(), PiuTypeDataAttributeName.DefAllowedSeqRestarts);
        this.myAttributeNameValidators.put("UpgradePackage/SubrackProdType/ProductData/" + ProductDataAttributeName.Type.getValue(), ProductDataAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/SubrackProdType/SubrackProdTypeData/" + SubrackProdTypeDataAttributeName.FanConfiguration.getValue(), SubrackProdTypeDataAttributeName.FanConfiguration);
        this.myAttributeNameValidators.put("UpgradePackage/SubrackProdType/SubrackProdTypeData/" + SubrackProdTypeDataAttributeName.TransmissionType.getValue(), SubrackProdTypeDataAttributeName.TransmissionType);
        this.myAttributeNameValidators.put("UpgradePackage/Repertoire/PiuTypeLoadList/LoadModuleRef/" + LoadModuleRefAttributeName.LoaderName.getValue(), LoadModuleRefAttributeName.LoaderName);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitAddition/PiuTypeLoadListDataAddition/" + PiuTypeLoadListDataAdditionAttributeName.AddDataInOldPiuTypeLoadLists.getValue(), PiuTypeLoadListDataAdditionAttributeName.AddDataInOldPiuTypeLoadLists);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/" + RpuAdditionAttributeName.ModifyExisting.getValue(), RpuAdditionAttributeName.ModifyExisting);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.ReverseRelations.getValue(), NewRpuAttributeName.ReverseRelations);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.Normalisation.getValue(), NewRpuAttributeName.Normalisation);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.Replication.getValue(), NewRpuAttributeName.Replication);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.SwitchOver.getValue(), NewRpuAttributeName.SwitchOver);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.OneLegged.getValue(), NewRpuAttributeName.OneLegged);
        this.myAttributeNameValidators.put("UpgradePackage/ExplicitReplacement/RpuAddition/NewRpu/" + NewRpuAttributeName.CreateOnlyIfNotExisting.getValue(), NewRpuAttributeName.CreateOnlyIfNotExisting);
        this.myAttributeNameValidators.put("UpgradePackage/InstallSequence/InstallStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.ForcedPreUpgrade.getValue(), PreUpgradeSuAttributeName.ForcedPreUpgrade);
        this.myAttributeNameValidators.put("UpgradePackage/InstallSequence/InstallStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.Phase.getValue(), PreUpgradeSuAttributeName.Phase);
        this.myAttributeNameValidators.put("UpgradePackage/VerifySequence/VerifyStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.ForcedPreUpgrade.getValue(), PreUpgradeSuAttributeName.ForcedPreUpgrade);
        this.myAttributeNameValidators.put("UpgradePackage/VerifySequence/VerifyStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.Phase.getValue(), PreUpgradeSuAttributeName.Phase);
        this.myAttributeNameValidators.put("UpgradePackage/VerifyUpgradeSequence/VerifyStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.ForcedPreUpgrade.getValue(), PreUpgradeSuAttributeName.ForcedPreUpgrade);
        this.myAttributeNameValidators.put("UpgradePackage/VerifyUpgradeSequence/VerifyStep/PreUpgradeSu/" + PreUpgradeSuAttributeName.Phase.getValue(), PreUpgradeSuAttributeName.Phase);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootNodeUpgrade/" + RebootNodeUpgradeAttributeName.BaseClassPath.getValue(), RebootNodeUpgradeAttributeName.BaseClassPath);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootNodeUpgrade/" + RebootNodeUpgradeAttributeName.UseRepertoiresValue.getValue(), RebootNodeUpgradeAttributeName.UseRepertoiresValue);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootJvmUpgrade/" + RebootJvmUpgradeAttributeName.BaseClassPath.getValue(), RebootJvmUpgradeAttributeName.BaseClassPath);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootJvmUpgrade/" + RebootJvmUpgradeAttributeName.UseRepertoiresValue.getValue(), RebootJvmUpgradeAttributeName.UseRepertoiresValue);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/" + RebootPiuUpgradeAttributeName.BaseClassPath.getValue(), RebootPiuUpgradeAttributeName.BaseClassPath);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/" + RebootPiuUpgradeAttributeName.UseRepertoiresValue.getValue(), RebootPiuUpgradeAttributeName.UseRepertoiresValue);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootNodeUpgrade/" + RebootNodeUpgradeAttributeName.ForcedMoppletUsage.getValue(), RebootNodeUpgradeAttributeName.ForcedMoppletUsage);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootJvmUpgrade/" + RebootJvmUpgradeAttributeName.ForcedMoppletUsage.getValue(), RebootJvmUpgradeAttributeName.ForcedMoppletUsage);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/" + RebootPiuUpgradeAttributeName.ForcedMoppletUsage.getValue(), RebootPiuUpgradeAttributeName.ForcedMoppletUsage);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/" + RebootPiuUpgradeAttributeName.Optional.getValue(), RebootPiuUpgradeAttributeName.Optional);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/Sequence/" + SequenceAttributeName.Type.getValue(), SequenceAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/Sequence/" + SequenceAttributeName.Shutdown.getValue(), SequenceAttributeName.Shutdown);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/SoftPiuUpgrade/" + SoftPiuUpgradeAttributeName.UnreliableProgramSelect.getValue(), SoftPiuUpgradeAttributeName.UnreliableProgramSelect);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootPiuUpgrade/SoftSequence/" + SoftSequenceAttributeName.Type.getValue(), SoftSequenceAttributeName.Type);
        this.myAttributeNameValidators.put("UpgradePackage/UpgradeSequence/Step/RebootProgramUpgrade/RunPrograms/" + RunProgramsAttributeName.OneInstance.getValue(), RunProgramsAttributeName.OneInstance);
    }
}

