/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.loadmodule;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallSM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallSM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModule;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleSubElementName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataValidator;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class LoadModuleValidator
extends Validator {
    public static String JAVA_UCF_PATH = "java/";

    public static void validate(LoadModule loadModule, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)LoadModuleValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)LoadModuleValidator.class, (int)25, (String)"validate(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule + "\n\taLocator: " + locator));
        }
        ProductDataValidator.validate(loadModule.getProductData(), 8, 24, 1, 7, true, true, "LoadModule");
        LoadModuleValidator.validateInstallLM_Elements(loadModule, locator);
        LoadModuleValidator.validateInstallSM_Elements(loadModule, locator);
        LoadModuleValidator.validateLoaderNameWithDestPath(loadModule, locator);
        if (!CommonDocumentObjectInformation.getInstance().getIgnoreUnknownAttributes()) {
            LoadModuleValidator.validateNotExpectedAttributes(loadModule);
        }
    }

    private static void validateLoaderNameWithDestPath(LoadModule loadModule, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)LoadModuleValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)LoadModuleValidator.class, (int)25, (String)"validateLoaderNameWithDestPath(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule));
        }
        Vector vector = loadModule.getInstallLM();
        if (loadModule.getMoDataLM().getLoaderName().equals(LoaderName.JVM.getValue())) {
            InstallLM installLM = null;
            for (int i = 0; i < vector.size(); ++i) {
                installLM = (InstallLM)vector.elementAt(i);
                if (installLM.getDestFilePathName() != null && installLM.getDestFilePathName().startsWith(JAVA_UCF_PATH)) continue;
                String string = "Upgrade control file error,\n\tUnexpected DestinationPath detected for loaderName=JVM: attribute " + InstallLM_AttributeName.DestFilePathName.getValue() + " found in element of type " + LoadModuleSubElementName.InstallLM.getValue() + " where parent is " + "LoadModule" + ". The product data of the load module is: " + " Product number : " + loadModule.getProductData().getNumberRaw() + " Revision: " + loadModule.getProductData().getRevisionRaw() + ".So use java/ as valid destinationPath";
                LoadModuleValidator.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator == null ? LoadModuleValidator.class$("se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleValidator") : class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator, "validateLoaderNameWithDestPath ( LoadModule aLoadModule, Loacator aLocator)", "LoadModule", LoadModuleSubElementName.InstallLM.getValue(), InstallLM_AttributeName.DestFilePathName.getValue(), installLM.getDestFilePathName(), string, locator);
            }
        }
    }

    private static void validateNotExpectedAttributes(LoadModule loadModule) throws UnexpectedAttributeException {
        if (UpgradeTrace.valid((Class)LoadModuleValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)LoadModuleValidator.class, (int)25, (String)"validateNotExpectedAttributes(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule));
        }
        if (loadModule.getMoDataLM().getChecksum() != null) {
            String string = "Upgrade control file error,\n\tUnexpected attribute detected: attribute " + MoDataLM_AttributeName.Checksum.getValue() + " found in element of type " + LoadModuleSubElementName.MoDataLM.getValue() + " where parent is " + "LoadModule" + ".";
            String string2 = "\n\tThe product data of the load module is: \n\tProduct number : " + loadModule.getProductData().getNumberRaw() + "Revision: " + loadModule.getProductData().getRevisionRaw();
            UpgradeTrace.error((Class)LoadModuleValidator.class, (String)"validateDateAttribute(LoadModule aLoadModule)", (String)(string + string2));
            throw new UnexpectedAttributeException(string + string2, 0, 0);
        }
        if (loadModule.getMoDataLM().getFileSize() != null) {
            String string = "Upgrade control file error,\n\tUnexpected attribute detected: attribute " + MoDataLM_AttributeName.FileSize.getValue() + " found in element of type " + LoadModuleSubElementName.MoDataLM.getValue() + " where parent is " + "LoadModule" + ".";
            String string3 = "\n\tThe product data of the load module is: \n\tProduct number : " + loadModule.getProductData().getNumberRaw() + "Revision: " + loadModule.getProductData().getRevisionRaw();
            UpgradeTrace.error((Class)LoadModuleValidator.class, (String)"validateDateAttribute(LoadModule aLoadModule)", (String)(string + string3));
            throw new UnexpectedAttributeException(string + string3, 0, 0);
        }
        Iterator iterator = loadModule.getInstallLM().iterator();
        InstallLM installLM = null;
        while (iterator.hasNext()) {
            installLM = (InstallLM)iterator.next();
            if (installLM.getFTP_TransferMode() == null) continue;
            String string = "Upgrade control file error,\n\tUnexpected attribute detected: attribute " + InstallLM_AttributeName.FTP_TransferMode.getValue() + " found in element of type " + LoadModuleSubElementName.InstallLM.getValue() + " where parent is " + "LoadModule" + ".";
            String string4 = "\n\tThe product data of the load module is: \n\tProduct number : " + loadModule.getProductData().getNumberRaw() + "Revision: " + loadModule.getProductData().getRevisionRaw();
            UpgradeTrace.error((Class)LoadModuleValidator.class, (String)"validateDateAttribute(LoadModule aLoadModule)", (String)(string + string4));
            throw new UnexpectedAttributeException(string + string4, 0, 0);
        }
    }

    private static void validateInstallLM_Elements(LoadModule loadModule, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)LoadModuleValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)LoadModuleValidator.class, (int)25, (String)"validateInstallLM_Elements(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule));
        }
        Vector vector = loadModule.getInstallLM();
        boolean bl = false;
        boolean bl2 = false;
        InstallLM installLM = null;
        int n = 0;
        for (n = 0; n < vector.size(); ++n) {
            installLM = (InstallLM)vector.elementAt(n);
            if (n == 0 && installLM.getDirectory().equals("yes")) {
                bl = true;
                continue;
            }
            if (n <= 0 || !installLM.getDirectory().equals("yes")) continue;
            bl2 = true;
        }
        if (n == 1) {
            if (bl) {
                String string = "When only one instance of element " + LoadModuleSubElementName.InstallLM.getValue() + " is defined for a load module, this attribute shall have its value set to " + "no" + ".";
                LoadModuleValidator.errorIllegalAttributeValue(LoadModuleValidator.class, "validateInstallLM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallLM.getValue(), InstallLM_AttributeName.Directory.getValue(), "yes", string, locator);
            }
        } else if (n > 1) {
            if (!bl) {
                String string = "When multiple InstallLM elements are defined for a load module, the first\n" + LoadModuleSubElementName.InstallLM.getValue() + " instance must have this attribute set to value" + "\n" + "yes" + ".";
                LoadModuleValidator.errorIllegalAttributeValue(LoadModuleValidator.class, "validateInstallLM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallLM.getValue(), InstallLM_AttributeName.Directory.getValue(), "no", string, locator);
            } else if (bl && bl2) {
                String string = "When multiple InstallLM elements are defined for a load module, only the first\n" + LoadModuleSubElementName.InstallLM.getValue() + " instance must have this attribute set to value" + "\n" + "yes" + ".";
                LoadModuleValidator.errorIllegalAttributeValue(LoadModuleValidator.class, "validateInstallLM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallLM.getValue(), InstallLM_AttributeName.Directory.getValue(), "yes", string, locator);
            }
        }
    }

    private static void validateInstallSM_Elements(LoadModule loadModule, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)LoadModuleValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)LoadModuleValidator.class, (int)25, (String)"validateInstallSM_Elements(LoadModule aLoadModule)", (String)("aLoadModule: " + loadModule));
        }
        Vector vector = loadModule.getInstallLM();
        Vector vector2 = (Vector)loadModule.getInstallSM();
        boolean bl = false;
        InstallLM installLM = null;
        InstallSM installSM = null;
        String string = "";
        int n = 0;
        installLM = (InstallLM)vector.elementAt(n);
        if (n == 0 && installLM.getDirectory().equals("yes")) {
            bl = true;
        }
        if (vector.size() == 1) {
            if (!bl && vector2.size() > 1) {
                string = "When only one instance of element " + LoadModuleSubElementName.InstallLM.getValue() + " is defined for a load module, In LoadModule shall have 0..1 InstallSM " + LoadModuleSubElementName.InstallSM.getValue() + ".";
                LoadModuleValidator.errorIllegalAttributeValue(LoadModuleValidator.class, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), LoadModuleSubElementName.InstallSM.getValue(), string, locator);
            } else if (!bl && vector2.size() == 1 && (installSM = (InstallSM)vector2.elementAt(n)).getDestFilePathNameRef() != null) {
                string = "When only one instance of element " + LoadModuleSubElementName.InstallLM.getValue() + " is defined for a load module, not valid to have " + InstallSM_AttributeName.DestFilePathNameRef.getValue() + ".";
                LoadModuleValidator.errorIllegalAttributeValue(LoadModuleValidator.class, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), InstallSM_AttributeName.DestFilePathNameRef.getValue(), string, locator);
            }
        } else if (vector.size() > 1) {
            if (bl && vector.size() < vector2.size() + 1) {
                string = "When multiple InstallLM elements are defined for a load module, and the first\n" + LoadModuleSubElementName.InstallLM.getValue() + " instance set to value" + " - " + "yes" + "." + vector.size() + "\n For each InstallLM we can have 0..1 InstallSM " + vector2.size();
                LoadModuleValidator.errorUnexpectedElement(LoadModuleValidator.class, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), LoadModuleSubElementName.InstallSM.getValue(), string, locator);
            }
            if (bl && vector.size() >= vector2.size() + 1) {
                Vector<String> vector3 = new Vector<String>(1);
                Vector<String> vector4 = new Vector<String>(1);
                boolean bl2 = false;
                for (int i = 0; i < vector.size(); ++i) {
                    vector4.add(((InstallLM)vector.elementAt(i)).getDestFilePathName());
                }
                for (n = 0; n < vector2.size(); ++n) {
                    installSM = (InstallSM)vector2.elementAt(n);
                    if (installSM.getDestFilePathNameRef() == null) {
                        bl2 = true;
                        continue;
                    }
                    if (vector3.contains(installSM.getDestFilePathNameRef())) {
                        string = "The attribute " + InstallSM_AttributeName.DestFilePathNameRef.getValue() + " : " + installSM.getDestFilePathNameRef() + " should be unique in " + LoadModuleSubElementName.InstallSM.getValue() + ".";
                        LoadModuleValidator.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator == null ? LoadModuleValidator.class$("se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleValidator") : class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), InstallLM_AttributeName.DestFilePathName.getValue(), string, locator);
                        continue;
                    }
                    if (!vector4.contains(installSM.getDestFilePathNameRef())) {
                        string = "The attribute " + InstallSM_AttributeName.DestFilePathNameRef.getValue() + " : " + installSM.getDestFilePathNameRef() + " should be matche with  " + LoadModuleSubElementName.InstallLM.getValue() + "." + InstallLM_AttributeName.DestFilePathName.getValue() + ".";
                        LoadModuleValidator.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator == null ? LoadModuleValidator.class$("se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleValidator") : class$se$ericsson$cello$sudom$parser$dom$loadmodule$LoadModuleValidator, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), InstallLM_AttributeName.DestFilePathName.getValue(), string, locator);
                    }
                    vector3.add(installSM.getDestFilePathNameRef());
                }
                if (bl2) {
                    string = "When multiple InstallSM elements are defined for a load module, each\n" + LoadModuleSubElementName.InstallLM.getValue() + " instance must set value" + " '" + InstallSM_AttributeName.DestFilePathNameRef + "' .";
                    LoadModuleValidator.errorAttributeMissingWithLocatorString(LoadModuleValidator.class, "validateInstallSM_Elements ( LoadModule aLoadModule )", "LoadModule", LoadModuleSubElementName.InstallSM.getValue(), InstallSM_AttributeName.DestFilePathNameRef.getValue(), string, LocatorProxy.getLocatorInfo(locator));
                }
            }
        }
    }
}

