/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.productdata;

import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.sudom.parser.dom.AttributeProperty;
import se.ericsson.cello.sudom.parser.dom.AttributeValidationInterface;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataDateValue;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductDataTypeValue;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class ProductDataAttributeName
extends AttributeProperty
implements AttributeValidationInterface {
    public static final ProductDataAttributeName Number = new ProductDataAttributeName("number", true);
    public static final ProductDataAttributeName Revision = new ProductDataAttributeName("revision", true);
    public static final ProductDataAttributeName Name = new ProductDataAttributeName("name", false, 12);
    public static final ProductDataAttributeName Date = new ProductDataAttributeName("date");
    public static final ProductDataAttributeName Type = new ProductDataAttributeName("type");
    public static final ProductDataAttributeName Information = new ProductDataAttributeName("information");
    private int minLength = -1;
    private int maxLength = -1;

    private ProductDataAttributeName(String string, boolean bl) {
        super(string, bl);
    }

    private ProductDataAttributeName(String string) {
        super(string);
    }

    private ProductDataAttributeName(String string, boolean bl, int n) {
        super(string, bl);
        this.maxLength = n;
    }

    private ProductDataAttributeName(String string, boolean bl, int n, int n2) {
        super(string, bl);
        this.minLength = n2;
        this.maxLength = n;
    }

    public boolean equals(ProductDataAttributeName productDataAttributeName) {
        return super.equals(productDataAttributeName.getValue());
    }

    public static String[] verifyNames(AttributeList attributeList) {
        String[] stringArray = new String[]{Number.getValue(), Revision.getValue(), Name.getValue(), Date.getValue(), Type.getValue(), Information.getValue()};
        return ProductDataAttributeName.verifyNames(attributeList, stringArray);
    }

    public void validate(String string, Locator locator, boolean bl) throws ValidateException {
        if (string == null) {
            if (this.isMandatory) {
                super.errorAttributeMissing(this.getClass(), "validate(String aValue, Locator aLocator, boolean anIsTransform)", "ProductData", super.getValue(), locator);
            }
        } else {
            if (this.minLength != -1 && string.length() < this.minLength) {
                super.errorAttributeValueOutOfRange(this.getClass(), "validate(String aValue, Locator aLocator, boolean anIsTransform)", "ProductData", super.getValue(), string, "Min length: " + this.minLength, locator);
            }
            if (this.maxLength != -1 && string.length() > this.maxLength) {
                super.errorAttributeValueOutOfRange(this.getClass(), "validate(String aValue, Locator aLocator, boolean anIsTransform)", "ProductData", super.getValue(), string, "Max length: " + this.maxLength, locator);
            }
            if (this.getValue().equals(Date.getValue())) {
                ProductDataDateValue.validate(string, locator);
            } else if (this.getValue().equals(Type.getValue())) {
                ProductDataTypeValue.validate(string, locator, bl);
            }
        }
    }
}

