/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeRefInterface;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeFormatException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeRefAttributeName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.repertoire.PiuTypeRefInformationInterface;

public class PiuTypeRef
extends ParsedData
implements DocumentObjectInterface,
PiuTypeRefInterface,
ProductNumberAndRevisionInterface,
PiuTypeRefInformationInterface {
    private String myProductNumber = null;
    private String myRevision = null;
    private String myJavaHeapSize = null;

    public PiuTypeRef(ProductNumberAndRevision productNumberAndRevision) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"PiuTypeRef(ProductNumberAndRevision aProductNumberAndRevision)", (String)("aProductNumberAndRevision: " + productNumberAndRevision));
        }
        this.myProductNumber = StringHandler.optimize(productNumberAndRevision.productNumber);
        this.myRevision = StringHandler.optimize(productNumberAndRevision.revision);
    }

    public PiuTypeRef(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"PiuTypeRef(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = PiuTypeRefAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("PiuTypeRef(AttributeList anAttributeList, Locator aLocator)", PiuTypeLoadListSubElementName.PiuTypeRef.getValue(), stringArray, locator);
        }
        this.myProductNumber = StringHandler.optimize(attributeList.getValue(PiuTypeRefAttributeName.ProductNumber.getValue()));
        this.myRevision = StringHandler.optimize(attributeList.getValue(PiuTypeRefAttributeName.Revision.getValue()));
        this.myJavaHeapSize = attributeList.getValue(PiuTypeRefAttributeName.JavaHeapSize.getValue());
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", PiuTypeLoadListSubElementName.PiuTypeRef.getValue(), string, locator);
    }

    public Integer getJavaHeapSize() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getJavaHeapSize()");
        }
        if (this.myJavaHeapSize != null) {
            return new Integer(this.myJavaHeapSize);
        }
        return null;
    }

    public String getJavaHeapForToString() {
        if (this.myJavaHeapSize != null) {
            return this.getJavaHeapSize().toString();
        }
        return "";
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + PiuTypeLoadListSubElementName.PiuTypeRef.getValue());
        if (this.myProductNumber != null) {
            printStream.println(string + "  " + PiuTypeRefAttributeName.ProductNumber.getValue() + " = \"" + this.getProductNumber() + "\"");
        }
        if (this.myRevision != null) {
            printStream.println(string + "  " + PiuTypeRefAttributeName.Revision.getValue() + " = \"" + this.getRevision() + "\"");
        }
        if (this.myJavaHeapSize != null) {
            printStream.println(string + "  " + PiuTypeRefAttributeName.JavaHeapSize.getValue() + " = \"" + this.getJavaHeapSize() + "\"");
        }
        printStream.println(string + "/>");
    }

    public void setJavaHeapSize(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setJavaHeapSize(Integer aJavaHeapSize)", (String)("aJavaHeapSize: " + n));
        }
        this.myJavaHeapSize = n.toString();
    }

    public void setProductNumber(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProductNumber(String aProductNumber)", (String)("aProductNumber: " + string));
        }
        this.myProductNumber = StringHandler.optimize(string);
    }

    public void setRevision(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRevision(String aRevision)", (String)("aRevision: " + string));
        }
        this.myRevision = StringHandler.optimize(string);
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate()");
        }
        PiuTypeRefAttributeName.ProductNumber.validate(this.getProductNumber(), super.getLocatorData());
        PiuTypeRefAttributeName.Revision.validate(this.getRevision(), super.getLocatorData());
        PiuTypeRefAttributeName.JavaHeapSize.validate(this.myJavaHeapSize, super.getLocatorData());
    }

    public boolean equals(String string, String string2) {
        return this.myProductNumber.equals(string) && this.myRevision.equals(string2);
    }

    public String getProductNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumber( )");
        }
        return this.myProductNumber;
    }

    public String getRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRevision( )");
        }
        return this.myRevision;
    }

    public boolean equals(Object object) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"equals(Object anPiuTypeObject)", (String)(" anPiuTypeObject: " + object + " (datacontainer)productNr: " + this.myProductNumber + " (datacontainer)revision: " + this.myRevision));
        }
        try {
            if (this.equalsSpecificRevision(((PiuTypeRef)object).getProductNumber(), ((PiuTypeRef)object).getRevision())) {
                return true;
            }
            if (this.equalsShortRevision(((PiuTypeRef)object).getProductNumber(), ((PiuTypeRef)object).getRevision())) {
                return true;
            }
            return this.equalsWildcardRevision(((PiuTypeRef)object).getProductNumber(), ((PiuTypeRef)object).getRevision());
        }
        catch (UnexpectedAttributeFormatException unexpectedAttributeFormatException) {
            UpgradeTrace.error(this.getClass(), (String)"equals(PiuTypeRef anPiuTypeObject)", (String)("UnexpectedAttributeFormatException caught when checking for PiuTypeRef\n\tThe PiuTypeRef product number: " + ((PiuTypeRef)object).getProductNumber() + "\n\tThe PiuTypeRef product revision: " + ((PiuTypeRef)object).getRevision()), (Throwable)unexpectedAttributeFormatException);
            return false;
        }
        catch (InvalidProductRevisionFormatException invalidProductRevisionFormatException) {
            UpgradeTrace.error(this.getClass(), (String)"equals(PiuTypeRef anPiuTypeObject)", (String)("InvalidProductRevisionFormatException caught when checking for PiuTypeRef\n\tThe PiuTypeRef product number: " + ((PiuTypeRef)object).getProductNumber() + "\n\tThe PiuTypeRef product revision: " + ((PiuTypeRef)object).getRevision()), (Throwable)invalidProductRevisionFormatException);
            return false;
        }
    }

    public boolean equalsSpecificRevision(String string, String string2) throws UnexpectedAttributeFormatException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"equals(String aProductNumber, String aProductRevision)", (String)(" aProductNumber: " + string + " aProductRevision: " + string2 + " (datacontainer)productNr: " + this.myProductNumber + " (datacontainer)revision: " + this.myRevision));
        }
        return string.equals(this.myProductNumber) && string2.equals(this.myRevision);
    }

    public boolean equalsShortRevision(String string, String string2) throws UnexpectedAttributeFormatException, InvalidProductRevisionFormatException {
        return string.equals(this.myProductNumber) && string2.equals(ProductNumberAndRevision.getShortProductRevision(this.myRevision));
    }

    public boolean equalsWildcardRevision(String string, String string2) throws UnexpectedAttributeFormatException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"equalsWildcardRevision(String aProductNumber, String aProductRevision)", (String)(" aProductNumber: " + string + " aProductRevision: " + string2 + " (datacontainer)productNr: " + this.myProductNumber + " (datacontainer)revision: " + this.myRevision));
        }
        if (string2.equals("*")) {
            return string.equals(this.myProductNumber) || string.equals("*");
        }
        return false;
    }
}

