/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecordException;

public class ProgramInstanceRecord {
    public static final int NO_PROGRAM_INSTANCE = 0;
    private static final int FIRST_FIELD = 0;
    private static final int SECOND_FIELD = 1;
    private static final int THIRD_FIELD = 2;
    private String[] myFieldValues = new String[3];
    private int myOverrideFirstFieldValue = -1;
    private int myOverrideSecondFieldValue = -1;
    private int myOverrideThirdFieldValue = -1;
    Locator myLocator = null;

    public ProgramInstanceRecord(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstanceRecord(String aProgramInstance)", (String)("aProgramInstance: " + string));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        this.myFieldValues[0] = stringTokenizer.nextToken();
        this.myFieldValues[1] = stringTokenizer.nextToken();
        this.myFieldValues[2] = stringTokenizer.nextToken();
    }

    public ProgramInstanceRecord(String string, Locator locator) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ProgramInstanceRecord(String aProgramInstance, Locator aLocator)", (String)("aProgramInstance: " + string));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        this.myFieldValues[0] = stringTokenizer.nextToken();
        this.myFieldValues[1] = stringTokenizer.nextToken();
        this.myFieldValues[2] = stringTokenizer.nextToken();
        this.myLocator = locator;
    }

    public Collection expandRecord() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"expandRecord ()");
        }
        LinkedList linkedList = new LinkedList();
        Collection collection = null;
        if (this.containsInterval(this.myFieldValues[0])) {
            collection = this.expandFirstField(this.getIntervalStartValue(this.myFieldValues[0]), this.getIntervalEndValue(this.myFieldValues[0]));
            linkedList.addAll(collection);
        } else if (this.containsInterval(this.myFieldValues[1])) {
            collection = this.expandSecondField(this.getIntervalStartValue(this.myFieldValues[1]), this.getIntervalEndValue(this.myFieldValues[1]));
            linkedList.addAll(collection);
        } else if (this.containsInterval(this.myFieldValues[2])) {
            collection = this.expandThirdField(this.getIntervalStartValue(this.myFieldValues[2]), this.getIntervalEndValue(this.myFieldValues[2]));
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    public Collection expandFirstField(int n, int n2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"expandFirstField (int aStartValue, int anEndValue)", (String)("aStartValue: " + n + "\n\tanEndValue: " + n2));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection collection = null;
        for (int i = n; i <= n2; ++i) {
            this.myOverrideFirstFieldValue = i;
            if (this.isFieldSpecifiedWithInterval(1)) {
                collection = this.expandSecondField(this.getIntervalStartValue(this.myFieldValues[1]) + 1, this.getIntervalEndValue(this.myFieldValues[1]));
                linkedList.addAll(collection);
            }
            if (this.isFieldSpecifiedWithInterval(2)) {
                collection = this.expandThirdField(this.getIntervalStartValue(this.myFieldValues[2]) + 1, this.getIntervalEndValue(this.myFieldValues[2]));
                linkedList.addAll(collection);
            }
            linkedList.add(i + ":" + this.getFieldValue(1) + ":" + this.getFieldValue(2));
        }
        this.myOverrideFirstFieldValue = -1;
        return linkedList;
    }

    public Collection expandSecondField(int n, int n2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"expandSecondField (int aStartValue, int anEndValue)", (String)("aStartValue: " + n + "\n\tanEndValue: " + n2));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection collection = null;
        for (int i = n; i <= n2; ++i) {
            this.myOverrideSecondFieldValue = i;
            if (this.isFieldSpecifiedWithInterval(2)) {
                collection = this.expandThirdField(this.getIntervalStartValue(this.myFieldValues[2]) + 1, this.getIntervalEndValue(this.myFieldValues[2]));
                linkedList.addAll(collection);
            }
            linkedList.add(this.getFieldValue(0) + ":" + i + ":" + this.getFieldValue(2));
        }
        this.myOverrideSecondFieldValue = -1;
        return linkedList;
    }

    public Collection expandThirdField(int n, int n2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"expandThirdField (int aStartValue, int anEndValue)", (String)("aStartValue: " + n + "\n\tanEndValue: " + n2));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = n; i <= n2; ++i) {
            linkedList.add(this.getFieldValue(0) + ":" + this.getFieldValue(1) + ":" + i);
        }
        return linkedList;
    }

    public int getFieldValue(int n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getFieldValue(int aFieldNo)", (String)("aFieldNo: " + n));
        }
        if (this.containsInterval(this.myFieldValues[n])) {
            if (n == 0 && this.myOverrideFirstFieldValue != -1) {
                return this.myOverrideFirstFieldValue;
            }
            if (n == 1 && this.myOverrideSecondFieldValue != -1) {
                return this.myOverrideSecondFieldValue;
            }
            if (n == 2 && this.myOverrideThirdFieldValue != -1) {
                return this.myOverrideThirdFieldValue;
            }
            return this.getIntervalStartValue(this.myFieldValues[n]);
        }
        return new Integer(this.myFieldValues[n]);
    }

    public String getInstanceAndDistributionIds() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstanceAndDistributionIds ()");
        }
        return this.myFieldValues[0] + ":" + this.myFieldValues[1];
    }

    public Integer getDistribution() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDistribution ()");
        }
        return new Integer(this.myFieldValues[1]);
    }

    public Integer getInstanceID() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstanceID ()");
        }
        return new Integer(this.myFieldValues[0]);
    }

    public Integer getRestartGroup() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRestartGroup ()");
        }
        return new Integer(this.myFieldValues[2]);
    }

    public boolean isRestartGroupEqualToInstanceID() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isRestartGroupEqualToInstanceID ()");
        }
        return this.getInstanceID().intValue() == this.getRestartGroup().intValue();
    }

    public boolean isRestartGroupAndInstanceIdNotZero() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isRestartGroupAndInstanceIdNotZero ()");
        }
        return this.getInstanceID() != 0 && this.getRestartGroup() != 0;
    }

    public int getIntervalStartValue(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIntervalStartValue(String aFieldValue)", (String)("aFieldValue: " + string));
        }
        int n = string.indexOf("..");
        return new Integer(string.substring(0, n));
    }

    public int getIntervalEndValue(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIntervalEndValue(String aFieldValue)", (String)("aFieldValue: " + string));
        }
        int n = string.indexOf("..");
        return new Integer(string.substring(n + "..".length()));
    }

    public boolean isFieldSpecifiedWithInterval(int n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isFieldSpecifiedWithInterval (int aFieldNo)", (String)("aFieldNo: " + n));
        }
        return this.containsInterval(this.myFieldValues[n]);
    }

    public boolean containsInterval(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"containsInterval(String aFieldValue)", (String)("aFieldValue: " + string));
        }
        return string.indexOf("..") != -1;
    }

    public void validate() throws ProgramInstanceRecordException {
        int n = -1;
        int n2 = -1;
        if (this.containsInterval(this.myFieldValues[0])) {
            n = this.getIntervalStartValue(this.myFieldValues[0]);
            n2 = this.getIntervalEndValue(this.myFieldValues[0]);
            if (n2 <= n) {
                throw new ProgramInstanceRecordException("The stop (end) value in the interval must be greater than the start value (first field).\n\tStart value: " + n + "\n\tStop value: " + n2 + "\n\tProgram instance value: " + this.toString());
            }
        }
        if (this.containsInterval(this.myFieldValues[1])) {
            n = this.getIntervalStartValue(this.myFieldValues[1]);
            n2 = this.getIntervalEndValue(this.myFieldValues[1]);
            if (n2 <= n) {
                throw new ProgramInstanceRecordException("The stop (end) value in the interval must be greater than the start value (second field).\n\tStart value: " + n + "\n\tStop value: " + n2 + "\n\tProgram instance value: " + this.toString());
            }
        }
        if (this.containsInterval(this.myFieldValues[2])) {
            throw new ProgramInstanceRecordException("It is not allowed to use intervalls in the restart group field.\n\tProgram instance value: " + this.toString());
        }
    }

    public String toString() {
        return this.myFieldValues[0] + ":" + this.myFieldValues[1] + ":" + this.myFieldValues[2];
    }
}

