/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.parser.dom.AttributeValue;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionConstraints;
import se.ericsson.cello.sudom.parser.dom.UpgradePackageSyntaxVersionValue;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecord;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecordException;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class ProgramInstancesValue
extends AttributeValue {
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DEFAULT_RECORD = "0:0:0";
    public static final String DOTS = "..";
    public static final String ZERO = "0";

    public static Collection convertToListOfSubStrings(String string) {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"convertToListOfSubStrings(String aProgramInstancesValueString)", (String)("aProgramInstancesValueString: " + string));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string == null) {
            return linkedList;
        }
        String string2 = StringHandler.removeWhiteSpaces(string);
        if (string2.length() == 0) {
            linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(""));
            return linkedList;
        }
        int n = string2.indexOf(COMMA);
        int n2 = 0;
        String string3 = null;
        while (n != -1) {
            if (n == n2) {
                linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(""));
            } else {
                string3 = string2.substring(n2, n);
                linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(string3));
            }
            n2 = n + 1;
            if (n2 == string2.length()) {
                linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(""));
                n = -1;
                continue;
            }
            n = string2.indexOf(COMMA, n2);
            if (n != -1) continue;
            string3 = string2.substring(n2);
            linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(string3));
        }
        if (linkedList.isEmpty()) {
            linkedList.add(ProgramInstancesValue.expandBasicFormatSubString(string2));
        }
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)26)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)26, (String)"convertToListOfSubStrings(String aProgramInstancesValueString)", (String)("RETURNS - " + linkedList));
        }
        return linkedList;
    }

    public static int getDistribution(String string) {
        String string2 = string.substring(string.indexOf(COLON) + 1, string.lastIndexOf(COLON));
        return Integer.parseInt(string2);
    }

    public static int getInstanceId(String string) {
        String string2 = string.substring(0, string.indexOf(COLON));
        return Integer.parseInt(string2);
    }

    public static int getRestartGroup(String string) {
        String string2 = string.substring(string.lastIndexOf(COLON) + 1);
        return Integer.parseInt(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void validate(String string, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"validate(String aValue, Locator aLocator)", (String)("aValue: " + string + "\n\taLocator: " + locator));
        }
        if (string == null) return;
        if (string.length() < 0) return;
        char[] cArray = string.toCharArray();
        int n = string.length();
        char c = ' ';
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c2;
            block20: {
                block23: {
                    block22: {
                        block21: {
                            c2 = cArray[i];
                            if (n3 > 0) {
                                if (n3 == 1) {
                                    if (c2 != '.') {
                                        string2 = "When dots are used the value of this attribute is only allowed to have a digit follow by two dots followed by a digit.";
                                        break;
                                    }
                                    ++n3;
                                } else if (n3 == 2) {
                                    if (!Character.isDigit(c2)) {
                                        string2 = "The value of this attribute is only allowed to have a digit follow by two dots followed by a digit.";
                                        break;
                                    }
                                    n3 = 0;
                                }
                            }
                            if (Character.isDigit(c2)) break block20;
                            if (!Character.isWhitespace(c2)) break block21;
                            if (c != ',' || i == n - 1) {
                                string2 = "The value of this attribute is only allowed to contain white space characters if they are preceded by a comma character and not are the last character.";
                                break;
                            }
                            break block20;
                        }
                        if (c2 == ':') {
                            if (n2 < 2) {
                                ++n2;
                                break block20;
                            } else {
                                string2 = "The value of this attribute is only allowed to contain maximum two colon characters within one record.";
                                break;
                            }
                        }
                        if (c2 != 44) break block22;
                        n2 = 0;
                        break block20;
                    }
                    if (c2 != 46) break block23;
                    if (ProgramInstancesValue.isDotsAllowed()) {
                        if (n3 == 0) {
                            if (!Character.isDigit(c)) {
                                string2 = "The value of this attribute is only allowed to contain a digit before the first dot within one record.";
                                break;
                            }
                            ++n3;
                        }
                        break block20;
                    } else {
                        string2 = "Intervall is not allowed to be specified in attribute programInstances for current syntaxVersion.Current syntaxVersion: " + CommonDocumentObjectInformation.getInstance().getSyntaxVersion() + "Required syntaxVersion: " + "PX1";
                        break;
                    }
                }
                string2 = "The value of this attribute is not allowed to contain character '" + c2 + "'.";
            }
            c = c2;
        }
        if (string2 != null) {
            ProgramInstancesValue.errorIllegalAttributeValue(ProgramInstancesValue.class, "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.ProgramInstances.getValue(), string, string2, locator);
            return;
        }
        Collection collection = ProgramInstancesValue.expandAnyIntervallProgramInstances(string, locator);
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"convertToListOfSubStrings(String aProgramInstancesValueString)", (String)("theProgramInstances (expanded, used in SU AutoTest): " + collection));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        ProgramInstanceRecord programInstanceRecord = null;
        String string3 = null;
        while (true) {
            if (!iterator.hasNext()) {
                ProgramInstancesValue.validateNotMixOfNonProgramInstanceAndProgramInstances(string, collection, locator);
                ProgramInstancesValue.validateInstanceIdAndRestartGroupIsIdenticalWhenNotEqualToZero(string, collection, locator);
                return;
            }
            string3 = (String)iterator.next();
            programInstanceRecord = new ProgramInstanceRecord(string3);
            if (hashSet.add(string3 = programInstanceRecord.getInstanceAndDistributionIds())) continue;
            string2 = "The specified program instances must be unique with respect to instance ID and distribution.\n\tThe program instances: " + collection + "\n\tThe duplicate program instance (instanceID and distribution): " + string3;
            ProgramInstancesValue.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue == null ? ProgramInstancesValue.class$("se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue") : class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue, "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.ProgramInstances.getValue(), string, string2, locator);
        }
    }

    private static void validateInstanceIdAndRestartGroupIsIdenticalWhenNotEqualToZero(String string, Collection collection, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"validateInstanceIdAndRestartGroupIsIdenticalWhenNotEqualToZero(String aValue, Collection aProgramInstances, Locator aLocator)", (String)("aProgramInstances: " + collection));
        }
        ProgramInstanceRecord programInstanceRecord = null;
        Iterator iterator = collection.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            programInstanceRecord = new ProgramInstanceRecord(string2);
            if (!programInstanceRecord.isRestartGroupAndInstanceIdNotZero() || programInstanceRecord.isRestartGroupEqualToInstanceID()) continue;
            String string3 = "When the instanceID and restartGroup not are equal to zero (0) they must have the same values.\n\tThe program instances: " + collection + "\n\tThe program instance: " + string2;
            ProgramInstancesValue.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue == null ? ProgramInstancesValue.class$("se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue") : class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue, "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.ProgramInstances.getValue(), string, string3, locator);
        }
    }

    private static void validateNotMixOfNonProgramInstanceAndProgramInstances(String string, Collection collection, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"validateNotMixOfNonProgramInstanceAndProgramInstances(String aValue, Collection aProgramInstances, Locator aLocator)", (String)("aProgramInstances: " + collection));
        }
        Collection collection2 = ProgramInstancesValue.getDistributions(collection, 0);
        Collection collection3 = ProgramInstancesValue.getInstanceIDs(collection, collection2);
        Iterator iterator = collection3.iterator();
        Integer n = null;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n == 0) continue;
            String string2 = "It is not allowed to mix program instances with non program instances.\n\tThe program instances: " + collection + "\n\tThe mixed program instance (instanceID): " + n;
            ProgramInstancesValue.errorIllegalAttributeValue(class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue == null ? ProgramInstancesValue.class$("se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue") : class$se$ericsson$cello$sudom$parser$dom$repertoire$ProgramInstancesValue, "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.ProgramInstances.getValue(), string, string2, locator);
        }
    }

    private static Collection getDistributions(Collection collection, int n) {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"getDistributions (Collection aProgramInstances, int anInstanceID)", (String)("aProgramInstances: " + collection + "\n\tanInstanceID: " + n));
        }
        Iterator iterator = collection.iterator();
        String string = null;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer n2 = null;
        ProgramInstanceRecord programInstanceRecord = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            programInstanceRecord = new ProgramInstanceRecord(string);
            if (programInstanceRecord.getInstanceID() != 0) continue;
            n2 = programInstanceRecord.getDistribution();
            linkedList.add(n2);
        }
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)26)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)26, (String)"getDistributions (Collection aProgramInstances, int anInstanceID)", (String)("RETURNS - " + linkedList));
        }
        return linkedList;
    }

    private static Collection getInstanceIDs(Collection collection, Collection collection2) {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"getInstanceIDs (Collection aProgramInstances, Collection aDistributions)", (String)("aProgramInstances: " + collection + "\n\taDistributions: " + collection2));
        }
        Iterator iterator = collection.iterator();
        String string = null;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer n = null;
        ProgramInstanceRecord programInstanceRecord = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            programInstanceRecord = new ProgramInstanceRecord(string);
            if (!collection2.contains(programInstanceRecord.getDistribution())) continue;
            n = programInstanceRecord.getInstanceID();
            linkedList.add(n);
        }
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)26)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)26, (String)"getDistributions (Collection aProgramInstances, int anInstanceID)", (String)("RETURNS - " + linkedList));
        }
        return linkedList;
    }

    public static Collection getProgramInstancesExpandedFormat(String string) throws ProgramInstanceRecordException {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"expandAnyIntervallProgramInstances (String aValue)", (String)("aValue: " + string));
        }
        try {
            return ProgramInstancesValue.expandAnyIntervallProgramInstances(string, null);
        }
        catch (ValidateException validateException) {
            UpgradeTrace.error((Class)ProgramInstancesValue.class, (String)"getProgramInstancesExpandedFormat (String aValue)", (String)"This can't happen due to the validation has already been performed in an earlier step");
            throw new ProgramInstanceRecordException(validateException.toString());
        }
    }

    private static Collection expandAnyIntervallProgramInstances(String string, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)25)) {
            UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)25, (String)"expandAnyIntervallProgramInstances (String aValue, Locator aLocator)", (String)("aValue: " + string + "\n\taLocator: " + locator));
        }
        Collection collection = ProgramInstancesValue.convertToListOfSubStrings(string);
        try {
            Iterator iterator = collection.iterator();
            String string2 = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            ProgramInstanceRecord programInstanceRecord = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (string2.indexOf(DOTS) != -1) {
                    programInstanceRecord = new ProgramInstanceRecord(string2, locator);
                    programInstanceRecord.validate();
                    linkedList.addAll(programInstanceRecord.expandRecord());
                    continue;
                }
                linkedList.add(string2);
            }
            if (UpgradeTrace.valid((Class)ProgramInstancesValue.class, (int)26)) {
                UpgradeTrace.debug((Class)ProgramInstancesValue.class, (int)26, (String)"expandAnyIntervallProgramInstances (String aValue, Locator aLocator)", (String)("RETURNS - " + linkedList));
            }
            return linkedList;
        }
        catch (ProgramInstanceRecordException programInstanceRecordException) {
            ProgramInstancesValue.errorIllegalAttributeValue(ProgramInstancesValue.class, "validate(String aValue, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.ProgramInstances.getValue(), string, programInstanceRecordException.getMessage(), locator);
            return null;
        }
    }

    private static String expandBasicFormatSubString(String string) {
        String string2 = null;
        if (string.length() == 0) {
            string2 = DEFAULT_RECORD;
        } else {
            int n = string.indexOf(COLON);
            if (n == -1) {
                string2 = string + COLON + ZERO + COLON + ZERO;
            } else {
                int n2 = string.lastIndexOf(COLON);
                if (n2 == n) {
                    string2 = string.length() == 1 ? DEFAULT_RECORD : (n == 0 ? ZERO + string + COLON + ZERO : (n == string.length() - 1 ? string + ZERO + COLON + ZERO : string + COLON + ZERO));
                } else {
                    string2 = string;
                    if (n2 == n + 1) {
                        string2 = string.substring(0, n2) + ZERO + string.substring(n2);
                    }
                    if (n == 0) {
                        string2 = ZERO + string2;
                    }
                    if (n2 == string.length() - 1) {
                        string2 = string2 + ZERO;
                    }
                }
            }
        }
        return string2;
    }

    public static boolean isDotsAllowed() {
        UpgradePackageSyntaxVersionConstraints upgradePackageSyntaxVersionConstraints = new UpgradePackageSyntaxVersionConstraints("PX1");
        return UpgradePackageSyntaxVersionValue.isAllowed(CommonDocumentObjectInformation.getInstance().getSyntaxVersion(), upgradePackageSyntaxVersionConstraints);
    }
}

