/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.subrackprodtype;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.BoardPositions;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.BoardPositionsAttributeName;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeDataAttributeName;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeDataSubElementName;
import se.ericsson.cello.sudom.parser.dom.subrackprodtype.SubrackProdTypeSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class SubrackProdTypeData
extends ParsedData
implements DocumentObjectInterface {
    private BoardPositions myBoardPositions = null;
    private String myFanConfiguration = null;
    private String myTransmissionType = null;
    private String myMaxPowerDissipation = null;
    private String myDefNumberOfSlots = null;

    public SubrackProdTypeData(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"PiuTypeData(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = SubrackProdTypeDataAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("SubrackProdTypeData(AttributeList anAttributeList, Locator aLocator)", SubrackProdTypeSubElementName.SubrackProdTypeData.getValue(), stringArray, locator);
        }
        this.myFanConfiguration = attributeList.getValue(SubrackProdTypeDataAttributeName.FanConfiguration.getValue());
        this.myTransmissionType = attributeList.getValue(SubrackProdTypeDataAttributeName.TransmissionType.getValue());
        this.myMaxPowerDissipation = attributeList.getValue(SubrackProdTypeDataAttributeName.MaxPowerDissipation.getValue());
        this.myDefNumberOfSlots = attributeList.getValue(SubrackProdTypeDataAttributeName.DefNumberOfSlots.getValue());
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (string.equals(SubrackProdTypeDataSubElementName.BoardPositions.getValue())) {
            return this.createBoardPositions(attributeList, locator);
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", SubrackProdTypeSubElementName.SubrackProdTypeData.getValue(), string, locator);
    }

    private BoardPositions createBoardPositions(AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createBoardPositions(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myBoardPositions == null) {
            this.myBoardPositions = new BoardPositions(attributeList, locator);
            return this.myBoardPositions;
        }
        return (BoardPositions)super.errorMoreElementsThanExpected("createBoardPositions(AttributeList anAttributeList, Locator aLocator)", SubrackProdTypeSubElementName.SubrackProdTypeData.getValue(), SubrackProdTypeDataSubElementName.BoardPositions.getValue(), locator);
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + SubrackProdTypeSubElementName.SubrackProdTypeData.getValue());
        if (this.myDefNumberOfSlots != null) {
            printStream.println(string + "  " + SubrackProdTypeDataAttributeName.DefNumberOfSlots.getValue() + " = \"" + this.myDefNumberOfSlots + "\"");
        }
        if (this.myFanConfiguration != null) {
            printStream.println(string + "  " + SubrackProdTypeDataAttributeName.FanConfiguration.getValue() + " = \"" + this.myFanConfiguration + "\"");
        }
        if (this.myTransmissionType != null) {
            printStream.println(string + "  " + SubrackProdTypeDataAttributeName.TransmissionType.getValue() + " = \"" + this.myTransmissionType + "\"");
        }
        if (this.myMaxPowerDissipation != null) {
            printStream.println(string + "  " + SubrackProdTypeDataAttributeName.MaxPowerDissipation.getValue() + " = \"" + this.myMaxPowerDissipation + "\"");
        }
        printStream.println(string + "  " + ">");
        if (this.myBoardPositions != null) {
            this.myBoardPositions.print(printStream, string + "  ");
        }
        printStream.println(string + "</" + SubrackProdTypeSubElementName.SubrackProdTypeData.getValue() + ">");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        SubrackProdTypeDataSubElementName.BoardPositions.validate(this.myBoardPositions, super.getLocatorData());
        SubrackProdTypeDataAttributeName.FanConfiguration.validate(this.myFanConfiguration, super.getLocatorData(), false);
        SubrackProdTypeDataAttributeName.TransmissionType.validate(this.myTransmissionType, super.getLocatorData(), false);
        SubrackProdTypeDataAttributeName.MaxPowerDissipation.validate(this.myMaxPowerDissipation, super.getLocatorData(), false);
        SubrackProdTypeDataAttributeName.DefNumberOfSlots.validate(this.myDefNumberOfSlots, super.getLocatorData(), false);
        if (this.myBoardPositions != null) {
            this.myBoardPositions.validate();
        }
        this.checkBoardPositionsValues(BoardPositionsAttributeName.CmxbPositionA, this.myBoardPositions.getCmxbPositionA());
        this.checkBoardPositionsValues(BoardPositionsAttributeName.CmxbPositionB, this.myBoardPositions.getCmxbPositionB());
        this.checkBoardPositionsValues(BoardPositionsAttributeName.ScuPositionA, this.myBoardPositions.getScuPositionA());
        this.checkBoardPositionsValues(BoardPositionsAttributeName.ScuPositionB, this.myBoardPositions.getScuPositionB());
        this.checkBoardPositionsValues(BoardPositionsAttributeName.TuPositionA, this.myBoardPositions.getTuPositionA());
        this.checkBoardPositionsValues(BoardPositionsAttributeName.TuPositionB, this.myBoardPositions.getTuPositionB());
    }

    private void checkBoardPositionsValues(BoardPositionsAttributeName boardPositionsAttributeName, Integer n) throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"checkBoardPositionsValues(BoardPositionsAttributeName aBoardPositionsAttributeName, Integer aBoardPosition)", (String)("aBoardPositionsAttributeName: " + boardPositionsAttributeName + "\n\taBoardPosition: " + n));
        }
        if (n > this.getDefNumberOfSlots()) {
            super.errorIllegalAttributeValue(this.getClass(), "checkBoardPositionsValues(BoardPositionsAttributeName aBoardPositionsAttributeName, Integer aBoardPosition)", SubrackProdTypeSubElementName.SubrackProdTypeData.getValue(), SubrackProdTypeDataSubElementName.BoardPositions.getValue(), boardPositionsAttributeName.getValue(), n.toString(), " Attribute cannot be larger than defNumberOfSlots.", super.getLocatorData());
        }
    }

    public String getFanConfiguration() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getFanConfiguration( )");
        }
        return this.myFanConfiguration;
    }

    public void setFanConfiguration(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setFanConfiguration(String aFanConfiguration)", (String)("aFanConfiguration: " + string));
        }
        this.myFanConfiguration = string;
    }

    public String getTransmissionType() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTransmissionType( )");
        }
        return this.myTransmissionType;
    }

    public void setTransmissionType(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setTransmissionType(Integer aTransmissionType)", (String)("aTransmissionType: " + string));
        }
        this.myTransmissionType = string.toString();
    }

    public String getMaxPowerDissipation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMaxPowerDissipation( )");
        }
        return this.myMaxPowerDissipation;
    }

    public void setMaxPowerDissipation(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setMaxPowerDissipation(Integer aMaxPowerDissipation)", (String)("aMaxPowerDissipation: " + n));
        }
        this.myMaxPowerDissipation = n.toString();
    }

    public Integer getDefNumberOfSlots() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDefNumberOfSlots( )");
        }
        if (this.myDefNumberOfSlots != null) {
            return new Integer(this.myDefNumberOfSlots);
        }
        return null;
    }

    public void setDefNumberOfSlots(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDefNumberOfSlots(Integer aDefNumberOfSlots)", (String)("aDefNumberOfSlots: " + n));
        }
        this.myDefNumberOfSlots = n.toString();
    }

    public BoardPositions getBoardPositions() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getBoardPositions( )");
        }
        return this.myBoardPositions;
    }

    public void setBoardPositions(BoardPositions boardPositions) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setBoardPositions(BoardPositions aBoardPositions)", (String)("aBoardPositions: " + boardPositions));
        }
        this.myBoardPositions = boardPositions;
    }
}

