/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.repertoire;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramBaseInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInterface;
import se.ericsson.cello.sudom.verify.LoaderInformation;

public class LoadModuleRefInformation
implements LoadModuleProgramBaseInterface {
    public static final int DEFAULT_HEAP_VALUE = 0;
    public static final int DEFAULT_POOL_VALUE = 0;
    public static final int DEFAULT_RESTART_COUNTER_LIMIT_VALUE = -1;
    public static final int DEFAULT_RESTART_TIMER_VALUE = -1;
    public static final int TRANSLATED_DEFAULT_VALUE_RESTART_COUNTER_LIMIT = 3;
    public static final int TRANSLATED_DEFAULT_VALUE_RESTART_TIMER = 60;
    public static final String EMPTY_STRING = "";
    private Integer myTag = null;
    private String myProductNumber = null;
    private String myRevision = null;
    private Integer myProgramMemoryPoolSize = null;
    private Integer myProgramMemoryHeapSize = null;
    private String myProgramInstances = null;
    private String myLoaderName = null;
    private String myDeviceLoaderName = null;
    private String myDeviceLoaderInformation = null;
    private Integer myRestartCounterLimit = null;
    private Integer myRestartTimer = null;
    private boolean myIsLoadModulesBothNonProgramInstanceAndProgramInstance = false;
    private boolean myExistLmRefWithoutHeapSize = true;
    private boolean myExistHeapSizeDefault = false;
    private Integer myMinHeapSize = null;
    private boolean myExistLmRefWithoutPoolSize = true;
    private boolean myExistPoolSizeDefault = false;
    private Integer myMinPoolSize = null;
    private boolean myExistLmRefWithoutRestartCounterLimit = true;
    private boolean myExistRestartCounterLimitDefault = false;
    private Integer myMaxRestartCounterLimit = null;
    private boolean myExistLmRefWithoutRestartTimer = true;
    private boolean myExistRestartTimerDefault = false;
    private Integer myMaxRestartTimer = null;
    Collection myMandatoryLoaderInformationInconsistencies = new LinkedList();
    Collection myDeviceLoaderInformationsInconsistencies = new LinkedList();
    private boolean myExistLmRefWithoutLoaderName = true;

    public LoadModuleRefInformation(Integer n, String string, String string2, Integer n2, Integer n3, String string3, String string4, String string5, String string6, Integer n4, Integer n5) {
        this.myTag = n;
        this.myProductNumber = string;
        this.myRevision = string2;
        this.myProgramMemoryPoolSize = n2;
        if (this.myProgramMemoryPoolSize != null) {
            this.myExistLmRefWithoutPoolSize = false;
            this.myMinPoolSize = this.myProgramMemoryPoolSize;
            if (this.myProgramMemoryPoolSize == 0) {
                this.myExistPoolSizeDefault = true;
            }
        }
        this.myProgramMemoryHeapSize = n3;
        if (this.myProgramMemoryHeapSize != null) {
            this.myExistLmRefWithoutHeapSize = false;
            this.myMinHeapSize = this.myProgramMemoryHeapSize;
            if (this.myProgramMemoryHeapSize == 0) {
                this.myExistHeapSizeDefault = true;
            }
        }
        this.myProgramInstances = string3 == null ? EMPTY_STRING : string3;
        if (string4 != null) {
            this.myExistLmRefWithoutLoaderName = false;
            this.myLoaderName = string4;
        } else {
            this.myLoaderName = EMPTY_STRING;
        }
        this.myDeviceLoaderName = string5 == null ? EMPTY_STRING : string5;
        this.myDeviceLoaderInformation = string6 == null ? EMPTY_STRING : string6;
        this.myRestartCounterLimit = n4;
        if (this.myRestartCounterLimit != null) {
            this.myExistLmRefWithoutRestartCounterLimit = false;
            this.myMaxRestartCounterLimit = this.myRestartCounterLimit;
            if (this.myRestartCounterLimit == -1) {
                this.myExistRestartCounterLimitDefault = true;
                this.myRestartCounterLimit = new Integer(3);
            }
        }
        this.myRestartTimer = n5;
        if (this.myRestartTimer != null) {
            this.myExistLmRefWithoutRestartTimer = false;
            this.myMaxRestartTimer = this.myRestartTimer;
            if (this.myRestartTimer == -1) {
                this.myExistRestartTimerDefault = true;
                this.myRestartTimer = new Integer(60);
            }
        }
    }

    public boolean isLoadModulesBothNonProgramInstanceAndProgramInstance() {
        return this.myIsLoadModulesBothNonProgramInstanceAndProgramInstance;
    }

    public void isLoadModulesBothNonProgramInstanceAndProgramInstance(boolean bl) {
        this.myIsLoadModulesBothNonProgramInstanceAndProgramInstance = bl;
    }

    public Integer getTag() {
        return this.myTag;
    }

    public void setTag(Integer n) {
        this.myTag = n;
    }

    public String getProductNumberAndRevision() {
        return this.myProductNumber + "_" + this.myRevision;
    }

    public String getProductNumber() {
        return this.myProductNumber;
    }

    public void setProductNumber(String string) {
        this.myProductNumber = string;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public void setRevision(String string) {
        this.myRevision = string;
    }

    public Integer getProgramMemoryPoolSize() {
        return this.myProgramMemoryPoolSize;
    }

    public String getProgramMemoryPoolSizeForToString() {
        if (this.myProgramMemoryPoolSize == null) {
            return EMPTY_STRING;
        }
        return this.myProgramMemoryPoolSize.toString();
    }

    public Integer getRestartCounterLimit() {
        return this.myRestartCounterLimit;
    }

    public String getRestartCounterLimitForToString() {
        if (this.myRestartCounterLimit == null) {
            return EMPTY_STRING;
        }
        return this.myRestartCounterLimit.toString();
    }

    public Integer getRestartTimer() {
        return this.myRestartTimer;
    }

    public String getRestartTimerForToString() {
        if (this.myRestartTimer == null) {
            return EMPTY_STRING;
        }
        return this.myRestartTimer.toString();
    }

    public void setProgramMemoryPoolSize(Integer n) {
        this.myProgramMemoryPoolSize = n;
    }

    public Integer getProgramMemoryHeapSize() {
        return this.myProgramMemoryHeapSize;
    }

    public String getProgramMemoryHeapSizeForToString() {
        if (this.myProgramMemoryHeapSize == null) {
            return EMPTY_STRING;
        }
        return this.myProgramMemoryHeapSize.toString();
    }

    public void setProgramMemoryHeapSize(Integer n) {
        this.myProgramMemoryHeapSize = n;
    }

    public String getProgramInstances() {
        return this.myProgramInstances;
    }

    public String getProgramInstancesForToString() {
        if (this.myProgramInstances == null) {
            return EMPTY_STRING;
        }
        return this.myProgramInstances;
    }

    public void setProgramInstances(String string) {
        this.myProgramInstances = string;
    }

    public void addMandatoryLoaderInformationInconsistency(LoaderInformation loaderInformation) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addMandatoryLoaderInformationInconsistency(LoaderInformation aLoaderInformation)", (String)("aLoaderInformation: " + loaderInformation));
        }
        if (loaderInformation.getLoaderName().equals(EMPTY_STRING)) {
            this.myExistLmRefWithoutLoaderName = true;
        }
        this.myMandatoryLoaderInformationInconsistencies.add(loaderInformation);
    }

    public void addDeviceLoaderInformationInconsistency(LoaderInformation loaderInformation) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addDeviceLoaderInformationInconsistency(LoaderInformation aLoaderInformation)", (String)("aLoaderInformation: " + loaderInformation));
        }
        this.myDeviceLoaderInformationsInconsistencies.add(loaderInformation);
    }

    public String getLoaderName() {
        return this.myLoaderName;
    }

    public String getLoaderNameSum() {
        return this.getLoaderName();
    }

    public String getLoaderNameForToString() {
        if (this.myLoaderName == null) {
            return EMPTY_STRING;
        }
        return this.myLoaderName;
    }

    public String getDeviceLoaderName() {
        return this.myDeviceLoaderName;
    }

    public String getDeviceLoaderNameSum() {
        return this.getDeviceLoaderName();
    }

    public String getDeviceLoaderNameForToString() {
        if (this.myDeviceLoaderName == null) {
            return EMPTY_STRING;
        }
        return this.myDeviceLoaderName;
    }

    public void setDeviceLoaderName(String string) {
        this.myDeviceLoaderName = string;
    }

    public String getDeviceLoaderInformation() {
        return this.myDeviceLoaderInformation;
    }

    public String getDeviceLoaderInformationSum() {
        return this.getDeviceLoaderInformation();
    }

    public String getDeviceLoaderInformationForToString() {
        if (this.myDeviceLoaderInformation == null) {
            return EMPTY_STRING;
        }
        return this.myDeviceLoaderInformation;
    }

    public void setDeviceLoaderInformation(String string) {
        this.myDeviceLoaderInformation = string;
    }

    public boolean isExistLmRefWithoutHeapSize() {
        return this.myExistLmRefWithoutHeapSize;
    }

    public void setExistLmRefWithoutHeapSize(boolean bl) {
        this.myExistLmRefWithoutHeapSize = bl;
    }

    public Integer getMinHeapSize() {
        return this.myMinHeapSize;
    }

    public void setMinHeapSize(Integer n) {
        this.myMinHeapSize = n;
    }

    public void setRestartCounterLimit(Integer n) {
        this.myRestartCounterLimit = n;
    }

    public void setRestartTimer(Integer n) {
        this.myRestartTimer = n;
    }

    public boolean isExistLmRefWithoutPoolSize() {
        return this.myExistLmRefWithoutPoolSize;
    }

    public boolean isExistLmRefWithoutRestartCounterLimit() {
        return this.myExistLmRefWithoutRestartCounterLimit;
    }

    public boolean isExistLmRefWithoutRestartTimer() {
        return this.myExistLmRefWithoutRestartTimer;
    }

    public void setExistLmRefWithoutPoolSize(boolean bl) {
        this.myExistLmRefWithoutPoolSize = bl;
    }

    public void setExistLmRefWithoutRestartCounterLimit(boolean bl) {
        this.myExistLmRefWithoutRestartCounterLimit = bl;
    }

    public void setExistLmRefWithoutRestartTimer(boolean bl) {
        this.myExistLmRefWithoutRestartTimer = bl;
    }

    public Integer getMinPoolSize() {
        return this.myMinPoolSize;
    }

    public Integer getMaxRestartCounterLimit() {
        return this.myMaxRestartCounterLimit;
    }

    public Integer getMaxRestartTimer() {
        return this.myMaxRestartTimer;
    }

    public void setMinPoolSize(Integer n) {
        this.myMinPoolSize = n;
    }

    public void setMaxRestartCounterLimit(Integer n) {
        this.myMaxRestartCounterLimit = n;
    }

    public void setMaxRestartTimer(Integer n) {
        this.myMaxRestartTimer = n;
    }

    public boolean existHeapSizeDefault() {
        return this.myExistHeapSizeDefault;
    }

    public void existHeapSizeDefault(boolean bl) {
        this.myExistHeapSizeDefault = bl;
    }

    public boolean existPoolSizeDefault() {
        return this.myExistPoolSizeDefault;
    }

    public boolean existRestartCounterLimitDefault() {
        return this.myExistRestartCounterLimitDefault;
    }

    public boolean existRestartTimerDefault() {
        return this.myExistRestartTimerDefault;
    }

    public void existPoolSizeDefault(boolean bl) {
        this.myExistPoolSizeDefault = bl;
    }

    public void existRestartCounterLimitDefault(boolean bl) {
        this.myExistRestartCounterLimitDefault = bl;
    }

    public void existRestartTimerDefault(boolean bl) {
        this.myExistRestartTimerDefault = bl;
    }

    public boolean isMandatoryLoaderDataEqual() {
        return this.myMandatoryLoaderInformationInconsistencies.isEmpty();
    }

    public boolean isDeviceLoaderInformationEqual() {
        return this.myDeviceLoaderInformationsInconsistencies.isEmpty();
    }

    public Collection getMandatoryLoaderInformationsDiff() {
        return this.myMandatoryLoaderInformationInconsistencies;
    }

    public Collection getDeviceLoaderInformationsDiff() {
        return this.myDeviceLoaderInformationsInconsistencies;
    }

    public boolean isExistLmRefWithoutLoaderName() {
        return this.myExistLmRefWithoutLoaderName;
    }

    public void setExistLmRefWithoutLoaderName(boolean bl) {
        this.myExistLmRefWithoutLoaderName = bl;
    }

    public String toString() {
        return "\n\t\tLMRI - start\n\t\tProductNumber: " + this.myProductNumber + "\n\t\tRevision: " + this.myRevision + "\n\t\tTag: " + this.myTag + "\n\t\tProgramMemoryPoolSize: " + this.getProgramMemoryPoolSizeForToString() + "\n\t\tProgramMemoryHeapSize: " + this.getProgramMemoryHeapSizeForToString() + "\n\t\tProgramInstances: " + this.getProgramInstancesForToString() + "\n\t\tLoaderName: " + this.getLoaderNameForToString() + "\n\t\tDeviceLoaderName: " + this.getDeviceLoaderNameForToString() + "\n\t\tDeviceLoaderInformation: " + this.getDeviceLoaderInformationForToString() + "\n\t\tMinHeapSize: " + this.myMinHeapSize + "\n\t\tMinPoolSize: " + this.myMinPoolSize + "\n\t\tExistLmRefWithoutPoolSize: " + this.myExistLmRefWithoutPoolSize + "\n\t\tExistLmRefWithoutHeapSize: " + this.myExistLmRefWithoutHeapSize + "\n\t\tmyExistHeapSizeDefault: " + this.myExistHeapSizeDefault + "\n\t\tmyExistPoolSizeDefault: " + this.myExistPoolSizeDefault + "\n\tmyDeviceLoaderInformationsInconsistencies: " + this.myDeviceLoaderInformationsInconsistencies + "\n\tmyMandatoryLoaderInformationInconsistencies: " + this.myMandatoryLoaderInformationInconsistencies + "\n\tRestartCounterLimit: " + this.getRestartCounterLimitForToString() + "\n\tRestartTimer: " + this.getRestartTimerForToString() + "\n\tmyMaxRestartCounterLimit: " + this.myMaxRestartCounterLimit + "\n\tmyMaxRestartTimer: " + this.myMaxRestartTimer + "\n\tmyExistRestartCounterLimitDefault: " + this.myExistRestartCounterLimitDefault + "\n\tmyExistLmRefWithoutRestartCounterLimit: " + this.myExistLmRefWithoutRestartCounterLimit + "\n\tmyExistLmRefWithoutRestartTimer: " + this.myExistLmRefWithoutRestartTimer + "\n\t\tLMRI - stop";
    }

    public boolean equals(Object object) {
        return ((LoadModuleProgramInterface)object).getProductNumber().equals(this.myProductNumber) && ((LoadModuleProgramInterface)object).getRevision().equals(this.myRevision);
    }
}

