/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.repertoire;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstanceException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInstances;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisionsOpt;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecordException;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleRefInformation;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleRefsWithLoaderNamesInformation;
import se.ericsson.cello.sudom.proxy.repertoire.OptimizedPiuTypeLoadListsProxy;
import se.ericsson.cello.sudom.proxy.repertoire.OptimizedPiuTypeLoadListsProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.PiuTypeLoadListsProxy;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoireProxy;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoireProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyException;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleHeapAndPoolSizeContainer;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleReplacementContainer;
import se.ericsson.cello.sudom.util.datacontainer.PiuTypeLoadListsAdditionContainer;
import se.ericsson.cello.sudom.util.datacontainer.PiuTypeLoadListsContentsAdditionContainer;
import se.ericsson.cello.sudom.util.datacontainer.PiuTypeReplacementContainer;
import se.ericsson.cello.sudom.verify.LoadModuleRefInformationData;
import se.ericsson.cello.sudom.verify.TagAndLoadModuleRefInformation;

public class RepertoiresProxy
implements RepertoiresProxyInterface {
    private static final ProductNumbersAndRevisions Object = null;
    protected Vector myRepertoires = new Vector(1);
    protected OptimizedPiuTypeLoadListsProxyInterface myOptimizedPiuTypeLoadListsProxyInterface = new OptimizedPiuTypeLoadListsProxy();
    protected HashMap myRepertoiresMap = new HashMap();
    protected HashMap myDuplicatRepertoiresMap = new HashMap();

    public RepertoiresProxy(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"RepertoiresProxy(Vector aRepertoires)", (String)("aRepertoires: " + vector));
        }
        this.myRepertoires = vector;
        this.buildSetOfRepertoireNames();
    }

    public void addOrReplaceRepertoires(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addOrReplaceRepertoires(Vector aRepertoires)", (String)("aRepertoires: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            RepertoireProxy repertoireProxy = (RepertoireProxy)iterator.next();
            this.myRepertoiresMap.put(repertoireProxy.getRepertoire().getName(), repertoireProxy);
        }
        this.getRepertoireByRepertoireValue();
    }

    public void addPiuTypeLoadLists(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addPiuTypeLoadLists(Vector aPiuTypeLoadListsAdditionContainers)", (String)("aPiuTypeLoadListsAdditionContainers: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            PiuTypeLoadListsAdditionContainer piuTypeLoadListsAdditionContainer = (PiuTypeLoadListsAdditionContainer)iterator.next();
            Collection collection = null;
            String string = piuTypeLoadListsAdditionContainer.getRepertoireName();
            boolean bl = true;
            if (string.equals("")) {
                collection = this.myRepertoiresMap.values();
            } else if (this.myRepertoiresMap.get(string) != null) {
                collection = new LinkedList();
                collection.add(this.myRepertoiresMap.get(string));
            } else {
                bl = false;
            }
            if (!bl) continue;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.myOptimizedPiuTypeLoadListsProxyInterface.addPiuTypeLoadLists(piuTypeLoadListsAdditionContainer.getKeyPiuTypeRef(), piuTypeLoadListsAdditionContainer.getPiuTypeLoadLists(), ((RepertoireProxy)iterator2.next()).getRepertoire().getPiuTypeLoadLists());
            }
        }
    }

    public Collection getPiuTypeRefInformations(Collection collection, String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Collection aRepertoireNames, String aProductNumber, String aRevision", (String)("aRepertoireNames: " + collection + "\n\taProductNumber: " + string + "\n\taRevision: " + string2));
        }
        Iterator iterator = collection.iterator();
        String string3 = null;
        RepertoireProxyInterface repertoireProxyInterface = null;
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            repertoireProxyInterface = this.getRepertoireProxyInterface(string3);
            linkedList.addAll(repertoireProxyInterface.getPiuTypeRefInformations(string, string2));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Collection aRepertoireNames, String aProductNumber, String aRevision", (String)("RETURNS - thePiuTypeRefInformations: " + linkedList));
        }
        return linkedList;
    }

    public Collection getLoadModuleRefInformations(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefInformations(String aRepertoireName)", (String)("aRepertoireName: " + string));
        }
        RepertoireProxyInterface repertoireProxyInterface = null;
        repertoireProxyInterface = this.getRepertoireProxyInterface(string);
        return repertoireProxyInterface.getAllLoadModuleRefInformations();
    }

    public void addReferencesInPiuTypeLoadLists(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addReferencesInPiuTypeLoadLists(Vector aPiuTypeLoadListsContentsAdditionContainers)", (String)("aPiuTypeLoadListsContentsAdditionContainers: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            PiuTypeLoadListsContentsAdditionContainer piuTypeLoadListsContentsAdditionContainer = (PiuTypeLoadListsContentsAdditionContainer)iterator.next();
            Collection collection = null;
            String string = piuTypeLoadListsContentsAdditionContainer.getRepertoireName();
            boolean bl = true;
            if (string.equals("")) {
                collection = this.myRepertoiresMap.values();
            } else if (this.myRepertoiresMap.get(string) != null) {
                collection = new Vector(1);
                collection.add(this.myRepertoiresMap.get(string));
            } else {
                bl = false;
            }
            if (!bl) continue;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                this.myOptimizedPiuTypeLoadListsProxyInterface.addReferencesInPiuTypeLoadLists(piuTypeLoadListsContentsAdditionContainer.getKeyPiuTypeRef(), piuTypeLoadListsContentsAdditionContainer.getPiuTypeRefs(), piuTypeLoadListsContentsAdditionContainer.getLoadModuleRefs(), ((RepertoireProxy)iterator2.next()).getRepertoire().getPiuTypeLoadLists());
            }
        }
    }

    public Collection extractRepertoiresReferencingNotExpectedLMs(Collection collection, ProductNumbersAndRevisions productNumbersAndRevisions) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"extractRepertoiresReferencingNotExpectedLMs(Collection aRepertoireNames, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfExpectedLMs)", (String)("aRepertoireNames: " + collection + "\n\taProductNumbersAndRevisionsOfExpectedLMs: " + productNumbersAndRevisions));
        }
        Iterator iterator = collection.iterator();
        String string = null;
        Repertoire repertoire = null;
        PiuTypeLoadListsProxy piuTypeLoadListsProxy = new PiuTypeLoadListsProxy();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            repertoire = this.getRepertoire(string);
            if (!piuTypeLoadListsProxy.containsNotExpectedLoadModuleRef(productNumbersAndRevisions, repertoire.getPiuTypeLoadLists())) continue;
            hashSet.add(string);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"extractRepertoiresReferencingNotExpectedLMs(Collection aRepertoireNames, ProductNumbersAndRevisions aProductNumbersAndRevisionsOfExpectedLMs)", (String)("RETURNS - " + hashSet));
        }
        return hashSet;
    }

    public LoadModuleHeapAndPoolSizeContainer getHeapAndPoolSizeForLoadModule(String string, ProductNumberAndRevision productNumberAndRevision, ProductNumberAndRevision productNumberAndRevision2, int n) {
        RepertoireProxy repertoireProxy;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getHeapAndPoolSizeForLoadModule(String aRepertoireName, ProductNumberAndRevision aPiuTypeProductNumberAndRevision, ProductNumberAndRevision aLoadModuleProductNumberAndRevision, int aTag)", (String)("aRepertoireName: " + string + "\n\taPiuTypeProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProductNumberAndRevision: " + productNumberAndRevision2 + "\n\taTag: " + n));
        }
        if ((repertoireProxy = (RepertoireProxy)this.myRepertoiresMap.get(string)) != null) {
            return this.myOptimizedPiuTypeLoadListsProxyInterface.getHeapAndPoolSizeForLoadModule(repertoireProxy.getRepertoire().getPiuTypeLoadLists(), productNumberAndRevision, productNumberAndRevision2, n);
        }
        UpgradeTrace.error(this.getClass(), (String)"getHeapAndPoolSizeForLoadModule(String aRepertoireName, ProductNumberAndRevision aPiuTypeProductNumberAndRevision, ProductNumberAndRevision aLoadModuleProductNumberAndRevision, int aTag)", (String)("No Repertoire with requested name found,\n\trequested name: " + string));
        return null;
    }

    public Collection getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        Iterator iterator = collection.iterator();
        String string = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        Collection collection2 = new HashSet();
        PiuTypeLoadListsProxy piuTypeLoadListsProxy = new PiuTypeLoadListsProxy();
        while (iterator.hasNext()) {
            Repertoire repertoire;
            string = (String)iterator.next();
            if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection aRepertoireNames)", (String)("theRepertoireName: " + string));
            }
            if ((repertoire = this.getRepertoire(string)) != null) {
                collection2 = piuTypeLoadListsProxy.getProductNumberAndRevisionsForLoadModulesInRepertoire(repertoire.getPiuTypeLoadLists());
                if (UpgradeTrace.valid(this.getClass(), (int)25)) {
                    UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection aRepertoireNames)", (String)("theProdNoAndRevsForLoadModulesInRepertoire: " + collection2));
                }
                Iterator iterator2 = collection2.iterator();
                ProductNumberAndRevision productNumberAndRevision = null;
                while (iterator2.hasNext()) {
                    productNumberAndRevision = (ProductNumberAndRevision)iterator2.next();
                    if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                    productNumbersAndRevisions.addElement(productNumberAndRevision);
                }
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection aRepertoireNames)", (String)("A given repertoire name does not exist in the UCF (ignored).\n\ttheRepertoireName: " + string));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(Collection aRepertoireNames)", (String)("RETURNS - " + productNumbersAndRevisions));
        }
        return productNumbersAndRevisions.getElements();
    }

    public Repertoire getRepertoire(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoire (String aName)", (String)("aName: " + string));
        }
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        Repertoire repertoire = null;
        while (iterator.hasNext()) {
            repertoire = ((RepertoireProxy)iterator.next()).getRepertoire();
            if (!repertoire.getName().equals(string)) continue;
            return repertoire;
        }
        return null;
    }

    public Vector getRepertoireByRepertoireValue() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoire (String aName)");
        }
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        Repertoire repertoire = null;
        this.myRepertoires.clear();
        while (iterator.hasNext()) {
            repertoire = ((RepertoireProxy)iterator.next()).getRepertoire();
            this.myRepertoires.add(repertoire);
        }
        return this.myRepertoires;
    }

    public Collection getLoadModulesConnectedToPiuTypes(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesConnectedToPiuTypes(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("aProductNumbersAndRevisionsOfPiuTypes: " + collection));
        }
        return this.getLoadModulesConnectedToPiuTypes(collection, this.myRepertoiresMap.values());
    }

    public Collection getLoadModulesConnectedToPiuType(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesConnectedToPiuType(String aProductNumber, String aProductRevision)", (String)("aProductNumber: " + string + "\n\taProductRevision: " + string2));
        }
        LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
        linkedList.add(new ProductNumberAndRevision(string, string2));
        return this.getLoadModulesConnectedToPiuTypes(linkedList, this.myRepertoiresMap.values());
    }

    public Collection getLoadModulesConnectedToPiuType(String string, String string2, Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesConnectedToPiuType(String aProductNumber, String aProductRevision, Collection aRepertoireNames)", (String)("aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taRepertoireNames: " + collection));
        }
        LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
        linkedList.add(new ProductNumberAndRevision(string, string2));
        Collection collection2 = this.getRepertoires(new Vector(collection), this.myRepertoiresMap.values());
        return this.getLoadModulesConnectedToPiuTypes(linkedList, collection2);
    }

    private Collection getLoadModulesConnectedToPiuTypes(Collection collection, Collection collection2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesConnectedToPiuTypes(Collection aProductNumbersAndRevisionsOfPiuTypes, Collection aRepertoires)", (String)("aProductNumbersAndRevisionsOfPiuTypes: " + collection + "\n\taRepertoires: " + collection2));
        }
        HashMap hashMap = this.convertProductNumbersAndRevisionsToHashMap(collection);
        HashMap hashMap2 = new HashMap();
        Iterator iterator = collection2.iterator();
        Repertoire repertoire = null;
        Collection collection3 = null;
        while (iterator.hasNext()) {
            repertoire = ((RepertoireProxy)iterator.next()).getRepertoire();
            collection3 = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModulesConnectedToPiuTypes(hashMap, repertoire.getPiuTypeLoadLists());
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"getLoadModulesConnectedToPiuTypes(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("Repertoire name: " + repertoire.getName() + "\n\ttheConnectedLoadModulesForOneRepertoire: " + collection3));
            }
            hashMap2 = this.addConnectedLoadModulesForOneRepertoire(collection3, hashMap2);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = this.convertHashMapToProductNumbersAndRevisions(hashMap2);
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"getLoadModulesConnectedToPiuTypes(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("returns theTotalConnectedLoadModules: \n\t" + productNumbersAndRevisions));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModulesConnectedToPiuTypes(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("Returns - theTotalConnectedLoadModules: " + productNumbersAndRevisions));
        }
        return productNumbersAndRevisions.getElements();
    }

    public TagAndLoadModuleRefInformation getLoadModuleRefsConnectedToPiuType(String string, String string2, Collection collection) throws RepertoiresProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefsConnectedToPiuType(String aPiuTypeProductNumber, String aPiuTypeProductRevision, Collection aRepertoireNames)", (String)("aPiuTypeProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taRepertoireNames: " + collection));
        }
        try {
            Collection collection2 = this.getRepertoires(new HashSet(collection), this.myRepertoiresMap.values());
            Iterator iterator = collection2.iterator();
            Repertoire repertoire = null;
            Collection collection3 = null;
            LinkedList linkedList = new LinkedList();
            while (iterator.hasNext()) {
                repertoire = (Repertoire)iterator.next();
                collection3 = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModulesConnectedToPiuTypes(string, string2, repertoire.getPiuTypeLoadLists());
                linkedList.addAll(collection3);
            }
            TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation = this.convertAndMergeLoadModuleRefs(linkedList);
            tagAndLoadModuleRefInformation.setPiuTypeProductNumber(string);
            tagAndLoadModuleRefInformation.setPiuTypeProductRevision(string2);
            tagAndLoadModuleRefInformation.setConnectedRepertoires(collection);
            tagAndLoadModuleRefInformation.setConnectedLM_Refs(linkedList);
            return tagAndLoadModuleRefInformation;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getLoadModuleRefsConnectedToPiuType(String aPiuTypeProductNumber, String aPiuTypeProductRevision, Collection aRepertoireNames)", (String)("aPiuTypeProductNumber: " + string + "\n\taPiuTypeProductRevision: " + string2 + "\n\taRepertoireNames: " + collection), (Throwable)throwable);
            throw new RepertoiresProxyException(throwable.toString());
        }
    }

    public Collection collectRepertoireNamesContainingOverrideAttributes() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"collectRepertoireNamesContainingOverrideAttributes()");
        }
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        RepertoireProxy repertoireProxy = null;
        Collection collection = null;
        HashSet<String> hashSet = new HashSet<String>();
        block0: while (iterator.hasNext()) {
            repertoireProxy = (RepertoireProxy)iterator.next();
            collection = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModuleRefs(repertoireProxy.getRepertoire().getPiuTypeLoadLists());
            Iterator iterator2 = collection.iterator();
            LoadModuleRef loadModuleRef = null;
            while (iterator2.hasNext()) {
                loadModuleRef = (LoadModuleRef)iterator2.next();
                if (!loadModuleRef.isContainingAnyOptionalAttribute()) continue;
                hashSet.add(repertoireProxy.getRepertoire().getName());
                continue block0;
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"collectRepertoireNamesContainingOverrideAttributes()", (String)("RETURNS - theRepertoiresContainingOverrideAttributes:" + hashSet));
        }
        return hashSet;
    }

    protected TagAndLoadModuleRefInformation convertAndMergeLoadModuleRefs(Collection collection) throws ProgramInstanceRecordException, ProgramInstanceException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"convertAndMergeLoadModuleRefs(Collection anAllConnectedLoadModuleRefs)", (String)("anAllConnectedLoadModuleRefs: " + collection));
        }
        TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation = new TagAndLoadModuleRefInformation();
        Iterator iterator = collection.iterator();
        LoadModuleRef loadModuleRef = null;
        LoadModuleRefInformationData loadModuleRefInformationData = null;
        while (iterator.hasNext()) {
            loadModuleRef = (LoadModuleRef)iterator.next();
            loadModuleRefInformationData = tagAndLoadModuleRefInformation.getLoadModuleRefInformationData(loadModuleRef.getTag());
            if (loadModuleRefInformationData == null) {
                loadModuleRefInformationData = new LoadModuleRefInformationData();
            }
            loadModuleRefInformationData.addLoadModuleRefInformation(new LoadModuleRefInformation(loadModuleRef.getTag(), loadModuleRef.getProductNumber(), loadModuleRef.getRevision(), loadModuleRef.getProgramMemoryPoolSize(), loadModuleRef.getProgramMemoryHeapSize(), this.getProgramInstancesExpandedFormat(loadModuleRef.getProgramInstances()), loadModuleRef.getLoaderName(), loadModuleRef.getDeviceLoaderName(), loadModuleRef.getDeviceLoaderInformation(), loadModuleRef.getRestartCounterLimit(), loadModuleRef.getRestartTimer()));
            tagAndLoadModuleRefInformation.set(loadModuleRef.getTag(), loadModuleRefInformationData);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"convertAndMergeLoadModuleRefs(Collection anAllConnectedLoadModuleRefs)", (String)("RETURNS - theTagAndLoadModuleRefInformation: " + tagAndLoadModuleRefInformation));
        }
        return tagAndLoadModuleRefInformation;
    }

    private String getProgramInstancesExpandedFormat(String string) throws ProgramInstanceRecordException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProgramInstancesExpandedFormat(String aRawProgramInstances)", (String)("aRawProgramInstances: " + string));
        }
        String string2 = null;
        if (string != null) {
            Collection collection = ProgramInstancesValue.getProgramInstancesExpandedFormat(string);
            Iterator iterator = collection.iterator();
            string2 = "";
            while (iterator.hasNext()) {
                string2 = string2 + iterator.next();
                if (!iterator.hasNext()) continue;
                string2 = string2 + ",";
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getProgramInstancesExpandedFormat(String aRawProgramInstances)", (String)("RETURNS - theProgramInstances: " + string2));
        }
        return string2;
    }

    public LoadModuleRefsWithLoaderNamesInformation getLoadModuleRefsWithLoaderNamesInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefsWithLoaderNamesInformation()");
        }
        return this.getLoadModuleRefsWithLoaderNamesInformation(this.myRepertoiresMap.values());
    }

    public Collection getNamesOfRepertoiresReferencingLMs(ProductNumbersAndRevisions productNumbersAndRevisions) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNamesOfRepertoiresReferencingLMs(ProductNumbersAndRevisions aProductNumbersAndRevisionsOfLMs)", (String)("aProductNumbersAndRevisionsOfLMs: " + productNumbersAndRevisions));
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        RepertoireProxy repertoireProxy = null;
        while (iterator.hasNext()) {
            repertoireProxy = (RepertoireProxy)iterator.next();
            if (!this.myOptimizedPiuTypeLoadListsProxyInterface.containsLoadModuleRef(productNumbersAndRevisions, repertoireProxy.getRepertoire().getPiuTypeLoadLists())) continue;
            hashSet.add(repertoireProxy.getRepertoire().getName());
        }
        return hashSet;
    }

    public ProductNumbersAndRevisions getProductNumbersAndRevisionsOfLoadModuleRefs() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfLoadModuleRefs()");
        }
        return this.getTheProductNumbersAndRevisionsOfLoadModuleRefs(this.myRepertoiresMap.values());
    }

    public ProductNumbersAndRevisionsOpt getProductNumbersAndRevisionsOfLoadModuleRefsOpt(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfLoadModuleRefsOpt(Collection aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        return this.getTheProductNumbersAndRevisionsOfLoadModuleRefsOpt(this.getRepertoires(collection, this.myRepertoiresMap.values()));
    }

    public ProductNumbersAndRevisionsOpt getTheProductNumbersAndRevisionsOfLoadModuleRefsOpt(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTheProductNumbersAndRevisionsOfLoadModuleRefsOpt(Collection aRepertoires)", (String)("aRepertoires: " + collection));
        }
        ProductNumbersAndRevisionsOpt productNumbersAndRevisionsOpt = new ProductNumbersAndRevisionsOpt();
        ProductNumbersAndRevisionsOpt productNumbersAndRevisionsOpt2 = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            productNumbersAndRevisionsOpt2 = this.myOptimizedPiuTypeLoadListsProxyInterface.getProductNumbersAndRevisionsOfLoadModuleRefsOpt(((RepertoireProxy)iterator.next()).getRepertoire().getPiuTypeLoadLists());
            Iterator iterator2 = productNumbersAndRevisionsOpt2.getProductNumberAndRevisionsIterator();
            while (iterator2.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator2.next();
                productNumbersAndRevisionsOpt.addIfNotExist(productNumberAndRevision);
            }
        }
        return productNumbersAndRevisionsOpt;
    }

    public ProductNumbersAndRevisions getProductNumbersAndRevisionsOfLoadModuleRefs(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfLoadModuleRefs(Collection aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        return this.getTheProductNumbersAndRevisionsOfLoadModuleRefs(this.getRepertoires(collection, this.myRepertoiresMap.values()));
    }

    public ProductNumbersAndRevisions getProductNumbersAndRevisionsOfPiuTypeRefs() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfPiuTypeRefs()");
        }
        return this.getTheProductNumbersAndRevisionsOfPiuTypeRefs(this.myRepertoiresMap.values());
    }

    public ProductNumbersAndRevisions getProductNumbersAndRevisionsOfPiuTypeRefs(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfPiuTypeRefs(11Collection aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        return this.getTheProductNumbersAndRevisionsOfPiuTypeRefs(this.getRepertoires(collection, this.myRepertoiresMap.values()));
    }

    public ProgramInstances getProgramInstancesForLoadModule(String string, ProductNumberAndRevision productNumberAndRevision, ProductNumberAndRevision productNumberAndRevision2, int n) throws ProgramInstanceRecordException {
        RepertoireProxy repertoireProxy;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProgramInstancesForLoadModule(String aRepertoireName, ProductNumberAndRevision aPiuTypeProductNumberAndRevision, ProductNumberAndRevision aLoadModuleProductNumberAndRevision, int aTag)", (String)("aRepertoireName: " + string + "\n\taPiuTypeProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProductNumberAndRevision: " + productNumberAndRevision2 + "\n\taTag: " + n));
        }
        if ((repertoireProxy = (RepertoireProxy)this.myRepertoiresMap.get(string)) != null) {
            return this.myOptimizedPiuTypeLoadListsProxyInterface.getProgramInstancesForLoadModule(repertoireProxy.getRepertoire().getPiuTypeLoadLists(), productNumberAndRevision, productNumberAndRevision2, n);
        }
        UpgradeTrace.error(this.getClass(), (String)"getHeapAndPoolSizeForLoadModule(String aRepertoireName, ProductNumberAndRevision aPiuTypeProductNumberAndRevision, ProductNumberAndRevision aLoadModuleProductNumberAndRevision, int aTag)", (String)("No Repertoire with requested name found,\n\trequested name: " + string));
        return null;
    }

    public Vector getRepertoireNames() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoireNames()");
        }
        Vector<String> vector = new Vector<String>(1);
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(((RepertoireProxy)iterator.next()).getRepertoire().getName());
        }
        Iterator iterator2 = this.myDuplicatRepertoiresMap.values().iterator();
        while (iterator2.hasNext()) {
            vector.addElement(((RepertoireProxy)iterator2.next()).getRepertoire().getName());
        }
        return vector;
    }

    public RepertoireProxyInterface getRepertoireProxyInterface(String string) {
        return (RepertoireProxyInterface)this.myRepertoiresMap.get(string);
    }

    public Collection getRepertoires() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoires()");
        }
        return this.myRepertoiresMap.values();
    }

    public boolean isJavaHeapSizeSpecifiedInAnyPiuTypeRef() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isJavaHeapSizeSpecifiedInAnyPiuTypeRef()");
        }
        Iterator iterator = this.myRepertoiresMap.values().iterator();
        RepertoireProxyInterface repertoireProxyInterface = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            repertoireProxyInterface = (RepertoireProxyInterface)iterator.next();
            if (!repertoireProxyInterface.isJavaHeapSizeSpecifiedInAnyPiuTypeRef()) continue;
            bl = true;
            break;
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"isJavaHeapSizeSpecifiedInAnyPiuTypeRef()", (String)("RETURNS - theIsJavaHeapSizeSpecified: " + bl));
        }
        return bl;
    }

    public void removeRepertoires(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"removeRepertoires(Vector aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.myRepertoiresMap.remove((String)iterator.next());
        }
        this.getRepertoireByRepertoireValue();
    }

    public void replaceLoadModuleRefs(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"replaceLoadModuleRefs(Vector aLoadModuleReplacementContainers)", (String)("aLoadModuleReplacementContainers: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            LoadModuleReplacementContainer loadModuleReplacementContainer = (LoadModuleReplacementContainer)iterator.next();
            Iterator iterator2 = this.myRepertoiresMap.values().iterator();
            while (iterator2.hasNext()) {
                this.myOptimizedPiuTypeLoadListsProxyInterface.replaceLoadModuleRefs(loadModuleReplacementContainer.getOldLMs(), loadModuleReplacementContainer.getNewLM(), ((RepertoireProxy)iterator2.next()).getRepertoire().getPiuTypeLoadLists());
            }
        }
    }

    public void replacePiuTypeRefs(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"replacePiuTypeRefs(Vector aPiuTypeReplacementContainers)", (String)("aPiuTypeReplacementContainers: " + vector));
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            PiuTypeReplacementContainer piuTypeReplacementContainer = (PiuTypeReplacementContainer)iterator.next();
            Iterator iterator2 = this.myRepertoiresMap.values().iterator();
            while (iterator2.hasNext()) {
                this.myOptimizedPiuTypeLoadListsProxyInterface.replacePiuTypeRefs(piuTypeReplacementContainer.getOldPiuTypes(), piuTypeReplacementContainer.getNewPiuTypes(), ((RepertoireProxy)iterator2.next()).getRepertoire().getPiuTypeLoadLists());
            }
        }
    }

    private HashMap addConnectedLoadModulesForOneRepertoire(Collection collection, HashMap hashMap) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addConnectedLoadModulesForOneRepertoire(Collection aConnectedLoadModulesForOneRepertoire, HashMap aTotalConnectedLoadModules)", (String)("aConnectedLoadModulesForOneRepertoire: " + collection));
        }
        Iterator iterator = collection.iterator();
        LoadModuleRef loadModuleRef = null;
        HashSet<String> hashSet = null;
        while (iterator.hasNext()) {
            loadModuleRef = (LoadModuleRef)iterator.next();
            hashSet = (HashSet<String>)hashMap.get(loadModuleRef.getProductNumber());
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashSet.add(loadModuleRef.getRevision());
                hashMap.put(loadModuleRef.getProductNumber(), hashSet);
            } else {
                hashSet.add(loadModuleRef.getRevision());
            }
            if (!UpgradeTrace.valid(this.getClass(), (int)27)) continue;
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"addConnectedLoadModulesForOneRepertoire(Collection aConnectedLoadModulesForOneRepertoire, HashMap aTotalConnectedLoadModules)", (String)("LoadModule: " + loadModuleRef.getProductNumber() + "_" + loadModuleRef.getRevision() + " has been added (if it not already present)."));
        }
        return hashMap;
    }

    private ProductNumbersAndRevisions convertHashMapToProductNumbersAndRevisions(HashMap hashMap) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"convertHashMapToProductNumbersAndRevisions(HashMap aConnectedLoadModules)", (String)("aConnectedLoadModules: " + hashMap));
        }
        Iterator iterator = hashMap.keySet().iterator();
        String string = null;
        Iterator iterator2 = null;
        String string2 = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            iterator2 = ((HashSet)hashMap.get(string)).iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                productNumbersAndRevisions.addElement(string, string2, null);
            }
        }
        return productNumbersAndRevisions;
    }

    private HashMap convertProductNumbersAndRevisionsToHashMap(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"convertProductNumbersAndRevisionsToHashMap(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("aProductNumbersAndRevisionsOfPiuTypes: " + collection));
        }
        Iterator iterator = collection.iterator();
        ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
        String string = null;
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        HashSet<String> hashSet = null;
        while (iterator.hasNext()) {
            productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
            try {
                string = ProductNumberAndRevision.getShortProductRevision(productNumberAndRevisionInterface.getRevision());
                hashSet = (HashSet<String>)hashMap.get(productNumberAndRevisionInterface.getProductNumber());
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashSet.add(productNumberAndRevisionInterface.getRevision());
                    hashSet.add(string);
                    hashSet.add("*");
                    hashMap.put(productNumberAndRevisionInterface.getProductNumber(), hashSet);
                    continue;
                }
                hashSet.add(productNumberAndRevisionInterface.getRevision());
                hashSet.add(string);
            }
            catch (InvalidProductRevisionFormatException invalidProductRevisionFormatException) {
                UpgradeTrace.warning(this.getClass(), (String)"convertProductNumbersAndRevisionsToHashMap(Collection aProductNumbersAndRevisionsOfPiuTypes)", (String)("The revision of PiuType: " + productNumberAndRevisionInterface + "\n\tis not allowed, this PiuType is ignored (i.e. removed from the list)."));
            }
        }
        return hashMap;
    }

    private int getIndexOfRepertoire(String string, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getIndexOfRepertoire(String aRepertoireName, Vector aRepertoires)", (String)("aRepertoireName: " + string + "\n\taRepertoires: " + vector));
        }
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            if (((Repertoire)iterator.next()).getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public LoadModuleRefsWithLoaderNamesInformation getLoadModuleRefsWithLoaderNamesInformation(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefsWithLoaderNamesInformation(Collection aRepertoires)", (String)("aRepertoires: " + collection));
        }
        LoadModuleRefsWithLoaderNamesInformation loadModuleRefsWithLoaderNamesInformation = new LoadModuleRefsWithLoaderNamesInformation();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            loadModuleRefsWithLoaderNamesInformation = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModuleRefsWithLoaderNamesInformation(loadModuleRefsWithLoaderNamesInformation, ((RepertoireProxy)iterator.next()).getRepertoire().getPiuTypeLoadLists());
        }
        return loadModuleRefsWithLoaderNamesInformation;
    }

    protected Collection getRepertoires(Collection collection, Collection collection2) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRepertoires(Collection aRepertoireNames, Collection aRepertoires)", (String)("aRepertoireNames: " + collection + "\n\taRepertoires: " + collection2));
        }
        Vector<RepertoireProxy> vector = new Vector<RepertoireProxy>(1);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            RepertoireProxy repertoireProxy = (RepertoireProxy)iterator.next();
            if (!collection.contains(repertoireProxy.getRepertoire().getName())) continue;
            vector.addElement(repertoireProxy);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getRepertoires(Collection aRepertoireNames, Collection aRepertoires)", (String)("RETURNS - theRequestedRepertoires: " + vector));
        }
        return vector;
    }

    private ProductNumbersAndRevisions getTheProductNumbersAndRevisionsOfLoadModuleRefs(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTheProductNumbersAndRevisionsOfLoadModuleRefs(Collection aRepertoires)", (String)("aRepertoires: " + collection));
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ProductNumbersAndRevisions productNumbersAndRevisions2 = this.myOptimizedPiuTypeLoadListsProxyInterface.getProductNumbersAndRevisionsOfLoadModuleRefs(((RepertoireProxy)iterator.next()).getRepertoire().getPiuTypeLoadLists());
            Iterator iterator2 = productNumbersAndRevisions2.getElements().iterator();
            while (iterator2.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)iterator2.next();
                if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                productNumbersAndRevisions.addElement(productNumberAndRevision);
            }
        }
        return productNumbersAndRevisions;
    }

    private ProductNumbersAndRevisions getTheProductNumbersAndRevisionsOfPiuTypeRefs(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTheProductNumbersAndRevisionsOfPiuTypeRefs(Collection aRepertoires)", (String)("aRepertoires: " + collection));
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ProductNumbersAndRevisions productNumbersAndRevisions2 = this.myOptimizedPiuTypeLoadListsProxyInterface.getProductNumbersAndRevisionsOfPiuTypeRefs(((RepertoireProxy)e).getRepertoire().getPiuTypeLoadLists());
            Iterator iterator2 = productNumbersAndRevisions2.getElements().iterator();
            while (iterator2.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)iterator2.next();
                if (productNumbersAndRevisions.contains(productNumberAndRevision)) continue;
                productNumbersAndRevisions.addElement(productNumberAndRevision);
            }
        }
        this.getRepertoireByRepertoireValue();
        return productNumbersAndRevisions;
    }

    public ProductNumbersAndRevisionsOpt getProductNumbersAndRevisionsOfPiuTypeRefsOpt(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfPiuTypeRefsOpt(Collection aRepertoireNames)", (String)("aRepertoireNames: " + collection));
        }
        return this.getTheProductNumbersAndRevisionsOfPiuTypeRefsOpt(this.getRepertoires(collection, this.myRepertoiresMap.values()));
    }

    private ProductNumbersAndRevisionsOpt getTheProductNumbersAndRevisionsOfPiuTypeRefsOpt(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getTheProductNumbersAndRevisionsOfPiuTypeRefsOpt(Collection aRepertoires)", (String)("aRepertoires: " + collection));
        }
        ProductNumbersAndRevisionsOpt productNumbersAndRevisionsOpt = new ProductNumbersAndRevisionsOpt();
        ProductNumbersAndRevisionsOpt productNumbersAndRevisionsOpt2 = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            productNumbersAndRevisionsOpt2 = this.myOptimizedPiuTypeLoadListsProxyInterface.getProductNumbersAndRevisionsOfPiuTypeRefsOpt(((RepertoireProxy)iterator.next()).getRepertoire().getPiuTypeLoadLists());
            Iterator iterator2 = productNumbersAndRevisionsOpt2.getProductNumberAndRevisionsIterator();
            while (iterator2.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator2.next();
                productNumbersAndRevisionsOpt.addIfNotExist(productNumberAndRevision);
            }
        }
        return productNumbersAndRevisionsOpt;
    }

    public TagAndLoadModuleRefInformation getLoadModuleRefsConnectedToPiuTypeOpt(String string, String string2, Collection collection) throws RepertoiresProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefsConnectedToPiuTypeOpt(String aPiuTypeProductNumber, String aPiuTypeProductRevision, Collection aRepertoireNames)", (String)("aPiuTypeProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taRepertoireNames: " + collection));
        }
        try {
            Collection collection2 = this.getRepertoires(new HashSet(collection), this.myRepertoiresMap.values());
            Iterator iterator = collection2.iterator();
            Repertoire repertoire = null;
            Collection collection3 = null;
            LinkedList linkedList = new LinkedList();
            while (iterator.hasNext()) {
                repertoire = ((RepertoireProxy)iterator.next()).getRepertoire();
                collection3 = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModuleRefsConnectedToPiuTypesOpt(string, string2, repertoire.getPiuTypeLoadLists());
                linkedList.addAll(collection3);
            }
            TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation = this.convertAndMergeLoadModuleRefs(linkedList);
            tagAndLoadModuleRefInformation.setPiuTypeProductNumber(string);
            tagAndLoadModuleRefInformation.setPiuTypeProductRevision(string2);
            tagAndLoadModuleRefInformation.setConnectedRepertoires(collection);
            tagAndLoadModuleRefInformation.setConnectedLM_Refs(linkedList);
            return tagAndLoadModuleRefInformation;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getLoadModuleRefsConnectedToPiuTypeOpt(String aPiuTypeProductNumber, String aPiuTypeProductRevision, Collection aRepertoireNames)", (String)("aPiuTypeProductNumber: " + string + "\n\taPiuTypeProductRevision: " + string2 + "\n\taRepertoireNames: " + collection), (Throwable)throwable);
            throw new RepertoiresProxyException(throwable.toString());
        }
    }

    public ProductNumbersAndRevisions getProductNumbersAndRevisionsOfPiuTypeRefs(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumbersAndRevisionsOfPiuTypeRefs(String aRepertoireName)", (String)("aRepertoireName: " + string));
        }
        Vector<RepertoireProxy> vector = new Vector<RepertoireProxy>();
        vector.add(new RepertoireProxy(this.getRepertoire(string)));
        return this.getTheProductNumbersAndRevisionsOfPiuTypeRefs(vector);
    }

    public LoadModuleRefInformationData getLoadModuleRefInformationOfAllLMsConnectedToRepertoires(Collection collection) throws RepertoiresProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoadModuleRefInformationOfAllLoadModulesConnectedToRepertoires(Collection aRepertorieNames)", (String)("aRepertorieNames: " + collection));
        }
        LoadModuleRefInformationData loadModuleRefInformationData = new LoadModuleRefInformationData();
        Collection collection2 = this.getRepertoires(collection, this.myRepertoiresMap.values());
        Iterator iterator = collection2.iterator();
        Repertoire repertoire = null;
        try {
            Collection collection3 = null;
            while (iterator.hasNext()) {
                repertoire = (Repertoire)iterator.next();
                collection3 = this.myOptimizedPiuTypeLoadListsProxyInterface.getLoadModuleRefs(repertoire.getPiuTypeLoadLists());
                Iterator iterator2 = collection3.iterator();
                LoadModuleRef loadModuleRef = null;
                while (iterator2.hasNext()) {
                    loadModuleRef = (LoadModuleRef)iterator2.next();
                    loadModuleRefInformationData.addLoadModuleRefInformation(new LoadModuleRefInformation(loadModuleRef.getTag(), loadModuleRef.getProductNumber(), loadModuleRef.getRevision(), loadModuleRef.getProgramMemoryPoolSize(), loadModuleRef.getProgramMemoryHeapSize(), loadModuleRef.getProgramInstances(), loadModuleRef.getLoaderName(), loadModuleRef.getDeviceLoaderName(), loadModuleRef.getDeviceLoaderInformation(), loadModuleRef.getRestartCounterLimit(), loadModuleRef.getRestartTimer()));
                }
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"getLoadModuleRefInformationOfAllLMsConnectedToRepertoires(Collection aRepertorieNames)", (String)("aRepertorieNames: " + collection + "\n\tThrowable caught."), (Throwable)throwable);
            throw new RepertoiresProxyException(throwable.toString());
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getLoadModuleRefInformationOfAllLoadModulesConnectedToRepertoires(Collection aRepertorieNames)", (String)("Returning - theLoadModuleRefInformationData: " + loadModuleRefInformationData));
        }
        return loadModuleRefInformationData;
    }

    private void buildSetOfRepertoireNames() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"buildSetOfRepertoireNames()");
        }
        if (!this.myRepertoiresMap.isEmpty()) {
            this.myRepertoiresMap.clear();
        }
        Iterator iterator = this.myRepertoires.iterator();
        Repertoire repertoire = null;
        while (iterator.hasNext()) {
            repertoire = (Repertoire)iterator.next();
            if (this.myRepertoiresMap.get(repertoire.getName()) != null) {
                this.myDuplicatRepertoiresMap.put(repertoire.getName(), new RepertoireProxy(repertoire));
                continue;
            }
            this.myRepertoiresMap.put(repertoire.getName(), new RepertoireProxy(repertoire));
        }
    }
}

