/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.delete;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.configurationversion.delete.CVsToDelete;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ValueAVC_Property;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallRemoveResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.timerforverification.VerificationTimerController;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.delete.DeleteRequestEvent;
import se.ericsson.cello.upgradepackage.delete.LoadModuleMOsAndFilesToBeDeleted;
import se.ericsson.cello.upgradepackage.delete.LoadModulesToBeDeletedAnalyser;
import se.ericsson.cello.upgradepackage.delete.UpgradePackageLoadModuleFileHolder;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.exception.UpgradePackageDeleteException;
import se.ericsson.cello.upgradepackage.main.exception.UpgradePackageDeleteNotAllowedException;
import se.ericsson.cello.upgradepackage.main.exception.UpgradePackageFileSystemErrorException;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ConfirmedEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_Controller;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_Exception;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RejectedInformationEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RequestEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ResponseEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.DeleteUP_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.IdleProgressInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.StateValueInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageRelatedCVsDataContainer;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.AllRelatedCVsAreNotDeleteableException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.VerifyCVsToBeCreatedResult;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public final class UpgradePackageRemover {
    private boolean isBusy = false;
    private static final int NUMBER_OF_CVS_REQUIRED_FOR_DOWNGRADE = 2;
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
    private static UpgradePackageRemover theInstance;

    public static synchronized UpgradePackageRemover instance() {
        if (theInstance == null) {
            theInstance = new UpgradePackageRemover();
        }
        return theInstance;
    }

    public void deleteUpgradePackageItems(DeleteRequestEvent deleteRequestEvent) throws ActionNotAllowedException, UpgradePackageDeleteNotAllowedException, UpgradePackageDeleteException, UpgradePackageFileSystemErrorException, MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteUpgradePackageItems(DeleteRequestEvent aDeleteRequestEvent)", "aDeleteRequestEvent: " + deleteRequestEvent);
        }
        if (!this.isUpgradePackageDeleteable(deleteRequestEvent.getUpDocumentID(), deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), deleteRequestEvent.getPreUpgradeState())) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteUpgradePackageItems(String anUpgradePackageMO_LocalDistinguishedName, String anUpgradePackageDocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, String anUpgradePackageControlFilePath)", "Deletion of this Upgrade Package is NOT allowed,\n\tthe reason is the existance of delete preventing CV(s) and/or delete preventing UP(s).\n\tanUpgradePackageMO_LocalDistinguishedName: " + deleteRequestEvent.getUP_MoLdn() + "\n\tanUpgradePackageDocumentId: " + deleteRequestEvent.getUpDocumentID() + "\n\tanUpgradePackageProductNumber" + deleteRequestEvent.getUpgradePackageDocumentNumber() + "\n\tanUpgradePackageProductRevision" + deleteRequestEvent.getUpgradePackageDocumentRevision() + "\n\tanUpgradePackageControlFilePath" + deleteRequestEvent.getUpgradePackageUCF_Path() + "\n\tdeletePreventingCVs: " + SuLib.toString(deleteRequestEvent.getUpgradePackageMO().getDeletePreventingCVs(null)) + "\n\totherReferingCVs: " + SuLib.toString(deleteRequestEvent.getUpgradePackageMO().getOtherReferringCVs(null)) + "\n\tdeletePreventingUPs: " + SuLib.toString(deleteRequestEvent.getUpgradePackageMO().getDeletePreventingUPs(null)));
            }
            throw new UpgradePackageDeleteNotAllowedException("UpgradePackage", "delete(Coordinator context)\n\tDeletion of this Upgrade Package is NOT allowed, the reason is the existance of delete preventing CV(s) and/or delete preventing UP(s).");
        }
        if (!this.lock()) {
            throw new ActionNotAllowedException("The action is not allowed due to a conflict with an other action that is in execution.");
        }
        this.doRestoreSU(deleteRequestEvent);
        try {
            this.doDeleteUpgradePackageItems(deleteRequestEvent);
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            throw actionNotAllowedException;
        }
        catch (UpgradePackageDeleteNotAllowedException upgradePackageDeleteNotAllowedException) {
            throw upgradePackageDeleteNotAllowedException;
        }
        catch (UpgradePackageDeleteException upgradePackageDeleteException) {
            throw upgradePackageDeleteException;
        }
        catch (UpgradePackageFileSystemErrorException upgradePackageFileSystemErrorException) {
            throw upgradePackageFileSystemErrorException;
        }
        catch (Exception exception) {
            throw new UpgradePackageDeleteException(exception);
        }
        finally {
            this.unlock();
        }
    }

    private void doRestoreSU(DeleteRequestEvent deleteRequestEvent) throws UpgradePackageDeleteException {
        block15: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteUpgradePackageItems(DeleteRequestEvent aDeleteRequestEvent)", "aDeleteRequestEvent: " + deleteRequestEvent);
            }
            try {
                Object object;
                if (deleteRequestEvent.getPreUpgradeState() != 2 && deleteRequestEvent.getPreUpgradeState() != 3) break block15;
                if (deleteRequestEvent.getPreUpgradeState() == 2) {
                    Trace.info(this.getClass(), "doRestoreSU(DeleteRequestEvent aDeleteRequestEvent)", "The UP to be deleted has been pre upgraded and needs therefor be restored (downgraded) to be able to execute the delete UP.\n\tThis will now be done automatically.");
                    object = ServiceFinder.getConfigurationVersionMO_HandlerInterface().verifyNumberOfCVsToBeCreated(2);
                    if (((Enumer)object).getValue() != VerifyCVsToBeCreatedResult.Confirmed.getValue()) {
                        throw new UpgradePackageDeleteNotAllowedException("UpgradePackage", "The UP to be deleted is pre upgrade and needs therefor to be restored (downgraded) prior the delete. At restore of the UP two CVs needs to be created which not is possible due to " + ((Enumer)object).getValue());
                    }
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doRestoreSU(DeleteRequestEvent aDeleteRequestEvent)", "The UP to be deleted is restored (downgraded) and the delete UP will soon continue.\n\tThis will now be done automatically.");
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsDeleteUP_InProgress, new DeleteUP_Information((Object)this, true));
                object = new RestoreSU_Controller();
                RestoreSU_ResponseEvent restoreSU_ResponseEvent = ((RestoreSU_Controller)object).restoreSU(new RestoreSU_RequestEvent(this, deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), deleteRequestEvent.getUpgradePackageUCF_Path(), deleteRequestEvent.getUpgradePackageOriginalUCF_Path(), deleteRequestEvent.getUpgradePackageMO(), deleteRequestEvent.getPreUpgradeState(), deleteRequestEvent.getPreviousState(), deleteRequestEvent.getCurrentState(), deleteRequestEvent.getPreviousJavaHeapSize(), deleteRequestEvent.getRemovedJavaLMsAtPreUpgradeAsArray(), deleteRequestEvent.getPreUpgradeExecutingPhase()));
                if (restoreSU_ResponseEvent instanceof RestoreSU_ConfirmedEvent) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsDeleteUP_InProgress, new DeleteUP_Information((Object)this, false));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this, ValueAVC_Property.OnlyValue));
                    if (deleteRequestEvent.getPreviousState() != -1) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new StateValueInformation(this, deleteRequestEvent.getPreviousState(), ValueAVC_Property.OnlyValue));
                    }
                    ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                    String string = null;
                    try {
                        string = configurationVersionMO_HandlerInterface.createDowngradeFinalCV_AndSetStartable(deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision());
                    }
                    catch (Throwable throwable) {
                        Trace.log1(this.getClass(), "doRestoreSU(DeleteRequestEvent aDeleteRequestEvent)", "Failed to create the downgrade of SU Final CV (ignored).");
                        this.setDowngradeBackupCvAsStartable(deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), configurationVersionMO_HandlerInterface);
                    }
                    configurationVersionMO_HandlerInterface.deleteDowngradeRollbackCVs(deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), string);
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this, ValueAVC_Property.OnlyAVC));
                    if (deleteRequestEvent.getPreviousState() != -1) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new StateValueInformation(this, deleteRequestEvent.getPreviousState(), ValueAVC_Property.OnlyAVC));
                    }
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "doRestoreSU(DeleteRequestEvent aDeleteRequestEvent)", "Continues with delete of the Upgrade Package Mo after sucessfully executed restoreSU");
                    }
                    break block15;
                }
                throw new UpgradePackageDeleteException("Not possible to delete the UP due to failed to restore SU when it is pre upgraded" + ((RestoreSU_RejectedInformationEvent)restoreSU_ResponseEvent).getReason());
            }
            catch (UpgradePackageDeleteException upgradePackageDeleteException) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsDeleteUP_InProgress, new DeleteUP_Information((Object)this, false));
                throw upgradePackageDeleteException;
            }
            catch (RestoreSU_Exception restoreSU_Exception) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsDeleteUP_InProgress, new DeleteUP_Information((Object)this, false));
                throw new UpgradePackageDeleteException(restoreSU_Exception.toString());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "doRestoreSU(DeleteRequestEvent aDeleteRequestEvent)", "aDeleteRequestEvent: " + deleteRequestEvent, throwable);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsDeleteUP_InProgress, new DeleteUP_Information((Object)this, false));
                throw new UpgradePackageDeleteException(throwable.toString());
            }
        }
    }

    private void setDowngradeBackupCvAsStartable(String string, String string2, ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setDowngradeBackupCvAsStartable(String anUP_ProdNo, String anUP_Rev, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "anUP_ProdNo: " + string + "\n\tanUP_Rev: " + string2 + "\n\taConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface);
        }
        try {
            String string3;
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "setDowngradeBackupCvAsStartable(String anUP_ProdNo, String anUP_Rev, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "The downgrade final CV has not been created. Set the pre - upgrade backup CV as startable to enable delete of the UP");
            }
            if ((string3 = this.getPreUpgradeBackupCV(configurationVersionMO_HandlerInterface, string, string2)) != null) {
                configurationVersionMO_HandlerInterface.setStartableCV(string3);
            } else {
                Trace.info(this.getClass(), "setDowngradeBackupCvAsStartable(String anUP_ProdNo, String anUP_Rev, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "Delete of UP has been requested and auto - restoreSu has been performed. The downgrade final CV has not been created as expected.When trying to set the pre - upgrade backup CV as startble it was not found despite it did exist prior starting the auto - restoreSu function.The delete of the UP will anyhow continue. Ensure that the current startable CV is manually deleted since it points to this deleted UP");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setDowngradeBackupCvAsStartable(String anUP_ProdNo, String anUP_Rev, ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface)", "anUP_ProdNo: " + string + "\n\tanUP_Rev: " + string2 + "\n\taConfigurationVersionMO_HandlerInterface: " + configurationVersionMO_HandlerInterface, throwable);
            throw new UpgradePackageDeleteException(throwable);
        }
    }

    public String[] getCVsNotPreventingDeleteOfUpgradePackage(String string) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCVsNotPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId, Coordinator aCoordinator )", "anUpgradePackageDocumentId: " + string);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string);
            String[] stringArray = upgradePackageRelatedCVsDataContainer.getDeleteableCVs();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getCVsNotPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId, Coordinator aCoordinator )", "theAllDeleteableCVs: " + SuLib.toString(stringArray));
            }
            return stringArray;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getCVsNotPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId, Coordinator aCoordinator )", "Retrieval of CV data for Upgrade Package failed,\n\tanUpgradePackageDocumentId: " + string + "Upgrade Package Path: " + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string.replace('/', '%').replace('\\', '%'), exception);
            throw new UpgradePackageDeleteException(exception);
        }
    }

    public String[] getCVsPreventingDeleteOfUpgradePackage(String string) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCVsPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId )", "\tanUpgradePackageDocumentId: " + string);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string);
            String[] stringArray = upgradePackageRelatedCVsDataContainer.getNotDeleteableCVs();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getCVsPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId )", "RETURNS - theAllNotDeleteableCVs: " + SuLib.toString(stringArray));
            }
            return stringArray;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getCVsPreventingDeleteOfUpgradePackage ( String anUpgradePackageDocumentId )", "Retrieval of CV data for Upgrade Package failed,\n\tanUpgradePackageDocumentId: " + string + "Upgrade Package Path: " + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string.replace('/', '%').replace('\\', '%'), exception);
            throw new UpgradePackageDeleteException(exception);
        }
    }

    public UpgradePackageRelatedCVsDataContainer getUpgradePackageCV_Information(String string) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageCV_Information ( String anUpgradePackageDocumentId )", "anUpgradePackageDocumentId: " + string);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getUpgradePackageCV_Information ( String anUpgradePackageDocumentId )", "RETURNS - theUpgradePackageRelatedCVsDataContainer: " + upgradePackageRelatedCVsDataContainer);
            }
            return upgradePackageRelatedCVsDataContainer;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getUpgradePackageCV_Information ( String anUpgradePackageDocumentId )", "Retrieval of CV data for Upgrade Package failed,\n\tanUpgradePackageDocumentId: " + string, exception);
            throw new UpgradePackageDeleteException(exception);
        }
    }

    public Struct[] getUPsPreventingDeleteOfUpgradePackage(String string, String string2, String string3) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUPsPreventingDeleteOfUpgradePackage(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "anUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3);
        }
        try {
            return this.getUPsBasedOnIndicatedUP(string, string2, string3);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getUPsPreventingDeleteOfUpgradePackage(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Exception caught when trying to get UPs based on indicated UP,\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\tgetUPsPreventingDeleteOfUpgradePackage(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tException caught when trying to get UPs based on indicated UP," + "\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
        }
    }

    public boolean isUpgradePackageDeleteable(String string, String string2, String string3, int n) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "anUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3 + "\n\taPreUpgradeState: " + n);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            if (n == 3) {
                return true;
            }
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 22, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "theUpgradePackageRelatedCVsDataContainer: " + upgradePackageRelatedCVsDataContainer);
            }
            if (upgradePackageRelatedCVsDataContainer.allCVsAreDeleteable()) {
                return !this.atLeastOneUP_BasedOnIndicatedUP_exists(string, string2, string3);
            }
            boolean bl = false;
            if (upgradePackageRelatedCVsDataContainer.isDeletePreventingCVsOnlyPreUpgradeCVs()) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "The UP to be deleted has been pre upgraded and at least one pre-upgraded CV prevents delete of the UP itself");
                }
                if (this.isCV_PreventingDeleteSetAsStartableOnly(string)) {
                    String string4 = this.getPreUpgradeBackupCV(configurationVersionMO_HandlerInterface, string2, string3);
                    if (string4 != null) {
                        bl = !upgradePackageRelatedCVsDataContainer.contains(string4);
                    } else {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "The pre upgrade backup CV do not exist and hence the deletion of the UP can not be performed");
                        }
                        bl = false;
                    }
                }
            }
            if (bl && this.atLeastOneUP_BasedOnIndicatedUP_exists(string, string2, string3)) {
                bl = false;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "RETURNS - theIsDeleteAllowed: " + bl);
            }
            return bl;
        }
        catch (UpgradePackageDeleteException upgradePackageDeleteException) {
            throw upgradePackageDeleteException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "UpgradePackageDeleteException caught when trying to check if indicated UP is deleteable,\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, throwable);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\tisUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tThrowable caught when trying to check if indicated UP is deleteable," + "\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, throwable);
        }
    }

    private String getPreUpgradeBackupCV(ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface, String string, String string2) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPreUpgradeBackupCV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "\n\tanUP_ProductDataNumber: " + string + "\n\tanUP_ProductDataRevision: " + string2);
        }
        try {
            String string3 = configurationVersionMO_HandlerInterface.createMainNameForCV("Ir", string, string2);
            Collection collection = configurationVersionMO_HandlerInterface.getStoredConfigurationVersionNames();
            String string4 = this.getBackupCV_Name(configurationVersionMO_HandlerInterface, string3, collection);
            if (string4 == null && (string4 = this.getBackupCV_Name(configurationVersionMO_HandlerInterface, string3 = configurationVersionMO_HandlerInterface.createMainNameForCV("Vr", string, string2), collection)) == null) {
                string3 = configurationVersionMO_HandlerInterface.createMainNameForCV("Rb", string, string2);
                string4 = this.getBackupCV_Name(configurationVersionMO_HandlerInterface, string3, collection);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getPreUpgradeBackupCV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface, UpgradePackageRelatedCVsDataContainer anUpgradePackageRelatedCVsDataContainer, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "RETURNS - theBackupCV_Name: " + string4);
            }
            return string4;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getPreUpgradeBackupCV(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "\n\tanUP_ProductDataNumber: " + string + "\n\tanUP_ProductDataRevision: " + string2, throwable);
            throw new UpgradePackageDeleteException(throwable.toString());
        }
    }

    private String getBackupCV_Name(ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface, String string, Collection collection) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getBackupCV_Name(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface, String aCV_NameWithoutTimestamp, Collection aStoredCVs)", "aCV_NameWithoutTimestamp: " + string + "\n\taStoredCVs: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string2.startsWith(string)) continue;
                return string2;
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getBackupCV_Name(ConfigurationVersionMO_HandlerInterface aConfigurationVersionMO_HandlerInterface, String aCV_NameWithoutTimestamp, Collection aStoredCVs)", "aCV_NameWithoutTimestamp: " + string + "\n\taStoredCVs: " + collection, throwable);
            throw new UpgradePackageDeleteException(throwable.toString());
        }
    }

    private boolean isCV_PreventingDeleteSetAsStartableOnly(String string) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCV_PreventingDeleteSetAsStartableOnly(String anUpgradePackageDocumentId)", "anUpgradePackageDocumentId: " + string);
        }
        try {
            Collection collection = CV_PreUpgradeRelationHandler.getInstance().getPreUpgradedCVsForUP_DeletePreventing(string);
            if (collection.size() == 1) {
                ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
                String string2;
                String string3;
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "Only one pre-upgrade CV prevents delete. If that one only is set to startable it still shall be possible to delete the UP.");
                }
                if ((string3 = (String)new LinkedList(collection).getFirst()).equals(string2 = (configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface()).getStartableCV())) {
                    String string4 = configurationVersionMO_HandlerInterface.getCurrentLoadedConfigurationVersion(null);
                    if (string3.equals(string4)) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "Loaded CV is a pre upgrade CV i.e. delete of UP is not possible.\n\tLoaded CV: " + string4 + "\n\tRETURNS - false");
                        }
                        return false;
                    }
                    if (configurationVersionMO_HandlerInterface.isCV_InRollbackList(string3, null)) {
                        if (Trace.valid(this.getClass(), 40)) {
                            Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "A pre upgrade CV is in rollback list i.e. delete of UP is not possible.\n\tThe CV that prevents delete: " + string3 + "\n\tRETURNS - false");
                        }
                        return false;
                    }
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "Delete preventing pre-upgrade CV is set as startable and will not prevent delete after the auto restore su function has been executed.\n\tRETURNS - true");
                    }
                    return true;
                }
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "Delete preventing pre-upgrade CV is not set as startable.\n\tRETURNS - false");
                }
                return false;
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision, int aPreUpgradeState)", "More than one pre upgrade CVs prevents delete of the UP. Nothing can be done more than stating that the UP is not deleteable.\n\tRETURNS - false");
            }
            return false;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new UpgradePackageDeleteException(configurationVersionException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "isUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Exception caught when trying to check if indicated UP is deleteable,\n\tanUpgradePackageDocumentId: " + string, exception);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\tisUpgradePackageDeleteable(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tException caught when trying to check if indicated UP is deleteable," + "\n\tanUpgradePackageDocumentId: " + string, exception);
        }
    }

    private synchronized boolean atLeastOneUP_BasedOnIndicatedUP_exists(String string, String string2, String string3) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "atLeastOneUP_BasedOnIndicatedUP_exists(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "anUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3);
        }
        try {
            UpgradePackageMoImpl upgradePackageMoImpl = null;
            Vector vector = null;
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null || upgradePackageMoImpl.getUpgradePackageDocumentId(null).equals(string) || !upgradePackageMoImpl.getTypeOfUpgradePackage(null).equals("Delta") || (vector = this.extractUPsBasedOnIndicatedUP_fromMO(upgradePackageMoImpl, string2, string3)).isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "atLeastOneUP_BasedOnIndicatedUP_exists(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Exception caught when trying to check if at least one UP is based on indicated UP,\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\tatLeastOneUP_BasedOnIndicatedUP_exists(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tException caught when trying to check if at least one UP is based on indicated UP," + "\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
        }
    }

    private Vector collectUpgradePackageControlFiles(String string) throws UpgradePackageFileSystemErrorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectUpgradePackageControlFiles (String anUpgradePackageToBeExcluded)", "anUpgradePackageToBeExcluded: " + string);
        }
        String[] stringArray = null;
        File file = new File(this.mySystemUpgradeConstantsInterface.getNodeUpRootPath());
        try {
            stringArray = file.list();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "collectUpgradePackageControlFiles (String anUpgradePackageToBeExcluded)", "Error when trying to list all files (directories) in the directory " + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + " in method collectUpgradePackageControlFiles().", exception);
            throw new UpgradePackageFileSystemErrorException("UpgradePackage", "Error when trying to list all files in the directory " + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + ".");
        }
        Vector<String> vector = new Vector<String>();
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = new File(this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + stringArray[i]);
            if (!file2.isDirectory()) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Vector<File> vector2 = new Vector<File>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((String)objectArray[i]).equals(string)) continue;
            String string2 = this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + (String)objectArray[i] + "/" + (String)objectArray[i] + ".xml";
            File file3 = new File(string2);
            if (!file3.exists()) {
                file3 = new File(string2 + "Original");
                if (!file3.exists()) {
                    Trace.info(this.getClass(), "collectUpgradePackageControlFiles (String anUpgradePackageToBeExcluded)", "The XML file for Upgrade Package '" + string2 + "' does not exist.");
                    continue;
                }
                Trace.log1(this.getClass(), "collectUpgradePackageControlFiles (String anUpgradePackageToBeExcluded)", "Using the the file (from an UP that exists but not shall be deleted) " + file3.getAbsolutePath() + " since the .xml file didn't exist");
                vector2.addElement(file3);
                continue;
            }
            vector2.addElement(file3);
        }
        return vector2;
    }

    private void deleteConfigurationVersions(String string, CVsToDelete cVsToDelete) throws UpgradePackageDeleteNotAllowedException, UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteConfigurationVersions(String anUpgradePackageDocumentId, CVsToDelete aConfigurationVersionsToDelete)", "anUpgradePackageDocumentId: " + string + "\n\taConfigurationVersionsToDelete: " + cVsToDelete);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            if (cVsToDelete.getCVsDocID() != null && cVsToDelete.getCVsDocID().length > 0) {
                configurationVersionMO_HandlerInterface.deleteAllCVsRelatedToUpgradePackage(string);
            }
            configurationVersionMO_HandlerInterface.deleteCVs(cVsToDelete.getPreUpgradedCVs());
        }
        catch (AllRelatedCVsAreNotDeleteableException allRelatedCVsAreNotDeleteableException) {
            throw new UpgradePackageDeleteNotAllowedException("UpgradePackage", allRelatedCVsAreNotDeleteableException.toString());
        }
        catch (Exception exception) {
            throw new UpgradePackageDeleteException(exception);
        }
    }

    private void deleteItems(String string, String string2, String string3, CVsToDelete cVsToDelete, File file, File file2, UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, Vector vector) throws UpgradePackageDeleteNotAllowedException, UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteItems(String anUpgradePackageDocumentId ,String aDocumentNumber, String aDocumentRevision, CVsToDelete aConfigurationVersionsToDelete, File anUP_Directory, File anUpgradePackageControlFileToDelete, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, Vector aLoadModuleMOsToBeDeleted)anUpgradePackageDocumentId: " + string + "\n\taDocumentNumber: " + string2 + "\n\taDocumentRevision: " + string3 + "\n\taConfigurationVersionsToDelete: " + cVsToDelete + "\n\tanUP_Directory: " + file.getPath() + "\n\tanUpgradePackageControlFileToDelete: " + file2 + "\n\tanUpgradePackageLoadModuleFilesToBeDeleted: " + upgradePackageLoadModuleFileHolder + "\n\taLoadModuleMOsToBeDeleted: " + vector);
        }
        this.deleteConfigurationVersions(string, cVsToDelete);
        if (this.isSU_VersionSupported("SU_4")) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the load module files that are unique to this Upgrade Package (on C- and D- partition).");
            }
            this.deleteLoadModuleFilesOnBothPartitions(upgradePackageLoadModuleFileHolder.getMasterLoadModuleFilePaths(), upgradePackageLoadModuleFileHolder.getMasterSMFilePaths());
        } else {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the replicated load module files that are unique to this Upgrade Package.");
            }
            this.deleteReplicatedLoadModuleFiles(upgradePackageLoadModuleFileHolder.getReplicatedLoadModuleFilePaths());
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the load module files that are unique to this Upgrade Package.");
            }
            this.deleteLoadModuleFiles(upgradePackageLoadModuleFileHolder.getMasterLoadModuleFilePaths());
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the replicated SM files that are unique to this Upgrade Package.");
            }
            this.deleteReplicatedSMFiles(upgradePackageLoadModuleFileHolder.getReplicatedSMFilePaths());
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the SM files that are unique to this Upgrade Package.");
            }
            this.deleteSMFiles(upgradePackageLoadModuleFileHolder.getMasterSMFilePaths());
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the load module MOs that are unique to this Upgrade Package.");
        }
        this.deleteLoadModuleMOs(vector);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "deleteItems(...)", "Deleting the Upgrade Package data.");
        }
        this.deleteUpgradePackageDirectory(file, file2);
        VerificationTimerController.instance().stopVerificationTimer();
    }

    private boolean isSU_VersionSupported(String string) {
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            return SU_AccessVersionHandler.getInstance().isCurrentlySupported(string, (Object)osaSwInstallProxyAccess);
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "isSU_VersionSupported(SU_AccessVersion anSU_AccessVersion)", "Assuming that the requested version not is supported", sU_ConditionalException);
            return false;
        }
    }

    private void deleteLoadModuleFiles(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLoadModuleFiles( Vector aMasterLoadModuleFilePaths )", "aMasterLoadModuleFilePaths: " + vector);
        }
        if (vector == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Vector<Object> vector2 = new Vector<Object>();
            Vector<File> vector3 = new Vector<File>();
            for (int i = 0; i < vector.size(); ++i) {
                object3 = vector.elementAt(i).toString();
                object2 = (File)vector.elementAt(i);
                if (!((File)object2).isDirectory()) {
                    try {
                        if (!((File)object2).delete()) {
                            Trace.info(this.getClass(), "deleteLoadModuleFiles( Vector aMasterLoadModuleFilePaths )", "Failure when trying to delete the Load Module file '" + ((File)object2).getAbsolutePath() + "'.");
                        }
                    }
                    catch (Exception exception) {
                        Trace.error(this.getClass(), "deleteLoadModuleFiles( Vector aMasterLoadModuleFilePaths )", "Exception caught when trying to delete the file '" + ((File)object2).getAbsolutePath() + "'.", exception);
                    }
                    object = ((String)object3).substring(0, ((String)object3).lastIndexOf("/"));
                    if (((String)object).startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) && !((String)object).equals(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
                        vector3.addElement(new File((String)object));
                        continue;
                    }
                    if (!SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)this.mySystemUpgradeConstantsInterface) || !((String)object).startsWith(this.mySystemUpgradeConstantsInterface.getNodeSystemFilesRootPath()) || ((String)object).equals(this.mySystemUpgradeConstantsInterface.getNodeSystemFilesRootPath())) continue;
                    vector3.addElement(new File((String)object));
                    continue;
                }
                vector2.addElement(object2);
            }
            Enumeration enumeration = vector3.elements();
            object3 = null;
            while (enumeration.hasMoreElements()) {
                object3 = (File)enumeration.nextElement();
                this.deleteDirectoriesIfEmpty((File)object3);
            }
            object2 = vector2.elements();
            object = null;
            while (object2.hasMoreElements()) {
                object = (File)object2.nextElement();
                try {
                    this.deleteSubdirectoriesIfEmpty((File)object);
                }
                catch (Exception exception) {
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "Failed to delete a subdirectory from the root directory '" + ((File)object).getAbsolutePath() + "'. " + "Parts of the subdirectories may have been deleted.");
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteLoadModuleFiles( Vector aMasterLoadModuleFilePaths )", "Exception caught when trying to delete Load Modules (on C: drive).", exception);
        }
    }

    private void deleteSMFiles(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteSMFiles( Vector aMasterSMFilePaths )", "aMasterSMFilePaths: " + vector);
        }
        if (vector == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Vector<Object> vector2 = new Vector<Object>();
            Vector<File> vector3 = new Vector<File>();
            for (int i = 0; i < vector.size(); ++i) {
                object3 = vector.elementAt(i).toString();
                object2 = (File)vector.elementAt(i);
                if (!((File)object2).isDirectory()) {
                    try {
                        if (!((File)object2).delete()) {
                            Trace.info(this.getClass(), "deleteSMFiles( Vector aMasterSMFilePaths )", "Failure when trying to delete the SM file '" + ((File)object2).getAbsolutePath() + "'.");
                        }
                    }
                    catch (Exception exception) {
                        Trace.error(this.getClass(), "deleteSMFiles( Vector aMasterSMFilePaths )", "Exception caught when trying to delete the file '" + ((File)object2).getAbsolutePath() + "'.", exception);
                    }
                    object = ((String)object3).substring(0, ((String)object3).lastIndexOf("/"));
                    if (!((String)object).startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) || ((String)object).equals(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) continue;
                    vector3.addElement(new File((String)object));
                    continue;
                }
                vector2.addElement(object2);
            }
            Enumeration enumeration = vector3.elements();
            object3 = null;
            while (enumeration.hasMoreElements()) {
                object3 = (File)enumeration.nextElement();
                this.deleteDirectoriesIfEmpty((File)object3);
            }
            object2 = vector2.elements();
            object = null;
            while (object2.hasMoreElements()) {
                object = (File)object2.nextElement();
                try {
                    this.deleteSubdirectoriesIfEmpty((File)object);
                }
                catch (Exception exception) {
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "Failed to delete a subdirectory from the root directory '" + ((File)object).getAbsolutePath() + "'. " + "Parts of the subdirectories may have been deleted.");
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteLoadModuleFiles( Vector aMasterLoadModuleFilePaths )", "Exception caught when trying to delete Load Modules (on C: drive).", exception);
        }
    }

    private void deleteLoadModuleMOs(Vector vector) {
        block11: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteLoadModuleMOs(Vector aLoadModuleMOsToBeDeleted)", "aLoadModuleMOsToBeDeleted: " + vector);
            }
            if (vector != null) {
                Control control = null;
                Coordinator coordinator = null;
                try {
                    control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                    coordinator = control.getCoordinator();
                    for (int i = 0; i < vector.size(); ++i) {
                        ManagedObject managedObject = (ManagedObject)vector.elementAt(i);
                        try {
                            ((LoadModuleMoSU_Access)managedObject).deleteMO(coordinator);
                            continue;
                        }
                        catch (Exception exception) {
                            Trace.info(this.getClass(), "deleteLoadModuleMOs(Vector aLoadModuleMOsToBeDeleted)", "Exception caught when trying to delete a Load Module MO, Exception = " + exception);
                        }
                    }
                    control.getTerminator().commit();
                }
                catch (Exception exception) {
                    Trace.info(this.getClass(), "deleteLoadModuleMOs(Vector aLoadModuleMOsToBeDeleted)", "Exception caught when trying to delete Load Module MO:s, Exception = " + exception.toString());
                    if (control == null) break block11;
                    try {
                        if (control.getCoordinator().getStatus() == Status.ACTIVE) {
                            control.getTerminator().rollback();
                        }
                    }
                    catch (Exception exception2) {
                        Trace.error(this.getClass(), "deleteLoadModuleMOs(Vector aLoadModuleMOsToBeDeleted)", "Exception caught when trying to rollback an active transaction.", exception2);
                    }
                    catch (Error error) {
                        Trace.error(this.getClass(), "deleteLoadModuleMOs(Vector aLoadModuleMOsToBeDeleted)", "Error caught when trying to rollback an active transaction.", error);
                    }
                }
            }
        }
    }

    private void deleteReplicatedLoadModuleFiles(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteReplicatedLoadModuleFiles( Vector aReplicatedLoadModuleFilePath )", "aReplicatedLoadModuleFilePath: " + vector);
        }
        if (vector == null) {
            return;
        }
        try {
            Enumeration enumeration = vector.elements();
            String string = "";
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultReplicatedPath())) {
                    string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string3.substring(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath().length());
                } else if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath())) {
                    string2 = this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath() + string3.substring((this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath()).length());
                    string = this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath();
                    bl = true;
                } else if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + "systemfiles/ssw_trustedcerts/")) {
                    string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string3.substring(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath().length());
                    string = this.mySystemUpgradeConstantsInterface.getNodeSystemFilesRootPath();
                    bl = true;
                } else {
                    string2 = string3;
                }
                try {
                    this.sendDeleteRequest(string2);
                    if (!bl) continue;
                    this.deleteEmptySubDirectories(string2, string);
                    bl = false;
                }
                catch (Exception exception) {
                    Trace.info(this.getClass(), "deleteReplicatedLoadModuleFiles( Vector aReplicatedLoadModuleFilePath )", "Exception caught when trying to delete the replicated Load Module '" + string2 + "'." + " Exception = " + exception);
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteReplicatedLoadModuleFiles( Vector aReplicatedLoadModuleFilePath )", "Exception caught when trying to delete replicated Load Modules (on D: drives).", exception);
        }
    }

    private void deleteLoadModuleFilesOnBothPartitions(Vector vector, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLoadModuleFilesOnBothPartitions( Vector aLoadModuleFilePaths, Collection aLoadModuleSM_FilePaths)", "aLoadModuleFilePaths: " + vector + "\n\taLoadModuleSM_FilePaths: " + collection);
        }
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        try {
            File file;
            Iterator iterator;
            Collection collection2;
            Collection collection3;
            if (vector != null) {
                collection3 = this.findSubDirectoriesUndertftp(vector);
                collection2 = this.moveDirectoriesToEndOfList(collection3);
                iterator = collection2.iterator();
                file = null;
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    if (!file.isDirectory()) {
                        osaSwInstallProxyAccess.sendOsaSwInstallRemove2Req(file.getAbsolutePath());
                        continue;
                    }
                    if (!this.isEmptyDirectory(file)) continue;
                    osaSwInstallProxyAccess.sendOsaSwInstallRemove2Req(file.getAbsolutePath());
                }
            }
            if (collection != null) {
                collection3 = this.findSubDirectoriesUndertftp(collection);
                collection2 = this.moveDirectoriesToEndOfList(collection3);
                iterator = collection2.iterator();
                file = null;
                while (iterator.hasNext()) {
                    file = (File)iterator.next();
                    if (!file.isDirectory()) {
                        osaSwInstallProxyAccess.sendOsaSwInstallRemove2Req(file.getAbsolutePath());
                        continue;
                    }
                    if (!this.isEmptyDirectory(file)) continue;
                    osaSwInstallProxyAccess.sendOsaSwInstallRemove2Req(file.getAbsolutePath());
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteLoadModuleFilesOnBothPartitions( Vector aLoadModuleFilePaths )", "Throwable caught when trying to delete replicated Load Modules (on D: drives).", throwable);
        }
    }

    public Collection findSubDirectoriesUndertftp(Collection collection) throws SU_ConditionalException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "findSubDirectoriesUndertftp( Collection lmOrSmFilePaths )", "anlmOrSmFilePaths: " + collection);
        }
        File file = null;
        LinkedList linkedList = new LinkedList(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            String string = file.toString();
            String string2 = string.substring(0, string.lastIndexOf("/"));
            if (!string2.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) continue;
            this.addSubDirectories(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath(), string2, linkedList);
        }
        return linkedList;
    }

    public boolean isEmptyDirectory(File file) {
        String string;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isEmptyDirectory( File anlmOrSmPath )", "anlmOrSmPath: " + file);
        }
        if ((string = file.toString()).startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) && file.list().length == 0) {
            return true;
        }
        return !string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath());
    }

    public void addSubDirectories(String string, String string2, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addSubDirectories( String anRootPath,String anSubDir,Vector anAllLmOrSmFilePaths)", "anRootPath: " + string + "\n\tanSubDir" + string2 + "\n\tanAllLmOrSmFilePaths" + collection);
        }
        boolean bl = true;
        while (bl) {
            if (string2.startsWith(string) && !string2.equals(string)) {
                File file = new File(string2);
                boolean bl2 = collection.contains(file);
                if (bl2) {
                    collection.remove(file);
                }
                collection.add(file);
                string2 = string2.substring(0, string2.lastIndexOf("/"));
                continue;
            }
            bl = false;
        }
    }

    private Collection moveDirectoriesToEndOfList(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "moveDirectoriesToEndOfList(Collection anLM_OrSM_FilePaths)", "anLM_OrSM_FilePaths: " + collection);
        }
        Iterator iterator = collection.iterator();
        File file = null;
        LinkedList<File> linkedList = new LinkedList<File>();
        LinkedList<File> linkedList2 = new LinkedList<File>();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (!file.isDirectory()) {
                linkedList.add(file);
                continue;
            }
            linkedList2.add(file);
        }
        linkedList.addAll(linkedList2);
        return linkedList;
    }

    private void deleteReplicatedSMFiles(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteReplicatedSMFiles( Vector aReplicatedSMFilePath )", "aReplicatedSMFilePath: " + vector);
        }
        if (vector == null) {
            return;
        }
        try {
            Enumeration enumeration = vector.elements();
            String string = "";
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultReplicatedPath())) {
                    string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string3.substring(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath().length());
                    string = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath();
                } else if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath())) {
                    string2 = this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath() + string3.substring((this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath()).length());
                    string = this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath();
                    bl = true;
                } else {
                    string2 = string3;
                }
                try {
                    this.sendDeleteRequest(string2);
                    if (!bl) continue;
                    this.deleteEmptySubDirectories(string2, string);
                    bl = false;
                }
                catch (Exception exception) {
                    Trace.info(this.getClass(), "deleteReplicatedSMFiles( Vector aReplicatedSMFilePath )", "Exception caught when trying to delete the replicated SM '" + string2 + "'." + " Exception = " + exception);
                }
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteReplicatedSMFiles( Vector aReplicatedSMFilePath )", "Exception caught when trying to delete replicated SM (on D: drives).", exception);
        }
    }

    private void deleteEmptySubDirectories(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteEmptySubDirectories(String theReplicatedLoadModuleFilePathString, String aRootPath )", "theReplicatedLoadModuleFilePathString: " + string + "\n\taRootPath: " + string2);
        }
        String string3 = null;
        try {
            File file;
            if (string.startsWith(string2) && !(string3 = string.substring(0, string.lastIndexOf("/") + 1)).equals(string2) && (file = new File(string3)).isDirectory()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "deleteEmptySubDirectories(String theReplicatedLoadModuleFilePathString)", "delete the tar file directory: " + string3);
                }
                this.sendDeleteRequest(string3);
                string3 = string3.substring(0, string3.lastIndexOf(file.getName()));
                if (!string3.equals(string2)) {
                    this.deleteEmptySubDirectories(string3, string2);
                }
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteEmptySubDirectories(String theReplicatedLoadModuleFilePathString)", "Throwable caught when trying to delete tar file directory : " + string3 + throwable);
        }
    }

    private void sendDeleteRequest(String string) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendDeleteRequest(String theReplicatedLoadModuleFilePathString)", "theReplicatedLoadModuleFilePathString: " + string);
        }
        InstallRemoveResultInformation installRemoveResultInformation = this.sendSignalOsaSwInstallRemoveReq(string);
        if (installRemoveResultInformation.result != 1) {
            Trace.error(this.getClass(), "sendDeleteRequest(String theReplicatedLoadModuleFilePathString)", "Failure when trying to delete the replicated Load Module '" + string + "'." + "\n\tResult code: " + installRemoveResultInformation.result);
        }
    }

    private void deleteUpgradePackageDirectory(File file, File file2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteUpgradePackageDirectory(File anUP_Directory)");
        }
        if (file != null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteUpgradePackageDirectory(File anUP_Directory)", "anUP_Directory: " + file.getPath());
            }
            try {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file3 = file.getAbsolutePath().endsWith("/") ? new File(file.getAbsolutePath() + stringArray[i]) : new File(file.getAbsolutePath() + "/" + stringArray[i]);
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "deleteUpgradePackageDirectory(File anUP_Directory)", "OneFilePath:" + file3.getAbsolutePath());
                    }
                    if (file3.getAbsolutePath().endsWith("/")) {
                        this.deleteSubdirectoriesIfEmpty(file3);
                        continue;
                    }
                    if (!file3.exists() || file3.delete()) continue;
                    Trace.error(this.getClass(), "deleteUpgradePackageDirectory(File anUP_Directory)", "Failure when trying to delete file '" + file3.getPath() + ".");
                }
                String[] stringArray2 = file.list();
                if (stringArray2.length == 0) {
                    if (!file.delete()) {
                        Trace.info(this.getClass(), "deleteUpgradePackageDirectory(File anUP_Directory)", "Not possible to delete the empty directory '" + file.getAbsolutePath() + "'. This is a known fault in the Java Virtual Machine. " + "See trouble report 'WRNaa48612' for more information.");
                    }
                } else {
                    Trace.info(this.getClass(), "deleteUpgradePackageDirectory(File anUP_Directory)", "Failure when trying to delete the Upgrade Package directory '" + file.getAbsolutePath() + "'.");
                }
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "deleteUpgradePackageDirectory(File anUP_Directory)", "Exception caught when trying to delete the upgrade package control file in the Upgrade Package directory '" + file.getAbsolutePath() + "' or the directory itself.", exception);
            }
        }
    }

    public Collection collectLMsDataThatMayBeDeleted(String string, DocumentObjectProxyInterface documentObjectProxyInterface, String string2, String string3) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLMsDataThatMayBeDeleted(String anUP_UCF_Path, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "anUP_UCF_Path: " + string + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        try {
            int n = string.lastIndexOf(47);
            String string4 = string.substring(n + 1);
            this.verifyControlFileValidAndMoreThanOneUP_Exists(string4, new File(string));
            LoadModulesToBeDeletedAnalyser loadModulesToBeDeletedAnalyser = new LoadModulesToBeDeletedAnalyser();
            Collection collection = loadModulesToBeDeletedAnalyser.collectLMsDataThatMayBeDeleted(documentObjectProxyInterface, string2, string3);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectLMsDataThatMayBeDeleted(String anUP_UCF_Path, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "RETURNS - theNotRequiredLoadModuleInformations: " + collection);
            }
            return collection;
        }
        catch (UpgradePackageDeleteException upgradePackageDeleteException) {
            throw upgradePackageDeleteException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLMsDataThatMayBeDeleted(String anUP_UCF_Path, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "anUP_UCF_Path: " + string + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3, throwable);
            throw new UpgradePackageDeleteException(throwable.toString());
        }
    }

    private void doDeleteUpgradePackageItems(DeleteRequestEvent deleteRequestEvent) throws ActionNotAllowedException, UpgradePackageDeleteNotAllowedException, UpgradePackageDeleteException, UpgradePackageFileSystemErrorException, MoAccessException {
        Vector vector;
        UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder;
        File file;
        File file2;
        CVsToDelete cVsToDelete;
        block9: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "doDeleteUpgradePackageItems(DeleteRequestEvent aDeleteRequestEvent)", "aDeleteRequestEvent: " + deleteRequestEvent);
            }
            cVsToDelete = null;
            file2 = null;
            file = null;
            upgradePackageLoadModuleFileHolder = new UpgradePackageLoadModuleFileHolder();
            vector = new Vector();
            try {
                int n = deleteRequestEvent.getUpgradePackageUCF_Path().lastIndexOf(47);
                String string = deleteRequestEvent.getUpgradePackageUCF_Path().substring(0, n + 1);
                String string2 = deleteRequestEvent.getUpgradePackageUCF_Path().substring(n + 1);
                if (this.upgradePackageDirectoryIsUsedByOnlyOneMO(deleteRequestEvent.getUpgradePackageUCF_Path())) {
                    cVsToDelete = this.getConfigurationVersionsToDelete(deleteRequestEvent.getUpDocumentID());
                    file2 = this.getUpgradePackageDirectory(string);
                    file = this.getUpgradePackageControlFile(deleteRequestEvent.getUpgradePackageUCF_Path());
                    if (file != null) {
                        this.verifyControlFileValidAndMoreThanOneUP_Exists(string2, file);
                        LoadModulesToBeDeletedAnalyser loadModulesToBeDeletedAnalyser = new LoadModulesToBeDeletedAnalyser();
                        LoadModuleMOsAndFilesToBeDeleted loadModuleMOsAndFilesToBeDeleted = loadModulesToBeDeletedAnalyser.collectLoadModuleMOsAndFilesToBeDeleted(string2, file, deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision());
                        upgradePackageLoadModuleFileHolder = loadModuleMOsAndFilesToBeDeleted.getLoadModuleFilesToBeDeleted();
                        vector = loadModuleMOsAndFilesToBeDeleted.getLoadModuleMOsToBeDeleted();
                    }
                    break block9;
                }
                Trace.info(this.getClass(), "deleteUpgradePackageItems(String anUpgradePackageMO_LocalDistinguishedName, String anUpgradePackageDocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, String anUpgradePackageControlFilePath)", "\nMore than one Upgrade Package MO are connected to the same Upgrade Package Control File (UCF). \nOnly the Upgrade Package MO will be deleted.\nAny upgrade package files, configuration versions, loadmodule files or load module MO's will be deleted when only one UP MO points to the same UCF.");
                this.printItemsToDelete(deleteRequestEvent.getUP_MoLdn(), deleteRequestEvent.getUpDocumentID(), deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), cVsToDelete, file2, file, upgradePackageLoadModuleFileHolder, vector);
                this.unlock();
                return;
            }
            catch (MoAccessException moAccessException) {
                this.unlock();
                throw moAccessException;
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "deleteUpgradePackageItems(String anUpgradePackageMO_LocalDistinguishedName, String anUpgradePackageDocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, String anUpgradePackageControlFilePath)", " Exception caught when trying to collect items to be deleted", exception);
                this.unlock();
                throw new UpgradePackageDeleteException(exception);
            }
        }
        try {
            this.deleteItems(deleteRequestEvent.getUpDocumentID(), deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), cVsToDelete, file2, file, upgradePackageLoadModuleFileHolder, vector);
        }
        catch (MoAccessException moAccessException) {
            this.unlock();
            throw moAccessException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteUpgradePackageItems(String anUpgradePackageMO_LocalDistinguishedName, String anUpgradePackageDocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, String anUpgradePackageControlFilePath)", " Exception caught when trying to delete items to be deleted", exception);
            this.unlock();
            throw new UpgradePackageDeleteException(exception);
        }
        this.printItemsToDelete(deleteRequestEvent.getUP_MoLdn(), deleteRequestEvent.getUpDocumentID(), deleteRequestEvent.getUpgradePackageDocumentNumber(), deleteRequestEvent.getUpgradePackageDocumentRevision(), cVsToDelete, file2, file, upgradePackageLoadModuleFileHolder, vector);
        this.unlock();
    }

    private Vector extractUPsBasedOnIndicatedUP_fromMO(UpgradePackageMoImpl upgradePackageMoImpl, String string, String string2) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "extractUPsBasedOnIndicatedUP_fromMO(UpgradePackageMoImpl anUpgradePackageMO, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "anUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanUP_ProductDataNumber: " + string + "\n\tanUP_ProductDataRevision: " + string2);
        }
        try {
            Struct[] structArray = upgradePackageMoImpl.getBasedOnUpgradePackages(null);
            boolean bl = false;
            Vector<Struct> vector = new Vector<Struct>(0);
            for (int i = 0; i < structArray.length; ++i) {
                if (bl) {
                    vector.addElement(structArray[i]);
                    continue;
                }
                if (!((String)structArray[i].getValue("productNumber")).equals(string) || !((String)structArray[i].getValue("productRevision")).equals(string2)) continue;
                bl = true;
            }
            if (bl) {
                vector.addElement(upgradePackageMoImpl.getAdministrativeDataAsBasedOnUpgradePackagesElement(null));
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "extractUPsBasedOnIndicatedUP_fromMO(UpgradePackageMoImpl anUpgradePackageMO, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Returns theExtractedUPs: " + vector);
            }
            return vector;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "extractUPsBasedOnIndicatedUP_fromMO(UpgradePackageMoImpl anUpgradePackageMO, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Exception caught when trying to extract UPs based on indicated UP from an UP MO,\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanUP_ProductDataNumber: " + string + "\n\tanUP_ProductDataRevision: " + string2, exception);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\textractUPsBasedOnIndicatedUP_fromMO(UpgradePackageMoImpl anUpgradePackageMO, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tException caught when trying to extract UPs based on indicated UP from an UCF," + "\n\tanUpgradePackageMO: " + upgradePackageMoImpl + "\n\tanUP_ProductDataNumber: " + string + "\n\tanUP_ProductDataRevision: " + string2, exception);
        }
    }

    private CVsToDelete getConfigurationVersionsToDelete(String string) throws UpgradePackageDeleteNotAllowedException, UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConfigurationVersionsToDelete(String anUpgradePackageDocumentId)", "anUpgradePackageDocumentId : " + string);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string);
            if (!upgradePackageRelatedCVsDataContainer.allCVsAreDeleteable()) {
                throw new UpgradePackageDeleteNotAllowedException("UpgradePackage", "getConfigurationVersionsToDelete(String anUpgradePackageDocumentId)\n\tDeletion all CVs related to the Upgrade Package is NOT allowed, at least one CV is NOT deletable.\n\tanUpgradePackageDocumentId: " + string);
            }
            Collection collection = CV_PreUpgradeRelationHandler.getInstance().getPreUpgradedCVsForUP(string);
            CVsToDelete cVsToDelete = new CVsToDelete(upgradePackageRelatedCVsDataContainer.getDeleteableCVs(), collection);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getConfigurationVersionsToDelete(String anUpgradePackageDocumentId)", "RETURNS - theCVsToDelete: " + cVsToDelete);
            }
            return cVsToDelete;
        }
        catch (UpgradePackageDeleteNotAllowedException upgradePackageDeleteNotAllowedException) {
            throw upgradePackageDeleteNotAllowedException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getConfigurationVersionsToDelete(String anUpgradePackageDocumentId)", "Retrieval of CV data for Upgrade Package failed,\n\tanUpgradePackageDocumentId: " + string + "Upgrade Package Path: " + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string.replace('/', '%').replace('\\', '%'), exception);
            throw new UpgradePackageDeleteException(exception);
        }
    }

    private File getUpgradePackageControlFile(String string) {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageControlFile(String aControlFilePath)", "aControlFilePath: " + string);
        }
        if ((file = new File(string)).exists()) {
            return file;
        }
        file = new File(string + "Original");
        if (file.exists()) {
            Trace.log1(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "Using the UCF file (from UP to be deleted) " + file.getAbsoluteFile() + " since the .xml file is missing");
            return file;
        }
        return null;
    }

    private File getUpgradePackageDirectory(String string) {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageDirectory(String aDirectoryPath)", "aDirectoryPath: " + string);
        }
        if ((file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    private synchronized Struct[] getUPsBasedOnIndicatedUP(String string, String string2, String string3) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUPsBasedOnIndicatedUP(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "anUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3);
        }
        Vector vector = new Vector(0);
        try {
            UpgradePackageMoImpl upgradePackageMoImpl = null;
            Vector vector2 = null;
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null || upgradePackageMoImpl.getUpgradePackageDocumentId(null).equals(string) || !upgradePackageMoImpl.getTypeOfUpgradePackage(null).equals("Delta") || (vector2 = this.extractUPsBasedOnIndicatedUP_fromMO(upgradePackageMoImpl, string2, string3)).size() <= vector.size()) continue;
                    vector = vector2;
                }
            }
            Object[] objectArray = new Struct[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getUPsBasedOnIndicatedUP(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)", "Exception caught when trying get UPs based on indicated UP,\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
            throw new UpgradePackageDeleteException("Class name: " + this.getClass().getName() + "\n\tgetUPsBasedOnIndicatedUP(String anUpgradePackageDocumentId, String anUP_ProductDataNumber, String anUP_ProductDataRevision)" + "\n\tException caught when trying get UPs based on indicated UP," + "\n\tanUpgradePackageDocumentId: " + string + "\n\tanUP_ProductDataNumber: " + string2 + "\n\tanUP_ProductDataRevision: " + string3, exception);
        }
    }

    private synchronized boolean lock() {
        if (this.isBusy) {
            return false;
        }
        this.isBusy = true;
        return true;
    }

    private boolean printable(String string, String string2) {
        boolean bl;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printable ( String anItemsRemovedFilePath, String anUP_DocumentId )", "anItemsRemovedFilePath: " + string + "\n\tanUP_DocumentId: " + string2);
        }
        try {
            File file = new File(this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath());
            if (file.exists()) {
                if (file.isDirectory()) {
                    bl = true;
                } else {
                    Trace.error(this.getClass(), "printable ( String anItemsRemovedFilePath, String anUP_DocumentId )", "During removal of items for Upgrade Package '" + string2 + "' it was not possible to report what should have been removed due to existance of a file named '" + this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "'." + "\nThe report should have been written to file '" + string + "'.");
                    bl = false;
                }
            } else if (file.mkdir()) {
                bl = true;
            } else {
                Trace.error(this.getClass(), "printable ( String anItemsRemovedFilePath, String anUP_DocumentId )", "During removal of items for Upgrade Package '" + string2 + "' it was not possible to create the directory '" + this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "'." + "\nThe report should have been written to file '" + string + "'.");
                bl = false;
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "printable ( String anItemsRemovedFilePath, String anUP_DocumentId )", "During removal of items for Upgrade Package '" + string2 + "' it was not possible to create the directory '" + this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "'." + "\nThe report should have been written to file '" + string + "'.", exception);
            bl = false;
        }
        return bl;
    }

    private void printConfigurationVersions(PrintStream printStream, String string, CVsToDelete cVsToDelete) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printConfigurationVersions(PrintStream aPrintStream, String aOneTab, CVsToDelete aConfigurationVersionsToDelete)", "aPrintStream: " + printStream + "\n\taOneTab: " + string);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printConfigurationVersions(PrintStream aPrintStream, String aOneTab, CVsToDelete aConfigurationVersionsToDelete)", "aConfigurationVersionsToDelete: " + cVsToDelete);
        }
        printStream.println(string + "<!-- Deleted Configuration Versions -->");
        if (!cVsToDelete.isAnyCVs()) {
            printStream.println();
            return;
        }
        String[] stringArray = cVsToDelete.getCVsDocID();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                printStream.println(string + "<" + "ConfigurationVersion");
                printStream.println(string + string + "name" + "=\"" + stringArray[i] + "\"");
                printStream.println(string + "/>");
                printStream.println();
            }
        }
        Iterator iterator = cVsToDelete.getPreUpgradedCVs().iterator();
        while (iterator.hasNext()) {
            printStream.println(string + "<" + "ConfigurationVersion");
            printStream.println(string + string + "name" + "=\"" + (String)iterator.next() + "\"");
            printStream.println(string + "/>");
            printStream.println();
        }
    }

    private void printHeaderAndRootElementStart(PrintStream printStream) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printHeaderAndRootElementStart(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        printStream.println();
        printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printStream.println("<!DOCTYPE RemovedUpgradePackageItems>");
        printStream.println("<!--DOCTYPE RemovedUpgradePackageItems SYSTEM \"file:///c/java/RemovedUpgradePackageItems.dtd\"-->");
        printStream.println();
        printStream.println("<RemovedUpgradePackageItems>");
        printStream.println();
    }

    private void printIdAndDirectory(PrintStream printStream, String string, String string2, File file, File file2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printIdAndDirectory(PrintStream aPrintStream, String aOneTab, String anUP_DocumentId, File anUP_Directory)", "aPrintStream: " + printStream + "\n\taOneTab: " + string + "\n\tanUP_DocumentId: " + string2);
        }
        if (file != null && Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printIdAndDirectory(PrintStream aPrintStream, String aOneTab, String anUP_DocumentId, File anUP_Directory)", "anUP_Directory: " + file.getPath());
        }
        if (file2 != null && Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printIdAndDirectory(PrintStream aPrintStream, String aOneTab, String anUP_DocumentId, File anUP_Directory)", "anUpgradePackageControlFileToDelete: " + file2.getPath());
        }
        printStream.println(string + "<!-- Upgrade Package id and directory with control file -->");
        printStream.println(string + "<" + "UpgradePackageInformation" + ">");
        printStream.println(string + string + "documentId" + "=\"" + string2 + "\"");
        if (file != null) {
            printStream.println(string + string + "pathName" + "=\"" + file + "\"");
            printStream.println();
            printStream.println(string + string + "<" + "UpgradePackageFile" + ">");
            if (file2 != null) {
                printStream.println(string + string + string + "filePathName" + "=\"" + file2.getPath() + "\"");
            } else {
                printStream.println(string + string + string + "filePathName" + "=\"" + "UCF_NotFound" + "\"");
            }
            printStream.println(string + string + "</" + "UpgradePackageFile" + ">");
        }
        printStream.println();
        printStream.println(string + "</" + "UpgradePackageInformation" + ">");
        printStream.println();
    }

    private void printItemsToDelete(String string, String string2, String string3, String string4, CVsToDelete cVsToDelete, File file, File file2, UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, Vector vector) {
        String string5;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printItemsToDelete(String anUpgradePackageMO_LocalDistinguishedName, String anUP_DocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, CVsToDelete aConfigurationVersionsToDelete, File anUP_Directory, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, Vector aLoadModuleMOsToBeDeleted )", "anUpgradePackageMO_LocalDistinguishedName: " + string + "\n\tanUP_DocumentId: " + string2 + "\n\tanUpgradePackageProductNumber: " + string3 + "\n\tanUpgradePackageProductRevision: " + string4 + "\n\taConfigurationVersionsToDelete: " + cVsToDelete + "\n\tanUP_Directory: " + file + "\n\tanUpgradePackageLoadModuleFilesToBeDeleted: " + upgradePackageLoadModuleFileHolder + "\n\taLoadModuleMOsToBeDeleted: " + vector);
        }
        if (!this.printable(string5 = this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "RemovedUpgradePackageItems" + ".xml", string2)) {
            return;
        }
        PrintStream printStream = null;
        File file3 = new File(string5);
        String string6 = "   ";
        try {
            printStream = new PrintStream(new FileOutputStream(file3));
            this.printHeaderAndRootElementStart(printStream);
            this.printIdAndDirectory(printStream, string6, string2, file, file2);
            this.printUpgradePackageMO(printStream, string6, string, string3, string4);
            this.printConfigurationVersions(printStream, string6, cVsToDelete);
            this.printLoadModuleMOs(printStream, string6, vector);
            this.printLoadModuleFiles(printStream, string6, upgradePackageLoadModuleFileHolder.getMasterLoadModuleFilePaths(), upgradePackageLoadModuleFileHolder.getMasterSMFilePaths());
            this.printReplicatedLoadModuleFiles(printStream, string6, upgradePackageLoadModuleFileHolder.getReplicatedLoadModuleFilePaths(), upgradePackageLoadModuleFileHolder.getReplicatedSMFilePaths());
            this.printRootElementEnd(printStream);
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            Trace.info(this.getClass(), "printItemsToDelete(String anUpgradePackageMO_LocalDistinguishedName, String anUP_DocumentId, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, String[ ] aConfigurationVersionsToDelete, File anUP_Directory, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, Vector aLoadModuleMOsToBeDeleted )", "Exception caught when trying to write to file: " + string5 + ",  Exception = " + exception);
            try {
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void printLoadModuleFiles(PrintStream printStream, String string, Vector vector, Vector vector2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printLoadModuleFiles(PrintStream aPrintStream, String aOneTab, Vector aMasterLoadModuleFilePaths, Vector aMasterSMFilePaths)", "aPrintStream: " + printStream + "\n\taOneTab: " + string + "\n\taMasterLoadModuleFilePaths: " + vector);
        }
        printStream.println(string + "<!-- Deleted Load module files (C drive) -->");
        if (vector != null && vector.size() > 0) {
            File file;
            int n;
            printStream.println(string + "<" + "LoadModules" + ">");
            for (n = 0; n < vector.size(); ++n) {
                file = (File)vector.elementAt(n);
                printStream.println(string + string + "<" + "LoadModule");
                printStream.println(string + string + string + "filePathName" + "=\"" + file.getAbsolutePath() + "\"");
                printStream.println(string + string + "/>");
                printStream.println();
            }
            for (n = 0; n < vector2.size(); ++n) {
                file = (File)vector2.elementAt(n);
                printStream.println(string + string + "<" + "InstallSM");
                printStream.println(string + string + string + "filePathName" + "=\"" + file.getAbsolutePath() + "\"");
                printStream.println(string + string + "/>");
                printStream.println();
            }
            printStream.println(string + "</" + "LoadModules" + ">");
            printStream.println();
        } else {
            printStream.println();
        }
    }

    private void printLoadModuleMOs(PrintStream printStream, String string, Vector vector) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printLoadModuleMOs(PrintStream aPrintStream, String aOneTab, Vector aLoadModuleMOsToBeDeleted)", "aPrintStream: " + printStream + "\n\taOneTab: " + string + "\n\taLoadModuleMOsToBeDeleted: " + vector);
        }
        printStream.println(string + "<!-- Deleted Load Module MOs -->");
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                LoadModuleMoSU_Access loadModuleMoSU_Access = (LoadModuleMoSU_Access)vector.elementAt(i);
                printStream.println(string + "<" + "LoadModuleMO");
                printStream.println(string + string + "DistinguishedName" + "=\"" + loadModuleMoSU_Access.getLocalDistinguishedName() + "\"");
                printStream.println(string + string + "productNumber" + "=\"" + loadModuleMoSU_Access.getProductNumber(null) + "\"");
                printStream.println(string + string + "productRevision" + "=\"" + loadModuleMoSU_Access.getProductRevision(null) + "\"");
                printStream.println(string + "/>");
                printStream.println();
            }
        } else {
            printStream.println();
        }
    }

    private void printReplicatedLoadModuleFiles(PrintStream printStream, String string, Vector vector, Vector vector2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printReplicatedLoadModuleFiles(PrintStream aPrintStream, String aOneTab, Vector aReplicatedLoadModuleFilePath, Vector aReplicatedSMFilePath)", "\taPrintStream: " + printStream + "\n\taOneTab: " + string + "\n\taReplicatedLoadModuleFilePath: " + vector);
        }
        printStream.println(string + "<!-- Deleted replicated load module files (D drive) -->");
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        if (vector != null && vector.size() > 0) {
            String string2;
            printStream.println(string + "<" + "ReplicatedLoadModules" + ">");
            printStream.println();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                printStream.println(string + string + "<" + "LoadModule");
                printStream.println(string + string + string + "filePathName" + "=\"" + string2 + "\"");
                printStream.println(string + string + "/>");
                printStream.println();
            }
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                printStream.println(string + string + "<" + "InstallSM");
                printStream.println(string + string + string + "filePathName" + "=\"" + string2 + "\"");
                printStream.println(string + string + "/>");
                printStream.println();
            }
            printStream.println(string + "</" + "ReplicatedLoadModules" + ">");
            printStream.println();
        } else {
            printStream.println();
        }
    }

    private void printRootElementEnd(PrintStream printStream) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printRootElementEnd(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        printStream.println("</RemovedUpgradePackageItems>");
    }

    private void printUpgradePackageMO(PrintStream printStream, String string, String string2, String string3, String string4) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printUpgradePackageMO(PrintStream aPrintStream, String aOneTab, String anUpgradePackageMO_LocalDistinguishedName, String anUpgradePackageProductNumber, String anUpgradePackageProductRevision)", "aPrintStream: " + printStream + "\n\taOneTab: " + string + "\n\tanUpgradePackageMO_LocalDistinguishedName: " + string2 + "\n\tanUpgradePackageProductNumber: " + string3 + "\n\tanUpgradePackageProductRevision: " + string4);
        }
        printStream.println(string + "<!-- Delete Upgrade Package MO -->");
        printStream.println(string + "<" + "UpgradePackageMO");
        printStream.println(string + string + "DistinguishedName" + "=\"" + string2 + "\"");
        printStream.println(string + string + "productNumber" + "=\"" + string3 + "\"");
        printStream.println(string + string + "productRevision" + "=\"" + string4 + "\"");
        printStream.println(string + "/>");
        printStream.println();
    }

    private InstallRemoveResultInformation sendSignalOsaSwInstallRemoveReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalOsaSwInstallRemoveReq(String aReplicatedLoadModuleFilePath)", "aReplicatedLoadModuleFilePath: " + string);
        }
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        InstallRemoveResultInformation installRemoveResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallRemoveReq(string);
        return installRemoveResultInformation;
    }

    private synchronized boolean unlock() {
        this.isBusy = false;
        return true;
    }

    private boolean upgradePackageDirectoryIsUsedByOnlyOneMO(String string) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "upgradePackageDirectoryIsUsedByOnlyOneMO(String anUpgradePackageControlFilePath)", "anUpgradePackageControlFilePath: " + string);
        }
        UpgradePackageMoImpl upgradePackageMoImpl = null;
        try {
            int n = 0;
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    String string2;
                    upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (upgradePackageMoImpl == null || !(string2 = upgradePackageMoImpl.getUpgradeControlFilePath(null)).equals(string) || ++n != 2) continue;
                    return false;
                }
            }
            return true;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "upgradePackageDirectoryIsUsedByOnlyOneMO(String anUpgradePackageControlFilePath),", "Exception caught when trying to retreive the UpgradeControlFilePath attribute for an UP MOtheUpgradePackageMO: " + upgradePackageMoImpl, moAccessException);
            throw new UpgradePackageDeleteException(moAccessException);
        }
    }

    private void deleteSubdirectoriesIfEmpty(File file) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteSubdirectoriesIfEmpty ( File anAbsoluteDirectoryPathName )", "anAbsoluteDirectoryPathName: " + SuLib.toString(file));
        }
        if (!file.isDirectory()) {
            throw new UpgradePackageDeleteException("The assumed directory '" + file.getPath() + "' is not a directory.");
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (file.getAbsolutePath().endsWith("/")) {
                this.deleteSubdirectoriesIfEmpty(new File(file.getAbsolutePath() + stringArray[i]));
                continue;
            }
            this.deleteSubdirectoriesIfEmpty(new File(file.getAbsolutePath() + "/" + stringArray[i]));
        }
        stringArray = file.list();
        if (stringArray.length == 0) {
            if (!file.delete()) {
                Trace.info(this.getClass(), "deleteSubdirectoriesIfEmpty ( File anAbsoluteDirectoryPathName )", "Not possible to delete the empty directory '" + file.getAbsolutePath() + "'. This is a known fault in the Java Virtual Machine. " + "See trouble report 'WRNaa48612' for more information.");
                throw new UpgradePackageDeleteException("Not possible to delete the empty directory '" + file.getAbsolutePath() + "'. This is a known fault in the Java Virtual Machine. " + "See trouble report 'WRNaa48612' for more information.");
            }
        } else {
            String string = "[ ";
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = i == stringArray.length - 1 ? string + stringArray[i] + " ]" : string + stringArray[i] + ", ";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.info(this.getClass(), "deleteSubdirectoriesIfEmpty ( File anAbsoluteDirectoryPathName )", "Failure when trying to delete the directory '" + file.getAbsolutePath() + "'." + " due to it contains the files/ directories: " + string + ".");
            throw new UpgradePackageDeleteException("The directory '" + file.getPath() + "' was not possible to delete due to it contains unexpected files or directories.");
        }
    }

    private void deleteDirectoriesIfEmpty(File file) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deletedirectoriesIfEmpty ( File anAbsoluteDirectoryPathName )", "anAbsoluteDirectoryPathName: " + SuLib.toString(file));
        }
        if (file.list().length == 0) {
            if (!file.delete()) {
                Trace.info(this.getClass(), "deleteSubdirectoriesIfEmpty ( File anAbsoluteDirectoryPathName )", "Not possible to delete the empty directory '" + file.getAbsolutePath() + "'. This is a known fault in the Java Virtual Machine. " + "See trouble report 'WRNaa48612' for more information.");
                throw new UpgradePackageDeleteException("Not possible to delete the empty directory '" + file.getAbsolutePath() + "'. This is a known fault in the Java Virtual Machine. " + "See trouble report 'WRNaa48612' for more information.");
            }
            String string = file.getPath();
            if (!(string = string.substring(0, string.lastIndexOf(file.getName()))).equals(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
                this.deleteDirectoriesIfEmpty(new File(string));
            }
        }
    }

    private void verifyControlFileValidAndMoreThanOneUP_Exists(String string, File file) throws UpgradePackageDeleteException, UpgradePackageFileSystemErrorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyControlFileValidAndMoreThanOneUP_Exists(String aControlFileName, File aControlFile)", "aControlFileName: " + string + "\n\taControlFile: " + file.getPath());
        }
        if (file == null) {
            Trace.error(this.getClass(), "verifyControlFileValidAndMoreThanOneUP_Exists(String aControlFileName, File aControlFile)", "The input parameter 'aCOntrolFile' was set to 'null'. Couldn't continue\taControlFileName: " + string);
            throw new UpgradePackageDeleteException("Illegal input data 'aControlFile' i.e. the upgrade control file to be deleted: " + file);
        }
        String string2 = null;
        if (string == null || !string.endsWith(".xml")) {
            Trace.error(this.getClass(), "verifyControlFileValidAndMoreThanOneUP_Exists(String aControlFileName, File aControlFile)", "Could not create the upgrade package directory from the input parameter aControlFileName.\taControlFileName: " + string);
            throw new UpgradePackageDeleteException("Illegal input data 'aControlFileName' i.e. the name of the upgrade control file: " + string);
        }
        int n = string.lastIndexOf(46);
        string2 = string.substring(0, n);
        Vector vector = this.collectUpgradePackageControlFiles(string2);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "verifyControlFileValidAndMoreThanOneUP_Exists(String aControlFileName, File aControlFile)", "\n\tOther existing Upgrade Package Control Files: " + vector);
        }
        if (vector.isEmpty()) {
            Trace.info(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "The upgrade package '" + string + "' is the only one that exist. " + "To be able to delete an upgrade package at least two upgrade packages must exist.");
            throw new UpgradePackageDeleteException("The upgrade package '" + string + "' is the only one that exist. " + "To be able to delete an upgrade package at least two upgrade packages must exist.");
        }
    }
}

