/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.FilepathHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.swinstall.UpgradeStatusHolder;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallListResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM_FTP_TransferModeValue;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_LoaderNameValue;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallSMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.InstallLM_Container;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.install.CancelInstallRequestException;
import se.ericsson.cello.upgradepackage.install.FileInstallerNotifier;
import se.ericsson.cello.upgradepackage.install.InstallCoordinator;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesCancelledException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesTimeOutException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedFTP_ServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedGetLoadModuleFileException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedIP_AddressException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedInsufficientDiskSpaceException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedLoadListFileException;
import se.ericsson.cello.upgradepackage.install.event.FTP_ServerInformation;
import se.ericsson.cello.upgradepackage.install.event.InstallCancelledEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallFailedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallFinishedEvent;
import se.ericsson.cello.upgradepackage.install.event.LoadModuleInstalledEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.DownloadLMsProgressInformation;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerException;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class FileInstaller {
    private Vector myLoadModulFilesToBeInstalled = new Vector();
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
    private String myTemporaryUpgradeControlFilePath = this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath() + "ftpget.xml";
    private InstallCoordinator myInstallCoordinator;
    private FileInstallerNotifier myFileInstallerNotifier = null;
    private static final String DOT = ".";

    public FileInstaller(InstallCoordinator installCoordinator) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "FileInstaller(InstallCoordinator anInstallCoordinator)", "anInstallCoordinator: " + installCoordinator);
        }
        this.myInstallCoordinator = installCoordinator;
    }

    public FileInstaller(String string) {
        this.myTemporaryUpgradeControlFilePath = string;
    }

    public FileInstallerNotifier installLoadModules(File file, ProductDataContainer productDataContainer, Collection collection, FTP_ServerInformation fTP_ServerInformation, int n, boolean bl, boolean bl2) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled, boolean anIsForcedInstall, boolean anIsProgressInfoToBeSent)", "anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanUPWithLMsCouner: " + n + "\n\tanIsForcedInstall: " + bl + "\n\tanIsProgressInfoToBeSent: " + bl2);
        }
        try {
            this.writeToLoadListFile(file, productDataContainer, collection, fTP_ServerInformation, bl);
            this.myFileInstallerNotifier = new FileInstallerNotifier(this.myInstallCoordinator, file, collection, productDataContainer, fTP_ServerInformation);
            this.requestForInstallationOfLoadModules(fTP_ServerInformation.ftpServerIP_Address, fTP_ServerInformation.ftpServerPassword, fTP_ServerInformation.ftpServerUserName, this.myTemporaryUpgradeControlFilePath, productDataContainer, n, bl2);
            return this.myFileInstallerNotifier;
        }
        catch (InstallRejectedLoadListFileException installRejectedLoadListFileException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "The installation of the load modules has been rejected due to error in the load list or failure during creation of the load list.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallRejectedLoadListFileException: " + (Object)((Object)installRejectedLoadListFileException));
            }
            throw installRejectedLoadListFileException;
        }
        catch (InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "The installation of the load modules has been rejected due to the FTP server is not accessible.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallRejectedFTP_ServerNotAccessibleException message: " + installRejectedFTP_ServerNotAccessibleException.toString());
            }
            throw installRejectedFTP_ServerNotAccessibleException;
        }
        catch (InstallRejectedGetLoadModuleFileException installRejectedGetLoadModuleFileException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "The installation of the load modules has been rejected due to error at installation of a specific load module file.\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallRejectedGetLoadModuleFileException message: " + installRejectedGetLoadModuleFileException.toString());
            }
            throw installRejectedGetLoadModuleFileException;
        }
        catch (InstallRejectedIP_AddressException installRejectedIP_AddressException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "The installation of the load modules has been rejected due to an error with the IP address.\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallRejectedIP_AddressException message: " + installRejectedIP_AddressException.toString());
            }
            throw installRejectedIP_AddressException;
        }
        catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "The installation of the load modules has been rejected due to insufficient with disk space.\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallRejectedInsufficientDiskSpaceException message: " + installRejectedInsufficientDiskSpaceException.toString());
            }
            throw installRejectedInsufficientDiskSpaceException;
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "InstallOfLoadModulesRejectedException was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tInstallOfLoadModulesRejectedException message: " + installOfLoadModulesRejectedException.toString());
            }
            throw installOfLoadModulesRejectedException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "MoAccessException was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanIsProgressInfoToBeSent: " + bl2, moAccessException);
            throw new InstallOfLoadModulesRejectedException("MoAccessException was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tOrigin Exception: " + moAccessException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "Exception was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanIsProgressInfoToBeSent: " + bl2, exception);
            throw new InstallOfLoadModulesRejectedException("Exception was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tOrigin Exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "installLoadModules(File anUCF_Path, Vector aLoadModulesToBeInstalled)", "Error was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanIsProgressInfoToBeSent: " + bl2, error);
            throw new InstallOfLoadModulesRejectedException("Error was caught at creation of the load list file or at installation of load module files.anUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tOrigin Exception: " + error.toString());
        }
    }

    public void cancelInstallLoadModules() throws CancelInstallRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelInstallLoadModules()");
        }
        try {
            this.sendSignalCancelInstallRequest();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "cancelInstallLoadModules()", "At sending of signal 'CancelInstallRequest' an exception was caught", exception);
            throw new CancelInstallRequestException("At sending of signal '' an exception was caughtOrigin Exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "cancelInstallLoadModules()", "At sending of signal 'CancelInstallRequest' an error was caught", error);
            throw new CancelInstallRequestException("At sending of signal '' an error was caughtOrigin Error: " + error.toString());
        }
    }

    private String checkAndGetFTP_ServerIP_Address(String string) throws InstallRejectedFTP_ServerNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkAndGetFTP_ServerIP_Address(String anFTP_ServerHostNameOrIP_Address)", "anFTP_ServerHostNameOrIP_Address: " + string);
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "checkAndGetFTP_ServerIP_Address(String anFTP_ServerHostNameOrIP_Address)", "UnknownHostException caught when converting/checking FTP server host name/IP address,\n\tanFTP_ServerHostNameOrIP_Address: " + string + "\n\tUnknownHostException info: " + unknownHostException.toString());
            }
            throw new InstallRejectedFTP_ServerNotAccessibleException("Verification of requested host name/IP address failed,\n\trequested host name/IP address: " + string + "\n\tUnknownHostException info: " + unknownHostException.toString());
        }
    }

    private void requestForInstallationOfLoadModules(String string, String string2, String string3, String string4, ProductDataContainer productDataContainer, int n, boolean bl) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForInstallationOfLoadModules(Collection aLoadModulesToBeInstalled, String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path, ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "\n\taFtpServerIP_Address: " + string + "\n\taFtpServerPassword: ****" + "\n\taFtpServerUserName: " + string3 + "\n\taFtpServerUCF_Path: " + string4 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tanUPWithLMsCouner: " + n + "\n\tanIsProgressInfoToBeSent: " + bl);
        }
        try {
            this.sendSignalInstallRequest(string, string2, string3, string4, n, bl);
            this.waitForResponseFromInstallRequest(productDataContainer, bl);
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "requestForInstallationOfLoadModules(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path, ProductDataContainer anUP_ProductData)", "InstallOfLoadModulesRejected Exception caught when sending signal to Osa layer to request for installation of the load module files.\n\taFtpServerIP_Address: " + string + "\n\taFtpServerPassword: ****" + "\n\taFtpServerUserName: " + string3 + "\n\taFtpServerUCF_Path: " + string4 + "\n\tInstallOfLoadModulesRejectedException: " + installOfLoadModulesRejectedException.toString());
            }
            throw installOfLoadModulesRejectedException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "requestForInstallationOfLoadModules(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path, ProductDataContainer anUP_ProductData)", "\n\taFtpServerIP_Address: " + string + "\n\taFtpServerPassword: ****" + "\n\taFtpServerUserName: " + string3 + "\n\taFtpServerUCF_Path: " + string4, exception);
            throw new InstallOfLoadModulesRejectedException("\n\tUnexpected exception was caught either when requesting for load module files to be \n\tinstalled from the resource layer or when waiting for response.\n\tOrigin exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "requestForInstallationOfLoadModules(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path, ProductDataContainer anUP_ProductData)", "Error caught when sending signal to Osa layer to request for installation of the load module files.\n\taFtpServerIP_Address: " + string + "\n\taFtpServerPassword: ****" + "\n\taFtpServerUserName: " + string3 + "\n\taFtpServerUCF_Path: " + string4, error);
            throw new InstallOfLoadModulesRejectedException("\n\tUnexpected error was caught either when requesting for load module files to be \n\tinstalled from the resource layer or when waiting for response.\n\tOrigin exception: " + error.toString());
        }
    }

    private void sendSignalCancelInstallRequest() throws CancelInstallRequestException {
        OsaSwInstallProxyAccess osaSwInstallProxyAccess;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalCancelInstallRequest()");
        }
        if (!(osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class)).sendOsaSwInstallCancelReq()) {
            Trace.error(this.getClass(), "sendSignalCancelInstallRequest()", "Failed to send signal OsaSwInstallCancelReq to the FRO.");
            throw new CancelInstallRequestException("Failed to send signal OsaSwInstallCancelReq to the FRO.");
        }
    }

    private void sendSignalInstallRequest(String string, String string2, String string3, String string4, int n, boolean bl) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalInstallRequest(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path)", "aFtpServerIP_Address: " + string + "\n\taFtpServerPassword: ****" + "\n\taFtpServerUserName: " + string3 + "\n\taFtpServerUCF_Path: " + string4 + "\n\tanUPWithLMsCouner: " + n + "\n\tanIsProgressInfoToBeSent: " + bl);
        }
        try {
            String string5 = this.checkAndGetFTP_ServerIP_Address(string);
            this.verifyAndGetFTP_ServerUserID_MaxLength(string3);
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (bl && n <= 1) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new DownloadLMsProgressInformation(this));
            }
            osaSwInstallProxyAccess.sendAsynchOsaSwInstallListReq3(string3, string2, string5, string4);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendSignalInstallRequest(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path)", "\n\tSignal AsynchOsaSwInstallListReq3 sent to the install proxy at Osa layer.");
            }
        }
        catch (InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendSignalInstallRequest(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path)", "InstallRejectedFTP_ServerNotAccessibleException caught: " + installRejectedFTP_ServerNotAccessibleException.toString());
            }
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this));
            throw installRejectedFTP_ServerNotAccessibleException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "sendSignalInstallRequest(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path)", "Exception caught: " + exception.toString(), exception);
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this));
            throw new InstallOfLoadModulesRejectedException("\n\tWhen trying to send signal 'OsaSwInstallListReq' \n\tan unexpected exception was caught.\n\tOrigin Exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "sendSignalInstallRequest(String aFtpServerIP_Address, String aFtpServerPassword, String aFtpServerUserName, String aFtpServerUCF_Path)", "Error caught: " + error.toString(), error);
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this));
            throw new InstallOfLoadModulesRejectedException("\n\tWhen trying to send signal 'OsaSwInstallListReq' \n\tan unexpected error was caught.\n\tOrigin Error: " + error.toString());
        }
    }

    private void throwInstallRejectedException(int n, String string, ProductDataContainer productDataContainer) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "aFailureReason: " + n + "\n\taErrorInfo: " + string + "\n\tanUP_ProductData: " + productDataContainer);
        }
        String string2 = "\n\tThe Upgrade Package Product Data:\n\tProduct number: " + productDataContainer.getNumber() + "\n\tProduct revision: " + productDataContainer.getRevision() + "\n\tProduct name: " + productDataContainer.getName() + "\n\tProduct date: " + productDataContainer.getDate() + "\n\tProduct information: " + productDataContainer.getInformation();
        if (this.myFileInstallerNotifier != null) {
            this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
        }
        if (n == 2) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "The installation has been rejected due to an error in the load list file.");
            }
            throw new InstallRejectedLoadListFileException("The installation has been rejected due to an error in the load list file according to the resource layer." + string2, string);
        }
        if (n == 3) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "The installation has been rejected due to the FTP server is not accessible.");
            }
            throw new InstallRejectedFTP_ServerNotAccessibleException("The installation has been rejected due to the FTP server is not accessible according to the resource layer." + string2, string);
        }
        if (n == 4) {
            ProductNumberAndRevision productNumberAndRevision = this.myFileInstallerNotifier.getFirstLoadModuleToBeInstalled();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "The download of load modules from the FTP server failed at installation due to error when trying to download a specific load module.");
            }
            throw new InstallRejectedGetLoadModuleFileException("The installation has been rejected due to an error occured when installing a load module file according to the resource layer." + string2, string, productNumberAndRevision);
        }
        if (n == 5) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "The download of load modules from the FTP server failed at installation due to error in IP address.");
            }
            throw new InstallRejectedIP_AddressException("The installation has been rejected due to an error in the IP address according to the resource layer." + string2, string);
        }
        if (n == 8) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "throwInstallRejectedException(int aFailureReason, String aErrorInfo, ProductDataContainer anUP_ProductData)", "The download of load modules from the FTP server failed at installation due to insufficient diskspace.");
            }
            throw new InstallRejectedInsufficientDiskSpaceException("The installation has been rejected due to insufficient disk space according to the resource layer." + string2, string);
        }
        Trace.error(this.getClass(), "throwInstallRejectedException(int aFailureReason)", "The download of load modules from the FTP server failed at installation due to unknown reason." + string2 + DOT + "\n\t" + string);
        throw new InstallOfLoadModulesRejectedException("The installation has been rejected due to an unspecified error according to the resource layer." + string2, string);
    }

    private int verifyAndGetFTP_ServerUserID_MaxLength(String string) throws InstallRejectedFTP_ServerNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyAndGetFTP_ServerUserID_MaxLength(String aUserIdentifier)", "aUserIdentifier: " + string);
        }
        try {
            OsaSwInstallProxyHandlerInterface osaSwInstallProxyHandlerInterface = ServiceFinder.getOsaSwInstallProxyHandlerInterface();
            return osaSwInstallProxyHandlerInterface.verifyAndGetFTP_ServerUserID_MaxLength(string);
        }
        catch (OsaSwInstallProxyHandlerException osaSwInstallProxyHandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "verifyAndGetFTP_ServerUserID_MaxLength(String aUserIdentifier)", "OsaSwInstallProxyHandlerException caught when verifying length of requested FTP server user id,\n\taUserIdentifier: " + string + "\n\tOsaSwInstallProxyHandlerException info: " + osaSwInstallProxyHandlerException.toString());
            }
            throw new InstallRejectedFTP_ServerNotAccessibleException("Verification of length of requested FTP server user id failed,\n\trequested user id: " + string + "\n\tOsaSwInstallProxyHandlerException info: " + osaSwInstallProxyHandlerException.toString());
        }
    }

    private void waitForResponseFromInstallRequest(ProductDataContainer productDataContainer, boolean bl) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "\n\tanUP_ProductData: " + productDataContainer + "\n\tanIsProgressInfoToBeSent: " + bl);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "myLoadModulFilesToBeInstalled: " + this.myLoadModulFilesToBeInstalled);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            UpgradeStatusHolder.getInstance().setIsUpgradeOngoing(bl);
            while (true) {
                InstallListResultInformation installListResultInformation = osaSwInstallProxyAccess.receiveOsaSwInstallListRsp();
                if (installListResultInformation.type == 0) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "OsaSwInstallProxyAccess.SWINSTALL_LM_IND");
                    }
                    if (this.myLoadModulFilesToBeInstalled.size() > 0) {
                        Integer n = (Integer)this.myLoadModulFilesToBeInstalled.get(0);
                        if (n > 1) {
                            this.myLoadModulFilesToBeInstalled.set(0, new Integer(n - 1));
                            this.myFileInstallerNotifier.installNotification(new LoadModuleInstalledEvent(this, false));
                            continue;
                        }
                        this.myLoadModulFilesToBeInstalled.remove(0);
                        this.myFileInstallerNotifier.installNotification(new LoadModuleInstalledEvent(this, true));
                        continue;
                    }
                    Trace.info(this.getClass(), "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "An indication is received that a load module file has been installed.This notification is ignored since no information about this installed file exist.Probably a missmatch has occured between the MAO layer and the resource (fro) layer.");
                    continue;
                }
                if (installListResultInformation.type == 1) {
                    if (installListResultInformation.result == 1) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "All load modules have been successfully installed.");
                        }
                        if (this.myLoadModulFilesToBeInstalled.size() > 0) {
                            Trace.info(this.getClass(), "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "An indication is received that all load module file(s) have been installed from the resource layer.\n\tAccording to the MAO layer it still remains load module files to be installed.Make sure that all load module files really has been installedLoad module files to be installed according to UP MO: " + this.myLoadModulFilesToBeInstalled);
                        }
                        this.myFileInstallerNotifier.installNotification(new InstallFinishedEvent(this));
                        break;
                    }
                    if (installListResultInformation.result == 9) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "The installation of load modules has been successfully interrupted.");
                        }
                        throw new InstallOfLoadModulesCancelledException("The installation of load modules has been successfully interrupted");
                    }
                    this.throwInstallRejectedException(installListResultInformation.result, installListResultInformation.errorInformation, productDataContainer);
                    break;
                }
                Trace.info(this.getClass(), "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "Unexpected type in response signal 'OsaSwInstallListRsp'.\n\tType: " + installListResultInformation.type);
            }
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
        }
        catch (InstallOfLoadModulesCancelledException installOfLoadModulesCancelledException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "InstallOfLoadModulesCancelledException caught: " + installOfLoadModulesCancelledException.toString());
            }
            this.myFileInstallerNotifier.installNotification(new InstallCancelledEvent(this));
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
            throw installOfLoadModulesCancelledException;
        }
        catch (InstallOfLoadModulesTimeOutException installOfLoadModulesTimeOutException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "InstallOfLoadModulesTimeOutException caught: " + installOfLoadModulesTimeOutException.toString());
            }
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this, true));
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
            throw installOfLoadModulesTimeOutException;
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "InstallOfLoadModulesRejectedException caught: " + installOfLoadModulesRejectedException.toString());
            }
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this));
            throw installOfLoadModulesRejectedException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "FroNotAccessibleException caught: " + froNotAccessibleException.toString());
            }
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this, true));
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
            throw new InstallOfLoadModulesRejectedException("\n\tWhen waiting for response from the installation request from the resource layer \n\trequest got timed out.\n\tProductNumberAndRevision: " + this.myFileInstallerNotifier.getFirstLoadModuleToBeInstalled() + "\n\tOrigin Exception: " + froNotAccessibleException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "Exception caught: " + exception.toString(), exception);
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this, true));
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
            throw new InstallOfLoadModulesRejectedException("\n\tWhen waiting for response from the installation request from the resource layer \n\tan unexpected exception was caught.\n\tProductNumberAndRevision: " + this.myFileInstallerNotifier.getFirstLoadModuleToBeInstalled() + "\n\tOrigin Exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "waitForResponseFromInstallRequest(ProductDataContainer anUP_ProductData, boolean anIsProgressInfoToBeSent)", "Error caught: " + error.toString(), error);
            this.myFileInstallerNotifier.installNotification(new InstallFailedEvent(this, true));
            if (this.myFileInstallerNotifier != null) {
                this.myFileInstallerNotifier.waitForAllLoadModuleFilesToProperlyInstalled();
            }
            throw new InstallOfLoadModulesRejectedException("\n\tWhen waiting for response from the installation request from the resource layer \n\tan unexpected error was caught.\n\tProductNumberAndRevision: " + this.myFileInstallerNotifier.getFirstLoadModuleToBeInstalled() + "\n\tOrigin Error: " + error.toString());
        }
        finally {
            this.myFileInstallerNotifier = null;
            UpgradeStatusHolder.getInstance().setIsUpgradeOngoing(false);
        }
    }

    private void writeLoadListEndInformation(FileWriter fileWriter) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListEndInformation(FileWriter aFileWriter)", "aFileWriter: " + fileWriter);
        }
        try {
            fileWriter.write("  </Contents>\n\n");
            fileWriter.write("</UpgradePackage>\n");
            fileWriter.close();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeLoadListEndInformation(FileWriter aFileWriter)", "Error caught when writing to the load list file.", throwable);
            throw new InstallRejectedLoadListFileException("Error caught when writing to the load list file.\n\tError: " + throwable.getMessage());
        }
    }

    private void writeLoadListInitialInformation(FileWriter fileWriter, ProductDataContainer productDataContainer) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListInitialInformation(FileWriter aFileWriter, String anUpgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, String anUpgradePackageProductName, String anUpgradePackageProductionDate)", "anUP_ProductData: " + productDataContainer);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)osaSwInstallProxyAccess)) {
                this.writeLoadListInitialInformationV2(fileWriter, productDataContainer);
            } else {
                this.writeLoadListInitialInformationV1(fileWriter, productDataContainer);
            }
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "writeLoadListInitialInformation(FileWriter aFileWriter, String anUpgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, String anUpgradePackageProductName, String anUpgradePackageProductionDate)", "Failed to look up the version of Osa Sw Install function (aborting)");
            throw new InstallRejectedLoadListFileException("Failed to look up the version of Osa Sw Install function (aborting).\n\tanUP_ProductData: " + productDataContainer + "\n\tSU_ConditionalException: " + (Object)((Object)sU_ConditionalException));
        }
    }

    private void writeLoadListInitialInformationV1(FileWriter fileWriter, ProductDataContainer productDataContainer) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListInitialInformationV1(FileWriter aFileWriter, ProductDataContainer anUP_ProductData)", "anUP_ProductData: " + productDataContainer);
        }
        try {
            fileWriter.write("<xml version=\"1.0\">\n");
            fileWriter.write("<UpgradePackage>\n");
            fileWriter.write("  <Title title=" + productDataContainer.getName() + "/>\n");
            fileWriter.write("  <DocNo docno=" + productDataContainer.getNumber() + "/>\n");
            fileWriter.write("  <Revision revision=" + productDataContainer.getRevision() + "/>\n");
            fileWriter.write("  <Date date=" + productDataContainer.getDate() + "/>\n");
            fileWriter.write("  <Contents>\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeLoadListInitialInformationV1(FileWriter aFileWriter, ProductDataContainer anUP_ProductData)", "Throwable caught when writing to the load list file.\n\tanUP_ProductData: " + productDataContainer, throwable);
            throw new InstallRejectedLoadListFileException("Throwable caught when writing to the load list file.\n\tanUP_ProductData: " + productDataContainer + "\n\tException: " + throwable);
        }
    }

    private void writeLoadListInitialInformationV2(FileWriter fileWriter, ProductDataContainer productDataContainer) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListInitialInformationV2(FileWriter aFileWriter, ProductDataContainer anUP_ProductData)", "anUP_ProductData: " + productDataContainer);
        }
        try {
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fileWriter.write("<!DOCTYPE UpgradePackage>\n\n");
            fileWriter.write("<UpgradePackage>\n\n");
            fileWriter.write("  <Title title = \"" + productDataContainer.getName() + "\"/>\n");
            fileWriter.write("  <DocNo docno = \"" + productDataContainer.getNumber() + "\"/>\n");
            fileWriter.write("  <Revision revision = \"" + productDataContainer.getRevision() + "\"/>\n");
            fileWriter.write("  <Date date = \"" + productDataContainer.getDate() + "\"/>\n");
            fileWriter.write("  <Contents>\n");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeLoadListInitialInformationV2(FileWriter aFileWriter, ProductDataContainer anUP_ProductData)", "Throwable caught when writing to the load list file.\n\tanUP_ProductData: " + productDataContainer, throwable);
            throw new InstallRejectedLoadListFileException("Throwable caught when writing to the load list file.\n\tanUP_ProductData: " + productDataContainer + "\n\tException: " + throwable);
        }
    }

    private void writeLoadListLoadModuleInformation(FileWriter fileWriter, LoadModuleProxyInterface loadModuleProxyInterface, Vector vector, Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface, String string, ProductNumberAndRevision productNumberAndRevision, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListLoadModuleInformation(FileWriter aLoadListFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tanIsForcedInstall: " + bl);
        }
        try {
            int n = this.writeInstallLM_ToLoadModuleInformation(fileWriter, vector, documentObjectProxyInterface, string, productNumberAndRevision, loadModuleProxyInterface, bl);
            int n2 = this.writeInstallSMsToLoadModuleInformation(fileWriter, vector, collection, documentObjectProxyInterface, string, productNumberAndRevision, loadModuleProxyInterface, bl);
            if ((n += n2) > 0) {
                this.myLoadModulFilesToBeInstalled.add(new Integer(n));
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeLoadListLoadModuleInformation(FileWriter aLoadListFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision)", "A load module has been identified that do not have any file to be downloaded according to the InstallLM element in UCF.\n\tProduct number of load module: " + loadModuleProxyInterface.getProductNumber() + "\n\tProduct revision of load module: " + loadModuleProxyInterface.getProductRevision());
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeLoadListLoadModuleInformation(FileWriter aLoadListFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision)", "Before returning - myLoadModulFilesToBeInstalled: " + this.myLoadModulFilesToBeInstalled);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeLoadListLoadModuleInformation(FileWriter aLoadListFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision)", "Throwable caught when writing to the load list file.aLoadListFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\tanIsForcedInstall: " + bl, throwable);
            throw new InstallRejectedLoadListFileException("Throwable caught when writing to the load list file.aLoadListFileWriter: " + fileWriter + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanInstallLM_Containers: " + vector + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\tError: " + throwable.getMessage());
        }
    }

    private int writeInstallLM_ToLoadModuleInformation(FileWriter fileWriter, Vector vector, DocumentObjectProxyInterface documentObjectProxyInterface, String string, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallLM_ToLoadModuleInformation(FileWriter aLoadListFileWriter, Vector anInstallLM_Containers, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String anUpgradePackageControlFileSourcePathOnFTP_Server, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + vector + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanIsForcedInstall: " + bl);
        }
        InstallLM_Container installLM_Container = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (!installLM_Container.getDirectory().equalsIgnoreCase("no")) continue;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeLoadListLoadModuleInformation(FileWriter aLoadListFileWriter, LoadModuleProxyInterface aLoadModuleProxyInterface, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, MoDataProxyInterface aMoDataProxyInterface, DocumentObjectProxyInterface aDocumentObjectProxyInterface, ProductNumberAndRevision aProductNumberAndRevision)", "A load module file has been identified for a load module.");
            }
            string2 = documentObjectProxyInterface.selectLoadModuleSourceAbsolutePath(installLM_Container.getSrcFilePathName(), string, loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            string3 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            if ((loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.JVM) || loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) && string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath()) && new File(string3).exists()) {
                string3 = FilepathHandler.addInstallDirectoryToLoadModulePath(string3);
            }
            this.writeLoadModuleInformation(fileWriter, InstallLM_FTP_TransferModeValue.getDefaultValue().toUpperCase(), string2, string3, installLM_Container.getFileSize(), loadModuleProxyInterface.getProductNumber() + loadModuleProxyInterface.getProductRevision(), installLM_Container.getChecksum(), bl);
            ++n;
        }
        return n;
    }

    private int writeInstallSMsToLoadModuleInformation(FileWriter fileWriter, Vector vector, Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface, String string, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallSMsToLoadModuleInformation(FileWriter aLoadListFileWriter, Vector anInstallLM_Containers, Collection anInstallSM_Interfaces, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String anUpgradePackageControlFileSourcePathOnFTP_Server, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + vector + "\n\tanInstallSM_Interfaces: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanIsForcedInstall: " + bl);
        }
        InstallSMInterface installSMInterface = null;
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            installSMInterface = (InstallSMInterface)iterator.next();
            InstallLM_Container installLM_Container = this.selectInstallLM_Container(installSMInterface, vector);
            this.writeInstallSM_ToLM_Information(fileWriter, installLM_Container, installSMInterface, documentObjectProxyInterface, string, productNumberAndRevision, loadModuleProxyInterface, bl);
            ++n;
        }
        return n;
    }

    private void writeInstallSM_ToLM_Information(FileWriter fileWriter, InstallLM_Container installLM_Container, InstallSMInterface installSMInterface, DocumentObjectProxyInterface documentObjectProxyInterface, String string, ProductNumberAndRevision productNumberAndRevision, LoadModuleProxyInterface loadModuleProxyInterface, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeInstallSM_ToLM_Information(FileWriter aLoadListFileWriter, InstallLM_Container anInstallLM_Container, InstallSM_Interface anInstallSM_Interface, DocumentObjectProxyInterface aDocumentObjectProxyInterface, String anUpgradePackageControlFileSourcePathOnFTP_Server, ProductNumberAndRevision aProductNumberAndRevision, LoadModuleProxyInterface aLoadModuleProxyInterface, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\tanInstallLM_Containers: " + installLM_Container + "\n\tanInstallSM_Interfaces: " + installSMInterface + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface + "\n\tanIsForcedInstall: " + bl);
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string2 = this.getSrcFilePathForSM_File(installSMInterface, installLM_Container, string, productNumberAndRevision, documentObjectProxyInterface, loadModuleProxyInterface);
        string3 = this.getDestFilePathForSM_File(installSMInterface, installLM_Container, productNumberAndRevision, documentObjectProxyInterface, loadModuleProxyInterface);
        if ((loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.JVM) || loadModuleProxyInterface.getLoaderName().equalsIgnoreCase(MoDataLM_LoaderNameValue.Other)) && string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath()) && new File(string4 = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw())).exists()) {
            string3 = FilepathHandler.addInstallDirectoryToLoadModulePath(string3);
        }
        this.writeLoadModuleInformation(fileWriter, InstallLM_FTP_TransferModeValue.getDefaultValue().toUpperCase(), string2, string3, installSMInterface.getFileSize(), loadModuleProxyInterface.getProductNumber() + loadModuleProxyInterface.getProductRevision(), installSMInterface.getChecksum(), bl);
    }

    private InstallLM_Container selectInstallLM_Container(InstallSMInterface installSMInterface, Collection collection) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectInstallLM_Container(InstallSMInterface anInstallSM_Interface, Collection anInstallLM_Containers)", "anInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
        }
        InstallLM_Container installLM_Container = null;
        if (collection.size() == 1) {
            installLM_Container = (InstallLM_Container)collection.iterator().next();
            return installLM_Container;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            installLM_Container = (InstallLM_Container)iterator.next();
            if (installLM_Container.getDestFilePathName() == null || !installLM_Container.getDestFilePathName().equals(installSMInterface.getDestFilePathNameRef())) continue;
            return installLM_Container;
        }
        Trace.error(this.getClass(), "selectInstallLM_Container(InstallSMInterface anInstallSM_Interface, Collection anInstallLM_Containers)", "Couldn't find any InstallLM_Container that matches the InstallSM_Interface.\n\tanInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
        throw new InstallRejectedLoadListFileException("Couldn't find any InstallLM_Container that matches the InstallSM_Interface.\n\tanInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Containers: " + collection);
    }

    private String getDestFilePathForSM_File(InstallSMInterface installSMInterface, InstallLM_Container installLM_Container, ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleProxyInterface loadModuleProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDestFilePathForSM_File(InstallSM_Interface anInstallSM_Interface, InstallLM_Container anInstallLM_Container, ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModuleProxyInterface aLoadModuleProxyInterface)", "anInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Container: " + installLM_Container + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        String string = documentObjectProxyInterface.selectLoadModuleDestinationAbsolutePath(installLM_Container.getDestFilePathName(), loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
        return string + DOT + installSMInterface.getExtension();
    }

    private String getSrcFilePathForSM_File(InstallSMInterface installSMInterface, InstallLM_Container installLM_Container, String string, ProductNumberAndRevision productNumberAndRevision, DocumentObjectProxyInterface documentObjectProxyInterface, LoadModuleProxyInterface loadModuleProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSrcFilePathForSM_File(InstallSM_Interface anInstallSM_Interface, InstallLM_Container anInstallLM_Container, String anUpgradePackageControlFileSourcePathOnFTP_Server, ProductNumberAndRevision aProductNumberAndRevision, DocumentObjectProxyInterface aDocumentObjectProxyInterface, LoadModuleProxyInterface aLoadModuleProxyInterface)", "anInstallSM_Interface: " + installSMInterface + "\n\tanInstallLM_Container: " + installLM_Container + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\taProductNumberAndRevision: " + productNumberAndRevision + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModuleProxyInterface: " + loadModuleProxyInterface);
        }
        String string2 = documentObjectProxyInterface.selectLoadModuleSourceAbsolutePath(installLM_Container.getSrcFilePathName(), string, loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
        return string2 + DOT + installSMInterface.getExtension();
    }

    private void writeLoadModuleInformation(FileWriter fileWriter, String string, String string2, String string3, int n, String string4, String string5, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformation(FileWriter aLoadListFileWriter, String aTransferMode, String aSourceFilePath, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\taTransferMode: " + string + "\n\taSourceFilePath: " + string2 + "\n\taDestinationFilePath: " + string3 + "\n\taFileSize: " + n + "\n\taLM_ID: " + string4 + "\n\taChecksum: " + string5 + "\n\tanIsForcedInstall: " + bl);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)osaSwInstallProxyAccess)) {
                this.writeLoadModuleInformationV2(fileWriter, string, string2, string3, n, string4, string5, bl);
            } else {
                this.writeLoadModuleInformationV1(fileWriter, string, string2, string3, n, string4, string5);
            }
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "writeLoadListInitialInformation(FileWriter aFileWriter, String anUpgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, String anUpgradePackageProductName, String anUpgradePackageProductionDate)", "Failed to look up the version of Osa Sw Install function (aborting)");
            throw new InstallRejectedLoadListFileException("Failed to look up the version of Osa Sw Install function (aborting).\n\tSU_ConditionalException: " + (Object)((Object)sU_ConditionalException));
        }
    }

    private void writeLoadModuleInformationV1(FileWriter fileWriter, String string, String string2, String string3, int n, String string4, String string5) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformationV1(FileWriter aLoadListFileWriter, String aTransferMode, String aSourceFilePath, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum)", "aLoadListFileWriter: " + fileWriter + "\n\taTransferMode: " + string + "\n\taSourceFilePath: " + string2 + "\n\taDestinationFilePath: " + string3 + "\n\taFileSize: " + n + "\n\taLM_ID: " + string4 + "\n\taChecksum: " + string5);
        }
        try {
            fileWriter.write("    <LoadModule>\n");
            fileWriter.write("      <TransferMode transfermode=" + InstallLM_FTP_TransferModeValue.getDefaultValue().toUpperCase() + "/>\n");
            fileWriter.write("      <SFile sfile=" + string2 + "/>\n");
            fileWriter.write("      <DFile dfile=" + string3 + "/>\n");
            fileWriter.write("      <FileSize size=" + n + "/>\n");
            fileWriter.write("      <LMid lmid=" + string4 + "/>\n");
            fileWriter.write("      <Checksum value=" + string5 + "/>\n");
            if (string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
                fileWriter.write("      <Replicate replicate=yes/>\n");
            }
            fileWriter.write("    </LoadModule>\n");
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "writeLoadModuleInformationV1(FileWriter aLoadListFileWriter, String aTransferMode, String aSourceFilePath, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum)", "aLoadListFileWriter: " + fileWriter + "\n\taTransferMode: " + string + "\n\taSourceFilePath: " + string2 + "\n\taDestinationFilePath: " + string3 + "\n\taFileSize: " + n + "\n\taLM_ID: " + string4 + "\n\taChecksum: " + string5, iOException);
            throw new InstallRejectedLoadListFileException(iOException.toString());
        }
    }

    private void writeLoadModuleInformationV2(FileWriter fileWriter, String string, String string2, String string3, int n, String string4, String string5, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadModuleInformationV2(FileWriter aLoadListFileWriter, String aTransferMode, String aSourceFilePath, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\taTransferMode: " + string + "\n\taSourceFilePath: " + string2 + "\n\taDestinationFilePath: " + string3 + "\n\taFileSize: " + n + "\n\taLM_ID: " + string4 + "\n\taChecksum: " + string5 + "\n\tanIsForcedInstall: " + bl);
        }
        try {
            fileWriter.write("    <Module>\n");
            fileWriter.write("      <SFile sfile = \"" + string2 + "\"/>\n");
            fileWriter.write("      <DFile dfile = \"" + string3 + "\"/>\n");
            if (n != 0) {
                fileWriter.write("      <FileSize size = \"" + n + "\"/>\n");
            }
            fileWriter.write("      <LMid lmid = \"" + string4 + "\"/>\n");
            if (string5 != null && !string5.equals("null")) {
                fileWriter.write("      <Checksum value = \"" + string5 + "\"/>\n");
            }
            if (bl) {
                fileWriter.write("      <InstallType forced = \"yes\"/>\n");
            }
            fileWriter.write("    </Module>\n");
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "writeLoadModuleInformationV1(FileWriter aLoadListFileWriter, String aTransferMode, String aSourceFilePath, String aDestinationFilePath, int aFileSize, String aLM_ID, String aChecksum)", "aLoadListFileWriter: " + fileWriter + "\n\taTransferMode: " + string + "\n\taSourceFilePath: " + string2 + "\n\taDestinationFilePath: " + string3 + "\n\taFileSize: " + n + "\n\taLM_ID: " + string4 + "\n\taChecksum: " + string5, iOException);
            throw new InstallRejectedLoadListFileException(iOException.toString());
        }
    }

    private void writeLoadListLoadModulesInformation(FileWriter fileWriter, File file, ProductDataContainer productDataContainer, Collection collection, String string, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeLoadListLoadModulesInformation(FileWriter aLoadListFileWriter, File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, boolean anIsForcedInstall)", "aLoadListFileWriter: " + fileWriter + "\n\tanUCF_Path: " + file + "\n\tanUP_ProductData: " + productDataContainer + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "\n\tanIsForcedInstall: " + bl);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            String[] stringArray = new String[]{"InstallUp", "LoadModule"};
            documentObjectProxyInterface = UCF_ParserFacade.parseMainElementsNoSave(file.getAbsolutePath(), stringArray, false);
            Iterator iterator = collection.iterator();
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            while (iterator.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface().getLoadModuleProxyInterface(productNumberAndRevision);
                this.writeLoadListLoadModuleInformation(fileWriter, loadModuleProxyInterface, loadModuleProxyInterface.getInstallDatas(), loadModuleProxyInterface.getInstallSMs(), documentObjectProxyInterface, string, productNumberAndRevision, bl);
            }
        }
        catch (InstallRejectedLoadListFileException installRejectedLoadListFileException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "writeLoadListLoadModulesInformation(FileWriter aLoadListFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aLoadModulesToBeInstalled)", "InstallRejectedLoadListFile Exception caught when writing to the load module list files to be installed.aLoadListFileWriter: " + fileWriter + "\n\tanUCF_Path: " + file + "\n\tanUP_ProductData: " + productDataContainer + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tInstallRejectedLoadListFileException: " + installRejectedLoadListFileException.toString());
            }
            throw installRejectedLoadListFileException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "writeLoadListLoadModulesInformation(FileWriter aLoadListFileWriter, DocumentObjectProxyInterface aDocumentObjectProxyInterface, Collection aLoadModulesToBeInstalled)", "Throwable caught when writing to the load module list files to be installed.aLoadListFileWriter: " + fileWriter + "\n\tanUCF_Path: " + file + "\n\tanUP_ProductData: " + productDataContainer + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanIsForcedInstall: " + bl, throwable);
            throw new InstallRejectedLoadListFileException("Exception caught when writing to the load module list files to be installed.aLoadListFileWriter: " + fileWriter + "\n\tanUCF_Path: " + file + "\n\tanUP_ProductData: " + productDataContainer + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUpgradePackageControlFileSourcePathOnFTP_Server: " + string + "Exception: " + throwable.toString());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToLoadListFile(File file, ProductDataContainer productDataContainer, Collection collection, FTP_ServerInformation fTP_ServerInformation, boolean bl) throws InstallRejectedLoadListFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, boolean anIsForcedInstall)", "anUCF_Path: " + file + "anUP_ProductData: " + productDataContainer + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanIsForcedInstall: " + bl);
        }
        File file2 = null;
        OutputStreamWriter outputStreamWriter = null;
        file2 = new File(this.mySystemUpgradeConstantsInterface.getNodeTmpRootPath());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        outputStreamWriter = new FileWriter(this.myTemporaryUpgradeControlFilePath);
        this.writeLoadListInitialInformation((FileWriter)outputStreamWriter, productDataContainer);
        this.writeLoadListLoadModulesInformation((FileWriter)outputStreamWriter, file, productDataContainer, collection, fTP_ServerInformation.ftpServerUCF_Path, bl);
        this.writeLoadListEndInformation((FileWriter)outputStreamWriter);
        Object var10_8 = null;
        if (outputStreamWriter == null) return;
        try {
            outputStreamWriter.close();
            return;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "Exception caught when trying to close the handle to load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter, exception);
        }
        return;
        {
            catch (InstallRejectedLoadListFileException installRejectedLoadListFileException) {
                if (!Trace.valid(this.getClass(), 22)) throw installRejectedLoadListFileException;
                Trace.debug(this.getClass(), 22, "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "InstallRejectedLoadListFile Exception caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter + "\n\tInstallRejectedLoadListFileException: " + (Object)((Object)installRejectedLoadListFileException));
                throw installRejectedLoadListFileException;
            }
            catch (IOException iOException) {
                Trace.error(this.getClass(), "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "IO Exception caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter + "\n\tanIsForcedInstall: " + bl, iOException);
                throw new InstallRejectedLoadListFileException("IO Exception caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\tIO Exception: " + iOException);
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "Exception caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter, exception);
                throw new InstallRejectedLoadListFileException("Exception caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\tException: " + exception);
            }
            catch (Error error) {
                Trace.error(this.getClass(), "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "Error caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter, error);
                throw new InstallRejectedLoadListFileException("Error caught when trying to write load modules to be installed into the load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\tError: " + error);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "writeToLoadListFile(File anUCF_Path, ProductDataContainer anUP_ProductData, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation)", "Exception caught when trying to close the handle to load list file.\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\ttheTemporaryDirectoryOnTarget: " + file2 + "\n\tanUP_ProductData: " + productDataContainer + "\n\tmyTemporaryUpgradeControlFilePath: " + this.myTemporaryUpgradeControlFilePath + "\n\ttheLoadListFileWriter: " + outputStreamWriter, exception);
            }
            throw throwable;
        }
    }
}

