/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.handler.actionhandler;

import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.information.ReadReferringConfigurationVersionsException;
import se.ericsson.cello.upgradepackage.information.event.ReadRefCV_InfoConfirmedEvent;
import se.ericsson.cello.upgradepackage.information.event.ReadRefCV_InfoRejectedEvent;
import se.ericsson.cello.upgradepackage.information.event.ReadRefCV_InfoRequestEvent;
import se.ericsson.cello.upgradepackage.information.event.ReadRefCV_InfoResponseEvent;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ActionHandler;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ControllerClientInterface;
import se.ericsson.cello.upgradepackage.main.interfaces.NonBlockingClientInterface;
import se.ericsson.cello.upgradepackage.main.util.ActionResultHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.enumer.ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class ActionReadReferringCvInformationHandler
extends ActionHandler
implements PropertyChangeListener,
ControllerClientInterface {
    private int myActionId = -1;
    private NonBlockingClientInterface myNonBlockingClientInterface = null;

    public ActionReadReferringCvInformationHandler(NonBlockingClientInterface nonBlockingClientInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ActionReadReferringCvInformationHandler(NonBlockingClientInterface aNonBlockingClientInterface )");
        }
        this.myNonBlockingClientInterface = nonBlockingClientInterface;
    }

    public int readReferringCvInformation(ReadRefCV_InfoRequestEvent readRefCV_InfoRequestEvent) throws ReadReferringConfigurationVersionsException, NoPermissionException, ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "readReferringCvInformation(ReadRefCV_InfoRequestEvent aReadRefCV_InfoRequestEvent)", "aReadRefCV_InfoRequestEvent: " + readRefCV_InfoRequestEvent);
        }
        Trace.log1(this.getClass(), "readReferringCvInformation(ReadRefCV_InfoRequestEvent aReadRefCV_InfoRequestEvent)", "Start Action - Read Referring Cv Information\n\tProduct number: " + readRefCV_InfoRequestEvent.getUpgradePackageDocumentNumber() + "\n\tProduct revision: " + readRefCV_InfoRequestEvent.getUpgradePackageDocumentRevision() + "\n\tActionId: " + this.myActionId);
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            this.verifyActionNotInvokedOnTheInitUP(readRefCV_InfoRequestEvent.getUpgradePackageDocumentNumber(), readRefCV_InfoRequestEvent.getUpgradePackageDocumentRevision());
            this.busyMark();
            this.createActionId();
            this.addAsListener();
            UpgradeCoordinator.instance().readReferringCvInformationRequest(this, readRefCV_InfoRequestEvent);
            Trace.log1(this.getClass(), "readReferringCvInformation(ReadRefCV_InfoRequestEvent aReadRefCV_InfoRequestEvent)", "End Action - ReadReferringConfigurationVersions, ReadReferringConfigurationVersions initiated (Action ID: " + this.myActionId + ")\n");
            int n = this.myActionId;
            return n;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "readReferringCvInformation(ReadReferringConfigurationVersionsRequestEvent aReadReferringConfigurationVersionsRequestEvent)", "NoPermissionException caught when performing access control,NoPermissionException info: " + (Object)((Object)noPermissionException));
            }
            this.handleExecutionFinished();
            throw noPermissionException;
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "readReferringCvInformation(ReadReferringConfigurationVersionsRequestEvent aReadReferringConfigurationVersionsRequestEvent)", "ActionNotAllowedException caught,ActionNotAllowedException info: " + (Object)((Object)actionNotAllowedException));
            }
            this.handleExecutionFinished();
            throw actionNotAllowedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "readReferringCvInformation(ReadReferringConfigurationVersionsRequestEvent aReadReferringConfigurationVersionsRequestEvent)", "Throwable caught when trying to execute action readReferringConfigurationVersions.", throwable);
            this.handleExecutionFinished();
            throw new ReadReferringConfigurationVersionsException("Excecution of action readReferringCvInformation failed,\n\tClass: " + this.getClass() + "\n\tMethod: readReferringCvInformation(ReadReferringConfigurationVersionsRequestEvent aReadReferringConfigurationVersionsRequestEvent)" + "\n\tReason: " + throwable.toString());
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    private void busyMark() throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark( )");
        }
        UpgradeCoordinator.instance().busyMark(this, ServiceSubType.readReferringCV);
    }

    private void freeMark() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMark( )");
        }
        UpgradeCoordinator.instance().freeMark(this, ServiceSubType.readReferringCV);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aEvt)", "aEvt: " + propertyChangeEvent);
        }
        if (propertyChangeEvent.getNewValue() instanceof ReadRefCV_InfoResponseEvent) {
            this.handlePropertyChange((ReadRefCV_InfoResponseEvent)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
            this.handlePropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unexpected type of property change value received (ignored).evt: " + propertyChangeEvent);
        }
    }

    private void handlePropertyChange(ReadRefCV_InfoResponseEvent readRefCV_InfoResponseEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePropertyChange(ReadRefCV_InfoResponseEvent aReadRefCV_InfoResponseEvent)", "ReadRefCV_InfoResponseEvent: " + readRefCV_InfoResponseEvent);
        }
        ActionResultHandler actionResultHandler = new ActionResultHandler();
        if (readRefCV_InfoResponseEvent instanceof ReadRefCV_InfoConfirmedEvent) {
            actionResultHandler.setActionResult(this.myActionId, (ReadRefCV_InfoConfirmedEvent)readRefCV_InfoResponseEvent, this.myNonBlockingClientInterface, ActionResultDataTypeOfInvokedActionValue.ReadReferringCV_Info);
        } else if (readRefCV_InfoResponseEvent instanceof ReadRefCV_InfoRejectedEvent) {
            actionResultHandler.setActionResult(this.myActionId, (ReadRefCV_InfoRejectedEvent)readRefCV_InfoResponseEvent, this.myNonBlockingClientInterface, ActionResultDataTypeOfInvokedActionValue.ReadReferringCV_Info);
        } else {
            Trace.info(this.getClass(), "handlePropertyChange(ReadRefCV_InfoResponseEvent aReadRefCV_InfoResponseEvent) ", "Unexpected type of ReadRefCV_InfoResponseEvent,\n\tno setting of actionResult will be executed.\n\taReadRefCV_InfoResponseEvent: " + readRefCV_InfoResponseEvent);
        }
    }

    private void handlePropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePropertyChange(UpgradeProgressInformation anUpgradeProgressInformation)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface);
        }
        this.myNonBlockingClientInterface.setProgressHeader(progressHeaderInformationInterface);
    }

    public void finished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "finished()");
        }
        this.removeAsListener();
        this.freeMark();
    }

    private void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener()");
        }
        ProgressInformationHandler progressInformationHandler = ProgressInformationHandler.instance();
        progressInformationHandler.addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ActionResult, this);
        progressInformationHandler.addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener()");
        }
        ProgressInformationHandler progressInformationHandler = ProgressInformationHandler.instance();
        progressInformationHandler.removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ActionResult, this);
        progressInformationHandler.removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
    }

    private void createActionId() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createActionId()");
        }
        this.myActionId = TimeHandler.createActionId();
    }

    private void handleExecutionFinished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleExecutionFinished()");
        }
        this.removeAsListener();
        this.freeMark();
    }
}

