/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.handler.actionhandler;

import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ActionHandler;
import se.ericsson.cello.upgradepackage.main.handler.actionhandler.ControllerClientInterface;
import se.ericsson.cello.upgradepackage.main.util.ActionResultHandler;
import se.ericsson.cello.upgradepackage.shrink.ShrinkClientInterface;
import se.ericsson.cello.upgradepackage.shrink.ShrinkConfirmedEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkException;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRejectedEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRequestEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkResponseEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ProgressHeaderInformationInterface;
import se.ericsson.cello.upgradepackage.util.enumer.ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class ActionShrinkHandler
extends ActionHandler
implements PropertyChangeListener,
ControllerClientInterface {
    private int myActionId = 0;
    private ShrinkClientInterface myShrinkClient = null;

    public ActionShrinkHandler(ShrinkClientInterface shrinkClientInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ActionShrinkHandler(ShrinkClientInterface aShrinkClientInterface) ", "aShrinkClientInterface: " + shrinkClientInterface);
        }
        this.myShrinkClient = shrinkClientInterface;
    }

    public void finished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "finished()");
        }
        this.removeAsListener();
        this.freeMark();
        this.myShrinkClient = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        if (propertyChangeEvent.getNewValue() instanceof ShrinkResponseEvent) {
            this.handlePropertyChange((ShrinkResponseEvent)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getNewValue() instanceof ProgressHeaderInformationInterface) {
            this.handlePropertyChange((ProgressHeaderInformationInterface)propertyChangeEvent.getNewValue());
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unexpected type of property change value received (ignored).evt: " + propertyChangeEvent);
        }
    }

    public int shrink(ShrinkRequestEvent shrinkRequestEvent) throws ActionNotAllowedException, ShrinkException, NoPermissionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        Trace.log1(this.getClass(), "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "Start Action - Shrink\n\tProduct number: " + shrinkRequestEvent.getUpgradePackageDocumentNumber() + "\n\tRevision: " + shrinkRequestEvent.getUpgradePackageDocumentRevision());
        Trace.flushToTraceFile();
        try {
            AccessControlHelper.performAccessControl();
            this.busyMark();
            this.createActionId();
            this.addAsListener();
            UpgradeCoordinator.instance().shrinkRequest(this, shrinkRequestEvent);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "End Action - Shrink, shrink initiated (Action ID: " + this.myActionId + ")\n");
            }
            int n = this.myActionId;
            return n;
        }
        catch (NoPermissionException noPermissionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "NoPermissionException caught when performing access control,NoPermissionException info: " + (Object)((Object)noPermissionException));
            }
            throw noPermissionException;
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "ActionNotAllowedException caught,ActionNotAllowedException info: " + (Object)((Object)actionNotAllowedException));
            }
            this.handleExecutionFinished();
            throw actionNotAllowedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "shrink(ShrinkRequestEvent aShrinkRequestEvent)", "Throwable caught when trying to execute action shrink.", throwable);
            this.handleExecutionFinished();
            throw new ShrinkException("Excecution of action shrink failed,\n\tClass: " + this.getClass() + "\n\tMethod: shrink(ShrinkRequestEvent aShrinkRequestEvent)" + "\n\tReason: " + throwable);
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    private void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener()");
        }
        ProgressInformationHandler progressInformationHandler = ProgressInformationHandler.instance();
        progressInformationHandler.addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ActionResult, this);
        progressInformationHandler.addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
    }

    private void busyMark() throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark()");
        }
        if (!this.myShrinkClient.setShrinkIsExecuting()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "busyMark()", "Action shrink rejected due to that other interacting action has been initiated on this UP MO.");
            }
            throw new ActionNotAllowedException("Class: " + this.getClass() + "\n\tMethod: busyMark()" + "\n\tAction update rejected due to that other interacting action has been initiated on this UP MO.");
        }
        UpgradeCoordinator.instance().busyMark(this, ServiceSubType.shrinkUP);
    }

    private void createActionId() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark()");
        }
        this.myActionId = TimeHandler.createActionId();
    }

    private void freeMark() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMark()");
        }
        UpgradeCoordinator.instance().freeMark(this, ServiceSubType.shrinkUP);
        this.myShrinkClient.setShrinkIsNotExecuting();
    }

    private void handleExecutionFinished() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleExecutionFinished()");
        }
        this.removeAsListener();
        this.freeMark();
        this.myShrinkClient = null;
    }

    private void handlePropertyChange(ShrinkResponseEvent shrinkResponseEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePropertyChange(ShrinkResponseEvent aShrinkResponseEvent)", "aShrinkResponseEvent: " + shrinkResponseEvent);
        }
        ActionResultHandler actionResultHandler = new ActionResultHandler();
        if (shrinkResponseEvent instanceof ShrinkConfirmedEvent) {
            actionResultHandler.setActionResult(this.myActionId, (ShrinkConfirmedEvent)shrinkResponseEvent, this.myShrinkClient, ActionResultDataTypeOfInvokedActionValue.Shrink);
        } else if (shrinkResponseEvent instanceof ShrinkRejectedEvent) {
            actionResultHandler.setActionResult(this.myActionId, (ShrinkRejectedEvent)shrinkResponseEvent, this.myShrinkClient, ActionResultDataTypeOfInvokedActionValue.Shrink);
        } else {
            Trace.info(this.getClass(), "handlePropertyChange(ShrinkResponseEvent aShrinkResponseEvent)", "Unexpected type of aShrinkResponseEvent,\n\tno setting of actionResult will be executed.\n\taShrinkResponseEvent: " + shrinkResponseEvent);
        }
    }

    private void handlePropertyChange(ProgressHeaderInformationInterface progressHeaderInformationInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handlePropertyChange(UpgradeProgressInformation anUpgradeProgressInformation)", "aProgressHeaderInformationInterface: " + progressHeaderInformationInterface);
        }
        this.myShrinkClient.setProgressHeader(progressHeaderInformationInterface);
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener()");
        }
        ProgressInformationHandler progressInformationHandler = ProgressInformationHandler.instance();
        progressInformationHandler.removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ActionResult, this);
        progressInformationHandler.removePropertyChangeListener(NotifyingSystemUpgradePropertyName.ProgressInformation, this);
    }
}

