/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.restoresu;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.convert.UpgradeMoDataConverter;
import se.ericsson.cello.su.convert.base.ConverterState;
import se.ericsson.cello.su.extsuif.upgradepackage.util.handler.FromVersionInformation;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ValueAVC_Property;
import se.ericsson.cello.su.signedsw.CrlAndCertificateUnloader;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.installsequence.PreUpgradeSuInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.sudom.proxy.verifyupgradesequence.VerifyUpgradeSequenceProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.install.MaxNoOfCVsException;
import se.ericsson.cello.upgradepackage.install.NotEnoughWithDiskSpaceForRequiredNoOfCVsException;
import se.ericsson.cello.upgradepackage.main.event.state.SU_DowngradeExecutingEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ConfirmedEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_Exception;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_FailureInformation;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RejectedInformationEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_RequestEvent;
import se.ericsson.cello.upgradepackage.restoresu.RestoreSU_ResponseEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandlerException;
import se.ericsson.cello.upgradepackage.util.datacontainer.DowngradeSU_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.JVM_RestartRequestInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.OngoingActionID_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeStateInformation;
import se.ericsson.cello.upgradepackage.util.handler.FromVersionHandler;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.VerifyCVsToBeCreatedResult;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class RestoreSU_Controller {
    private static final int TWO_MINUTES = 120000;
    private static final int TWO_INSTALL_CVS = 2;
    private static final String EMPTY_STRING = "";

    public RestoreSU_ResponseEvent restoreSU(RestoreSU_RequestEvent restoreSU_RequestEvent) throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "aRestoreSU_RequestEvent: " + restoreSU_RequestEvent);
        }
        try {
            Object object;
            if (restoreSU_RequestEvent.getPreUpgradeState() != 3) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new DowngradeSU_Information(this, ValueAVC_Property.OnlyAVC));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new SU_DowngradeExecutingEvent(this, ValueAVC_Property.OnlyAVC));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation(this, 3, ValueAVC_Property.OnlyAVC));
                object = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult = object.verifyNumberOfCVsToBeCreated(2);
                if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.Confirmed)) {
                    Iterator iterator;
                    Collection collection;
                    Object object2;
                    String string = object.createDowngradeRollbackCV_AndSetStartable(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
                    object.deleteCVsWithReason("Pb", restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision(), string);
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new DowngradeSU_Information(this, ValueAVC_Property.OnlyValue));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new SU_DowngradeExecutingEvent(this, ValueAVC_Property.OnlyValue));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation(this, 3, ValueAVC_Property.OnlyValue));
                    String[] stringArray = new String[]{"UpgradeWindow", "UpCompatibilityIndex", "InstallSequence", "VerifySequence", "VerifyUpgradeSequence", "UpgradeLogic", "LoadModule"};
                    DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision(), restoreSU_RequestEvent.getUpgradePackageOriginalUCF_Path(), stringArray);
                    FromVersionHandler fromVersionHandler = new FromVersionHandler();
                    String string2 = documentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
                    if (string2 == null) {
                        string2 = EMPTY_STRING;
                    }
                    FromVersionInformation fromVersionInformation = fromVersionHandler.getFromVersion(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision(), string2, documentObjectProxyInterface.isDeltaUP());
                    Collection collection2 = new LinkedList();
                    Collection collection3 = new LinkedList();
                    Collection collection4 = new LinkedList();
                    if (restoreSU_RequestEvent.getPreUpgradeExecutingPhase() == 0) {
                        object2 = documentObjectProxyInterface.getInstallSequenceProxyInterface(fromVersionInformation, documentObjectProxyInterface.isDeltaUP());
                        collection = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                        collection4 = collection.getLoadModules();
                        iterator = object2.getPreUpgradeSuInterface();
                        collection3 = iterator.getAddJavaLMs();
                        collection2 = restoreSU_RequestEvent.getRemovedJavaLMsAtPreUpgrade();
                        collection2 = this.filterNotExistingLMs(collection2);
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Pre upgrade executed at installation\n\ttheFromVersionInformation: " + fromVersionInformation + "\n\ttheSU_LMs: " + collection4);
                        }
                    } else if (restoreSU_RequestEvent.getPreUpgradeExecutingPhase() == 1) {
                        object2 = documentObjectProxyInterface.getVerifySequenceProxyInterface(fromVersionInformation, documentObjectProxyInterface.isDeltaUP());
                        collection = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                        collection4 = collection.getLoadModules();
                        iterator = object2.getPreUpgradeSuInterface();
                        collection3 = iterator.getAddJavaLMs();
                        collection2 = restoreSU_RequestEvent.getRemovedJavaLMsAtPreUpgrade();
                        collection2 = this.filterNotExistingLMs(collection2);
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Pre upgrade executed at action verify\n\ttheFromVersionInformation: " + fromVersionInformation + "\n\ttheSU_LMs: " + collection4);
                        }
                    } else if (restoreSU_RequestEvent.getPreUpgradeExecutingPhase() == 3) {
                        object2 = null;
                        collection = documentObjectProxyInterface.getVerifyUpgradeSequenceProxyInterface(restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision(), string2);
                        iterator = collection.iterator();
                        if (iterator.hasNext()) {
                            object2 = (VerifyUpgradeSequenceProxyInterface)iterator.next();
                        }
                        UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                        collection4 = upgradeLogicProxyInterface.getLoadModules();
                        PreUpgradeSuInterface preUpgradeSuInterface = object2.getPreUpgradeSuInterface();
                        collection3 = preUpgradeSuInterface.getAddJavaLMs();
                        collection2 = restoreSU_RequestEvent.getRemovedJavaLMsAtPreUpgrade();
                        collection2 = this.filterNotExistingLMs(collection2);
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Pre upgrade executed at verification during an upgrade.\n\ttheFromVersionInformation: " + fromVersionInformation + "\n\ttheSU_LMs: " + collection4);
                        }
                    } else {
                        Trace.error(this.getClass(), "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Unexpected pre upgrade phase (assume it is in the installation phase");
                        object2 = documentObjectProxyInterface.getInstallSequenceProxyInterface(fromVersionInformation, documentObjectProxyInterface.isDeltaUP());
                        collection = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                        collection4 = collection.getLoadModules();
                        iterator = object2.getPreUpgradeSuInterface();
                        collection3 = iterator.getAddJavaLMs();
                        collection2 = restoreSU_RequestEvent.getRemovedJavaLMsAtPreUpgrade();
                        collection2 = this.filterNotExistingLMs(collection2);
                        if (Trace.valid(this.getClass(), 20)) {
                            Trace.debug(this.getClass(), 20, "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Pre upgrade executed at installation\n\ttheFromVersionInformation: " + fromVersionInformation + "\n\ttheSU_LMs: " + collection4);
                        }
                    }
                    object2 = new LinkedList();
                    object2.addAll(collection2);
                    collection = new LinkedList();
                    collection.addAll(collection4);
                    collection.addAll(collection3);
                    iterator = new JvmUpdateHandler();
                    ((JvmUpdateHandler)((Object)iterator)).calculateAndSetExistingJvmAdmClassPath(new LinkedList(), (Collection)object2, collection, restoreSU_RequestEvent.getUpgradeClientInterface());
                    ((JvmUpdateHandler)((Object)iterator)).setJavaHeapSize(new Integer(restoreSU_RequestEvent.getPreviousJavaHeapSizeInKB()));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, restoreSU_RequestEvent.getActionId()));
                    this.createSuConvertTable(ConverterState.RESTORE, restoreSU_RequestEvent.getUpgradePackageDocumentNumber(), restoreSU_RequestEvent.getUpgradePackageDocumentRevision());
                    this.removeCreatedProgramsForCertAndCrls();
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new JVM_RestartRequestInformation(this));
                    ((JvmUpdateHandler)((Object)iterator)).doRestartJvm();
                    TimeHandler.sleep(120000L);
                    Trace.info(this.getClass(), "executePreUpgrade(Collection aSU_LMs, Collection anAddJavaLMs, Collection aRemoveJavaLMs, UpgradeClientInterface aToUP_Mo)", "The restart of the JVM seems to have failed since this log is printed...");
                } else {
                    if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NumberOfCVsExceeded)) {
                        throw new MaxNoOfCVsException("The max number of allowed CVs will be exceeded i.e. the number of required CVs at the restoreSu are two i.e. a rollback CV (Pb_) and a final CV (Pr_)");
                    }
                    if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NoAvailableMemoryForCVs)) {
                        throw new NotEnoughWithDiskSpaceForRequiredNoOfCVsException("The available disk space for creation of CVs is insufficient (the number of required CVs at the restoreSu are two i.e. a rollback CV (Pb_) and a final CV (Pr_))");
                    }
                }
            }
            object = new CrlAndCertificateUnloader();
            ((CrlAndCertificateUnloader)object).unloadCrlsAndCertificatesForToState();
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 0));
            return new RestoreSU_ConfirmedEvent(this, restoreSU_RequestEvent.getActionId());
        }
        catch (MaxNoOfCVsException maxNoOfCVsException) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RestoreSU_FailureInformation((Object)this, maxNoOfCVsException.getMessage(), (Throwable)((Object)maxNoOfCVsException)));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 2));
            return new RestoreSU_RejectedInformationEvent(this, restoreSU_RequestEvent.getActionId(), maxNoOfCVsException.toString());
        }
        catch (NotEnoughWithDiskSpaceForRequiredNoOfCVsException notEnoughWithDiskSpaceForRequiredNoOfCVsException) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RestoreSU_FailureInformation((Object)this, notEnoughWithDiskSpaceForRequiredNoOfCVsException.getMessage(), (Throwable)((Object)notEnoughWithDiskSpaceForRequiredNoOfCVsException)));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 2));
            return new RestoreSU_RejectedInformationEvent(this, restoreSU_RequestEvent.getActionId(), notEnoughWithDiskSpaceForRequiredNoOfCVsException.toString());
        }
        catch (JvmUpdateHandlerException jvmUpdateHandlerException) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RestoreSU_FailureInformation((Object)this, jvmUpdateHandlerException.getMessage(), (Throwable)((Object)jvmUpdateHandlerException)));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 2));
            return new RestoreSU_RejectedInformationEvent(this, restoreSU_RequestEvent.getActionId(), jvmUpdateHandlerException.toString());
        }
        catch (RestoreSU_Exception restoreSU_Exception) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RestoreSU_FailureInformation((Object)this, restoreSU_Exception.getMessage(), (Throwable)((Object)restoreSU_Exception)));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 2));
            return new RestoreSU_RejectedInformationEvent(this, restoreSU_RequestEvent.getActionId(), restoreSU_Exception.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "restoreSU (RestoreSU_RequestEvent aRestoreSU_RequestEvent)", "Throwable caught when trying to execute action restoreSU.\n\taRestoreSU_RequestEvent: " + restoreSU_RequestEvent, throwable);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RestoreSU_FailureInformation((Object)this, throwable.getMessage(), throwable));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.PreUpgradeState, new PreUpgradeStateInformation((Object)this, 2));
            return new RestoreSU_RejectedInformationEvent(this, restoreSU_RequestEvent.getActionId(), throwable.toString());
        }
    }

    private void removeCreatedProgramsForCertAndCrls() throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeCreatedProgramsForCertAndCrls()");
        }
        Control control = null;
        try {
            Collection collection = this.getCreatedProgramMOs();
            Iterator iterator = collection.iterator();
            ProgramMoSU_Access programMoSU_Access = null;
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            while (iterator.hasNext()) {
                programMoSU_Access = (ProgramMoSU_Access)iterator.next();
                this.deleteProgram((ManagedObject)programMoSU_Access, coordinator);
            }
            this.deleteCertCrlProgramsFromDB();
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "removeCreatedProgramsForCertAndCrls()", "Throwable caught", throwable);
            Transaction.rollback(control);
            throw new RestoreSU_Exception(throwable.toString());
        }
    }

    private void deleteCertCrlProgramsFromDB() throws UpgradeDB_StorageHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteCertCrlProgramsFromDB");
        }
        if (UpgradeDB_StorageUtil.existsCertCrlPrograms()) {
            UpgradeDB_StorageUtil.deleteCertCrlPrograms();
        }
    }

    private Collection getCreatedProgramMOs() throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCreatedProgramMOs()");
        }
        try {
            String string = UpgradeDB_StorageUtil.getCertCrlPrograms();
            Collection collection = this.getLDNsForPrograms(string);
            Trace.log1(this.getClass(), "getCreatedProgramMOs()", "--->* CertCrlPrograms stored in DB: " + UpgradeDB_StorageUtil.getCertCrlPrograms() + "\n\t--->*theProgramLDNs: " + collection);
            Iterator iterator = collection.iterator();
            String string2 = null;
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            ManagedObject managedObject = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                managedObject = MoRepository.instance().lookup(string2);
                if (managedObject != null) {
                    linkedList.add(managedObject);
                    continue;
                }
                Trace.warning(this.getClass(), "getCreatedProgramMOs()", "The saved program for the cert or CRL for TO state wasn't found (ignoring this)theProgramLDN: " + string2 + "\n\ttheLDNsForCertAndCrls: " + string);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCreatedProgramMOs()", "Throwable caught", throwable);
            throw new RestoreSU_Exception(throwable.toString());
        }
    }

    private Collection getLDNsForPrograms(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLDNsForPrograms(String aLDNsForCertAndCrls)", "aLDNsForCertAndCrls: " + string);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        if (string != null) {
            while (string.indexOf("::_::") != -1) {
                string2 = string.substring(0, string.indexOf("::_::"));
                string = string.substring(string2.length() + "::_::".length(), string.length());
                linkedList.add(string2);
            }
            if (string.length() > 0) {
                linkedList.add(string);
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLDNsForPrograms(String aLDNsForCertAndCrls)", "RETURNS - theProgramLDNs: " + linkedList);
        }
        return linkedList;
    }

    private void deleteProgram(ManagedObject managedObject, Coordinator coordinator) throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteProgram(ManagedObject aProgramLDN, Coordinator aCoordinator)", "aProgram: " + managedObject + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        try {
            managedObject.delete(coordinator);
            Trace.log1(this.getClass(), "deleteProgram(ManagedObject aProgramLDN, Coordinator aCoordinator)", "---> Deleted the program: " + managedObject);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteProgram(ManagedObject aProgramLDN, Coordinator aCoordinator)", "Deleted the program: " + managedObject);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteProgram(ManagedObject aProgram, Coordinator aCoordinator)", "Throwable caught (ignored) when trying to delete program for Certificate or CRL that has been created at pre upgrade of SU.aProgram: " + managedObject, throwable);
            throw new RestoreSU_Exception(throwable.toString());
        }
    }

    private Collection filterNotExistingLMs(Collection collection) throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterNotExistingLMs(Collection anIntendedRemoveJavaLMs)", "anIntendedRemoveJavaLMs: " + collection);
        }
        LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
        Iterator iterator = collection.iterator();
        ProductNumberAndRevisionInterface productNumberAndRevisionInterface = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        LinkedList<ProductNumberAndRevisionInterface> linkedList = new LinkedList<ProductNumberAndRevisionInterface>();
        while (iterator.hasNext()) {
            productNumberAndRevisionInterface = (ProductNumberAndRevisionInterface)iterator.next();
            loadModuleMoSU_Access = this.lookupLM_Mo(loadModuleMO_HandlerInterface, productNumberAndRevisionInterface);
            if (loadModuleMoSU_Access == null) continue;
            linkedList.add(productNumberAndRevisionInterface);
        }
        return linkedList;
    }

    private LoadModuleMoSU_Access lookupLM_Mo(LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface, ProductNumberAndRevisionInterface productNumberAndRevisionInterface) throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "lookupLM_Mo(LoadModuleMO_HandlerInterface aLoadModuleMO_HandlerInterface, ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "aLM_ProductNumberAndRevision: " + productNumberAndRevisionInterface);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModule(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision());
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "RETURNS theLM_Mo: " + loadModuleMoSU_Access);
            }
            return loadModuleMoSU_Access;
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new RestoreSU_Exception(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "lookupLM_Mo(ProductNumberAndRevisionInterface aLM_ProductNumberAndRevision)", "Throwable caught", throwable);
            throw new RestoreSU_Exception(throwable.toString());
        }
    }

    private void createSuConvertTable(ConverterState converterState, String string, String string2) throws RestoreSU_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSuConvertTable(ConverterState aConverterState, String anUP_ProductNumber, String anUP_ProductRevision)", "aConverterState: " + converterState + "\n\tanUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2);
        }
        try {
            UpgradeMoDataConverter.storeSuConvertInfoInTable(converterState, string, string2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSuConvertTable(boolean aRecordConvertToFile, boolean aRemoveRecordedFiles)", "Throwable caught during execution of the received trigger type.", throwable);
            throw new RestoreSU_Exception("Throwable caught when creating SU Convert table.\n\tThrowable: " + throwable);
        }
    }
}

