/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.shrink;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.FilepathHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallRemoveResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleInformation;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.delete.UpgradePackageLoadModuleFileHolder;
import se.ericsson.cello.upgradepackage.delete.UpgradePackageRemover;
import se.ericsson.cello.upgradepackage.information.ReferringCVsInformationHandler;
import se.ericsson.cello.upgradepackage.information.ReferringConfigurationVersionInfo;
import se.ericsson.cello.upgradepackage.information.UpgradePackageInformationException;
import se.ericsson.cello.upgradepackage.main.exception.UpgradePackageDeleteException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.shrink.CollectingNotRequiredLoadModulesInformation;
import se.ericsson.cello.upgradepackage.shrink.CurrentUP_NotMatchingTheExistingException;
import se.ericsson.cello.upgradepackage.shrink.DeletedLoadModulesInformation;
import se.ericsson.cello.upgradepackage.shrink.IllegalNumberOfUpgradePackagesException;
import se.ericsson.cello.upgradepackage.shrink.NoCurrentUP_Exception;
import se.ericsson.cello.upgradepackage.shrink.RemovingNotRequiredLoadModuleFilesInformation;
import se.ericsson.cello.upgradepackage.shrink.ShrinkConfirmedEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkException;
import se.ericsson.cello.upgradepackage.shrink.ShrinkFailureInformation;
import se.ericsson.cello.upgradepackage.shrink.ShrinkInitiatedInformation;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRejectReasonEnum;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRejectedEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkRequestEvent;
import se.ericsson.cello.upgradepackage.shrink.ShrinkedUP_FileHandler;
import se.ericsson.cello.upgradepackage.shrink.SucessfullyExecutedInformation;
import se.ericsson.cello.upgradepackage.shrink.UP_NotHwSensitiveException;
import se.ericsson.cello.upgradepackage.shrink.UP_TypeInformation;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.IdleProgressInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradePackageRelatedCVsDataContainer;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationFinishedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.VerificationInitiatedInformation;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.file.FileHandler;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ShrinkController {
    public static final char FRONTSLASH = '/';
    private static final String EMPTY_STRING = "";
    private static final String UNDERSCORE = "_";
    private static final char BACKSLASH = '\\';
    private static final char PERCENT = '&';
    private static final String FRONTSLASH_STRING = "/";
    public static final int ONE = 1;
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shrink(ShrinkRequestEvent shrinkRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            try {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerificationInitiatedInformation(this));
                int n = this.verifyShrinkRequest(shrinkRequestEvent);
                if (n == 1) {
                    this.shrinkHSI(shrinkRequestEvent);
                }
                this.shrinkPreUpgraded(shrinkRequestEvent);
            }
            catch (UP_NotHwSensitiveException uP_NotHwSensitiveException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "UP_NotHwSensitiveException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.IllegalTypeOfUP, uP_NotHwSensitiveException.getUP_TypeInformation().getDetailedInformation());
                Object var4_10 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (IllegalNumberOfUpgradePackagesException illegalNumberOfUpgradePackagesException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "IllegalNumberOfUpgradePackagesException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.MoreThanOneUP);
                Object var4_11 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (NoCurrentUP_Exception noCurrentUP_Exception) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "NoCurrentUP_Exception");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var4_12 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (CurrentUP_NotMatchingTheExistingException currentUP_NotMatchingTheExistingException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "CurrentUP_NotMatchingTheExistingException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var4_13 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (ShrinkException shrinkException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "ShrinkException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)shrinkException));
                Object var4_14 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "Throwable caught.\n\taShrinkRequestEvent: " + shrinkRequestEvent, throwable);
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + throwable);
                Object var4_15 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_16 = null;
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
            UpgradeCoordinator.instance().shrinkResponse();
            throw throwable;
        }
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
        UpgradeCoordinator.instance().shrinkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shrinkHSI(ShrinkRequestEvent shrinkRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            try {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerificationFinishedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ShrinkInitiatedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new CollectingNotRequiredLoadModulesInformation(this));
                HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
                Collection collection = hW_SensitiveAdapter.getRequiredLoadModules(new File(shrinkRequestEvent.getUpgradePackageUCF_Path()), shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), shrinkRequestEvent.getActualTypeOfUP().isDelta());
                Collection collection2 = this.getNotRequiredLoadModules(shrinkRequestEvent.getUpgradePackageUCF_Path(), shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), collection);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RemovingNotRequiredLoadModuleFilesInformation(this));
                DeletedLoadModulesInformation deletedLoadModulesInformation = this.deleteLoadModuleAndSM_Files(collection2);
                this.updateStates(deletedLoadModulesInformation.getLoadModuleFilePathsMap());
                String string = this.printDeletedFilesToFile(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), shrinkRequestEvent.getUpgradePackageUCF_Path(), deletedLoadModulesInformation.getDeletedLoadModuleFilePathsMap());
                deletedLoadModulesInformation.setShrinkLogFilePath(string);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SucessfullyExecutedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActionResult, new ShrinkConfirmedEvent((Object)this, deletedLoadModulesInformation));
            }
            catch (UP_NotHwSensitiveException uP_NotHwSensitiveException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "UP_NotHwSensitiveException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.IllegalTypeOfUP, uP_NotHwSensitiveException.getUP_TypeInformation().getDetailedInformation());
                Object var8_16 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (IllegalNumberOfUpgradePackagesException illegalNumberOfUpgradePackagesException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "IllegalNumberOfUpgradePackagesException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.MoreThanOneUP);
                Object var8_17 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (NoCurrentUP_Exception noCurrentUP_Exception) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "NoCurrentUP_Exception");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var8_18 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (CurrentUP_NotMatchingTheExistingException currentUP_NotMatchingTheExistingException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "CurrentUP_NotMatchingTheExistingException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var8_19 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (ShrinkException shrinkException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "ShrinkException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)shrinkException));
                Object var8_20 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "LoadModuleMO_HandlerException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)loadModuleMO_HandlerException));
                Object var8_21 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "HW_SensitiveAdapterException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)hW_SensitiveAdapterException));
                Object var8_22 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "Throwable caught.\n\taShrinkRequestEvent: " + shrinkRequestEvent, throwable);
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + throwable);
                Object var8_23 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_24 = null;
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
            UpgradeCoordinator.instance().shrinkResponse();
            throw throwable;
        }
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
        UpgradeCoordinator.instance().shrinkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shrinkPreUpgraded(ShrinkRequestEvent shrinkRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "shrinkPreUpgraded(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            try {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkPreUpgraded(ShrinkRequestEvent aShrinkRequestEvent)", "Shrink on an upgrade package MO that is pre upgraded and the loaded CV is a pre upgraded CV");
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new VerificationFinishedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ShrinkInitiatedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new CollectingNotRequiredLoadModulesInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new RemovingNotRequiredLoadModuleFilesInformation(this));
                String[] stringArray = new String[]{"LoadModule", "UpgradeLogic"};
                documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), shrinkRequestEvent.getUpgradePackageUCF_Path(), stringArray);
                Collection collection = UpgradePackageRemover.instance().collectLMsDataThatMayBeDeleted(shrinkRequestEvent.getUpgradePackageUCF_Path(), documentObjectProxyInterface, shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                collection = this.excludeSU_LMs(collection, documentObjectProxyInterface);
                DeletedLoadModulesInformation deletedLoadModulesInformation = this.deleteLoadModuleAndSM_Files(collection);
                this.updateStates(deletedLoadModulesInformation.getLoadModuleFilePathsMap());
                this.updateUP_State(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
                String string = this.printDeletedFilesToFile(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), shrinkRequestEvent.getUpgradePackageUCF_Path(), deletedLoadModulesInformation.getDeletedLoadModuleFilePathsMap());
                deletedLoadModulesInformation.setShrinkLogFilePath(string);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SucessfullyExecutedInformation(this));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActionResult, new ShrinkConfirmedEvent((Object)this, deletedLoadModulesInformation));
            }
            catch (UP_NotHwSensitiveException uP_NotHwSensitiveException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "UP_NotHwSensitiveException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.IllegalTypeOfUP, uP_NotHwSensitiveException.getUP_TypeInformation().getDetailedInformation());
                Object var8_16 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (IllegalNumberOfUpgradePackagesException illegalNumberOfUpgradePackagesException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "IllegalNumberOfUpgradePackagesException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.MoreThanOneUP);
                Object var8_17 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (NoCurrentUP_Exception noCurrentUP_Exception) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "NoCurrentUP_Exception");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var8_18 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (CurrentUP_NotMatchingTheExistingException currentUP_NotMatchingTheExistingException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "CurrentUP_NotMatchingTheExistingException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.OnlyAllowedOnCurrentUP);
                Object var8_19 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (ShrinkException shrinkException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "ShrinkException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)shrinkException));
                Object var8_20 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "LoadModuleMO_HandlerException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)loadModuleMO_HandlerException));
                Object var8_21 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "HW_SensitiveAdapterException");
                }
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + (Object)((Object)hW_SensitiveAdapterException));
                Object var8_22 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "shrinkHSI(ShrinkRequestEvent aShrinkRequestEvent)", "Throwable caught.\n\taShrinkRequestEvent: " + shrinkRequestEvent, throwable);
                this.rejectShrinkRequest(ShrinkRejectReasonEnum.Unspecified, "Unexpected failure with reason: " + throwable);
                Object var8_23 = null;
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                UpgradeCoordinator.instance().shrinkResponse();
                return;
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_24 = null;
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
            UpgradeCoordinator.instance().shrinkResponse();
            throw throwable;
        }
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
        UpgradeCoordinator.instance().shrinkResponse();
    }

    private void updateUP_State(String string, String string2) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateUP_State(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface();
            UpgradePackageMoExtended upgradePackageMoExtended = upgradePackageMO_HandlerInterface.getUpgradePackageMo(string, string2);
            ManagedObject[] managedObjectArray = upgradePackageMoExtended.getLoadModuleList(null);
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            for (int i = 0; i < managedObjectArray.length; ++i) {
                linkedList.add(managedObjectArray[i]);
            }
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Collection collection = loadModuleMO_HandlerInterface.getNotInstalledLoadModules(linkedList);
            Collection collection2 = loadModuleMO_HandlerInterface.getInstalledLoadModules(linkedList);
            if (collection.isEmpty()) {
                upgradePackageMoExtended.setStateValue(1);
            } else if (collection2.isEmpty()) {
                upgradePackageMoExtended.setStateValue(0);
            } else {
                upgradePackageMoExtended.setStateValue(6);
            }
        }
        catch (UpgradePackageMO_HandlerException upgradePackageMO_HandlerException) {
            throw new ShrinkException(upgradePackageMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateUP_State(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
            throw new ShrinkException(throwable.toString());
        }
    }

    private Collection excludeSU_LMs(Collection collection, DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "excludeSU_LMs(Collection aLoadModuleInformationNotNeeded, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aLoadModuleInformationNotNeeded: " + collection + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
        Collection collection2 = upgradeLogicProxyInterface.getLoadModules();
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection2));
        Iterator iterator = collection.iterator();
        LoadModuleInformation loadModuleInformation = null;
        LinkedList<LoadModuleInformation> linkedList = new LinkedList<LoadModuleInformation>();
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            if (productNumbersAndRevisions.contains(loadModuleInformation.getProductNumber(), loadModuleInformation.getProductRevision())) continue;
            linkedList.add(loadModuleInformation);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "excludeSU_LMs(Collection aLoadModuleInformationNotNeeded, DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "RETURNS - theLoadModuleInformationNotNeededWherSU_IsExcluded: " + linkedList);
        }
        return linkedList;
    }

    private void updateStates(HashMap hashMap) throws LoadModuleMO_HandlerException, HW_SensitiveAdapterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateStates(HashMap aDeletedLM_Files)", "aDeletedLM_Files: " + hashMap);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "updateLM_FileStates(HashMap aDeletedLM_Files)", "Updating state in LoadModule MO's and PiuType MO's");
        }
        Iterator iterator = hashMap.keySet().iterator();
        LoadModuleInformation loadModuleInformation = null;
        LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            loadModuleMO_HandlerInterface.updateFileStateInLM(new ProductNumberAndRevision(loadModuleInformation.getProductNumber(), loadModuleInformation.getProductRevision()));
        }
        HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
        hW_SensitiveAdapter.updateStateInAllPiuTypes();
    }

    private String printDeletedFilesToFile(String string, String string2, String string3, HashMap hashMap) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "printDeletedFilesToFile (String aProductNumber, String aProductRevision, String anUCF_Path, HashMap aDeletedLM_Files)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanUCF_Path: " + string3 + "\n\taDeletedLM_Files: " + hashMap);
        }
        try {
            ShrinkedUP_FileHandler shrinkedUP_FileHandler = new ShrinkedUP_FileHandler();
            return shrinkedUP_FileHandler.print(string, string2, string3, hashMap);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "printDeletedFilesToFile (HashMap aDeletedLM_Files)", "aDeletedLM_Files: " + hashMap + "Throwable caught (ignored): " + throwable);
            return null;
        }
    }

    private DeletedLoadModulesInformation deleteLoadModuleAndSM_Files(Collection collection) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLoadModuleAndSM_Files(Collection aLoadModuleInformations)", "aLoadModuleInformations: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleInformation loadModuleInformation = null;
            UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = null;
            HashMap<LoadModuleInformation, UpgradePackageLoadModuleFileHolder> hashMap = new HashMap<LoadModuleInformation, UpgradePackageLoadModuleFileHolder>();
            while (iterator.hasNext()) {
                loadModuleInformation = (LoadModuleInformation)iterator.next();
                upgradePackageLoadModuleFileHolder = this.getLoadModuleAndSM_FilePaths(loadModuleInformation);
                hashMap.put(loadModuleInformation, upgradePackageLoadModuleFileHolder);
            }
            Iterator iterator2 = hashMap.keySet().iterator();
            UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder2 = null;
            HashMap<LoadModuleInformation, UpgradePackageLoadModuleFileHolder> hashMap2 = new HashMap<LoadModuleInformation, UpgradePackageLoadModuleFileHolder>();
            boolean bl = true;
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (!this.isSU_VersionSupported(osaSwInstallProxyAccess, "SU_4")) {
                bl = false;
            }
            while (iterator2.hasNext()) {
                loadModuleInformation = (LoadModuleInformation)iterator2.next();
                upgradePackageLoadModuleFileHolder2 = (UpgradePackageLoadModuleFileHolder)hashMap.get(loadModuleInformation);
                if (!this.deleteLM_AndSM_Files(upgradePackageLoadModuleFileHolder2, bl, osaSwInstallProxyAccess)) continue;
                hashMap2.put(loadModuleInformation, upgradePackageLoadModuleFileHolder2);
            }
            return new DeletedLoadModulesInformation(hashMap, hashMap2);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteLoadModuleAndSM_Files(Collection aLoadModuleInformations)", "Throwable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private boolean isSU_VersionSupported(OsaSwInstallProxyAccess osaSwInstallProxyAccess, String string) {
        try {
            return SU_AccessVersionHandler.getInstance().isCurrentlySupported(string, (Object)osaSwInstallProxyAccess);
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "isSU_VersionSupported(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, SU_AccessVersion anSU_AccessVersion)", "Assuming that the requested version not is supported", sU_ConditionalException);
            return false;
        }
    }

    private boolean deleteLM_AndSM_Files(UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, boolean bl, OsaSwInstallProxyAccess osaSwInstallProxyAccess) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLM_AndSM_Files(UpgradePackageLoadModuleFileHolder aLM_FilePaths, boolean anIsAllFilesToBeDeletedByFroLayer, OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "anLM_AndSM_FilePaths: " + upgradePackageLoadModuleFileHolder + "\n\tanIsAllFilesToBeDeletedByFroLayer: " + bl + "\n\tanOsaSwInstallProxyAccess: " + osaSwInstallProxyAccess);
        }
        try {
            if (bl) {
                return this.deleteLM_AndSM_FilesOnBothPartitions(upgradePackageLoadModuleFileHolder, osaSwInstallProxyAccess);
            }
            Iterator iterator = upgradePackageLoadModuleFileHolder.getReplicatedLoadModuleAndSM_FilePaths().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.deleteReplicatedLoadModuleOrSM_File(string);
            }
            return this.deleteMasterLoadModuleAndSM_Files(upgradePackageLoadModuleFileHolder.getMasterLoadModuleAndSM_FilePaths());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteLM_AndSM_Files(UpgradePackageLoadModuleFileHolder anLM_AndSM_FilePaths, boolean anIsAllFilesToBeDeletedByFroLayer, OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "anLM_AndSM_FilePaths: " + upgradePackageLoadModuleFileHolder + "\n\tanIsAllFilesToBeDeletedByFroLayer: " + bl + "\n\tanOsaSwInstallProxyAccess: " + osaSwInstallProxyAccess + "\n\tThrowable caught", throwable);
            return false;
        }
    }

    private boolean deleteLM_AndSM_FilesOnBothPartitions(UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, OsaSwInstallProxyAccess osaSwInstallProxyAccess) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLM_AndSM_FilesOnBothPartitions(UpgradePackageLoadModuleFileHolder anLM_AndSM_FilePaths, OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "anLM_AndSM_FilePaths: " + upgradePackageLoadModuleFileHolder + "\n\tanOsaSwInstallProxyAccess: " + osaSwInstallProxyAccess);
        }
        try {
            Collection collection = upgradePackageLoadModuleFileHolder.getMasterLoadModuleAndSM_FilePaths();
            Collection collection2 = UpgradePackageRemover.instance().findSubDirectoriesUndertftp(collection);
            Iterator iterator = collection2.iterator();
            File file = null;
            boolean bl = false;
            boolean bl2 = false;
            LinkedList<File> linkedList = new LinkedList<File>();
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (!file.exists()) continue;
                bl = true;
                if (!file.isDirectory()) {
                    if (this.sendDeleteRequest2(osaSwInstallProxyAccess, file.getAbsolutePath())) continue;
                    bl2 = true;
                    continue;
                }
                linkedList.add(file);
            }
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                file = (File)iterator2.next();
                if (!UpgradePackageRemover.instance().isEmptyDirectory(file) || this.sendDeleteRequest2(osaSwInstallProxyAccess, file.getAbsolutePath())) continue;
                bl2 = true;
            }
            return bl && !bl2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteLM_AndSM_FilesOnBothPartitions(UpgradePackageLoadModuleFileHolder anLM_AndSM_FilePaths, OsaSwInstallProxyAccess anOsaSwInstallProxyAccess)", "Throwable caught when trying to delete files (on C: and D: drives).", throwable);
            return false;
        }
    }

    private boolean deleteMasterLoadModuleAndSM_Files(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteMasterLoadModuleFiles(Collection aMasterFilePaths)", "aMasterFilePaths: " + collection);
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            LinkedList<File> linkedList = new LinkedList<File>();
            Iterator iterator = collection.iterator();
            File file = null;
            while (iterator.hasNext()) {
                file = (File)iterator.next();
                if (file.isDirectory()) {
                    linkedList.add(file);
                    continue;
                }
                bl = this.deleteLoadModuleOrSM_File(file);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteMasterLoadModuleFiles(Collection aMasterFilePaths)", "Delete all directories and their subdirectories: \n\ttheDirectoriesToBeDeleted: " + FileHandler.toString(linkedList));
            }
            Iterator iterator2 = linkedList.iterator();
            File file2 = null;
            while (iterator2.hasNext()) {
                file2 = (File)iterator2.next();
                bl2 = this.deleteDirectoryRecursively(file2);
            }
            return bl || bl2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteMasterLoadModuleFiles(Collection aMasterFilePaths)", "Throwable caught when trying to delete Load Module and SM files (on C disk) ignored", throwable);
            return false;
        }
    }

    private boolean deleteDirectoryRecursively(File file) throws UpgradePackageDeleteException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteDirectoryRecursively(File aDirectoryPath)", "aDirectoryPath: " + file.getAbsolutePath());
        }
        boolean bl = false;
        try {
            if (!file.exists()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteDirectoryRecursively(File aDirectoryPath)", "The directory path do not exist (has been deleted when deleting a dir for some other LM) - ignoring");
                }
                return bl;
            }
            String[] stringArray = file.list();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deleteDirectoryRecursively(File aDirectoryPath)", "theSubDirs: " + SuLib.toString(stringArray));
            }
            String string = null;
            File file2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = file.getAbsolutePath();
                if (!string.endsWith(FRONTSLASH_STRING)) {
                    string = string + FRONTSLASH_STRING;
                }
                if ((file2 = new File(string + stringArray[i])).isDirectory()) {
                    this.deleteDirectoryRecursively(file2);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "deleteDirectoryRecursively(File aDirectoryPath)", "A file has been found in the directory structure (it might be the case where two load modules have the same directory structure).\n\tDue to this it is not possible to delete this path element\n\ttheSubDir: " + file2.getAbsolutePath());
            }
            stringArray = file.list();
            if (stringArray.length == 0) {
                if (file.delete()) {
                    return bl;
                }
                Trace.info(this.getClass(), "deleteDirectoryRecursively(File aDirectoryPath)", "Failed to delete an empty directory (ignored)\n\taDirectoryPath: " + file.getAbsolutePath());
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "deleteDirectoryRecursively(File aDirectoryPath)", "Throwable caught (ignored): \n\t" + throwable + "\n\taDirectoryPath: " + file.getAbsolutePath());
            return bl;
        }
    }

    private boolean deleteLoadModuleOrSM_File(File file) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteLoadModuleOrSM_File(File aFilePath)", "aFilePath: " + file.getAbsolutePath());
        }
        boolean bl = false;
        try {
            if (file.delete()) {
                bl = true;
            } else {
                Trace.info(this.getClass(), "deleteLoadModuleOrSM_File(File aFilePath)", "Failure when trying to delete the Load Module or SM file (ignored) '" + file.getAbsolutePath() + "'.");
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteLoadModuleOrSM_File(File aFilePath)", "aFilePath: " + file.getAbsolutePath() + "Failed to delete the file due to Throwable caught (ignored)", throwable);
            return bl;
        }
    }

    private void deleteReplicatedLoadModuleOrSM_File(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteReplicatedLoadModuleOrSM_File(String aReplicatedFilePath)", "aReplicatedFilePath: " + string);
        }
        try {
            if (string == null) {
                return;
            }
            if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultReplicatedPath())) {
                string = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath().length());
            } else if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath())) {
                string = this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath() + string.substring((this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath()).length());
            }
            try {
                this.sendDeleteRequest(string);
                this.deleteTarFileDirectory(string);
            }
            catch (Throwable throwable) {
                Trace.info(this.getClass(), "deleteReplicatedLoadModuleOrSM_File( Vector aReplicatedLoadModuleFilePath )", "Throwable caught when trying to delete the replicated Load Module or SM file '" + string + "' (ignored)." + " Throwable = " + throwable);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "deleteReplicatedLoadModuleOrSM_File( Vector aReplicatedLoadModuleFilePath )", "Throwable caught when trying to delete replicated Load Module or SM file (on D disk), ignored", throwable);
        }
    }

    private void deleteTarFileDirectory(String string) {
        String string2 = null;
        try {
            File file;
            if (string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) && !(string2 = string.substring(0, string.lastIndexOf(FRONTSLASH_STRING) + 1)).equals(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath()) && (file = new File(string2)).isDirectory()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "deleteTarFileDirectory(String aReplicatedLoadModuleFilePath)", "delete the tar file directory: " + string2);
                }
                this.sendDeleteRequest(string2);
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "deleteTarFileDirectory(String aReplicatedLoadModuleFilePath)", "Exception caught when trying to delete tar file directory : " + string2 + exception);
        }
    }

    private void sendDeleteRequest(String string) throws Exception {
        InstallRemoveResultInformation installRemoveResultInformation = this.sendSignalOsaSwInstallRemoveReq(string);
        if (installRemoveResultInformation.result != 1) {
            Trace.error(this.getClass(), "deleteReplicatedLoadModuleFile(String aReplicatedLoadModuleFilePath)", "Failure when trying to delete the replicated Load Module file '" + string + "' (ignored).");
        }
    }

    private InstallRemoveResultInformation sendSignalOsaSwInstallRemoveReq(String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalOsaSwInstallRemoveReq(String aReplicatedLoadModuleFilePath)", "aReplicatedLoadModuleFilePath: " + string);
        }
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        InstallRemoveResultInformation installRemoveResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallRemoveReq(string);
        return installRemoveResultInformation;
    }

    private boolean sendDeleteRequest2(OsaSwInstallProxyAccess osaSwInstallProxyAccess, String string) throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendDeleteRequest2(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, String aMasterLM_OrSM_FilePath)", "anOsaSwInstallProxyAccess: " + osaSwInstallProxyAccess + "\n\taMasterLM_OrSM_FilePath: " + string);
        }
        InstallRemoveResultInformation installRemoveResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallRemove2Req(string);
        if (installRemoveResultInformation.result == 1) {
            return true;
        }
        Trace.info(this.getClass(), "sendDeleteRequest2(OsaSwInstallProxyAccess anOsaSwInstallProxyAccess, String aMasterLM_OrSM_FilePath)", "Failure when trying to delete the LM/SM file '" + string + "' during shrink (ignored).");
        return false;
    }

    private UpgradePackageLoadModuleFileHolder getLoadModuleAndSM_FilePaths(LoadModuleInformation loadModuleInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleAndSM_FilePaths(LoadModuleInformation aLoadModuleInformation)", "aLoadModuleInformation: " + loadModuleInformation);
        }
        UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = new UpgradePackageLoadModuleFileHolder();
        Collection collection = loadModuleInformation.getDestinationPaths();
        upgradePackageLoadModuleFileHolder = collection.isEmpty() ? this.getDefaultLoadModuleAndSM_FilePaths(loadModuleInformation) : this.getStatedLoadModuleAndSM_FilePaths(loadModuleInformation, collection);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getLoadModuleAndSM_FilePaths(LoadModuleInformation aLoadModuleInformation)", "RETURNS - theLoadModuleAndSM_FilePaths: " + upgradePackageLoadModuleFileHolder);
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private UpgradePackageLoadModuleFileHolder getDefaultLoadModuleAndSM_FilePaths(LoadModuleInformation loadModuleInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDefaultLoadModuleAndSM_FilePaths(LoadModuleInformation aLoadModuleInformation)", "aLoadModuleInformation: " + loadModuleInformation);
        }
        UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = new UpgradePackageLoadModuleFileHolder();
        String string = loadModuleInformation.getProductNumber() + UNDERSCORE + loadModuleInformation.getProductRevision();
        string = string.replace('/', '&');
        string = string.replace('\\', '&');
        String string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath() + string;
        upgradePackageLoadModuleFileHolder = this.addLoadModuleFilePath(string2, upgradePackageLoadModuleFileHolder);
        if (loadModuleInformation.getIsContainingsInstallSM()) {
            String string3 = string2 + "." + loadModuleInformation.getSM_Extension();
            upgradePackageLoadModuleFileHolder = this.addSM_FilePath(string3, upgradePackageLoadModuleFileHolder);
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private UpgradePackageLoadModuleFileHolder getStatedLoadModuleAndSM_FilePaths(LoadModuleInformation loadModuleInformation, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStatedLoadModuleAndSM_FilePaths(LoadModuleInformation aLoadModuleInformation, Collection aDestinationPaths)", "aLoadModuleInformation: " + loadModuleInformation + "\n\taDestinationPaths: " + collection);
        }
        UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = new UpgradePackageLoadModuleFileHolder();
        Iterator iterator = collection.iterator();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string;
            upgradePackageLoadModuleFileHolder = this.addLoadModuleFilePath(string2, upgradePackageLoadModuleFileHolder);
            if (!string2.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) continue;
            string3 = FilepathHandler.addInstallDirectoryToLoadModulePath(string2);
            upgradePackageLoadModuleFileHolder = this.addLoadModuleFilePath(string3, upgradePackageLoadModuleFileHolder);
        }
        if (loadModuleInformation.getIsContainingsInstallSM()) {
            Collection collection2 = loadModuleInformation.getDestinationPathsRefs();
            if (collection2.isEmpty()) {
                string4 = string2 + "." + loadModuleInformation.getSM_Extension();
                upgradePackageLoadModuleFileHolder = this.addSM_FilePath(string4, upgradePackageLoadModuleFileHolder);
                if (string4.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) {
                    string3 = FilepathHandler.addInstallDirectoryToLoadModulePath(string4);
                    upgradePackageLoadModuleFileHolder = this.addSM_FilePath(string3, upgradePackageLoadModuleFileHolder);
                }
            } else {
                Iterator iterator2 = collection2.iterator();
                String string5 = null;
                while (iterator2.hasNext()) {
                    string5 = (String)iterator2.next();
                    string4 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string5;
                    upgradePackageLoadModuleFileHolder = this.addSM_FilePath(string4, upgradePackageLoadModuleFileHolder);
                }
            }
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private UpgradePackageLoadModuleFileHolder addLoadModuleFilePath(String string, UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder) {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLoadModuleFilePath(String anLM_FilePath, UpgradePackageLoadModuleFileHolder aLoadModuleAndSM_FilePaths)", "anLM_FilePath: " + string + "\n\taLoadModuleFilePaths: " + upgradePackageLoadModuleFileHolder);
        }
        if ((file = new File(string)).exists()) {
            upgradePackageLoadModuleFileHolder.addMasterLoadModuleFilePath(file);
        }
        if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
            String string2 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
            upgradePackageLoadModuleFileHolder.addReplicatedLoadModuleFilePath(string2);
        } else if (string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
            String string3 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath() + string.substring(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath().length());
            upgradePackageLoadModuleFileHolder.addReplicatedLoadModuleFilePath(string3);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addLoadModuleFilePath(String anLM_FilePath, UpgradePackageLoadModuleFileHolder aLoadModuleAndSM_FilePaths)", "RETURNS - aLoadModuleAndSM_FilePaths: " + upgradePackageLoadModuleFileHolder);
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private UpgradePackageLoadModuleFileHolder addSM_FilePath(String string, UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder) {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addSM_FilePath(String anSM_FilePath, UpgradePackageLoadModuleFileHolder aLoadModuleAndSM_FilePaths)", "anSM_FilePath: " + string + "\n\taLoadModuleAndSM_FilePaths: " + upgradePackageLoadModuleFileHolder);
        }
        if ((file = new File(string)).exists()) {
            upgradePackageLoadModuleFileHolder.addMasterSMFilePath(file);
        }
        String string2 = null;
        if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
            string2 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
            upgradePackageLoadModuleFileHolder.addReplicatedSMFilePath(string2);
        } else if (string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
            string2 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath() + string.substring(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath().length());
            upgradePackageLoadModuleFileHolder.addReplicatedSMFilePath(string2);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addSM_FilePath(String anSM_FilePath, UpgradePackageLoadModuleFileHolder aLoadModuleAndSM_FilePaths)", "RETURNS - aLoadModuleAndSM_FilePaths: " + upgradePackageLoadModuleFileHolder);
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private Collection getNotRequiredLoadModules(String string, String string2, String string3, Collection collection) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotRequiredLoadModules(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision, Collection aRequiredLoadModules)", "anUCF_Path: " + string + "\n\tanUP_ProductNumber: " + string2 + "\n\tanUP_ProductRevision: " + string3 + "\n\taRequiredLoadModules: " + collection);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(string2, string3, string, "LoadModule");
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            Vector vector = new Vector(collection);
            Collection collection2 = loadModulesProxyInterface.getNotReferencedLoadModulesAsNumberAndRevision(new ProductNumbersAndRevisions(vector));
            Iterator iterator = collection2.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            LoadModuleInformation loadModuleInformation = null;
            LinkedList<LoadModuleInformation> linkedList = new LinkedList<LoadModuleInformation>();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
                loadModuleInformation = loadModuleProxyInterface.getLoadModuleInformation();
                linkedList.add(loadModuleInformation);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNotRequiredLoadModules(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision, Collection aRequiredLoadModules)", "RETURNS - theNotRequiredLM_informations: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNotRequiredLoadModules(String anUCF_Path, String anUP_ProductNumber, String anUP_ProductRevision, Collection aRequiredLoadModules)", "Throwable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private void rejectShrinkRequest(ShrinkRejectReasonEnum shrinkRejectReasonEnum) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rejectShrinkRequest(ShrinkRejectReasonEnum aShrinkRejectReasonEnum)", "aShrinkRejectReasonEnum: " + shrinkRejectReasonEnum);
        }
        this.rejectShrinkRequest(shrinkRejectReasonEnum, EMPTY_STRING);
    }

    private void rejectShrinkRequest(ShrinkRejectReasonEnum shrinkRejectReasonEnum, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "rejectShrinkRequest(ShrinkRejectReasonEnum aShrinkRejectReasonEnum)", "aShrinkRejectReasonEnum: " + shrinkRejectReasonEnum);
        }
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ShrinkFailureInformation((Object)this, shrinkRejectReasonEnum.getDescription()));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActionResult, new ShrinkRejectedEvent(this, shrinkRejectReasonEnum, string));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "rejectShrinkRequest(ShrinkRejectReasonEnum aShrinkRejectReasonEnum)", "Throwable caught.\n\taShrinkRejectReasonEnum: " + shrinkRejectReasonEnum, throwable);
        }
    }

    private int verifyShrinkRequest(ShrinkRequestEvent shrinkRequestEvent) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            this.verifyShrinkRequestHSI_Variant(shrinkRequestEvent);
            return 1;
        }
        catch (ShrinkException shrinkException) {
            if (this.isUP_PreUpgradedVariant(shrinkRequestEvent)) {
                return 2;
            }
            throw shrinkException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyShrinkRequest(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent + "\n\tThrowable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private void verifyShrinkRequestHSI_Variant(ShrinkRequestEvent shrinkRequestEvent) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyShrinkRequestHSI_Variant(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            Collection collection = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMOs();
            if (collection.size() != 1) {
                throw new IllegalNumberOfUpgradePackagesException(collection);
            }
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended == null) {
                throw new NoCurrentUP_Exception();
            }
            UpgradePackageMoExtended[] upgradePackageMoExtendedArray = new UpgradePackageMoExtended[collection.size()];
            if (upgradePackageMoExtended != (upgradePackageMoExtendedArray = collection.toArray(upgradePackageMoExtendedArray))[0]) {
                throw new CurrentUP_NotMatchingTheExistingException(upgradePackageMoExtended, upgradePackageMoExtendedArray[0]);
            }
            UP_TypeInformation uP_TypeInformation = this.isUP_OfTypeHSI(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision(), shrinkRequestEvent.getActualTypeOfUP());
            if (!uP_TypeInformation.isUP_OfTypeHSI()) {
                throw new UP_NotHwSensitiveException(uP_TypeInformation);
            }
        }
        catch (ShrinkException shrinkException) {
            throw shrinkException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyShrinkRequestHSI_Variant(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent + "\n\tThrowable caught", throwable);
        }
    }

    private boolean isUP_PreUpgradedVariant(ShrinkRequestEvent shrinkRequestEvent) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUP_PreUpgradedVariant(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            Collection collection = ServiceFinder.getUpgradePackageMO_HandlerInterface().getUpgradePackageMOs();
            boolean bl = false;
            if (collection.size() > 1 && (shrinkRequestEvent.getState() == 1 || shrinkRequestEvent.getState() == 6) && this.isLoadedCvPreUpgradedCv() && this.isUP_ToShrinkConnectedToLoadedCv(shrinkRequestEvent)) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isUP_PreUpgradedVariant(ShrinkRequestEvent aShrinkRequestEvent)", "RETURNS - theIsUP_PreUpgradedVariant: " + bl);
            }
            return bl;
        }
        catch (ShrinkException shrinkException) {
            throw shrinkException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUP_PreUpgradedVariant(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent + "\n\tThrowable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private boolean isLoadedCvPreUpgradedCv() throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isLoadedCvPreUpgradedCv()");
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = configurationVersionMO_HandlerInterface.getCurrentLoadedConfigurationVersion(null);
            CV_PreUpgradeRelationHandler.getInstance().synchExistingCVsWithPreUpgradedCVs();
            String[] stringArray = CV_PreUpgradeRelationHandler.getInstance().getAllPreUpgradedCVs(null);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                bl = true;
                break;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isLoadedCvPreUpgradedCv()", "RETURNS - theIsLoadedCV_PreUpgradedCV: " + bl);
            }
            return bl;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new ShrinkException(mO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isLoadedCvPreUpgradedCv()", "\n\tThrowable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private boolean isUP_ToShrinkConnectedToLoadedCv(ShrinkRequestEvent shrinkRequestEvent) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUP_ToShrinkConnectedToLoadedCv(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent);
        }
        try {
            boolean bl = false;
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = configurationVersionMO_HandlerInterface.getCurrentLoadedConfigurationVersion(null);
            String string2 = SuLib.createUpgradePackageDocumentId(shrinkRequestEvent.getUpgradePackageDocumentNumber(), shrinkRequestEvent.getUpgradePackageDocumentRevision());
            UpgradePackageRelatedCVsDataContainer upgradePackageRelatedCVsDataContainer = configurationVersionMO_HandlerInterface.getUpgradePackageRelatedCVsData(string2);
            if (upgradePackageRelatedCVsDataContainer.contains(string)) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isUP_ToShrinkConnectedToLoadedCv(ShrinkRequestEvent aShrinkRequestEvent)", "RETURNS - theIsUP_ToShrinkConnectedToLoadedCv: " + bl);
            }
            return bl;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new ShrinkException(mO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUP_ConnectedToAnyCvViaDocumentID(ShrinkRequestEvent aShrinkRequestEvent)", "aShrinkRequestEvent: " + shrinkRequestEvent + "\n\tThrowable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private UP_TypeInformation isUP_OfTypeHSI(String string, String string2, ActualTypeOfUP actualTypeOfUP) throws ShrinkException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isUP_OfTypeHSI(String aProductNumber, String aProductRevision, ActualTypeOfUP anActualTypeOfUP)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tanActualTypeOfUP: " + actualTypeOfUP);
        }
        try {
            UP_TypeInformation uP_TypeInformation = new UP_TypeInformation(true, EMPTY_STRING);
            if (actualTypeOfUP.isHW_Sensitive()) {
                ReferringCVsInformationHandler referringCVsInformationHandler = new ReferringCVsInformationHandler(string, string2);
                Collection collection = referringCVsInformationHandler.getReferringConfigurationVersionInfos();
                Iterator iterator = collection.iterator();
                ReferringConfigurationVersionInfo referringConfigurationVersionInfo = null;
                while (iterator.hasNext()) {
                    referringConfigurationVersionInfo = (ReferringConfigurationVersionInfo)iterator.next();
                    if (referringConfigurationVersionInfo.activatedTypeOfUP.getValue() == ActivatedTypeOfUP.HW_Sensitive.getValue() || referringConfigurationVersionInfo.activatedTypeOfUP.getValue() == ActivatedTypeOfUP.DeltaHW_Sensitive.getValue()) continue;
                    String string3 = "The UP type is regarded as not HwSensitive according to the UP referring CVs:" + this.getReferringCvsInformationToString(collection);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "isUP_OfTypeHSI(String aProductNumber, String aProductRevision)", "Not possible to execute HSI shrink since the UP type is regarded as not HSI according to the UP referring CVs\n\ttheReferringConfigurationVersionInfo: " + referringConfigurationVersionInfo + "\n\tUP Product number: " + string + "\n\tUP product revision: " + string2);
                    }
                    uP_TypeInformation = new UP_TypeInformation(false, string3);
                    break;
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isUP_OfTypeHSI(String aProductNumber, String aProductRevision)", "Not possible to execute HSI shrink since the actual type of UP is defined as " + actualTypeOfUP.getDescription() + "\n\tUP Product number: " + string + "\n\tUP product revision: " + string2);
                }
                uP_TypeInformation = new UP_TypeInformation(false, "The actual type of UP is defined as " + actualTypeOfUP.getDescription());
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isUP_OfTypeHSI(String aProductNumber, String aProductRevision)", "RETURNS - theUP_TypeInformation: " + uP_TypeInformation);
            }
            return uP_TypeInformation;
        }
        catch (UpgradePackageInformationException upgradePackageInformationException) {
            throw new ShrinkException(upgradePackageInformationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isUP_OfTypeHSI(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tThrowable caught", throwable);
            throw new ShrinkException(throwable.toString());
        }
    }

    private String getReferringCvsInformationToString(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getReferringCvsInformationToString(Collection aReferringConfigurationVersionInfos)", "aReferringConfigurationVersionInfos: " + collection);
        }
        String string = EMPTY_STRING;
        ReferringConfigurationVersionInfo referringConfigurationVersionInfo = null;
        Iterator iterator = collection.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            referringConfigurationVersionInfo = (ReferringConfigurationVersionInfo)iterator.next();
            string2 = referringConfigurationVersionInfo.activatedTypeOfUP.getValue() == ActivatedTypeOfUP.Undefined.getValue() ? ActivatedTypeOfUP.Adapted.getDescription() : referringConfigurationVersionInfo.activatedTypeOfUP.getDescription();
            string = string + "\n\tReferring CV " + referringConfigurationVersionInfo.configurationVersionName + " where the UP is of type " + string2;
        }
        return string;
    }
}

