/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.property.PropertyChangeSupport;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandler;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceInfoInterface;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceData;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceDebug;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceError;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfo;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceLog;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceWarning;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;

public class Trace {
    private static String[] myFilterPropertyChangeClasses = new String[]{"ProgressInformationHandler"};
    private static Class myValidatedClass = Object.class;
    private static int myValidatedPriorityLevel = Integer.MAX_VALUE;
    private static boolean myIsInSuSimEnvironment = false;
    private static SimpleDateFormat myTraceLogTextTimeStringFormatter = new SimpleDateFormat("'Date:'\tyyyy-MM-dd', Time:' H:mm:ss.SSS", Locale.getDefault());
    private static PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)Trace.class);
    private static UpgradeTraceInfoInterface myUpgradeTraceHandler = UpgradeTraceHandler.instance();

    public static void flushToTraceFile() {
        if (myUpgradeTraceHandler.getTraceInfoData().getOutputMode() == 0) {
            myUpgradeTraceHandler.flushToTraceFile();
        }
    }

    public static boolean valid(Class clazz, int n) {
        boolean bl = false;
        try {
            if ((Trace.isPrioValidToLevel(n) || Trace.isPrioValidToLevelsSU(n)) && Trace.isClassNameToBeLogged(Trace.getClassName(clazz))) {
                myValidatedPriorityLevel = n;
                myValidatedClass = clazz;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "valid(Class aClass, int aPriority)", "Throwable caught, SU trace log might have been lost. ", throwable);
        }
        return bl;
    }

    private static boolean isPrioValidToLevelsSU(int n) {
        boolean bl = false;
        if (!myUpgradeTraceHandler.getTraceInfoData().getLevelsSU().isEmpty() && myUpgradeTraceHandler.getTraceInfoData().getLevelsSU().contains(new Integer(n))) {
            bl = true;
        }
        return bl;
    }

    private static boolean isPrioValidToLevel(int n) {
        boolean bl = true;
        if (n > myUpgradeTraceHandler.getTraceInfoData().getLevel() || n < 3) {
            bl = false;
        }
        return bl;
    }

    private static boolean validate(Class clazz, int n) {
        boolean bl = false;
        try {
            if ((Trace.isPrioValidToLevel(n) || Trace.isPrioValidToLevelsSU(n)) && Trace.isClassNameToBeLogged(Trace.getClassName(clazz))) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "valid(Class aClass, int aPriority)", "Throwable caught, SU trace log might have been lost. ", throwable);
        }
        return bl;
    }

    public static void addPropertyChangeListener(NotifyingTracePropertyName notifyingTracePropertyName, PropertyChangeListener propertyChangeListener) {
        try {
            myPropertyChangeSupport.addPropertyChangeListener(notifyingTracePropertyName.getValue(), propertyChangeListener);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "addPropertyChangeListener(NotifyingTracePropertyName aNotifyingTracePropertyName, PropertyChangeListener aPropertyChangeListener)", "aNotifyingTracePropertyName: " + notifyingTracePropertyName + "\n\taPropertyChangeListener: " + propertyChangeListener + "\n\tThrowable caught.", throwable);
        }
    }

    public static void removePropertyChangeListener(NotifyingTracePropertyName notifyingTracePropertyName, PropertyChangeListener propertyChangeListener) {
        try {
            myPropertyChangeSupport.removePropertyChangeListener(notifyingTracePropertyName.getValue(), propertyChangeListener);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "removePropertyChangeListener(NotifyingTracePropertyName aNotifyingTracePropertyName, PropertyChangeListener aPropertyChangeListener)", "aNotifyingTracePropertyName: " + notifyingTracePropertyName + "\n\taPropertyChangeListener: " + propertyChangeListener + "\n\tThrowable caught.", throwable);
        }
    }

    public static void suTestLog(Class clazz, String string, String string2) {
        Trace.suTestLog(clazz, string, string2, true);
    }

    public static void suTestLog(Class clazz, String string, String string2, boolean bl) {
        if (myIsInSuSimEnvironment) {
            Trace.handleSuTestLog(clazz, Trace.getClassName(clazz), string, string2, bl);
        }
    }

    public static void log1(Class clazz, String string, String string2) {
        Trace.handleLog(clazz, Trace.getClassName(clazz), string, string2, 0, true);
    }

    public static void log1(Class clazz, String string, String string2, boolean bl) {
        Trace.handleLog(clazz, Trace.getClassName(clazz), string, string2, 0, bl);
    }

    public static void log2(Class clazz, String string, String string2) {
        Trace.handleLog(clazz, Trace.getClassName(clazz), string, string2, 1, true);
    }

    public static void log2(Class clazz, String string, String string2, boolean bl) {
        Trace.handleLog(clazz, Trace.getClassName(clazz), string, string2, 1, bl);
    }

    public static void debug(String string) {
        Trace.handleDebug(myValidatedClass, string, "", myValidatedPriorityLevel, true);
    }

    public static void debug(String string, boolean bl) {
        Trace.handleDebug(myValidatedClass, string, "", myValidatedPriorityLevel, bl);
    }

    public static void debug(String string, String string2) {
        Trace.handleDebug(myValidatedClass, string, string2, myValidatedPriorityLevel, true);
    }

    public static void debug(String string, String string2, boolean bl) {
        Trace.handleDebug(myValidatedClass, string, string2, myValidatedPriorityLevel, bl);
    }

    public static void debug(Class clazz, int n, String string) {
        if (Trace.validate(clazz, n)) {
            Trace.handleDebug(clazz, string, "", n, true);
        }
    }

    public static void debug(Class clazz, int n, String string, boolean bl) {
        if (Trace.validate(clazz, n)) {
            Trace.handleDebug(clazz, string, "", n, bl);
        }
    }

    public static void debug(Class clazz, int n, String string, String string2) {
        if (Trace.validate(clazz, n)) {
            Trace.handleDebug(clazz, string, string2, n, true);
        }
    }

    public static void debug(Class clazz, int n, String string, String string2, boolean bl) {
        if (Trace.validate(clazz, n)) {
            Trace.handleDebug(clazz, string, string2, n, bl);
        }
    }

    public static void info(Class clazz, String string, String string2) {
        Trace.handleInfo(clazz, string, string2, true);
    }

    public static void info(Class clazz, String string, String string2, boolean bl) {
        Trace.handleInfo(clazz, string, string2, bl);
    }

    public static void warning(Class clazz, String string, String string2) {
        Trace.handleWarning(clazz, string, string2, true);
    }

    public static void warning(Class clazz, String string, String string2, boolean bl) {
        Trace.handleWarning(clazz, string, string2, bl);
    }

    public static void error(Class clazz, String string, String string2) {
        Trace.handleError(clazz, string, string2, null, true);
    }

    public static void error(Class clazz, String string, String string2, boolean bl) {
        Trace.handleError(clazz, string, string2, null, bl);
    }

    public static void error(Class clazz, String string, String string2, Throwable throwable) {
        Trace.handleError(clazz, string, string2, throwable, true);
    }

    public static void error(Class clazz, String string, String string2, Throwable throwable, boolean bl) {
        Trace.handleError(clazz, string, string2, throwable, bl);
    }

    private static synchronized void handleDebug(Class clazz, String string, String string2, int n, boolean bl) {
        try {
            String string3 = Trace.getClassName(clazz);
            if (string == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleDebug(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string3);
                string = "NULL";
            }
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleDebug(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string3);
                string2 = "NULL";
            }
            if (!myUpgradeTraceHandler.isMethodSU_ToBeLogged(string3, string)) {
                return;
            }
            String string4 = Trace.createTraceLogTextTimeStamp();
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Debug, string3, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Debug, new TraceDebug(string3, string, string2, string4, string5));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("Debug", string4, string5, clazz, string3, string, string2, null);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleDebug(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, a debug message might have been lost.", throwable);
        }
    }

    private static synchronized void handleInfo(Class clazz, String string, String string2, boolean bl) {
        try {
            if (myUpgradeTraceHandler.getTraceInfoData().getDisableInfoAndLogSU()) {
                return;
            }
            String string3 = Trace.createTraceLogTextTimeStamp();
            String string4 = Trace.getClassName(clazz);
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (string == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleInfo(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string4);
                string = "NULL";
            }
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleInfo(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string4);
                string2 = "NULL";
            }
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Info, string4, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Info, new TraceInfo(string4, string, string2, string3, string5));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("I N F O", string3, string5, clazz, string4, string, string2, null);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleInfo(Class aClass, String aMethod, String aMessage, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, an info message might have been lost.", throwable);
        }
    }

    private static synchronized void handleError(Class clazz, String string, String string2, Throwable throwable, boolean bl) {
        try {
            String string3 = Trace.getClassName(clazz);
            String string4 = Trace.createTraceLogTextTimeStamp();
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (string == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleError(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string3);
                string = "NULL";
            }
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleError(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string3);
                string2 = "NULL";
            }
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Error, string3, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Error, new TraceError(string3, string, string2, string4, string5, throwable));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("E R R O R", string4, string5, clazz, string3, string, string2, throwable);
        }
        catch (Throwable throwable2) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleError(Class aClass, String aMethod, String aMessage, Throwable aThrowable, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, an info message might have been lost.", throwable2);
        }
    }

    private static synchronized void handleLog(Class clazz, String string, String string2, String string3, int n, boolean bl) {
        try {
            if (myUpgradeTraceHandler.getTraceInfoData().getDisableInfoAndLogSU()) {
                return;
            }
            if (!Trace.validFunctionLog(n)) {
                return;
            }
            String string4 = Trace.createTraceLogTextTimeStamp();
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleLog(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string);
                string2 = "NULL";
            }
            if (string3 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleLog(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string);
                string3 = "NULL";
            }
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Log, string, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Log, new TraceLog(string, string2, string3, string4, string5));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("Log", string4, string5, clazz, string, string2, string3, null);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleLog(Class aClass, String aClassName, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, an info message might have been lost.", throwable);
        }
    }

    private static synchronized void handleSuTestLog(Class clazz, String string, String string2, String string3, boolean bl) {
        try {
            String string4 = Trace.createTraceLogTextTimeStamp();
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleSuTestLog(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string);
                string2 = "NULL";
            }
            if (string3 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleSuTestLog(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string);
                string3 = "NULL";
            }
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Log, string, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Log, new TraceLog(string, string2, string3, string4, string5));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("SuTestLog", string4, string5, clazz, string, string2, string3, null);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleSuTestLog(Class aClass, String aClassName, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, an info message might have been lost.", throwable);
        }
    }

    private static synchronized void handleWarning(Class clazz, String string, String string2, boolean bl) {
        try {
            String string3 = Trace.createTraceLogTextTimeStamp();
            String string4 = Trace.getClassName(clazz);
            String string5 = myUpgradeTraceHandler.getTraceInfoData().getSU_VersionString();
            if (string == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleWarning(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMethod is null, not allowed. Changing value to 'NULL'. The calling class: " + string4);
                string = "NULL";
            }
            if (string2 == null) {
                TraceTE_LogWriter.teLogError(Trace.class, "handleWarning(Class aClass, String aMethod, String aMessage, int aPriority, boolean aPropertyChangeIndicationIsAllowed)", "String aMessage is null, not allowed. Changing value to 'NULL'. The calling class: " + string4);
                string2 = "NULL";
            }
            if (Trace.propertyChangeShallBeFired(NotifyingTracePropertyName.Warning, string4, bl)) {
                Trace.firePropertyChange(NotifyingTracePropertyName.Warning, new TraceWarning(string4, string, string2, string3, string5));
            }
            myUpgradeTraceHandler.getTraceWriter().writeToOut("W A R N I N G", string3, string5, clazz, string4, string, string2, null);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(Trace.class, "handleWarning(Class aClass, String aMethod, String aMessage, boolean aPropertyChangeIndicationIsAllowed)", "Throwable caught, an info message might have been lost.", throwable);
        }
    }

    private static void firePropertyChange(NotifyingTracePropertyName notifyingTracePropertyName, TraceData traceData) {
        try {
            myPropertyChangeSupport.firePropertyChange(notifyingTracePropertyName.getValue(), null, (Object)traceData);
        }
        catch (Exception exception) {
            TraceTE_LogWriter.teLogError(Trace.class, "firePropertyChange(NotifyingTracePropertyName aNotifyingTracePropertyName, TraceData aTraceData )", "aNotifyingTracePropertyName: " + notifyingTracePropertyName + "\n\taTraceData: " + traceData + "\n\tException caught.", exception);
        }
    }

    private static boolean isClassNameToBeLogged(String string) {
        boolean bl = false;
        if (myUpgradeTraceHandler.getTraceInfoData().getActiveClasses().contains(string)) {
            bl = true;
        } else if (myUpgradeTraceHandler.getTraceInfoData().getActiveFunctionClasses().contains(string)) {
            bl = true;
        }
        return bl;
    }

    private static boolean validFunctionLog(int n) {
        if (n == 0) {
            return true;
        }
        return n <= myUpgradeTraceHandler.getTraceInfoData().getLevel() && n > 0;
    }

    private static String getClassName(Class clazz) {
        if (clazz != null) {
            int n = clazz.getName().lastIndexOf(".");
            return clazz.getName().substring(n + 1);
        }
        TraceTE_LogWriter.teLogError(Trace.class, "getClassName(Class aClass)", "Class object is null, not allowed. Changing value to 'ClassUnknown'.");
        return "ClassUnknown";
    }

    private static boolean propertyChangeShallBeFired(NotifyingTracePropertyName notifyingTracePropertyName, String string, boolean bl) {
        if (!bl) {
            return false;
        }
        if (!myPropertyChangeSupport.hasListeners(notifyingTracePropertyName.getValue())) {
            return false;
        }
        for (int i = 0; i < myFilterPropertyChangeClasses.length; ++i) {
            if (!myFilterPropertyChangeClasses[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    private static String createTraceLogTextTimeStamp() {
        return myTraceLogTextTimeStringFormatter.format(new Date());
    }

    static {
        Properties properties = new Properties(System.getProperties());
        String string = properties.getProperty("SU_SIM");
        if (string != null && string.equals("yes")) {
            myIsInSuSimEnvironment = true;
        }
        Trace.log1(Trace.class, "Trace()", myUpgradeTraceHandler.getTraceInfoData().getLogString());
    }
}

