/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.validate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidatorException;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;

public class TraceAttributeValidator {
    public static void checkActiveFunctions(Collection collection) throws TraceAttributeValidatorException {
        if (collection.size() > 4) {
            throw new TraceAttributeValidatorException("A maximum of 4 functions can be activated at the same time.");
        }
        Integer n = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n >= 0 && n <= 22) continue;
            throw new TraceAttributeValidatorException("One of the values of activeFunctions is out of range. Value: " + n);
        }
    }

    public static void checkFileName(String string) throws TraceAttributeValidatorException {
        if (string.length() == 0) {
            throw new TraceAttributeValidatorException("The filename cannot be an empty string.");
        }
        if (string.lastIndexOf(47) != -1) {
            throw new TraceAttributeValidatorException("The filename cannot contain '/'.");
        }
    }

    public static void checkLevel(int n) throws TraceAttributeValidatorException {
        if (n < 2 || n > 99) {
            throw new TraceAttributeValidatorException("The value of level is outside range.");
        }
    }

    public static void checkSendLogsAsNotification(int n) throws TraceAttributeValidatorException {
        if (n != 0 && n != 1 && n != 2) {
            throw new TraceAttributeValidatorException("The value of sendLogsAsNotification is outside range.");
        }
    }

    public static void checkFileSize(int n) throws TraceAttributeValidatorException {
        if (n < 1 || n > 1000000) {
            throw new TraceAttributeValidatorException("The value of fileSize is outside range.");
        }
    }

    public static void checkFlushInterval(int n) throws TraceAttributeValidatorException {
        if (n < 1 || n > 1000000) {
            throw new TraceAttributeValidatorException("The value of flushInterval is outside range.");
        }
    }

    public static void checkOutputMode(int n) throws TraceAttributeValidatorException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new TraceAttributeValidatorException("The value of outputMode is outside range.");
        }
    }

    public static void checkOutputModeSU(int n) throws TraceAttributeValidatorException {
        if (n != -1 && n != 10) {
            throw new TraceAttributeValidatorException("The value of outputModeSU is outside range.");
        }
    }

    public static void checkTypeOfStorage(int n) throws TraceAttributeValidatorException {
        if (n != 0 && n != 1 && n != 2) {
            throw new TraceAttributeValidatorException("The value of typeOfStorage is outside valid range.");
        }
    }

    public static void checkNoDebug(int n) throws TraceAttributeValidatorException {
        if (n < -1 || n > 1) {
            throw new TraceAttributeValidatorException("The value of noDebug is outside valid range.");
        }
    }

    public static int convertOutputModeString(String string) throws TraceAttributeValidatorException {
        int n;
        if (string.equals("File")) {
            n = 0;
        } else if (string.equals("SerialPort")) {
            n = 1;
        } else if (string.equals("TeLog")) {
            n = 2;
        } else {
            throw new TraceAttributeValidatorException("Unknown string value for outputMode.");
        }
        return n;
    }

    public static String convertOutputModeInt(int n) throws TraceAttributeValidatorException {
        String string = null;
        if (n == 0) {
            string = "File";
        } else if (n == 1) {
            string = "SerialPort";
        } else if (n == 2) {
            string = "TeLog";
        } else {
            throw new TraceAttributeValidatorException("Unknown int value for outputMode.");
        }
        return string;
    }

    public static HashSet convertLevelsSU_String(String string) throws NumberFormatException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            n = (string2 = string2.trim()).indexOf("..");
            if (n != -1) {
                int n2 = new Integer(string2.substring(0, n));
                int n3 = new Integer(string2.substring(n + 2));
                for (int i = n2; i <= n3; ++i) {
                    hashSet.add(new Integer(i));
                }
                continue;
            }
            hashSet.add(new Integer(string2.trim()));
        }
        return hashSet;
    }

    public static String convertLevelsSU_Collection(Collection collection) {
        String string = "";
        try {
            Integer[] integerArray = TraceAttributeValidator.getSortedIntegerArray(collection);
            int n = -1;
            for (int i = 0; i < integerArray.length; ++i) {
                if (string.length() != 0 && n == -1) {
                    string = string + ";";
                }
                if (i + 1 < integerArray.length) {
                    if (integerArray[i] == integerArray[i + 1] - 1) {
                        if (n != -1) continue;
                        n = integerArray[i];
                        continue;
                    }
                    if (n != -1) {
                        string = string + n + ".." + integerArray[i];
                        n = -1;
                        continue;
                    }
                    string = string + integerArray[i];
                    continue;
                }
                if (n != -1) {
                    string = string + n + ".." + integerArray[i];
                    n = -1;
                    continue;
                }
                string = string + integerArray[i];
            }
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(TraceAttributeValidator.class, "convertLevelsSU_Collection(Collection aLevelsSU_Collection)", "Throwable caught when converting levelsSU Collection to String (ignored).", throwable);
        }
        return string;
    }

    public static Integer[] getSortedIntegerArray(Collection collection) {
        Integer[] integerArray = new Integer[collection.size()];
        Integer n = null;
        int n2 = -1;
        for (int i = 0; i < integerArray.length; ++i) {
            n = new Integer(Integer.MAX_VALUE);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Integer n3 = (Integer)iterator.next();
                if (n3 <= n2 || n3.compareTo(n) >= 0) continue;
                n = n3;
            }
            n2 = n;
            integerArray[i] = n;
        }
        return integerArray;
    }

    public static TreeMap convertActiveMethodsSU_String(String string) throws TraceAttributeValidatorException {
        TreeMap<String, Collection> treeMap = new TreeMap<String, Collection>();
        String string2 = null;
        Collection collection = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = TraceAttributeValidator.getClassNameFromClassMethodsString(string3);
            collection = TraceAttributeValidator.getMethodsFromClassMethodsString(string3);
            treeMap.put(string2, collection);
        }
        return treeMap;
    }

    public static String convertActiveMethodsSU_Map(TreeMap treeMap) {
        String string = "";
        String string2 = null;
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (string.length() != 0) {
                string = string + ";";
            }
            string2 = (String)iterator.next();
            string = string + string2;
            string = string + "[";
            String string3 = null;
            Iterator iterator2 = ((Collection)treeMap.get(string2)).iterator();
            while (iterator2.hasNext()) {
                if (string3 != null) {
                    string = string + " & ";
                }
                string3 = (String)iterator2.next();
                string = string + string3;
            }
            string = string + "]";
        }
        return string;
    }

    private static String getClassNameFromClassMethodsString(String string) throws TraceAttributeValidatorException {
        int n = string.indexOf("[");
        if (n == -1) {
            throw new TraceAttributeValidatorException("Wrong format of one of the Class/Methods strings in activeMethodsSU (getClassName)\naClassMethodsString: " + string);
        }
        return string.substring(0, n).trim();
    }

    private static Collection getMethodsFromClassMethodsString(String string) throws TraceAttributeValidatorException {
        int n = string.indexOf("[");
        if (n == -1) {
            throw new TraceAttributeValidatorException("Wrong format of one of the Class/Methods strings in activeMethodsSU (getMethod)");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        String string2 = string.substring(n + 1, string.length() - 1).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            treeSet.add(string3);
        }
        return treeSet;
    }

    public static String convertCollectionToPropString(Collection collection) {
        String string = "";
        String string2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!string.equals("")) {
                string = string + ";";
            }
            if ((string2 = (String)iterator.next()) instanceof String) {
                string2 = ((String)string2).trim();
            }
            string = string + string2;
        }
        return string;
    }

    public static boolean isMethodNamesEqual(String string, String string2) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string.indexOf(string3);
            if (n == -1) {
                bl = false;
                break;
            }
            string = string.substring(n + string3.length() - 1);
        }
        return bl;
    }
}

