/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.update;

import java.util.EventObject;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradePackageException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.SystemUpgradeEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ValueAVC_Property;
import se.ericsson.cello.su.timerforverification.VerificationTimerController;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.updatesequence.ReplaceConfigSupportMos;
import se.ericsson.cello.sudom.proxy.updatesequence.UpdateSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.updatesequence.UpdateStepEntity;
import se.ericsson.cello.sudom.proxy.verifyupdatesequence.VerifyUpdateSequenceProxyInterface;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.base.exception.CreationOfRollbackCV_Exception;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.main.event.actionresult.ActionResultEvent;
import se.ericsson.cello.upgradepackage.main.event.autocreatecv.AutoCreateCV_Event;
import se.ericsson.cello.upgradepackage.main.event.plugandplay.PlugAndPlayOnEvent;
import se.ericsson.cello.upgradepackage.main.event.progresstotal.ProgressTotalEvent;
import se.ericsson.cello.upgradepackage.main.event.rollbackon.RollbackOnEvent;
import se.ericsson.cello.upgradepackage.main.event.sequence.SequenceEvent;
import se.ericsson.cello.upgradepackage.main.event.state.InstallCompletedEvent;
import se.ericsson.cello.upgradepackage.main.event.state.UpgradeCompletedEvent;
import se.ericsson.cello.upgradepackage.main.event.state.UpgradeExecutingEvent;
import se.ericsson.cello.upgradepackage.main.event.steplabel.StepLabelEvent;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.update.ProxyHelper;
import se.ericsson.cello.upgradepackage.update.VerifyUpdateSequenceController;
import se.ericsson.cello.upgradepackage.update.event.UpdateRequestEvent;
import se.ericsson.cello.upgradepackage.update.exception.UpdateException;
import se.ericsson.cello.upgradepackage.update.exception.UpdateNotAllowedVerifyPhaseRejectionException;
import se.ericsson.cello.upgradepackage.upgrade.event.ActivatedTypeOfUP_InformationEvent;
import se.ericsson.cello.upgradepackage.upgrade.step.AueReportedFailureException;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOperation;
import se.ericsson.cello.upgradepackage.upgrade.step.replaceconfigsupportmos.ReplaceConfigSupportMosOp2;
import se.ericsson.cello.upgradepackage.util.datacontainer.IdleProgressInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.NodeRestartFailureReqInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeExecutionFailedInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.UpgradeRequestedInformation;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;
import se.ericsson.cello.upgradepackage.verify.VerifyHelper;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.event.BlockingVerifyInformationConfirmedEvent;
import se.ericsson.cello.upgradepackage.verify.event.BlockingVerifyRequestEvent;
import se.ericsson.cello.upgradepackage.verify.event.VerifyResponseEvent;

public class UpdateController
implements Runnable,
PropertyChangeListener {
    private boolean myIsAutoCreateCV_TurnedOn = false;
    private boolean myIsRollbackOn = false;
    private boolean myIsPlugAndPlayOn = false;
    private String myExecutedStep = "";
    private BlockingQueue myBlockingQueue = new BlockingQueue();
    private VerifyResponseEvent myVerifyResponseEvent = null;

    public UpdateController() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpdateController()");
        }
        new Thread(this).start();
    }

    public void cleanup() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cleanup()");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        if (propertyChangeEvent.getNewValue() instanceof VerifyResponseEvent) {
            this.myVerifyResponseEvent = (VerifyResponseEvent)propertyChangeEvent.getNewValue();
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unexpected type of property change value received (ignored).\n\tevt: " + propertyChangeEvent.getNewValue().getClass().getName() + "\n\tevt: " + propertyChangeEvent.getNewValue());
        }
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling System Upgrade function UPDATE has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myBlockingQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof UpdateRequestEvent) {
                this.handleUpdateRequest((UpdateRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (UpdateException updateException) {
            Trace.info(this.getClass(), "run()", "UpdateException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tUpdateException data: " + updateException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "The execution of the update function failed.\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\tThrowable caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            this.handleUpdateFailureRollback("The execution of the update function failed.\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\ttheRequestEvent: " + eventObject + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            UpgradeCoordinator.instance().updateResponse();
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling System Upgrade function UPDATE is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    public void updateRequest(UpdateRequestEvent updateRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateRequest(UpdateRequestEvent anUpdateRequestEvent)", "anUpdateRequestEvent: " + updateRequestEvent);
        }
        this.myBlockingQueue.enqueue((Object)updateRequestEvent);
    }

    private void createUpdateFinalCV(UpdateRequestEvent updateRequestEvent) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createUpdateFinalCV(UpdateRequestEvent anUpdateRequestEvent)", "anUpdateRequestEvent: " + updateRequestEvent);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            configurationVersionMO_HandlerInterface.setCurrentUpgradePackage(updateRequestEvent.upgradePackageMO, null);
            UpgradeDB_StorageUtil.removeNewActiveUP();
            String string = configurationVersionMO_HandlerInterface.getStartableCV();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createUpdateFinalCV(UpdateRequestEvent anUpdateRequestEvent", "CV currently set as startable: " + string);
            }
            if (updateRequestEvent.upgradePackageMO.getPreUpgradeState(null) == 2) {
                updateRequestEvent.upgradePackageMO.setPreUpgradeState(0);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createUpdateFinalCV(UpdateRequestEvent anUpdateRequestEvent)", "Create an update final CV.");
            }
            configurationVersionMO_HandlerInterface.createUpgradeFinalCV_AndSetStartable(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, false, string);
            configurationVersionMO_HandlerInterface.setRollbackDataForUpgradeFinalCV(string, this.myIsRollbackOn);
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            throw new UpdateException(configurationVersionMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createUpdateFinalCV(UpdateRequestEvent anUpdateRequestEvent)", "Throwable caught when ...\n\tanUpdateRequestEvent: " + updateRequestEvent, throwable);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tcreateUpdateFinalCV(UpdateRequestEvent anUpdateRequestEvent)" + "\n\tThrowable caught when ..." + "\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void createUpdateRollbackCV(String string, String string2) throws CreationOfRollbackCV_Exception {
        String string3 = "createUpdateRollbackCV(String aProductNumber, String aProductRevision)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string3, "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string4 = configurationVersionMO_HandlerInterface.getStartableCV();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string3, "CV currently set as startable: " + string4);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string3, "Creating an update rollback CV.");
            }
            String string5 = configurationVersionMO_HandlerInterface.createUpgradeRollbackCV_AndSetStartable(string, string2);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string3, "Deleting any install CV's and old rollbacks CV's...");
            }
            VerificationTimerController.instance().stopVerificationTimer(new ProductNumberAndRevision(string, string2));
            configurationVersionMO_HandlerInterface.deleteInstallCVsAndOldRollbackCVs(string, string2, string5);
            String[] stringArray = new String[]{"Ir", "Vr", "Vf"};
            configurationVersionMO_HandlerInterface.deleteCVsWithReasons(stringArray, string, string2);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string3, "Setting the old startable CV first in the rollback list...");
            }
            configurationVersionMO_HandlerInterface.setRollbackDataForUpgradeRollbackCV(string4);
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            throw new CreationOfRollbackCV_Exception(configurationVersionMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string3, "Throwable caught when trying to create the rollback CV for the Update function.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new CreationOfRollbackCV_Exception("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\t" + string3 + "\n\tThrowable caught when trying to create the rollback CV for the Update function." + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private SequenceInformation getSequenceInformationToBeUsed() throws UpdateNotAllowedVerifyPhaseRejectionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "determineIfUpdateIsAllowed(VerifyResponseEvent anVerifyResponseEvent)", "myVerifyResponseEvent: " + this.myVerifyResponseEvent);
        }
        try {
            if (this.myVerifyResponseEvent instanceof BlockingVerifyInformationConfirmedEvent) {
                this.notifyListeners(NotifyingSystemUpgradePropertyName.ActionResult, new ActionResultEvent((Object)this, this.myVerifyResponseEvent));
                return ((BlockingVerifyInformationConfirmedEvent)this.myVerifyResponseEvent).supportedSequenceInformation.getFirstSequenceInformation();
            }
            throw new UpdateNotAllowedVerifyPhaseRejectionException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tdetermineIfUpdateIsAllowed(VerifyResponseEvent anVerifyResponseEvent)" + "\n\tThe verification phase for update returned an unexpected variant of result." + "\n\tThe update is therefor not allowed to be executed." + "\n\tVerifyRejectedEvent: " + this.myVerifyResponseEvent.toString());
        }
        catch (UpdateNotAllowedVerifyPhaseRejectionException updateNotAllowedVerifyPhaseRejectionException) {
            throw updateNotAllowedVerifyPhaseRejectionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "determineIfUpdateIsAllowed(VerifyResponseEvent anVerifyResponseEvent)", "Throwable caught when ...\n\tmyVerifyResponseEvent: " + this.myVerifyResponseEvent, throwable);
            throw new UpdateNotAllowedVerifyPhaseRejectionException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tdetermineIfUpdateIsAllowed(VerifyResponseEvent anVerifyResponseEvent)" + "\n\tThrowable caught when ..." + "\n\tmyVerifyResponseEvent: " + this.myVerifyResponseEvent + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void disableInteractingFunctions() throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "disableInteractingFunctions()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            configurationVersionMO_HandlerInterface.setAutoCreatedCVIsTurnedOn(false, coordinator);
            Transaction.commit(control);
            ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
            managedElementDataMO_HandlerInterface.disablePlugAndPlay();
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            Transaction.rollback(control);
            throw new UpdateException(configurationVersionMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "saveOriginConfigurationData ()", "Throwable caught while disabling interacting functions...", throwable);
            Transaction.rollback(control);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tdisableInteractingFunctions()" + "\n\tThrowable caught when trying to disabling interacting functions...." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void executeUpdateSequence(UpdateRequestEvent updateRequestEvent, String string) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeUpdateSequence(UpdateRequestEvent anUpdateRequestEvent, String anUpdateCaseID)", "anUpdateRequestEvent: " + updateRequestEvent + "\n\tanUpdateCaseID: " + string);
        }
        Trace.log1(this.getClass(), "executeUpdateSequence(UpdateRequestEvent anUpdateRequestEvent, String anUpdateCaseID)", "anUpdateCaseID: " + string);
        try {
            ProxyHelper proxyHelper = new ProxyHelper();
            UpdateSequenceProxyInterface updateSequenceProxyInterface = proxyHelper.getUpdateSequenceProxyInterface(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, updateRequestEvent.ucfPath);
            if (updateSequenceProxyInterface == null) {
                throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\texecuteUpdateSequence(UpdateRequestEvent anUpdateRequestEvent, String anUpdateCaseID)" + "\n\tCan't execute the update sequence due to no UpdateSequence was found (this should not happen...)." + "\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tanUpdateCaseID: " + string);
            }
            ExecutableOperation executableOperation = null;
            while (updateSequenceProxyInterface.hasNextUpdateStep(this.myExecutedStep)) {
                executableOperation = this.getUpdateOperation(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, updateRequestEvent.upgradePackageMO, string, updateSequenceProxyInterface, updateRequestEvent.ucfPath);
                executableOperation.executeOp();
            }
        }
        catch (UpdateException updateException) {
            throw updateException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeUpdateSequence(UpdateRequestEvent anUpdateRequestEvent, String anUpdateCaseID)", "Throwable caught while saving origin configuration data...\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tanUpdateCaseID: " + string, throwable);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\texecuteUpdateSequence(UpdateRequestEvent anUpdateRequestEvent, String anUpdateCaseID)" + "\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tanUpdateCaseID: " + string + "\n\tThrowable caught when trying to ...." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private ExecutableOperation getUpdateOperation(String string, String string2, UpgradePackageMoExtended upgradePackageMoExtended, String string3, UpdateSequenceProxyInterface updateSequenceProxyInterface, String string4) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpdateOperation(String anUP_ProductNumber, String anUP_ProductRevision, UpgradePackageMoExtended anUpgradePackageMoExtended, String aSequenceCaseID, UpdateSequenceProxyInterface anUpdateSequenceProxyInterface, String anUCF_Path)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUpgradePackageMoExtended: " + upgradePackageMoExtended + "\n\taSequenceCaseID: " + string3 + "\n\tanUpdateSequenceProxyInterface: " + updateSequenceProxyInterface + "\n\tanUCF_Path: " + string4);
        }
        try {
            UpdateStepEntity updateStepEntity = updateSequenceProxyInterface.nextUpdateStep(this.myExecutedStep);
            if (updateStepEntity instanceof ReplaceConfigSupportMos) {
                this.myExecutedStep = updateStepEntity.updateStepLabel;
                this.notifyListeners(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, updateStepEntity.updateStepLabel, ValueAVC_Property.ValueAndAVC));
                return new ReplaceConfigSupportMosOp2(string, string2, string4, string3, upgradePackageMoExtended, updateStepEntity.updateStepLabel);
            }
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tgetUpdateOperation(String anUpdateStepLabel)" + "\n\tUnsupported update step detected (aborting the execution of the update function)." + "\n\taSequenceCaseID: " + string3 + "\n\tanUpdateSequenceProxyInterface: " + updateSequenceProxyInterface + "\n\tanUCF_Path: " + string4);
        }
        catch (UpdateException updateException) {
            throw updateException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUpdateOperation(String anUpdateStepLabel)", "Throwable caught when retreiving an update operation to execute.\n\taSequenceCaseID: " + string3 + "\n\tanUpdateSequenceProxyInterface: " + updateSequenceProxyInterface + "\n\tanUCF_Path: " + string4, throwable);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tgetUpdateOperation(String anUpdateStepLabel)" + "\n\tThrowable caught when retreiving an update operation to execute." + "\n\taSequenceCaseID: " + string3 + "\n\tanUpdateSequenceProxyInterface: " + updateSequenceProxyInterface + "\n\tanUCF_Path: " + string4 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void handleUpdateFailure(UpdateRequestEvent updateRequestEvent, String string, UpgradePackageException upgradePackageException) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateFailure(UpdateRequestEvent anUpdateRequestEvent, String aReason, UpgradePackageException anUpdateException)", "anUpdateRequestEvent: " + updateRequestEvent + "\n\taReason: " + string + "\n\tanUpdateException: " + (Object)((Object)upgradePackageException));
        }
        try {
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, string, (Throwable)((Object)upgradePackageException));
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressTotal, new ProgressTotalEvent((Object)this, 0));
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new StepLabelEvent((Object)this, ""));
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
            InstallCompletedEvent installCompletedEvent = new InstallCompletedEvent(this);
            if (installCompletedEvent.identifier == updateRequestEvent.originState) {
                this.notifyListeners(NotifyingSystemUpgradePropertyName.State, installCompletedEvent);
            } else {
                this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeCompletedEvent(this));
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleUpdateFailure(UpdateRequestEvent anUpdateRequestEvent, String aReason, UpgradePackageException anUpdateException)", "Throwable caught when ...\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\taReason: " + string + "\n\tanUpdateException: " + (Object)((Object)upgradePackageException), throwable);
            this.handleUpdateFailureRollback("The execution of the update function failed and when trying to set back properties to origin\n\tvalues a failure has been detected and therefor a node restart need to be invoked (i.e. a rollback is requested).\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void handleUpdateFailureRollback(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateFailureRollback()");
        }
        try {
            UpgradeExecutionFailedInformation upgradeExecutionFailedInformation = new UpgradeExecutionFailedInformation((Object)this, string);
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, upgradeExecutionFailedInformation);
            this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new NodeRestartFailureReqInformation(this));
            this.requestForNodeRestart();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleUpdateFailureRollback(String aReason)", "Throwable caught when ...\n\taReason: " + string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUpdateRequest(UpdateRequestEvent updateRequestEvent) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "anUpdateRequestEvent: " + updateRequestEvent);
        }
        try {
            try {
                Object object;
                String string = updateRequestEvent.sequenceCaseID;
                DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseAllMainElements(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, updateRequestEvent.ucfPath, false);
                if (!updateRequestEvent.isContinueUpdate) {
                    ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new UpgradeRequestedInformation(this));
                    object = new VerifyUpdateSequenceController();
                    VerifyUpdateSequenceProxyInterface verifyUpdateSequenceProxyInterface = ((VerifyUpdateSequenceController)object).getVerifyUpdateSequenceProxyInterface(documentObjectProxyInterface, updateRequestEvent);
                    int n = this.calculateNumberOfSteps(documentObjectProxyInterface, updateRequestEvent, verifyUpdateSequenceProxyInterface);
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressTotal, new ProgressTotalEvent(this, n, ValueAVC_Property.OnlyAVC));
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Verify that it is allowed to execute the update function.");
                    }
                    ((VerifyUpdateSequenceController)object).execute(updateRequestEvent, verifyUpdateSequenceProxyInterface);
                    SequenceInformation sequenceInformation = this.getSequenceInformationToBeUsed();
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeExecutingEvent(this, ValueAVC_Property.ValueAndAVC));
                    string = sequenceInformation.currentCase;
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this, ValueAVC_Property.OnlyValue));
                    updateRequestEvent.upgradePackageMO.setStateValueNoNotification(updateRequestEvent.upgradePackageMO.getPreviousState(null));
                    this.createUpdateRollbackCV(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision);
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeExecutingEvent(this, ValueAVC_Property.OnlyValue));
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeExecutingEvent(this, ValueAVC_Property.OnlyValue));
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressTotal, new ProgressTotalEvent(this, n, ValueAVC_Property.OnlyValue));
                    this.notifyListeners(NotifyingSystemUpgradePropertyName.Sequence, new SequenceEvent(this, sequenceInformation.label, sequenceInformation.currentCase));
                    this.saveOriginConfigurationData();
                    this.disableInteractingFunctions();
                } else {
                    this.saveIncomingConfigurationData(updateRequestEvent);
                    this.myExecutedStep = updateRequestEvent.stepLabel;
                }
                this.executeUpdateSequence(updateRequestEvent, string);
                this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this, ValueAVC_Property.OnlyValue));
                this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressTotal, new ProgressTotalEvent((Object)this, 0));
                this.notifyListeners(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent((Object)this, ""));
                this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeCompletedEvent(this, ValueAVC_Property.OnlyValue));
                Trace.suTestLog(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Sets back origin configuration");
                this.setBackOriginConfiguration(this.myIsAutoCreateCV_TurnedOn, this.myIsPlugAndPlayOn);
                object = ActivatedTypeOfUP.getInstance(updateRequestEvent.installedTypeOfUP.getValue());
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActivatedTypeOfUP, new ActivatedTypeOfUP_InformationEvent(this, (ActivatedTypeOfUP)object));
                Trace.suTestLog(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Creating the Fi_ CV");
                this.createUpdateFinalCV(updateRequestEvent);
                Trace.suTestLog(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Created the Fi_ CV");
                UCF_ParserFacade.removeNotNeededDocumentObjectForUpgradePackages();
                this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new UpgradeExecutedInformation(this));
                this.notifyListeners(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this));
                this.notifyListeners(NotifyingSystemUpgradePropertyName.State, new UpgradeCompletedEvent(this, ValueAVC_Property.OnlyAVC));
            }
            catch (VerifyRequestException verifyRequestException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "The verification phase failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.");
                }
                this.handleUpdateFailure(updateRequestEvent, "The verification phase part of the update action failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.\n\tanUpdateRequestEvent: " + updateRequestEvent, verifyRequestException);
                Object var9_15 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            catch (UpdateNotAllowedVerifyPhaseRejectionException updateNotAllowedVerifyPhaseRejectionException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "The verification phase has been executed and it is detected that update is not allowed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.");
                }
                this.handleUpdateFailure(updateRequestEvent, "The creation of the update rollback CV failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.\n\tanUpdateRequestEvent: " + updateRequestEvent, updateNotAllowedVerifyPhaseRejectionException);
                Object var9_16 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            catch (AueReportedFailureException aueReportedFailureException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "An AUE has reported failure which results in that update is not allowed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.");
                }
                this.handleUpdateFailure(updateRequestEvent, "The creation of the update rollback CV failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.\n\tanUpdateRequestEvent: " + updateRequestEvent, new UpdateException(aueReportedFailureException.getMessage()));
                Object var9_17 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            catch (CreationOfRollbackCV_Exception creationOfRollbackCV_Exception) {
                Trace.error(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "The creation of the update rollback CV failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.anUpdateRequestEvent: " + updateRequestEvent, (Throwable)((Object)creationOfRollbackCV_Exception));
                this.handleUpdateFailure(updateRequestEvent, "The creation of the update rollback CV failed.\n\tThe update request is aborted and no rollback is required due to no configuration data has been changed.\n\tanUpdateRequestEvent: " + updateRequestEvent, creationOfRollbackCV_Exception);
                Object var9_18 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            catch (UpdateException updateException) {
                Trace.error(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "The execution of the update function failed.\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\tanUpdateRequestEvent: " + updateRequestEvent, (Throwable)((Object)updateException));
                this.handleUpdateFailureRollback("The execution of the update function failed.\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tUpdateException: " + (Object)((Object)updateException) + "\n\tUpdateException data: " + updateException.toString());
                Object var9_19 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent)", "Throwable caught while waiting for an event or executing an received event.anUpdateRequestEvent: " + updateRequestEvent, throwable);
                this.handleUpdateFailureRollback("The execution of the update function failed.\n\tThe update request is aborted and rollback is requested i.e. node restart is invoked.\n\tanUpdateRequestEvent: " + updateRequestEvent + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
                Object var9_20 = null;
                Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
                ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
                UpgradeCoordinator.instance().updateResponse();
                Trace.flushToTraceFile();
                return;
            }
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_21 = null;
            Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
            UpgradeCoordinator.instance().updateResponse();
            Trace.flushToTraceFile();
            throw throwable;
        }
        Trace.log1(this.getClass(), "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent", "Cleaning up.");
        ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.VerifyResult, this);
        UpgradeCoordinator.instance().updateResponse();
        Trace.flushToTraceFile();
    }

    public int calculateNumberOfSteps(DocumentObjectProxyInterface documentObjectProxyInterface, UpdateRequestEvent updateRequestEvent, VerifyUpdateSequenceProxyInterface verifyUpdateSequenceProxyInterface) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateNumberOfSteps(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpdateRequestEvent anUpdateRequestEvent, VerifyUpdateSequenceProxyInterface anVerifyUpdateSequenceProxyInterface)", "anUpdateRequestEvent: " + updateRequestEvent + "\n\tanVerifyUpdateSequenceProxyInterface: " + verifyUpdateSequenceProxyInterface);
        }
        try {
            BlockingVerifyRequestEvent blockingVerifyRequestEvent;
            SupportedSequenceInformation supportedSequenceInformation;
            int n = 1;
            if (verifyUpdateSequenceProxyInterface != null) {
                n = verifyUpdateSequenceProxyInterface.getNumberOfSteps();
            }
            if (!(supportedSequenceInformation = VerifyHelper.verifyUpgradeWindow(documentObjectProxyInterface, blockingVerifyRequestEvent = new BlockingVerifyRequestEvent(updateRequestEvent.upgradePackageMO, updateRequestEvent.baseUP_UCF_Path, updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, updateRequestEvent.originalUCF_Path, updateRequestEvent.productionDate, updateRequestEvent.productName, updateRequestEvent.typeOfUP, updateRequestEvent.ucfPath, updateRequestEvent.typeOfUpgrade, updateRequestEvent.upCompatibilityIndex, updateRequestEvent.installedTypeOfUP, updateRequestEvent.omittVerifyUpgradeChecks, updateRequestEvent.su_LogicCompatibilityIndex, updateRequestEvent.progressCount, updateRequestEvent.executedStepLabel, updateRequestEvent.currentSequenceLabel, updateRequestEvent.preUpgradeState, updateRequestEvent.requestedTypeOfUP, updateRequestEvent.hsi_Variant, updateRequestEvent.ftp_ServerInformation, updateRequestEvent.activatedTypeOfUP, updateRequestEvent.isOverrideForcedPreUpgrade))).isSupported()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "calculateNumberOfSteps(DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpdateRequestEvent anUpdateRequestEvent)", "No valid update sequence was found i.e. could not calculate the total number of steps.");
                }
                return n;
            }
            ProxyHelper proxyHelper = new ProxyHelper();
            UpdateSequenceProxyInterface updateSequenceProxyInterface = proxyHelper.getUpdateSequenceProxyInterface(updateRequestEvent.documentNumber, updateRequestEvent.documentRevision, updateRequestEvent.originalUCF_Path);
            if (updateSequenceProxyInterface != null) {
                return updateSequenceProxyInterface.getNumberOfSteps() + n;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "calculateNumberOfStepsInUpgradeSequence (DocumentObjectProxyInterface aDocumentObjectProxyInterface, UpdateRequestEvent anUpdateRequestEvent)", "No update seqeuence was found with label name " + supportedSequenceInformation + " i.e. could not calculate the total number of steps.");
            }
            return n;
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "calculateNumberOfStepsInUpgradeSequence ()", "Throwable caught while trying to calculate the number of steps to be executed at execution of the requested upgrade (IGNORED)\n\tThrowable data: " + throwable.toString());
            }
            return 0;
        }
    }

    private void notifyListeners(NotifyingSystemUpgradePropertyName notifyingSystemUpgradePropertyName, SystemUpgradeEvent systemUpgradeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyListeners(NotifyingSystemUpgradePropertyName aNotifyingSystemUpgradePropertyName, SystemUpgradeEvent aSystemUpgradeEvent)", "aNotifyingSystemUpgradePropertyName: " + notifyingSystemUpgradePropertyName + "\n\taSystemUpgradeEvent: " + systemUpgradeEvent);
        }
        ProgressInformationHandler.instance().firePropertyChange(notifyingSystemUpgradePropertyName, systemUpgradeEvent);
    }

    private void requestForNodeRestart() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestForNodeRestart()");
        }
        try {
            Trace.log1(this.getClass(), "requestForNodeRestart ()", "Requesting node to be restarted within 5000 milliseconds.");
            TimeHandler.sleep(5000L);
            ManagedObject managedObject = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElement")).getMo();
            ((ManagedElementMoSU_Access)managedObject).systemInitiatedRestartFromSU(0, 21, "", null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "requestForNodeRestart()", "Throwable caught when requesting for node restart.", throwable);
        }
    }

    private void saveIncomingConfigurationData(UpdateRequestEvent updateRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "saveIncomingConfigurationData(UpdateRequestEvent anUpdateRequestEvent)", "anUpdateRequestEvent: " + updateRequestEvent);
        }
        this.myIsAutoCreateCV_TurnedOn = updateRequestEvent.isAutoCV_On;
        this.myIsRollbackOn = updateRequestEvent.isRollbackForCV_On;
        this.myIsPlugAndPlayOn = updateRequestEvent.isAutoConfigForPlugAndPlayOn;
    }

    private void saveOriginConfigurationData() throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateRequest(UpdateRequestEvent anUpdateRequestEvent");
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            this.myIsAutoCreateCV_TurnedOn = configurationVersionMO_HandlerInterface.getAutoCreatedCVIsTurnedOn(null);
            this.notifyListeners(NotifyingSystemUpgradePropertyName.AutoCreateCV_On, new AutoCreateCV_Event(this, this.myIsAutoCreateCV_TurnedOn, ValueAVC_Property.OnlyValue));
            this.myIsRollbackOn = configurationVersionMO_HandlerInterface.getRollbackOn(null);
            this.notifyListeners(NotifyingSystemUpgradePropertyName.RollbackOn, new RollbackOnEvent(this, this.myIsRollbackOn, ValueAVC_Property.OnlyValue));
            ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
            this.myIsPlugAndPlayOn = managedElementDataMO_HandlerInterface.isPlugAndPlayOn();
            this.notifyListeners(NotifyingSystemUpgradePropertyName.PlugAndPlayOn, new PlugAndPlayOnEvent(this, this.myIsPlugAndPlayOn, ValueAVC_Property.OnlyValue));
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            throw new UpdateException(configurationVersionMO_HandlerException.toString());
        }
        catch (ManagedElementDataMO_HandlerException managedElementDataMO_HandlerException) {
            throw new UpdateException(managedElementDataMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "saveOriginConfigurationData ()", "Throwable caught while saving origin configuration data...", throwable);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tsaveOriginConfigurationData ()" + "\n\tThrowable caught when trying to ...." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setBackOriginConfiguration(boolean bl, boolean bl2) throws UpdateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBackOriginConfiguration(boolean anIsAutoCreateCV_TurnedOn, boolean anIsPlugAndPlayOn)", "anIsAutoCreateCV_TurnedOn: " + bl + "\n\tanIsPlugAndPlayOn: " + bl2);
        }
        try {
            ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
            managedElementDataMO_HandlerInterface.setPlugAndPlayConfigurationAllowed(bl2);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            configurationVersionMO_HandlerInterface.setAutoCreatedCVIsTurnedOn(bl, null);
        }
        catch (ManagedElementDataMO_HandlerException managedElementDataMO_HandlerException) {
            throw new UpdateException(managedElementDataMO_HandlerException.toString());
        }
        catch (ConfigurationVersionMO_HandlerException configurationVersionMO_HandlerException) {
            throw new UpdateException(configurationVersionMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setBackOriginConfiguration(boolean anIsAutoCreateCV_TurnedOn, boolean anIsPlugAndPlayOn", "Throwable caught when ...\n\tanIsAutoCreateCV_TurnedOn: " + bl + "\n\tanIsPlugAndPlayOn: " + bl2, throwable);
            throw new UpdateException("Class: " + this + "\n\tClass Name: " + this.getClass().getName() + "\n\tsetBackOriginConfiguration(boolean anIsAutoCreateCV_TurnedOn, boolean anIsPlugAndPlayOn" + "\n\tThrowable caught when ..." + "\n\tanIsAutoCreateCV_TurnedOn: " + bl + "\n\tanIsPlugAndPlayOn: " + bl2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

