/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.upi.interfaces.OsaUpiProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ConfirmationDeadlineTimerInformation;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class UpgradeSupervisionTimerHandler
extends Thread {
    private long myUpgradeSupervisionTimer = -1L;
    private boolean myContinue = true;
    private boolean myUPI_ProxyIsUpAndRunning = false;
    private boolean myIsTimerSet = false;
    private int myWaitingTimeForOsaUpiFRO_ToPublish = 720;

    public UpgradeSupervisionTimerHandler(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradeSupervisionTimerHandler ( String anUpgradeSupervisionTimer )", "anUpgradeSupervisionTimer: " + string);
        }
        this.myUpgradeSupervisionTimer = this.defineUpgradeSupervisionTimer(string);
        this.start();
    }

    private long defineUpgradeSupervisionTimer(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "defineUpgradeSupervisionTimer ( String aConfirmTimer )", "aConfirmTimer: " + string);
        }
        try {
            if (string != null) {
                long l = Long.parseLong(string);
                return l;
            }
            return 1440L;
        }
        catch (NumberFormatException numberFormatException) {
            Trace.error(this.getClass(), "defineUpgradeSupervisionTimer ( String aConfirmTimer )", "Wrong Number Format, Confirm WatchdogTimOut " + string + ", using default " + 1440L, numberFormatException);
            return 1440L;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "defineUpgradeSupervisionTimer ( String aConfirmTimer )", "Exception caught while attempting to convert the defined confirm timer in UCF, Confirm WatchdogTimOut " + string + ", using default " + 1440L, exception);
            return 1440L;
        }
    }

    public boolean getAttemptsToSetUpgradeSupervisionTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAttemptsToSetUpgradeSupervisionTimer ()");
        }
        return this.myContinue;
    }

    public void stopAttempts() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stop ()");
        }
        this.myWaitingTimeForOsaUpiFRO_ToPublish = 0;
    }

    public boolean isTimerSet() {
        return this.myIsTimerSet;
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ()");
        }
        if (this.myUpgradeSupervisionTimer < 0L) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "run()", "The upgrade supervision timer is not set due to the timer value is illegal (" + this.myUpgradeSupervisionTimer + "' seconds).");
            }
            return;
        }
        OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
        this.myContinue = true;
        for (int i = 0; i < this.myWaitingTimeForOsaUpiFRO_ToPublish; ++i) {
            try {
                if (this.myUpgradeSupervisionTimer == 0L) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "run()", "Attempts to turn off the upgrade supervision timer.");
                    }
                    this.myUPI_ProxyIsUpAndRunning = osaUpiProxyAccess.sendOsaUpiSetSuperTimerReq(0L);
                } else {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "run()", "Attempts to set the Upgrade Supervision Timer to " + this.myUpgradeSupervisionTimer + " seconds.");
                    }
                    this.myUPI_ProxyIsUpAndRunning = osaUpiProxyAccess.sendOsaUpiSetSuperTimerReq(this.myUpgradeSupervisionTimer);
                }
                if (this.myUPI_ProxyIsUpAndRunning) {
                    Trace.log2(this.getClass(), "run()", "The upgrade supervision timer is set to " + this.myUpgradeSupervisionTimer + " seconds and started.");
                    this.myIsTimerSet = true;
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ConfirmationDeadlineTimerInformation((Object)this, this.myUpgradeSupervisionTimer));
                    break;
                }
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "run()", "Failed to set the timer (sleeps 10 seconds before trying to set the upgrade supervision timer again).");
                }
                TimeHandler.sleep(10000L);
                continue;
            }
            catch (Exception exception) {
                Trace.warning(this.getClass(), "run()", "Exception caught when trying to set the Upgrade Supervision Timer (ignored).\n\tAttempts to set the upgrade supervision timer anyway (aftet 10 seconds),\n\tException data: " + exception.toString());
                TimeHandler.sleep(10000L);
            }
        }
        this.myContinue = false;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ( )", "New THREAD handling the Upgrade Supervision Timer is going to be STOPPED.");
        }
        Trace.flushToTraceFile();
    }
}

