/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.ActiveOtherLMsHelperException;
import se.ericsson.cello.upgradepackage.upgrade.UpgradeClientInterface;
import se.ericsson.cello.upgradepackage.upgrade.WebserverLMsHelperException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class WebserverLMsHelper {
    public static final String VIEW_FILE = "ViewFile";

    public boolean isConnected() throws WebserverLMsHelperException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isConnected()");
        }
        try {
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface;
            boolean bl = false;
            SwAllocationMoSU_Access swAllocationMoSU_Access = ServiceFinder.getWebServerMO_HandlerInterface().getReferencedSwAllocationMo();
            if (swAllocationMoSU_Access != null && !(swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface()).getRepertoiresReferencedBySwAllocation(swAllocationMoSU_Access).isEmpty()) {
                bl = true;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isConnected()", "RETURNS -" + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isConnected()", "Throwable caught.", throwable);
            throw new WebserverLMsHelperException("Class name: " + this.getClass().getName() + "\n\tMethod: isConnected()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getWebserverLMs(UpgradeClientInterface upgradeClientInterface) throws ActiveOtherLMsHelperException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getWebserverLMs(UpgradeClientInterface anUpgradePackageMo)", "anUpgradePackageMo: " + upgradeClientInterface);
        }
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            Object object;
            Collection<Object> collection = new LinkedList<ManagedObject>();
            if (this.isConnected()) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getWebserverLMs(UpgradeClientInterface anUpgradePackageMo)", "The Webserver Mo is connected i.e. only connected load modules are of interest.");
                }
                if ((object = ServiceFinder.getWebServerMO_HandlerInterface().getReferencedSwAllocationMo()) != null) {
                    SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
                    Collection collection2 = swAllocationMO_HandlerInterface.getRepertoiresReferencedBySwAllocation((SwAllocationMoSU_Access)object);
                    RepertoireMoSU_Access repertoireMoSU_Access = null;
                    LinkedList<String> linkedList = new LinkedList<String>();
                    RepertoireMoData repertoireMoData = null;
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        repertoireMoData = (RepertoireMoData)iterator.next();
                        repertoireMoSU_Access = repertoireMoData.repertoireMo;
                        linkedList.add(repertoireMoSU_Access.getName(null));
                    }
                    documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(upgradeClientInterface.getUpgradePackageProductNumber(), upgradeClientInterface.getUpgradePackageProductRevision(), new File(upgradeClientInterface.getUpgradeControlFilePath(null)).getAbsolutePath(), "Repertoire");
                    RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
                    Collection collection3 = repertoiresProxyInterface.getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(linkedList);
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                    collection = loadModuleMO_HandlerInterface.getLoadModules(collection3);
                }
            } else {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getWebserverLMs(UpgradeClientInterface anUpgradePackageMo)", "The Webserver Mo is not connected i.e. all load modules of type Webserver are of interest.");
                }
                object = ServiceFinder.getLoadModuleMO_HandlerInterface();
                ManagedObject[] managedObjectArray = upgradeClientInterface.getLoadModuleList(null);
                ManagedObject[] managedObjectArray2 = object.getLoadModulesOfType(managedObjectArray, 3);
                for (int i = 0; i < managedObjectArray2.length; ++i) {
                    collection.add(managedObjectArray2[i]);
                }
                Collection collection4 = object.getLoadModulesOfType(managedObjectArray, 99, VIEW_FILE);
                collection.addAll(collection4);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getReferencedLMs()", "RETURNS - " + collection);
            }
            object = collection;
            return object;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getReferencedLMs()", "Throwable caught.", throwable);
            throw new ActiveOtherLMsHelperException("Class name: " + this.getClass().getName() + "\n\tMethod: getReferencedLMs()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
        finally {
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
        }
    }
}

