/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.installsequence;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.timerforverification.VerificationTimerController;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.install.ChecksumException;
import se.ericsson.cello.upgradepackage.install.ExecuteableOperationException;
import se.ericsson.cello.upgradepackage.install.ExecuteableOperationInterface;
import se.ericsson.cello.upgradepackage.install.InitUP_Information;
import se.ericsson.cello.upgradepackage.install.InstallBaseHandler;
import se.ericsson.cello.upgradepackage.install.InstallCoordinator;
import se.ericsson.cello.upgradepackage.install.InstallException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesCancelledException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedFTP_ServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedGetLoadModuleFileException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedIP_AddressException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedInsufficientDiskSpaceException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedLoadListFileException;
import se.ericsson.cello.upgradepackage.install.LM_ExistenceInformation;
import se.ericsson.cello.upgradepackage.install.MergeControlFileException;
import se.ericsson.cello.upgradepackage.install.UP_AndLM_Information;
import se.ericsson.cello.upgradepackage.install.UP_LM_InstallInformation;
import se.ericsson.cello.upgradepackage.install.UP_LoadModulesRelationInformation;
import se.ericsson.cello.upgradepackage.install.UpgradePackageControlFileTransformer;
import se.ericsson.cello.upgradepackage.install.event.FTP_ServerInformation;
import se.ericsson.cello.upgradepackage.install.event.InstalledTypeOfUP_InformationEvent;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.util.LoadModulesToBeInstalledAnalyser;
import se.ericsson.cello.upgradepackage.install.util.LoadModulesToBeInstalledAnalyserException;
import se.ericsson.cello.upgradepackage.install.verify.InstallVerifier;
import se.ericsson.cello.upgradepackage.install.verify.InstallVerifyException;
import se.ericsson.cello.upgradepackage.install.verify.event.ConfigurationMissmatchForLM;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyRejectedEvent;
import se.ericsson.cello.upgradepackage.install.verify.event.VerifyResponseEvent;
import se.ericsson.cello.upgradepackage.main.exception.FtpServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.main.exception.GetFileException;
import se.ericsson.cello.upgradepackage.main.exception.InsufficientDiskspaceException;
import se.ericsson.cello.upgradepackage.main.exception.IpAddressException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.event.ActivatedTypeOfUP_InformationEvent;
import se.ericsson.cello.upgradepackage.util.datacontainer.CalculationOfLMsToBeInstalled;
import se.ericsson.cello.upgradepackage.util.datacontainer.LM_FilePathInconsistencyInformation;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.enumer.InstalledTypeOfUP;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.file.FileCopyException;
import se.ericsson.cello.upgradepackage.util.file.FileHandler;
import se.ericsson.cello.upgradepackage.util.file.FileNotExistException;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapterException;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.ReserveLoadModulesException;
import se.ericsson.cello.upgradepackage.util.nsi.NSI_AdapterNoNodeTypeListFoundException;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandlerException;

public class InstallLMsExecOp
extends InstallBaseHandler
implements ExecuteableOperationInterface {
    private InitUP_Information myInitUP_Information = null;
    private boolean myIsForcedInstallRequest = false;

    public InstallLMsExecOp(InitUP_Information initUP_Information, boolean bl) {
        this.myInitUP_Information = initUP_Information;
        this.myIsForcedInstallRequest = bl;
    }

    public void execute() throws ExecuteableOperationException {
        Trace.log1(this.getClass(), "execute()", "Execution of operation InstallLMs");
        Collection collection = new Vector();
        try {
            Object object;
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute()", "Verification of the Upgrade package is executed from an installation perspective.");
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new CalculationOfLMsToBeInstalled(this));
            InstallVerifier installVerifier = new InstallVerifier();
            Vector vector = this.verifyInstall(installVerifier, this.myInitUP_Information.getUP_InstallRequestEvent());
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "execute()", "Find out which load modules that need to be installed.");
            }
            if (!this.myInitUP_Information.isUCF_Prepared()) {
                object = this.prepareControlFile(this.myInitUP_Information.getUP_InstallRequestEvent());
                this.myInitUP_Information.setUP_AndLM_Information((UP_AndLM_Information)object);
            }
            if (this.myInitUP_Information.getUP_AndLM_Information().isDelta) {
                this.installDeltaUP_LoadModules(this.myInitUP_Information.getUP_AndLM_Information(), this.myInitUP_Information.getUP_InstallRequestEvent(), this.myIsForcedInstallRequest, vector);
            } else {
                object = new LoadModulesToBeInstalledAnalyser();
                collection = ((LoadModulesToBeInstalledAnalyser)object).getLoadModulesToBeInstalled(this.myInitUP_Information.getUP_AndLM_Information(), this.myInitUP_Information.getUP_InstallRequestEvent(), this.myIsForcedInstallRequest, vector, false);
                VerificationTimerController.instance().prepareToStartVerificationTimerDuringInstallation(this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, collection);
                UP_LoadModulesRelationInformation uP_LoadModulesRelationInformation = this.myInitUP_Information.getUP_AndLM_Information().transformedUP;
                this.sendProgressTotal(uP_LoadModulesRelationInformation.productDataOfUP, uP_LoadModulesRelationInformation.ucfPath, collection, new HashSet());
                if (!collection.isEmpty()) {
                    this.installLoadModules(uP_LoadModulesRelationInformation.productDataOfUP, uP_LoadModulesRelationInformation.ucfPath, collection, this.myInitUP_Information.getUP_InstallRequestEvent().ftpServerInformation, 1);
                }
                this.allLoadModulesInstalled(new ProductNumberAndRevision(uP_LoadModulesRelationInformation.productDataOfUP.getNumber(), uP_LoadModulesRelationInformation.productDataOfUP.getRevision()), uP_LoadModulesRelationInformation.ucfPath, this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageUCF_Path, uP_LoadModulesRelationInformation.productNumberAndRevisionForLoadModules, this.myInitUP_Information.getUP_InstallRequestEvent().getRequestedTypeOfUP(), collection, this.myInitUP_Information.getUP_AndLM_Information().isTranformationFailed, this.myInitUP_Information.getUP_InstallRequestEvent().activatedTypeOfUP);
                Collection collection2 = ServiceFinder.getLoadModuleMO_HandlerInterface().getLoadModules(uP_LoadModulesRelationInformation.productNumberAndRevisionForLoadModules);
                LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[collection2.size()];
                loadModuleMoSU_AccessArray = collection2.toArray(loadModuleMoSU_AccessArray);
                UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)loadModuleMoSU_AccessArray, 857, new Boolean(this.myInitUP_Information.getUP_InstallRequestEvent().getRequestedTypeOfUP().isSelective()).toString()));
            }
        }
        catch (InstallRejectedLoadListFileException installRejectedLoadListFileException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to error in the load list or failure during creation of the load list.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedLoadListFileException message: " + (Object)((Object)installRejectedLoadListFileException) + "\n\tErrorInfo: " + (Object)((Object)installRejectedLoadListFileException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new GetFileException("Installation download failed LoadList Error"), 890, installRejectedLoadListFileException.getErrorInfo()));
            throw new ExecuteableOperationException(installRejectedLoadListFileException.getErrorInfo());
        }
        catch (InstallOfLoadModulesCancelledException installOfLoadModulesCancelledException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been cancelled (interrupted) due to requested by an operator.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedLoadListFileException message: " + (Object)((Object)installOfLoadModulesCancelledException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, 887, null));
            throw new ExecuteableOperationException(installOfLoadModulesCancelledException.toString());
        }
        catch (InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to the FTP server is not accessible.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedFTP_ServerNotAccessibleException message: " + (Object)((Object)installRejectedFTP_ServerNotAccessibleException) + "\n\tErrorInfo: " + installRejectedFTP_ServerNotAccessibleException.toString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new FtpServerNotAccessibleException("Installation download failed Ftp Connect Error"), 896, installRejectedFTP_ServerNotAccessibleException.toString()));
            throw new ExecuteableOperationException(installRejectedFTP_ServerNotAccessibleException.toString());
        }
        catch (InstallRejectedGetLoadModuleFileException installRejectedGetLoadModuleFileException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to error at installation of a specific load module file.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedGetLoadModuleFileException message: " + (Object)((Object)installRejectedGetLoadModuleFileException) + "\n\tErrorInfo: " + installRejectedGetLoadModuleFileException.toString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new GetFileException("Load module file not found on FTP server", installRejectedGetLoadModuleFileException.getFailedToInstallLoadModule()), 897, installRejectedGetLoadModuleFileException.toString()));
            throw new ExecuteableOperationException(installRejectedGetLoadModuleFileException.toString());
        }
        catch (InstallRejectedIP_AddressException installRejectedIP_AddressException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to IP address error.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedIP_AddressException message: " + (Object)((Object)installRejectedIP_AddressException) + "\n\tErrorInfo: " + installRejectedIP_AddressException.toString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new IpAddressException("Invalid format in IP address of FTP server"), 895, installRejectedIP_AddressException.toString()));
            throw new ExecuteableOperationException(installRejectedIP_AddressException.toString());
        }
        catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to insufficient with disk space.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallRejectedInsufficientDiskSpaceException message: " + (Object)((Object)installRejectedInsufficientDiskSpaceException) + "\n\tErrorInfo: " + installRejectedInsufficientDiskSpaceException.toString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InsufficientDiskspaceException("Installation download failed Error, Insufficient Diskspace"), 892, installRejectedInsufficientDiskSpaceException.toString()));
            throw new ExecuteableOperationException(installRejectedInsufficientDiskSpaceException.toString());
        }
        catch (NSI_AdapterNoNodeTypeListFoundException nSI_AdapterNoNodeTypeListFoundException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to no NodeTypeSpecificPiuTypeList was found that matches actual PIU's configured on the node.\n\tThe problems detected are: \n\tNSI_AdapterNoNodeTypeListFoundException: " + (Object)((Object)nSI_AdapterNoNodeTypeListFoundException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)nSI_AdapterNoNodeTypeListFoundException, 853, nSI_AdapterNoNodeTypeListFoundException.getVariablesAsString()));
            throw new ExecuteableOperationException(nSI_AdapterNoNodeTypeListFoundException.toString());
        }
        catch (ChecksumException checksumException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to checksum problems detected.\n\tThe problems detected are: \n\tChecksumException: " + (Object)((Object)checksumException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)checksumException, 852, checksumException.getVariablesAsString()));
            throw new ExecuteableOperationException(checksumException.toString());
        }
        catch (InstallVerifyException installVerifyException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to the verify phase has detected some problems with the upgrade package and/or node configuration.\n\tThe problems detected are: \n\tconfigurationMissmatchForLMs: " + installVerifyException.configurationMissmatchForLMs);
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)installVerifyException, 872, installVerifyException.getVariablesAsString()));
            throw new ExecuteableOperationException(installVerifyException.toString());
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tInstallOfLoadModulesRejectedException: " + (Object)((Object)installOfLoadModulesRejectedException) + "\n\tErrorInfo: " + installOfLoadModulesRejectedException.toString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)installOfLoadModulesRejectedException, 993, installOfLoadModulesRejectedException.toString()));
            throw new ExecuteableOperationException(installOfLoadModulesRejectedException.toString());
        }
        catch (FileCopyException fileCopyException) {
            InstallException installException = new InstallException("The installation of the load modules has been rejected due to failed to save the UCF to be used after the successful install (the install will be treated as failed even if all LMs have been successfully installed).\n\tPlease, try to clean up some disk space on C disk. Check the size of the used origin UCF file and from that estimate the amount of disk space that needs to be cleaned up.\n\tReason message: " + (Object)((Object)fileCopyException));
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)installException, 993, "--"));
            throw new ExecuteableOperationException(fileCopyException.toString());
        }
        catch (ReserveLoadModulesException reserveLoadModulesException) {
            Trace.error(this.getClass(), "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has been rejected due to failed to reserve the load module MO's that are part of the upgrade package.\n\tThe load modules that were requested to be installed are: \n\ttheLoadModulesToBeInstalled: " + collection, (Throwable)((Object)reserveLoadModulesException));
            InstallException installException = new InstallException("The installation of the load modules has been rejected due to failed to reserve the load module MO's that are part of the upgrade package.\n\tThe load modules that were requested to be installed are: \n\ttheLoadModulesToBeInstalled: " + collection);
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)installException, 993, "--"));
            throw new ExecuteableOperationException(reserveLoadModulesException.toString());
        }
        catch (InstallException installException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to an InstallException was caught.\n\tInstallException: " + (Object)((Object)installException) + "\n\tInstallException info: " + installException.getVariablesAsString());
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)installException, 993, installException.toString()));
            throw new ExecuteableOperationException(installException.toString());
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to an HW_SensitiveAdapterException was caught.\n\tHW_SensitiveAdapterException: " + (Object)((Object)hW_SensitiveAdapterException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)hW_SensitiveAdapterException, 993, hW_SensitiveAdapterException.toString()));
            throw new ExecuteableOperationException(hW_SensitiveAdapterException.toString());
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to an LoadModulesToBeInstalledAnalyserException was caught.\n\tLoadModulesToBeInstalledAnalyserException: " + (Object)((Object)loadModulesToBeInstalledAnalyserException));
            }
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)loadModulesToBeInstalledAnalyserException, 993, loadModulesToBeInstalledAnalyserException.toString()));
            throw new ExecuteableOperationException(loadModulesToBeInstalledAnalyserException.toString());
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to Mo Access exception was caught.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tMoAccessException message: " + (Object)((Object)moAccessException) + "\n\tErrorInfo: " + moAccessException.getVariablesAsString(), moAccessException);
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)moAccessException, 993, moAccessException.getVariablesAsString()));
            throw new ExecuteableOperationException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to a Throwable was caught.\n\tThe load modules that were requested to be installed are: \n\tmyInitUP_Information: " + this.myInitUP_Information + "\n\taForcedInstallRequest: " + this.myIsForcedInstallRequest + "\n\tThrowable message: " + throwable, throwable);
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException("Throwable caught: " + throwable.toString()), 993, "--"));
            throw new ExecuteableOperationException(throwable.toString());
        }
    }

    private void copyAndDeleteUCF(File file, String string) throws FileNotExistException, FileCopyException, ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyAndDeleteUCF(File anUpgradePackageControlFileUsedAtInstallation, String anUpgradePackageControlFilePath)", "anUpgradePackageControlFileUsedAtInstallation (path): " + file.getAbsolutePath() + "\n\tanUpgradePackageControlFilePath: " + string);
        }
        String string2 = "null";
        if (file == null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "copyAndDeleteUCF(File anUpgradePackageControlFileUsedAtInstallation, String anUpgradePackageControlFilePath)", "The file to be copied does not exist (i.e. it is null). The copy request is ignored.");
            }
            return;
        }
        string2 = file.getAbsolutePath();
        if (!FileHandler.enoughWithDiskSpaceForCopy(file)) {
            throw new FileCopyException("Not enough with space on C disk to be able to copy the transformed UCF to the working UCF (....xml).");
        }
        FileHandler.copyFile(file, new File(string));
        ChecksumHandler checksumHandler = new ChecksumHandler();
        checksumHandler.setCurrentUcfChecksumInUp(this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageMO, string);
        try {
            if (file != null) {
                file.delete();
            }
        }
        catch (Exception exception) {
            Trace.info(this.getClass(), "copyAndDeleteUCF(File anUpgradePackageControlFileUsedAtInstallation, String anUpgradePackageControlFilePath)", "Failed to delete the temporary upgrade control file after copying it to '" + string + "'." + "Exception message: " + exception.toString());
        }
    }

    private void createShadowLM_MOs(ProductNumberAndRevision productNumberAndRevision, String string, Collection collection, Collection collection2, RequestedTypeOfUP requestedTypeOfUP) throws InstallException {
        String string2 = "createShadowLM_MOs ( ProductNumberAndRevision anUP_ProductNumberAndRevision, String anUCF, Collection aLoadModulesProductNumberAndRevisions, Collection theInstalledLoadModulesProductNumberAndRevisions, RequestedTypeOfUP aRequestedTypeOfUP )";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "anUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\tanAllLoadModulesProductNumberAndRevisions: " + collection + "\n\ttheInstalledLoadModulesProductNumberAndRevisions: " + collection2 + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP);
        }
        try {
            if (requestedTypeOfUP.isHW_Sensitive()) {
                ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions(new Vector(collection2));
                Collection collection3 = productNumbersAndRevisions.getNotIncludedElements(collection);
                Iterator iterator = collection3.iterator();
                LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                ProductNumberAndRevision productNumberAndRevision2 = null;
                LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
                while (iterator.hasNext()) {
                    productNumberAndRevision2 = (ProductNumberAndRevision)iterator.next();
                    if (loadModuleMO_HandlerInterface.isLoadModulePresent(productNumberAndRevision2)) continue;
                    linkedList.add(productNumberAndRevision2);
                }
                loadModuleMO_HandlerInterface.createShadowLoadModules(productNumberAndRevision, string, linkedList);
            }
        }
        catch (LoadModuleMO_HandlerException loadModuleMO_HandlerException) {
            throw new InstallException(loadModuleMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string2, "Throwable caught.\n\tanUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\tanAllLoadModulesProductNumberAndRevisions: " + collection + "\n\ttheInstalledLoadModulesProductNumberAndRevisions: " + collection2 + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\t" + string2 + "\n\tThrowable caught." + "\n\tanUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\tanUCF: " + string + "\n\tanAllLoadModulesProductNumberAndRevisions: " + collection + "\n\ttheInstalledLoadModulesProductNumberAndRevisions: " + collection2 + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private boolean isValueOfActivatedTypeOfUP_ToBeUpdated(RequestedTypeOfUP requestedTypeOfUP, ActivatedTypeOfUP activatedTypeOfUP, boolean bl) throws InstallException {
        String string = "isValueOfActivatedTypeOfUP_ToBeUpdated(RequestedTypeOfUP aRequestedTypeOfUP, ActivatedTypeOfUP anActivatedTypeOfUP, boolean anIsTransformationFailed)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "aRequestedTypeOfUP: " + requestedTypeOfUP.toString2() + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP.toString2() + "\n\tanIsTransformationFailed: " + bl);
        }
        try {
            if (!activatedTypeOfUP.equals(ActivatedTypeOfUP.Undefined)) {
                if (requestedTypeOfUP.getValue() != activatedTypeOfUP.getValue()) {
                    return !bl;
                }
                return false;
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.\n\taRequestedTypeOfUP: " + requestedTypeOfUP.toString2() + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP.toString2() + "\n\tanIsTransformationFailed: " + bl, throwable);
            throw new InstallException("Class: " + this.getClass().getName() + "\n\tMethod: " + string + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP.toString2() + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP.toString2() + "\n\tanIsTransformationFailed: " + bl + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
        }
    }

    private void allLoadModulesInstalled(ProductNumberAndRevision productNumberAndRevision, File file, String string, Collection collection, RequestedTypeOfUP requestedTypeOfUP, Collection collection2, boolean bl, ActivatedTypeOfUP activatedTypeOfUP) throws FileCopyException, ReserveLoadModulesException, InstallException, ChecksumHandlerException {
        String string2 = "allLoadModulesInstalled(ProductNumberAndRevision anUP_ProductNumberAndRevision, File aTransformedUCF_Path, String anUP_UCF_Path, Collection aLoadModulesProductNumberAndRevisions, RequestedTypeOfUP aRequestedTypeOfUP, Collection anInstalledLoadModules, boolean anIsTransformationFailed, ActivatedTypeOfUP anActivatedTypeOfUP)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string2, "anUP_ProductNumberAndRevision: " + productNumberAndRevision + "\n\taTransformedUCF_Path: " + SuLib.toString(file) + "\n\tanUP_UCF_Path: " + string + "\n\taLoadModulesProductNumberAndRevisions: " + collection + "\n\taRequestedTypeOfUP: " + requestedTypeOfUP + "\n\tanInstalledLoadModules: " + collection2 + "\n\tanIsTransformationFailed: " + bl + "\n\tanActivatedTypeOfUP: " + activatedTypeOfUP);
        }
        try {
            this.copyAndDeleteUCF(file, string);
            this.createShadowLM_MOs(productNumberAndRevision, string, collection, collection2, requestedTypeOfUP);
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = loadModuleMO_HandlerInterface.reserveLoadModules(new Vector(collection));
            InstalledTypeOfUP installedTypeOfUP = InstalledTypeOfUP.getInstance(requestedTypeOfUP.getValue());
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string2, "Invokes firePropertyChange for property: " + NotifyingSystemUpgradePropertyName.InstalledTypeOfUP + "Property value: : " + installedTypeOfUP.toString2());
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.InstalledTypeOfUP, new InstalledTypeOfUP_InformationEvent(this, installedTypeOfUP));
            if (this.isValueOfActivatedTypeOfUP_ToBeUpdated(requestedTypeOfUP, activatedTypeOfUP, bl)) {
                ActivatedTypeOfUP activatedTypeOfUP2 = ActivatedTypeOfUP.getInstance(requestedTypeOfUP.getValue());
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string2, "Invokes firePropertyChange for property: " + NotifyingSystemUpgradePropertyName.ActivatedTypeOfUP + "Property value: : " + activatedTypeOfUP2.toString2());
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ActivatedTypeOfUP, new ActivatedTypeOfUP_InformationEvent(this, activatedTypeOfUP2));
            }
        }
        catch (FileCopyException fileCopyException) {
            throw fileCopyException;
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string2, "The installation of the load modules has failed due to a Throwable was caught.\n\tThe load modules that were requested to be installed are: \n\taLoadModulesProductNumberAndRevisions: " + collection, throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private void installLoadModuleFilesForTransformedOriginDeltaUP(UP_AndLM_Information uP_AndLM_Information, Collection collection, UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallException, InstallOfLoadModulesRejectedException {
        String string = "installLoadModuleFilesForTransformedOriginDeltaUP (UP_AndLM_Information anUP_AndLM_Information, Collection aLoadModulesToBeInstalled, UP_InstallRequestEvent anUP_InstallRequestEvent)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            Object object;
            Object object2;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, string, "Collect information of all LMs to be installed from the Delta UP.");
            }
            LM_ExistenceInformation lM_ExistenceInformation = this.getLM_ExistenceInUP(uP_AndLM_Information.thisUP.productNumberAndRevisionForLoadModules, collection);
            LinkedList<UP_LM_InstallInformation> linkedList = new LinkedList<UP_LM_InstallInformation>();
            linkedList.add(new UP_LM_InstallInformation(uP_AndLM_Information.thisUP.productDataOfUP, uP_InstallRequestEvent.ftpServerInformation, (Collection)lM_ExistenceInformation.existingLMs.clone(), uP_AndLM_Information.thisUP.ucfPath));
            if (!lM_ExistenceInformation.notExistingLMs.isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Collects information of all LMs to be installed from the Delta UP based on UP's.");
                }
                if ((object2 = (object = ServiceFinder.getUpgradePackageMO_HandlerInterface()).getUpgradePackageMo(uP_AndLM_Information.thisUP.productDataOfUP.getNumber(), uP_AndLM_Information.thisUP.productDataOfUP.getRevision())) == null) {
                    Trace.info(this.getClass(), "installLoadModuleFilesForTransformedOriginDeltaUP (UP_AndLM_Information anUP_AndLM_Information, Collection aLoadModulesToBeInstalled, UP_InstallRequestEvent anUP_InstallRequestEvent)", "The delta UP MO with product data below was not found (aborting the installation).\n\tanUP_AndLM_Information: " + uP_AndLM_Information.thisUP.productDataOfUP + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent);
                    throw new InstallException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThe delta UP MO with product data below was not found (aborting the installation)." + "\n\tanUP_AndLM_Information: " + uP_AndLM_Information.thisUP.productDataOfUP + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent);
                }
                Collection collection2 = this.collectUP_LMsInformation(object2.getBasedOnUpgradePackagesAsProductDatas(null), lM_ExistenceInformation.notExistingLMs);
                linkedList.addAll(collection2);
            }
            this.sendProgressTotal(uP_AndLM_Information.transformedUP.productDataOfUP.getNumber(), uP_AndLM_Information.transformedUP.productDataOfUP.getRevision(), uP_AndLM_Information.transformedUP.ucfPath, collection);
            object = linkedList.iterator();
            object2 = null;
            int n = 0;
            while (object.hasNext()) {
                object2 = (UP_LM_InstallInformation)object.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, string, "Installing load modules from the UP with product data:\n\tProduct number: " + ((UP_LM_InstallInformation)object2).upProductData.getNumber() + "\n\tProduct revision: " + ((UP_LM_InstallInformation)object2).upProductData.getRevision());
                }
                if (((UP_LM_InstallInformation)object2).lmsToBeInstalled.isEmpty()) continue;
                this.installLoadModules(((UP_LM_InstallInformation)object2).upProductData, ((UP_LM_InstallInformation)object2).ucfPath, ((UP_LM_InstallInformation)object2).lmsToBeInstalled, ((UP_LM_InstallInformation)object2).ftpServerInformation, ++n);
            }
            Trace.log1(this.getClass(), string, "All required load modules have been installed.");
            this.allLoadModulesInstalled(new ProductNumberAndRevision(uP_AndLM_Information.transformedUP.productDataOfUP.getNumber(), uP_AndLM_Information.transformedUP.productDataOfUP.getRevision()), uP_AndLM_Information.transformedUP.ucfPath, uP_InstallRequestEvent.upgradePackageUCF_Path, uP_AndLM_Information.transformedUP.productNumberAndRevisionForLoadModules, uP_InstallRequestEvent.getRequestedTypeOfUP(), collection, uP_AndLM_Information.isTranformationFailed, uP_InstallRequestEvent.activatedTypeOfUP);
            int n2 = 857;
            if (uP_AndLM_Information.isTranformationFailed) {
                n2 = 856;
            }
            Collection collection3 = ServiceFinder.getLoadModuleMO_HandlerInterface().getLoadModules(uP_AndLM_Information.transformedUP.productNumberAndRevisionForLoadModules);
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = new LoadModuleMoSU_Access[collection3.size()];
            loadModuleMoSU_AccessArray = collection3.toArray(loadModuleMoSU_AccessArray);
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)loadModuleMoSU_AccessArray, n2, new Boolean(uP_InstallRequestEvent.getRequestedTypeOfUP().isSelective()).toString()));
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            throw installOfLoadModulesRejectedException;
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tOriginal Throwable: " + (Object)((Object)checksumHandlerException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), string, "Throwable caught.anUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\t" + string + "\n\tThrowable caught." + "\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\taLoadModulesToBeInstalled: " + collection + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private void installDeltaUP_LoadModules(UP_AndLM_Information uP_AndLM_Information, UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl, Collection collection) throws InstallException, InstallOfLoadModulesRejectedException, HW_SensitiveAdapterException, LoadModulesToBeInstalledAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installDeltaUP_LoadModules(UP_AndLM_Information anUP_AndLM_Information, UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, Collection aFaultyLoadModuleIdentifiers)", "\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\taFaultyLoadModuleIdentifiers: " + collection);
        }
        try {
            LoadModulesToBeInstalledAnalyser loadModulesToBeInstalledAnalyser = new LoadModulesToBeInstalledAnalyser();
            Collection collection2 = loadModulesToBeInstalledAnalyser.getLoadModulesToBeInstalledForDeltaUP(uP_AndLM_Information, uP_InstallRequestEvent, bl, collection, false);
            VerificationTimerController.instance().prepareToStartVerificationTimerDuringInstallation(this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber, this.myInitUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision, collection2);
            this.installLoadModuleFilesForTransformedOriginDeltaUP(uP_AndLM_Information, collection2, uP_InstallRequestEvent);
        }
        catch (HW_SensitiveAdapterException hW_SensitiveAdapterException) {
            throw hW_SensitiveAdapterException;
        }
        catch (LoadModulesToBeInstalledAnalyserException loadModulesToBeInstalledAnalyserException) {
            throw loadModulesToBeInstalledAnalyserException;
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            throw installOfLoadModulesRejectedException;
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "installDeltaUP_LoadModules(UP_AndLM_Information anUP_AndLM_Information, UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught.\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "method: installDeltaUP_LoadModules(UP_AndLM_Information anUP_AndLM_Information, UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)" + "\n\tanUP_AndLM_Information: " + uP_AndLM_Information + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    private UP_AndLM_Information prepareControlFile(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallException, MergeControlFileException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareControlFile(InstallRequestEvent anUP_InstallRequestEvent)", "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            UpgradePackageControlFileTransformer upgradePackageControlFileTransformer = new UpgradePackageControlFileTransformer();
            UP_AndLM_Information uP_AndLM_Information = upgradePackageControlFileTransformer.prepareControlFile(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageProductName, uP_InstallRequestEvent.upgradePackageProductionDate, uP_InstallRequestEvent.upgradePackageOriginalUCF_Path, uP_InstallRequestEvent.upgradePackageUCF_Path, uP_InstallRequestEvent.upgradePackageMO, uP_InstallRequestEvent.getRequestedTypeOfUP(), uP_InstallRequestEvent.ftpServerInformation.ftpServerUCF_Path);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "prepareControlFile(InstallRequestEvent anUP_InstallRequestEvent)", "\n\tRETURNS (theUP_AndLM_Information): " + uP_AndLM_Information);
            }
            return uP_AndLM_Information;
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (MergeControlFileException mergeControlFileException) {
            throw mergeControlFileException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "prepareControlFile(InstallRequestEvent anUP_InstallRequestEvent)", "At preparation of the UCF a Throwable was caught.\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable message: " + throwable, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tMethod: prepareControlFile(InstallRequestEvent anUP_InstallRequestEvent" + "\n\tAt preparation of the UCF a Throwable was caught." + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable message: " + throwable);
        }
    }

    private void sendProgressTotal(ProductDataContainer productDataContainer, File file, Collection collection, Collection collection2) throws InstallException {
        String string = "sendProgressTotal ( ProductDataContainer anUP_ProductDataContainer, File anUCF_Path, Collection aDeltaLoadModulesToBeInstalled, aMasterLoadModulesToBeInstalled )";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, string, "anUP_ProductDataContainer: " + productDataContainer + "\n\tanUCF_Path: " + SuLib.toString(file) + "\n\taDeltaLoadModulesToBeInstalled: " + collection + "\n\taMasterLoadModulesToBeInstalled: " + collection2 + "\n\taDeltaLoadModulesToBeInstalled size: " + collection.size() + "\n\taMasterLoadModulesToBeInstalled size: " + collection2.size());
        }
        this.sendProgressTotal(productDataContainer.getNumber(), productDataContainer.getRevision(), file, collection, collection2);
    }

    private void installLoadModules(ProductDataContainer productDataContainer, File file, Collection collection, FTP_ServerInformation fTP_ServerInformation, int n) throws InstallException, InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, int anUPWithLMsCouner)", "\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanUPWithLMsCouner: " + n);
        }
        try {
            InstallCoordinator installCoordinator = new InstallCoordinator();
            installCoordinator.installLoadModules(productDataContainer, file, collection, fTP_ServerInformation, n, this.myIsForcedInstallRequest, true);
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            throw installOfLoadModulesRejectedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, int anUPWithLMsCouner)", "Throwable caught.\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanUPWithLMsCouner: " + n, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "method: installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, int anUPWithLMsCouner)" + "\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanUPWithLMsCouner: " + n + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    private Vector verifyInstall(InstallVerifier installVerifier, UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallVerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyInstall(InstallVerifier anInstallVerifier, UP_InstallRequestEvent anUP_InstallRequestEvent)", "anInstallVerifier: " + installVerifier + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            VerifyResponseEvent verifyResponseEvent = installVerifier.verify(uP_InstallRequestEvent);
            Vector<ProductNumberAndRevision> vector = new Vector<ProductNumberAndRevision>(1);
            if (verifyResponseEvent instanceof VerifyRejectedEvent) {
                VerifyRejectedEvent verifyRejectedEvent = (VerifyRejectedEvent)verifyResponseEvent;
                boolean bl = true;
                if (!verifyRejectedEvent.configurationMissmatchForLMs.isEmpty()) {
                    Collection collection = ((VerifyRejectedEvent)verifyResponseEvent).configurationMissmatchForLMs;
                    Iterator iterator = collection.iterator();
                    ConfigurationMissmatchForLM configurationMissmatchForLM = null;
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                    while (iterator.hasNext()) {
                        configurationMissmatchForLM = (ConfigurationMissmatchForLM)iterator.next();
                        vector.addElement(configurationMissmatchForLM.productNumberAndRevision);
                        if (loadModuleMO_HandlerInterface.isPredefined_eNodeB_FilePath(configurationMissmatchForLM.configurationDestinationFilePath)) continue;
                        if (bl) {
                            Trace.log1(this.getClass(), "verifyInstall(verifyInstall(InstallVerifier anInstallVerifier, UP_InstallRequestEvent anUP_InstallRequestEvent)", "The verification phase discovered node configurations or UCF problems related to load modules: " + verifyRejectedEvent);
                            bl = false;
                        }
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new LM_FilePathInconsistencyInformation(this, configurationMissmatchForLM.productNumberAndRevision, configurationMissmatchForLM.configurationDestinationFilePath, configurationMissmatchForLM.ucfDestinationFilePath));
                    }
                }
                if (!verifyRejectedEvent.diskspaceInformation.isDiskspaceAvailable) {
                    if (bl) {
                        Trace.log1(this.getClass(), "verifyInstall(verifyInstall(InstallVerifier anInstallVerifier, UP_InstallRequestEvent anUP_InstallRequestEvent)", "The verification phase discovered node configurations or UCF problems related to load modules: " + verifyRejectedEvent);
                    }
                    throw new InstallVerifyException(verifyRejectedEvent.configurationMissmatchForLMs, verifyRejectedEvent.diskspaceInformation);
                }
            }
            return vector;
        }
        catch (InstallVerifyException installVerifyException) {
            throw installVerifyException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyInstall(verifyInstall(InstallVerifier anInstallVerifier, UP_InstallRequestEvent anUP_InstallRequestEvent)", "anInstallVerifier: " + installVerifier + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught at verification of the UP." + "\n\tThrowable data: " + throwable);
            throw new InstallVerifyException("Class: " + this.getClass().getName() + "\n\tMethod: verifyInstall(verifyInstall(InstallVerifier anInstallVerifier, UP_InstallRequestEvent anUP_InstallRequestEvent)" + "\n\tanInstallVerifier: " + installVerifier + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught at verification of the UP." + "\n\tThrowable data: " + throwable);
        }
    }
}

