/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class WaitForAdmStateIndication
extends Thread {
    private boolean myContinueLoop = false;
    private Vector myUpgradeablePlugInUnits = null;

    public WaitForAdmStateIndication(Vector vector) {
        super("WaitForAdmStateIndication");
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "WaitForAdmStateIndication ()");
        }
        this.myUpgradeablePlugInUnits = vector;
    }

    public void startRunning() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startRunning ()");
        }
        if (!this.myContinueLoop) {
            this.myContinueLoop = true;
            this.start();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "startRunning()", "A new thread has been requested to be started to make it possible for indication signals from the FRO possible to be received.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "startRunning ()", "Not possible to start up the thread since it already is running.");
        }
    }

    public void stopRunning() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopRunning ()");
        }
        if (this.myContinueLoop) {
            this.myContinueLoop = false;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "stopRunning()", "The running thread is requested to be stopped.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "stopRunning()", "No running thread exists that can be stopped.");
        }
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ()");
        }
        try {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "start()", "A new thread has been started (WaitForAdmStateIndication).");
            }
            while (this.myContinueLoop) {
                TimeHandler.sleep(1000L);
                Iterator iterator = this.myUpgradeablePlugInUnits.iterator();
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
                while (iterator.hasNext()) {
                    genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                    genericUpgradeablePlugInUnit.getAdministrativeState(null);
                }
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "start()", "The thread has been stopped (WaitForAdmStateIndication).");
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "run ()", "Exception caught when waiting for to be stopped... Only to enable incoming indication signals from the FRO...\n\tmyUpgradeablePlugInUnits: " + this.myUpgradeablePlugInUnits + "\n\tException data: " + exception.toString(), exception);
        }
        catch (Error error) {
            Trace.error(this.getClass(), "run ()", "Error caught when waiting for to be stopped... Only to enable incoming indication signals from the FRO...\n\tmyUpgradeablePlugInUnits: " + this.myUpgradeablePlugInUnits + "\n\tError data: " + error.toString(), error);
        }
    }
}

