/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.eqaccess.PIU_OperStateListenerAccessInterface;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.AttributePiusUpgradeInformationHandlerInterface;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.PiuUpgradeInformation;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerException;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerFactory;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.UpgradeablePIU_AdmStateListenerInterface;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public final class WaitForLockedOp
implements ExecutableOp,
UpgradePackageConst,
UpgradeablePIU_AdmStateListenerInterface,
PIU_OperStateListenerAccessInterface {
    public static final String HANDLING_FTC_STATE_FAULTY_AT_REBOOT_PIU = "Handling FTC state faulty at reboot PIU";
    private static final int FTC_ACTIVE = 3;
    private static final int FTC_FAULTY = 4;
    private static final int FTC_PASSIVE_NOT_READY = 5;
    private static final int OPER_STATE_ENABLED = 1;
    private static final int RESTART_TIMEOUT = 120;
    private Vector piuList = null;
    private Vector waitForEnabledPiuList = new Vector();
    private AttributePiusUpgradeInformationHandlerInterface myAttributePiusUpgradeInformationHandlerInterface = null;

    public WaitForLockedOp(Vector vector, AttributePiusUpgradeInformationHandlerInterface attributePiusUpgradeInformationHandlerInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "WaitForLockedOp(Vector piuList, AttributePiusUpgradeInformationHandlerInterface anAttributePiusUpgradeInformationHandlerInterface))", "piuList: " + vector + "AttributePiusUpgradeInformationHandlerInterface: " + attributePiusUpgradeInformationHandlerInterface);
        }
        this.piuList = vector;
        this.myAttributePiusUpgradeInformationHandlerInterface = attributePiusUpgradeInformationHandlerInterface;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        int n;
        Object object;
        Object object2;
        Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'WaitForLocked'.\n\tUpgradeablePIUs: " + this.piuList);
        try {
            PIU_AdmStateHandlerFactory pIU_AdmStateHandlerFactory = PIU_AdmStateHandlerFactory.instance();
            object2 = pIU_AdmStateHandlerFactory.getPIU_AdmStateHandler(this.piuList);
            if (object2 != null) {
                ((PIU_AdmStateHandler)object2).waitingForAdminStateToBeSet(this);
                pIU_AdmStateHandlerFactory.removePIU_AdmStateHandlers((PIU_AdmStateHandler)object2);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "No PIU admStateHandler was available. proceed the execution anyway.\n\tpiuList size :" + this.piuList.size() + "\n\tpiuList :" + this.piuList);
            }
        }
        catch (PIU_AdmStateHandlerException pIU_AdmStateHandlerException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "executeOp( ActionListener observer )", "PIU_AdmStateHandlerException caught while waiting for adm state to be set for all requested PIUs.\n\tpiuList: " + this.piuList + "\n\tException data: " + pIU_AdmStateHandlerException.toString());
            }
            throw new SAXException("PIU_AdmStateHandlerException caught while waiting for adm state to be set for all requested PIUs.\n\tpiuList: " + this.piuList + pIU_AdmStateHandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Exception caught while waiting for adm state to be set for all requested PIUs.\n\tpiuList: " + this.piuList, exception);
            throw new SAXException("Exception caught while waiting for adm state to be set for all requested PIUs.\n\tpiuList: " + this.piuList + exception.toString());
        }
        boolean bl = false;
        object2 = (Vector)this.piuList.clone();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Waiting for all PIU's to be locked\n\tpiuList size :" + this.piuList.size() + "\n\tpiuList :" + this.piuList);
        }
        while (!bl) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Exception caught while trying to sleep for 3s. at waiting for OpState to be set to LOCKED for the PIUs: " + this.piuList, exception);
            }
            for (int i = 0; i < this.piuList.size(); ++i) {
                object = (GenericUpgradeablePlugInUnit)this.piuList.elementAt(i);
                try {
                    if (object.getAdministrativeState(null) == 0) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Adm state of a PIU has been locked.\n\tpiu: " + object);
                        }
                        this.piuList.removeElementAt(i);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Waiting for adm state of PIUs to be locked.\n\tPIUs: " + this.piuList);
                    continue;
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Throwable caught while trying to retreive the administrative state from an PIU.\n\tSize of PIU list: " + this.piuList.size());
                    throw new SAXException(throwable.toString());
                }
            }
            if (this.piuList.size() != 0) continue;
            bl = true;
        }
        Coordinator coordinator = null;
        object = new Vector();
        try {
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            PiuUpgradeInformation piuUpgradeInformation = null;
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                coordinator = null;
                try {
                    genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)((Vector)object2).elementAt(i);
                    PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                    if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                        piuUpgradeInformation = this.myAttributePiusUpgradeInformationHandlerInterface.getPiuUpgradeInformation(genericUpgradeablePlugInUnit);
                        if (piuUpgradeInformation != null) {
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "thePiuUpgradeInformation:" + piuUpgradeInformation);
                            }
                            if (piuUpgradeInformation.isAnyProgramPresentInToVersion) {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Subscribing for operState enabled: " + genericUpgradeablePlugInUnit);
                                }
                                ((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit).subscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
                                this.waitForEnabledPiuList.add(genericUpgradeablePlugInUnit);
                            }
                        } else {
                            if (Trace.valid(this.getClass(), 22)) {
                                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "Subscribing for operState enabled (no piu upgrade information was available): " + genericUpgradeablePlugInUnit);
                            }
                            ((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit).subscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
                            this.waitForEnabledPiuList.add(genericUpgradeablePlugInUnit);
                        }
                    }
                    Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Requests for restart of PIU: " + genericUpgradeablePlugInUnit.toString() + "\n\t upContext = " + coordinator);
                    pIU_MO_HandlerInterface.restartPIU(genericUpgradeablePlugInUnit, 0, 2, coordinator);
                    continue;
                }
                catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
                    if (pIU_MO_HandlerException.toString().lastIndexOf("RestartRejectedException") != -1) {
                        if (this.isRestartRejectedDueToFTC_StateFaulty(genericUpgradeablePlugInUnit, pIU_MO_HandlerException.toString(), true)) {
                            this.executeRebootNodeUpgradeOp(actionListener);
                        }
                        ((Vector)object).add(genericUpgradeablePlugInUnit);
                        continue;
                    }
                    throw pIU_MO_HandlerException;
                }
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "When requesting for restart of a PIU exception where caught.", moAccessException);
            throw new SAXException(moAccessException.toString());
        }
        try {
            while (((Vector)object).size() > 0) {
                object = this.restartFailedPIUs(actionListener, (Vector)object);
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "When attempts to request for restart of a PIU that was failed an exception where caught.", moAccessException);
            throw new SAXException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "executeOp( ActionListener observer )", "When attempts to request for restart of a PIU that was failed an exception where caught.", throwable);
            throw new SAXException(throwable.toString());
        }
        boolean bl2 = false;
        for (n = 0; n < 120; ++n) {
            if (!this.waitForEnabledPiuList.isEmpty()) {
                TimeHandler.sleep(1000L);
                continue;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            Trace.warning(this.getClass(), "executeOp( ActionListener observer )", "All  boards have not become enabled during 120s after restart.\n\twaitForEnabledPiuList: " + this.waitForEnabledPiuList.toString());
            for (n = 0; n < this.waitForEnabledPiuList.size(); ++n) {
                ((PlugInUnitMoSU_Access)this.waitForEnabledPiuList.elementAt(n)).unSubscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
            }
            this.waitForEnabledPiuList.removeAllElements();
        }
    }

    public void operStateHasBeenSet(PlugInUnitMoSU_Access plugInUnitMoSU_Access, int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "operStateHasBeenSet(PlugInUnitMoSU_Access aPiu, int anOperState)", "aPiu: " + plugInUnitMoSU_Access + "\n\tanOperState: " + n);
        }
        if (n == 1) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "executeOp( ActionListener observer )", "unSubscribing for operState enabled: " + plugInUnitMoSU_Access.toString());
            }
            plugInUnitMoSU_Access.unSubscribeForOperStateAVCs((PIU_OperStateListenerAccessInterface)this);
            if (!this.waitForEnabledPiuList.removeElement(plugInUnitMoSU_Access) && Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "operStateHasBeenSet(PlugInUnitMoSU_Access aPiu, int anOperState)", "A notification has been received from a PIU that in not included in the list (ignored).\n\tPiu: " + plugInUnitMoSU_Access);
            }
        }
    }

    private void executeRebootNodeUpgradeOp(ActionListener actionListener) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "executeRebootNodeUpgradeOp(ActionListener anObserver)", "anObserver: " + actionListener);
        }
        throw new SAXException(HANDLING_FTC_STATE_FAULTY_AT_REBOOT_PIU);
    }

    private boolean isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string, boolean bl) {
        int n;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "aPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
        }
        if ((n = this.getFTC_State(genericUpgradeablePlugInUnit)) == 4) {
            Trace.info(this.getClass(), "isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "Restart of a PIU was rejected due to FTC state faulty.\n\tA restart node upgrade operation will be executed in this step instead of the specified restart PIU upgrade operation(s).\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
            return true;
        }
        if (n == 5) {
            if (bl) {
                Trace.info(this.getClass(), "isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "Restart of a PIU was rejected due to FTC sync in progress.\n\tA restart of this PIU will be requested with a common\n\tinterval until it succeeds or until an upgrade supervision timeout occurs.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
            } else if (Trace.valid(this.getClass(), 8)) {
                Trace.debug("isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "Restart of a PIU was rejected due to FTC sync in progress.\n\tA restart of this PIU will be requested with a common\n\tinterval until it succeeds or until an upgrade supervision timeout occurs.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
            }
            return false;
        }
        if (bl) {
            Trace.info(this.getClass(), "isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "Restart of a PIU was rejected for any reason.\n\tA restart of this PIU will be requested with a common\n\tinterval until it succeeds or until an upgrade supervision timeout occurs.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
        } else if (Trace.valid(this.getClass(), 8)) {
            Trace.debug("isRestartRejectedDueToFTC_StateFaulty(GenericUpgradeablePlugInUnit aPIU, String aRestartPIU_RejectionInfo, boolean anIsFirstRejectionForThisPIU)", "Restart of a PIU was rejected for any reason.\n\tA restart of this PIU will be requested with a common\n\tinterval until it succeeds or until an upgrade supervision timeout occurs.\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\taRestartPIU_RejectionInfo: " + string + "\n\tanIsFirstRejectionForThisPIU: " + bl);
        }
        return false;
    }

    private int getFTC_State(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFTC_State(GenericUpgradeablePlugInUnit aPIU)", "aPIU: " + genericUpgradeablePlugInUnit);
        }
        try {
            if (genericUpgradeablePlugInUnit instanceof ManagedObject) {
                ManagedObject managedObject = (ManagedObject)genericUpgradeablePlugInUnit;
                ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)ServiceLocatorFacade.getRepository().getService(ManagedElementMoSU_Access.class);
                ManagedObject[] managedObjectArray = managedElementMoSU_Access.getFtcsMos(null);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getFTC_State(GenericUpgradeablePlugInUnit aPIU)", "retrieved FTC MOs: " + SuLib.toString(managedObjectArray));
                }
                if (managedObjectArray.length == 2) {
                    String string = managedObject.getLocalDistinguishedName();
                    if (managedObjectArray[0].getLocalDistinguishedName().equals(string) || managedObjectArray[1].getLocalDistinguishedName().equals(string)) {
                        int[] nArray = managedElementMoSU_Access.getFtcStates(null);
                        String[] stringArray = new String[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            stringArray[i] = managedElementMoSU_Access.getState(nArray[i]);
                        }
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getFTC_State(GenericUpgradeablePlugInUnit aPIU)", "retrieved FTC states: " + SuLib.toString(stringArray));
                        }
                        if (nArray.length == 2) {
                            if (nArray[0] == 3) {
                                if (nArray[1] == 4 || nArray[1] == 5) {
                                    return nArray[1];
                                }
                            } else if (nArray[1] == 3 && (nArray[0] == 4 || nArray[0] == 5)) {
                                return nArray[0];
                            }
                        }
                    }
                }
            }
            return -1;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "getFTC_State(GenericUpgradeablePlugInUnit aPIU)", "Throwable caught (and ignored) when trying to get FTC State after rejection of restart PIU,\n\taPIU: " + genericUpgradeablePlugInUnit + "\n\tThrowable data: " + throwable.toString());
            return -1;
        }
    }

    private Vector restartFailedPIUs(ActionListener actionListener, Vector vector) throws SAXException, PIU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restartFailedPIUs ( ActionListener anObserver, Vector aPIUsWithRejectedRestarts )", "anObserver: " + actionListener + "\n\taPIUsWithRejectedRestarts: " + vector);
        }
        Vector vector2 = (Vector)vector.clone();
        Iterator iterator = vector2.iterator();
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        while (iterator.hasNext()) {
            TimeHandler.sleep(60000L);
            Control control = null;
            try {
                control = Transaction.create();
                Coordinator coordinator = Transaction.getCoordinator(control);
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restartFailedPIUs ( ActionListener anObserver, Vector aPIUsWithRejectedRestarts )", "Requests for restart of PIU: " + genericUpgradeablePlugInUnit);
                }
                PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
                pIU_MO_HandlerInterface.restartPIU(genericUpgradeablePlugInUnit, 0, 2, coordinator);
                vector.remove(genericUpgradeablePlugInUnit);
                Transaction.commit(control);
            }
            catch (PIU_MO_HandlerException pIU_MO_HandlerException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "restartFailedPIUs ( ActionListener anObserver, Vector aPIUsWithRejectedRestarts )", "PIU_MO_HandlerException: " + pIU_MO_HandlerException.toString());
                }
                Transaction.rollback(control);
                if (pIU_MO_HandlerException.toString().lastIndexOf("RestartRejectedException") != -1) {
                    if (!this.isRestartRejectedDueToFTC_StateFaulty(genericUpgradeablePlugInUnit, pIU_MO_HandlerException.toString(), false)) continue;
                    this.executeRebootNodeUpgradeOp(actionListener);
                    continue;
                }
                throw pIU_MO_HandlerException;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "restartFailedPIUs( ActionListener anObserver, Vector aPIUsWithRejectedRestarts )", "The restart of a PIU were rejected for an unknown reason.\n\tPIU: " + genericUpgradeablePlugInUnit + "\n\tException data: " + throwable.toString());
                Transaction.rollback(control);
                throw new SAXException("The restart of a PIU were rejected for an unknown reason.\n\tPIU: " + genericUpgradeablePlugInUnit + "\n\tException data: " + throwable.toString());
            }
        }
        return vector;
    }

    public String toString() {
        return "\n\n\tClass: " + this.getClass().getName() + "\n\tpiuList: " + this.piuList + "\n\twaitForEnabledPiuList: " + this.waitForEnabledPiuList;
    }
}

