/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootprogramupgrade;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradeException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.UpgradePackageConst;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_SubscribedInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.OsaUpiProxyAccess;
import se.ericsson.cello.su.froproxy.upi.interfaces.UPI_ProxyPropertyName;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.installsequence.RemoveProgramsInterface;
import se.ericsson.cello.sudom.proxy.installsequence.RunProgramsInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformation;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformations;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.util.datacontainer.NewStepLabelInformation;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationData;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.LoadModuleInformationsContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.TagAndLoadModuleInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramHandler;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.verify.ssw.CrlAndCertificateToStateHandler;

public final class RebootProgramUpgradeOp
implements ExecutableOp,
UpgradePackageConst,
PropertyChangeListener {
    private Vector myRunPrograms = null;
    private Vector myRemovePrograms = null;
    private Vector myAllProgramsToStart;
    private Vector myRegisteredPrograms = new Vector(1);
    private int myNumberOfUnknownRegisteredPrograms = 0;
    private GenericUpgradeablePlugInUnit[] myU_PIUs = null;
    private String myUpgradePackageUCF_Path = null;
    private String myUpgradePackageDocumentNumber = null;
    private String myUpgradePackageDocumentRevision = null;
    private String myStepLabel = null;
    private CrlAndCertificateToStateHandler myCrlAndCertificateToStateHandler = null;
    private HashMap myRunRemoveProgramsRepInfoMap = new HashMap(1);

    public RebootProgramUpgradeOp(Vector vector, Vector vector2, Vector vector3, String string, String string2, String string3, String string4, String string5) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RebootProgramUpgradeOp(Vector anU_PIUs, Vector aRunPrograms, Vector aRemovePrograms, String aStepLabel, String anUpgradePackageUCF_Path, String anUgradePackageDocumentNumber, String anUpgradePackageDocumentRevision, String anUpgradeCompatibilityIndex, String aCase)", "anU_PIUs: " + vector + "\n\taRunPrograms: " + vector2 + "\n\taRemovePrograms: " + vector3 + "\n\taStepLabel: " + string + "\n\tanUpgradePackageUCF_Path: " + string2 + "\n\tanUpgradePackageDocumentNumber: " + string3 + "\n\tanUpgradePackageDocumentRevision: " + string4 + "\n\taCase: " + string5);
        }
        this.myRunPrograms = vector2;
        this.myRemovePrograms = vector3;
        this.myU_PIUs = new GenericUpgradeablePlugInUnit[vector.size()];
        vector.copyInto(this.myU_PIUs);
        this.myStepLabel = string;
        this.myUpgradePackageUCF_Path = string2;
        this.myUpgradePackageDocumentNumber = string3;
        this.myUpgradePackageDocumentRevision = string4;
        this.myCrlAndCertificateToStateHandler = new CrlAndCertificateToStateHandler(string2, string3, string4, string5);
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        if (this.myStepLabel != null) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new NewStepLabelInformation((Object)this, this.myStepLabel));
        }
        Trace.log1(this.getClass(), "executeOp( ActionListener observer )", "Execute operation 'RebootProgramUpgrade'.");
        try {
            if (!this.myRunPrograms.isEmpty()) {
                this.doCreateAndStartPrograms();
            } else if (!this.myRemovePrograms.isEmpty()) {
                this.doStopAndDeletePrograms();
            }
        }
        catch (Exception exception) {
            if (!this.myRunPrograms.isEmpty()) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Exception caught when trying to execute 'doCreateAndStartPrograms ( )', myRunPrograms: " + this.myRunPrograms + " ,myRemovePrograms: " + this.myRemovePrograms + " ,piuList: " + this.myU_PIUs, exception);
            } else if (!this.myRemovePrograms.isEmpty()) {
                Trace.error(this.getClass(), "executeOp( ActionListener observer )", "Exception caught when trying to execute 'doStopAndDeletePrograms ( )', myRunPrograms: " + this.myRunPrograms + " ,myRemovePrograms: " + this.myRemovePrograms + " ,piuList: " + this.myU_PIUs, exception);
            }
            throw new SAXException(exception.toString());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof AUE_SubscribedInformation) {
                String string;
                AUE_SubscribedInformation aUE_SubscribedInformation = (AUE_SubscribedInformation)propertyChangeEvent.getNewValue();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Received AUE_SubscribedInformation: " + aUE_SubscribedInformation);
                }
                if ((string = "").equals(aUE_SubscribedInformation.productNumber) && string.equals(aUE_SubscribedInformation.productRevision)) {
                    ++this.myNumberOfUnknownRegisteredPrograms;
                } else {
                    ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(aUE_SubscribedInformation.productNumber, aUE_SubscribedInformation.productRevision, null);
                    this.myRegisteredPrograms.addElement(productNumberAndRevision);
                }
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught, message: " + throwable.toString(), throwable);
            Trace.flushToTraceFile();
        }
    }

    private void doCreateAndStartPrograms() throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doCreateAndStartPrograms()Creating and starting programs.");
        }
        try {
            this.startListeningOnC_AUE_HasSubscribed();
            this.myAllProgramsToStart = new Vector();
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = this.parseUCF();
            LoadModulesProxyInterface loadModulesProxyInterface = optimizedDocumentObjectProxyInterface.getLoadModulesProxyInterface();
            Collection collection = this.matchPiuWithRepertoire(this.myRunPrograms);
            HashMap hashMap = (HashMap)this.myRunRemoveProgramsRepInfoMap.clone();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doCreateAndStartPrograms()", "thePiuMo: " + genericUpgradeablePlugInUnit);
                }
                Vector vector = new Vector(1);
                if (genericUpgradeablePlugInUnit.getOperationalState(null) != 1) continue;
                if (UpgradeDB_StorageUtil.isExecutedFromState()) {
                    this.myCrlAndCertificateToStateHandler.loadCrlAndCertForToState(genericUpgradeablePlugInUnit);
                }
                Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                Coordinator coordinator = control.getCoordinator();
                PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(coordinator);
                ProgramConfigurationInformations programConfigurationInformations = ServiceFinder.getPiuTypeMO_HandlerInterface().getProgramConfigurations(piuTypeMoSU_Access, coordinator);
                if (programConfigurationInformations.isEmpty()) {
                    Trace.error(this.getClass(), "doCreateAndStartPrograms()", "No program configurations definition found in the PiuType referenced by the U-PIU.\n\taPiuMo: " + genericUpgradeablePlugInUnit + "\n\tthePiuType: " + piuTypeMoSU_Access + "\n\ttheProgramConfigurationInformations: " + programConfigurationInformations);
                    throw new NoSuchFieldException("No program configurations definition found in the PiuType: " + piuTypeMoSU_Access);
                }
                ProgramHandler programHandler = new ProgramHandler(genericUpgradeablePlugInUnit);
                TagAndLoadModuleInformation tagAndLoadModuleInformation = programHandler.getLoadModulesDefinedInRepertoires(hashMap.keySet(), piuTypeMoSU_Access, programConfigurationInformations, coordinator);
                Integer n = null;
                ProgramConfigurationInformation programConfigurationInformation = null;
                Iterator iterator2 = programConfigurationInformations.iterator();
                while (iterator2.hasNext()) {
                    programConfigurationInformation = (ProgramConfigurationInformation)iterator2.next();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "doCreateAndStartPrograms()", "(PiuType) Program Config Entry " + programConfigurationInformation.getTag() + " " + programConfigurationInformation.getSubparentLDN() + " " + " " + programConfigurationInformation.getProgramMoTypeName());
                    }
                    n = new Integer(programConfigurationInformation.getTag());
                    LoadModuleInformationData loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(n);
                    vector.addAll(this.doCreateAndEnablePrograms(programHandler, n, programConfigurationInformation, loadModuleInformationData, loadModulesProxyInterface, coordinator));
                }
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "doCreateAndStartPrograms()", vector.size() + " program(s) shall be started for this PIU: " + genericUpgradeablePlugInUnit.getLocalDistinguishedName() + ". ProdNoAndRev of PiuType: " + piuTypeMoSU_Access.getProductNumber(null) + "_" + piuTypeMoSU_Access.getProductRevision(null) + ".");
                }
                control.getTerminator().commit();
                this.myAllProgramsToStart.addAll(vector);
                if (!(hashMap = this.removeHandledRepertoires(hashMap, piuTypeMoSU_Access)).isEmpty()) continue;
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "doCreateAndStartPrograms()", "A total of " + this.myAllProgramsToStart.size() + " program(s) shall be started for RebootProgramUpgrade step.");
            }
            this.startPrograms(this.myAllProgramsToStart);
            this.waitForPogramsGetOpStateEnabled();
            this.verifyThatAllStartedProgramsAreRegisteredAsSubscribers();
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "doCreateAndStartPrograms( )", "Throwable caught when trying to create and start programs.", throwable);
            throw new UpgradeException("Throwable caught when trying to create and start programs,\n\tThrowable: " + throwable);
        }
        finally {
            this.stopListeningOnC_AUE_HasSubscribed();
            this.myAllProgramsToStart = null;
        }
    }

    private void waitForPogramsGetOpStateEnabled() throws MoAccessException {
        boolean bl = false;
        for (int i = 0; !bl && i < 360; ++i) {
            TimeHandler.sleep(5000L);
            bl = true;
            Enumeration enumeration = this.myAllProgramsToStart.elements();
            while (enumeration.hasMoreElements()) {
                GenericProgramBase genericProgramBase = (GenericProgramBase)enumeration.nextElement();
                int n = genericProgramBase.getOperationalState(null);
                if (n != 0) continue;
                bl = false;
                if (i <= 0 || i % 100 != 0 || !Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "waitForPogramsGetOpStateEnabled()", "Waiting for operational state of started program(s) to be set to ENABLED,\n\toperational state is DISABLED for program: " + ((ManagedObject)genericProgramBase).getLocalDistinguishedName());
            }
        }
        if (!bl) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForPogramsGetOpStateEnabled()", "Starts Program failed");
            }
            throw new UpgradeException("RebootProgramUpgradeOp, start program failed");
        }
    }

    private Collection doCreateAndEnablePrograms(ProgramHandler programHandler, Integer n, ProgramConfigurationInformation programConfigurationInformation, LoadModuleInformationData loadModuleInformationData, LoadModulesProxyInterface loadModulesProxyInterface, Coordinator coordinator) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doCreateAndEnablePrograms(ProgramHandler aProgramHandler, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformation, LoadModuleInformationData aLoadModuleInformationData, LoadModulesProxyInterface aLoadModulesProxyInterface, Coordinator aCoordinator)", "aProgramHandler: " + programHandler + "\n\taTag: " + n + "\n\taProgramConfigurationInformation: " + programConfigurationInformation + "\n\taLoadModuleInformationData: " + loadModuleInformationData + "\n\taLoadModulesProxyInterface: " + loadModulesProxyInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Vector vector = new Vector(1);
        if (loadModuleInformationData != null) {
            LoadModuleInformationsContainer loadModuleInformationsContainer = null;
            Iterator iterator = loadModuleInformationData.getLoadModuleInformationsContainers().iterator();
            while (iterator.hasNext()) {
                loadModuleInformationsContainer = (LoadModuleInformationsContainer)iterator.next();
                vector.addAll(this.doCreateAndEnablePrograms(programHandler, n, programConfigurationInformation, loadModuleInformationsContainer, loadModulesProxyInterface, coordinator));
            }
        }
        return vector;
    }

    private Collection doCreateAndEnablePrograms(ProgramHandler programHandler, Integer n, ProgramConfigurationInformation programConfigurationInformation, LoadModuleInformationsContainer loadModuleInformationsContainer, LoadModulesProxyInterface loadModulesProxyInterface, Coordinator coordinator) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createProgram(ProgramHandler aProgramHandler, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformation, LoadModuleInformationsContainer aLoadModuleInformationsContainer, LoadModulesProxyInterface aLoadModulesProxyInterface, Coordinator aCoordinator)", "aProgramHandler: " + programHandler + "\n\taTag: " + n + "\n\taProgramConfigurationInformation: " + programConfigurationInformation + "\n\taLoadModuleInformationsContainer: " + loadModuleInformationsContainer + "\n\taLoadModulesProxyInterface: " + loadModulesProxyInterface + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Vector<GenericProgramBase> vector = new Vector<GenericProgramBase>(1);
        LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
        GenericProgramBase genericProgramBase = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        LoadModuleInformation loadModuleInformation = null;
        Iterator iterator = loadModuleInformationsContainer.getAllLoadModuleInformationIter();
        while (iterator.hasNext()) {
            loadModuleInformation = (LoadModuleInformation)iterator.next();
            loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(loadModuleInformation);
            if (loadModuleMoSU_Access != null) {
                genericProgramBase = programHandler.createProgram(n, loadModuleMoSU_Access, programConfigurationInformation, loadModuleInformation, loadModuleMO_HandlerInterface, coordinator);
                if (genericProgramBase == null) continue;
                genericProgramBase.setIsUpgradePersistent(true, coordinator);
                genericProgramBase.setStartState(1, coordinator);
                vector.add(genericProgramBase);
                continue;
            }
            Trace.info(this.getClass(), "doCreateAndEnablePrograms(ProgramHandler aProgramHandler, Integer aTag, ProgramConfigurationInformation aProgramConfigurationInformation, LoadModuleInformationsContainer aLoadModuleInformationsContainer, LoadModulesProxyInterface aLoadModulesProxyInterface, Coordinator aCoordinator)", "No LoadModule MO was found for following LM info (ignoring i.e. no C-AUE will be started related to this LM info): " + loadModuleInformation);
        }
        return vector;
    }

    private HashMap removeHandledRepertoires(Map map, PiuTypeMoSU_Access piuTypeMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeHandledRepertoires(Map aRunProgramsRepInfoMapClone, PiuTypeMoSU_Access aPiuTypeMo)", "aRunProgramsRepInfoMapClone: " + map + "\n\taPiuTypeMo: " + piuTypeMoSU_Access);
        }
        HashMap<RepertoireMoSU_Access, Boolean> hashMap = new HashMap<RepertoireMoSU_Access, Boolean>(1);
        RepertoireMoSU_Access repertoireMoSU_Access = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
            Boolean bl = (Boolean)map.get(repertoireMoSU_Access);
            if (this.isPiuTypePartOfRepertoire(repertoireMoSU_Access, piuTypeMoSU_Access)) {
                if (bl.booleanValue()) continue;
                hashMap.put(repertoireMoSU_Access, bl);
                continue;
            }
            hashMap.put(repertoireMoSU_Access, bl);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "removeHandledRepertoires(Map aRunProgramsRepInfoMapClone, PiuTypeMoSU_Access aPiuTypeMo)", "Returns - theNewRunProgramsRepInfoMap: " + hashMap);
        }
        return hashMap;
    }

    private boolean isPiuTypePartOfRepertoire(RepertoireMoSU_Access repertoireMoSU_Access, PiuTypeMoSU_Access piuTypeMoSU_Access) throws MoAccessException {
        boolean bl = false;
        ManagedObject[] managedObjectArray = repertoireMoSU_Access.getPiuTypeList(null);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!managedObjectArray[i].equals(piuTypeMoSU_Access)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void startPrograms(Collection collection) throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startPrograms(Collection aProgramsToStart)", "Number of programs: " + collection.size());
        }
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
        Coordinator coordinator = control.getCoordinator();
        GenericProgramBase genericProgramBase = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            genericProgramBase = (GenericProgramBase)iterator.next();
            genericProgramBase.actionStartImmediate(coordinator);
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "startPrograms(Collection aProgramsToStart)", "Starts Program.");
        }
        control.getTerminator().commit();
    }

    private void doStopAndDeletePrograms() throws Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doStopAndDeletePrograms ( )");
        }
        Trace.suTestLog(this.getClass(), "doStopAndDeletePrograms ( )", "Stop and delete programs.");
        int n = 0;
        Iterator iterator = this.matchPiuWithRepertoire(this.myRemovePrograms).iterator();
        while (iterator.hasNext()) {
            ProgramConfigurationInformations programConfigurationInformations;
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
            int n2 = 0;
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)genericUpgradeablePlugInUnit.getPiuType(null);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doStopAndDeletePrograms ( )", "piutype = " + piuTypeMoSU_Access.toString());
            }
            if ((programConfigurationInformations = ServiceFinder.getPiuTypeMO_HandlerInterface().getProgramConfigurations(piuTypeMoSU_Access, null)).isEmpty()) {
                throw new NoSuchFieldException("No Program Configuration for piuType " + piuTypeMoSU_Access);
            }
            Hashtable hashtable = this.collectOldPrograms(programConfigurationInformations, genericUpgradeablePlugInUnit, null);
            ProgramHandler programHandler = new ProgramHandler(genericUpgradeablePlugInUnit);
            TagAndLoadModuleInformation tagAndLoadModuleInformation = programHandler.getLoadModulesDefinedInRepertoires(this.myRunRemoveProgramsRepInfoMap.keySet(), piuTypeMoSU_Access, programConfigurationInformations, null);
            ProgramConfigurationInformation programConfigurationInformation = null;
            Iterator iterator2 = programConfigurationInformations.iterator();
            while (iterator2.hasNext()) {
                programConfigurationInformation = (ProgramConfigurationInformation)iterator2.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doStopAndDeletePrograms ( )", "(PiuType) Program Config Entry " + programConfigurationInformation.getTag() + " " + programConfigurationInformation.getSubparentLDN() + " " + programConfigurationInformation.getProgramMoTypeName());
                }
                Control control = TransactionServiceImpl.instance().getTransactionFactory().create(3600);
                Coordinator coordinator = control.getCoordinator();
                Integer n3 = new Integer(programConfigurationInformation.getTag());
                LoadModuleInformationData loadModuleInformationData = tagAndLoadModuleInformation.getLoadModuleInformationData(n3);
                n2 += this.doStopAndDeletePrograms(piuTypeMoSU_Access, loadModuleInformationData, hashtable, n3, coordinator);
                control.getTerminator().commit();
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "doStopAndDeletePrograms()", "" + n2 + " program(s) has been stopped and deleted for this PIU: " + genericUpgradeablePlugInUnit + ". ProdNoAndRev of PiuType: " + piuTypeMoSU_Access.getProductNumber(null) + "_" + piuTypeMoSU_Access.getProductRevision(null) + ".");
            }
            n += n2;
        }
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "doStopAndDeletePrograms()", "A total of " + n + " program(s) has been stopped and deleted for RebootProgramUpgrade step.");
        }
    }

    private int doStopAndDeletePrograms(PiuTypeMoSU_Access piuTypeMoSU_Access, LoadModuleInformationData loadModuleInformationData, Hashtable hashtable, Integer n, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doStopAndDeletePrograms(PiuTypeMoSU_Access aPiuTypeMo, LoadModuleInformationData aLoadModuleInformationData, Hashtable anOldPrograms, Integer aTag, Coordinator aCoordinator)", "aPiuTypeMo: " + piuTypeMoSU_Access + "\n\taLoadModuleInformationData: " + loadModuleInformationData + "\n\tanOldPrograms: " + hashtable + "\n\taTag: " + n + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        int n2 = 0;
        if (loadModuleInformationData != null) {
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModuleInformationsContainer loadModuleInformationsContainer = null;
            Iterator iterator = loadModuleInformationData.getLoadModuleInformationsContainers().iterator();
            while (iterator.hasNext()) {
                loadModuleInformationsContainer = (LoadModuleInformationsContainer)iterator.next();
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                LoadModuleInformation loadModuleInformation = null;
                loadModuleInformation = loadModuleInformationsContainer.getFirstLoadModuleInformation();
                loadModuleMoSU_Access = loadModuleMO_HandlerInterface.getLoadModuleMo(loadModuleInformation);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doStopAndDeletePrograms ( )", "Removing Program for LM " + loadModuleMoSU_Access);
                }
                n2 += this.doStopAndDeleteProgramsWithMatchingLM(n, loadModuleMoSU_Access, hashtable, coordinator);
            }
        }
        return n2;
    }

    private Collection matchPiuWithRepertoire(Vector vector) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "matchPiuWithRepertoire ( Vector aRunOrRemovePrograms )", "aRunOrRemovePrograms: " + vector);
        }
        LinkedList<GenericUpgradeablePlugInUnit> linkedList = new LinkedList<GenericUpgradeablePlugInUnit>();
        RepertoireMoSU_Access repertoireMoSU_Access = null;
        boolean bl = false;
        RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
        RunProgramsInterface runProgramsInterface = null;
        RemoveProgramsInterface removeProgramsInterface = null;
        Object var8_8 = null;
        for (int i = 0; i < vector.size(); ++i) {
            var8_8 = vector.elementAt(i);
            if (var8_8 instanceof RunProgramsInterface) {
                runProgramsInterface = var8_8;
                repertoireMoSU_Access = repertoireMO_HandlerInterface.getRepertoireMo(runProgramsInterface.getRepertoireName(), null);
                bl = runProgramsInterface.isOneInstance();
            } else {
                removeProgramsInterface = var8_8;
                repertoireMoSU_Access = repertoireMO_HandlerInterface.getRepertoireMo(removeProgramsInterface.getRepertoireName(), null);
                bl = false;
            }
            this.myRunRemoveProgramsRepInfoMap.put(repertoireMoSU_Access, new Boolean(bl));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "matchPiuWithRepertoire ( Vector aRunOrRemovePrograms )", "myRunRemoveProgramsRepInfoMap: " + this.myRunRemoveProgramsRepInfoMap);
            }
            ManagedObject[] managedObjectArray = repertoireMoSU_Access.getPiuTypeList(null);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "matchPiuWithRepertoire(Vector aRunOrRemovePrograms)", "The repertoire piuTypeList: " + SuLib.toString(managedObjectArray));
            }
            for (int j = 0; j < this.myU_PIUs.length; ++j) {
                for (int k = 0; k < managedObjectArray.length; ++k) {
                    if (!this.myU_PIUs[j].getPiuType(null).equals(managedObjectArray[k])) continue;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "matchPiuWithRepertoire ( Vector aRunOrRemovePrograms )", "Found a match: " + this.myU_PIUs[j]);
                    }
                    linkedList.add(this.myU_PIUs[j]);
                    k = managedObjectArray.length;
                }
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "matchPiuWithRepertoire ( Vector aRunOrRemovePrograms )", "RETURNS - theMatchPiu: " + linkedList);
        }
        return linkedList;
    }

    private Hashtable collectOldPrograms(ProgramConfigurationInformations programConfigurationInformations, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectOldPrograms (ProgramConfigurationInformations theProgramConfigurationInformations, GenericUpgradeablePlugInUnit aPiuMo, Coordinator aCoordinator)", "theProgramConfigurationInformations: " + programConfigurationInformations + "\n\taPiuMo: " + genericUpgradeablePlugInUnit + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        Hashtable hashtable = new Hashtable();
        ProgramConfigurationInformation programConfigurationInformation = null;
        Iterator iterator = programConfigurationInformations.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject;
            programConfigurationInformation = (ProgramConfigurationInformation)iterator.next();
            Integer n = new Integer(programConfigurationInformation.getTag());
            String string = programConfigurationInformation.getProgramMoTypeName();
            String string2 = programConfigurationInformation.getSubparentLDN();
            String string3 = genericUpgradeablePlugInUnit.getLocalDistinguishedName();
            if (!string2.equals("")) {
                string3 = string3 + "," + string2;
            }
            if ((managedObject = MoRepository.instance().lookup(string3)) == null) {
                Trace.warning(this.getClass(), "collectOldPrograms ( Struct[] progConfigList, ManagedObject plugInUnit, Coordinator c )", "Program Parent defined in PiuType not found under PIU, parent ##" + string3 + "## (## = delimiter generated in this message)");
                continue;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectOldPrograms ( Struct[] progConfigList, ManagedObject plugInUnit, Coordinator c )", "Disabling Old Programs, Parent " + managedObject.toString() + " mo Type" + string);
            }
            MoIterator moIterator = MoRepository.instance().select(managedObject, 1, (MoFilter)new MoTypeFilter(string));
            Vector<GenericProgramBase> vector = new Vector<GenericProgramBase>(1);
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    GenericProgramBase genericProgramBase = (GenericProgramBase)moIterator.nextMo();
                    vector.addElement(genericProgramBase);
                }
            }
            hashtable.put(n, vector);
        }
        return hashtable;
    }

    private int doStopAndDeleteProgramsWithMatchingLM(Integer n, LoadModuleMoSU_Access loadModuleMoSU_Access, Hashtable hashtable, Coordinator coordinator) throws MoAccessException {
        Enumeration enumeration;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doStopAndDeleteProgramsWithMatchingLM(Integer aTag, LoadModuleMoSU_Access aLoadModule, Hashtable oldPrograms, Coordinator aCoordinator)", "aTag: " + n + "\n\taLoadModule: " + loadModuleMoSU_Access + "\n\toldPrograms: " + hashtable + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        int n2 = 0;
        if (loadModuleMoSU_Access != null && hashtable.containsKey(n) && (enumeration = ((Vector)hashtable.get(n)).elements()) != null) {
            while (enumeration.hasMoreElements()) {
                GenericProgramBase genericProgramBase = (GenericProgramBase)enumeration.nextElement();
                if (!loadModuleMoSU_Access.equals(genericProgramBase.getLoadModule(coordinator))) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "doStopAndDeleteProgramsWithMatchingLM(Integer aTag, LoadModuleMoSU_Access aLoadModule, Hashtable oldPrograms, Coordinator aCoordinator)", "Found " + genericProgramBase);
                }
                this.doStopAndDeleteProgram(genericProgramBase, coordinator);
                ++n2;
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "doStopAndDeleteProgramsWithMatchingLM(Integer aTag, LoadModuleMoSU_Access aLoadModule, Hashtable oldPrograms, Coordinator aCoordinator)", "Returning - theDeleteProgramCounter: " + n2);
        }
        return n2;
    }

    private void doStopAndDeleteProgram(GenericProgramBase genericProgramBase, Coordinator coordinator) throws MoAccessException {
        if (genericProgramBase != null) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doStopAndDeleteProgram(GenericProgramBase aGenericProgram)", "Program stop & delete " + genericProgramBase);
            }
            genericProgramBase.actionStopImmediate(coordinator);
            ((ManagedObject)genericProgramBase).delete(coordinator);
        }
    }

    private void startListeningOnC_AUE_HasSubscribed() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startListeningOnC_AUE_HasSubscribed( )");
        }
        try {
            OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
            osaUpiProxyAccess.addPropertyChangeListener(UPI_ProxyPropertyName.AUE_Subscribed, this);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "startListeningOnC_AUE_HasSubscribed( )", "Failed to add upgrade logic as listener on subscription indications from C-AUEs (ignored).Throwable data: " + throwable);
        }
    }

    private void stopListeningOnC_AUE_HasSubscribed() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopListeningOnC_AUE_HasSubscribed( )");
        }
        try {
            OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
            osaUpiProxyAccess.removePropertyChangeListener(UPI_ProxyPropertyName.AUE_Subscribed, this);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "stopListeningOnC_AUE_HasSubscribed( )", "Failed to remove upgrade logic as listener on subscription indications from C-AUEs (ignored).Throwable data: " + throwable);
        }
    }

    private void verifyThatAllStartedProgramsAreRegisteredAsSubscribers() throws UpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatAllStartedProgramsAreRegisteredAsSubscribers( )");
        }
        try {
            Vector vector = this.getProductNumbersAndRevisionsOfStartedPrograms();
            boolean bl = false;
            int n = 0;
            while (!bl) {
                if ((vector = this.updateNotRegisteredPrograms(vector)).isEmpty()) {
                    bl = true;
                    continue;
                }
                if (this.myNumberOfUnknownRegisteredPrograms >= vector.size()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "verifyThatAllStartedProgramsAreRegisteredAsSubscribers( )", "All started program(s) (C-AUEs) have been registered as subscribers of triggers\n\t(assumed since the number of subscriptions matches the number of started programs).");
                    }
                    bl = true;
                    continue;
                }
                if (++n == 12 || n % 100 == 0) {
                    Trace.log1(this.getClass(), "verifyThatAllStartedProgramsAreRegisteredAsSubscribers( )", "Waiting for started program(s) (C-AUEs) to be registered as subscribers of triggers,\n\tnot yet registered program(s): " + vector);
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyThatAllStartedProgramsAreRegisteredAsSubscribers( )", "Throwable caught when trying to verify that all started program(s) are registered as subscribers of triggers.", throwable);
            throw new UpgradeException("Throwable caught when trying to verify that all started program(s) are registered as subscribers of triggers,\n\tThrowable: " + throwable);
        }
    }

    private Vector getProductNumbersAndRevisionsOfStartedPrograms() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductNumbersAndRevisionsOfStartedPrograms( )");
        }
        Iterator iterator = this.myAllProgramsToStart.iterator();
        GenericProgramBase genericProgramBase = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        Vector<ProductNumberAndRevision> vector = new Vector<ProductNumberAndRevision>(this.myAllProgramsToStart.size());
        if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
            while (iterator.hasNext()) {
                genericProgramBase = (GenericProgramBase)iterator.next();
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(null);
                vector.addElement(new ProductNumberAndRevision(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null), null));
            }
        } else {
            while (iterator.hasNext()) {
                genericProgramBase = (GenericProgramBase)iterator.next();
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)genericProgramBase.getLoadModule(null);
                vector.addElement(new ProductNumberAndRevision(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)), null));
            }
        }
        return vector;
    }

    private Vector updateNotRegisteredPrograms(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateNotRegisteredPrograms(Vector aProgramsToCheck)", "aProgramsToCheck: " + vector);
        }
        Vector<ProductNumberAndRevision> vector2 = new Vector<ProductNumberAndRevision>(1);
        Iterator iterator = vector.iterator();
        ProductNumberAndRevision productNumberAndRevision = null;
        while (iterator.hasNext()) {
            productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
            if (this.removeElementFromMyRegisteredPrograms(productNumberAndRevision)) continue;
            vector2.addElement(productNumberAndRevision);
        }
        return vector2;
    }

    private boolean removeElementFromMyRegisteredPrograms(ProductNumberAndRevision productNumberAndRevision) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeElementFromMyRegisteredPrograms(ProductNumberAndRevision aProgram)", "aProgram: " + productNumberAndRevision);
        }
        Iterator iterator = ((Vector)this.myRegisteredPrograms.clone()).iterator();
        ProductNumberAndRevision productNumberAndRevision2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            productNumberAndRevision2 = (ProductNumberAndRevision)iterator.next();
            if (productNumberAndRevision2.equals(productNumberAndRevision)) {
                bl = true;
                break;
            }
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "removeElementFromMyRegisteredPrograms(ProductNumberAndRevision aProgram)", "No match,\n\treceived program product number  : " + productNumberAndRevision.productNumber + " revision: " + productNumberAndRevision.revision + " length: " + productNumberAndRevision.productNumber.length() + " + " + productNumberAndRevision.revision.length() + " characters," + "\n\tregistered program product number: " + productNumberAndRevision2.productNumber + " revision: " + productNumberAndRevision2.revision + " length: " + productNumberAndRevision2.productNumber.length() + " + " + productNumberAndRevision2.revision.length() + " characters.");
        }
        if (bl) {
            this.myRegisteredPrograms.removeElement(productNumberAndRevision2);
        }
        return bl;
    }

    private OptimizedDocumentObjectProxyInterface parseUCF() throws UpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseUCF()");
        }
        try {
            String[] stringArray = new String[]{"LoadModule"};
            return UCF_ParserFacade.parseMainElementsOptimizedInterface(this.myUpgradePackageDocumentNumber, this.myUpgradePackageDocumentRevision, this.myUpgradePackageUCF_Path, stringArray, false);
        }
        catch (Throwable throwable) {
            throw new UpgradeException("Class name: " + this.getClass().getName() + "\n\tparseUCF()" + "\n\tThrowable caught," + "\n\tmyUpgradePackageUCF_Path: " + this.myUpgradePackageUCF_Path + "\n\tmyUpgradePackageDocumentNumber: " + this.myUpgradePackageDocumentNumber + "\n\tmyUpgradePackageDocumentRevision: " + this.myUpgradePackageDocumentRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }
}

