/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.trigger;

import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.upi.UpgradeTriggerResultInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ConfirmedInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ConfirmedWithWarningInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_FailureInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_ProgressInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.AUE_TimeoutInformation;
import se.ericsson.cello.su.froproxy.upi.interfaces.OsaUpiProxyAccess;
import se.ericsson.cello.su.froproxy.upi.interfaces.TriggerListener;
import se.ericsson.cello.su.froproxy.upi.interfaces.UPI_ProxyPropertyName;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueCfmWithWarningInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueFailureInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueProgressInfo;
import se.ericsson.cello.upgradepackage.util.enumer.TypeOfAUE;

public class UpiTriggerSender
extends Thread
implements UpgradeParticipator,
PropertyChangeListener,
TriggerListener {
    private BlockingQueue inQueue = new BlockingQueue();
    private UpgradeMaster master;
    private int timeout;
    private String triggerName;
    private static final int SEND_TRIGGER_TO_UPI_FRO = 1;
    private static final String NAME_OF_TRIGGER_SENDER_THREAD = "SU_UPI_TriggerSender";

    public UpiTriggerSender(int n) {
        super(NAME_OF_TRIGGER_SENDER_THREAD);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpiTriggerSender(int timeout)", "\ttimeout: " + n);
        }
        this.timeout = n;
        this.start();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)");
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof AUE_ProgressInformation) {
                this.invokeHandlePropertyChange((AUE_ProgressInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof AUE_ConfirmedInformation) {
                this.invokeHandlePropertyChange((AUE_ConfirmedInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof AUE_ConfirmedWithWarningInformation) {
                this.invokeHandlePropertyChange((AUE_ConfirmedWithWarningInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof AUE_FailureInformation) {
                this.invokeHandlePropertyChange((AUE_FailureInformation)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getNewValue() instanceof AUE_TimeoutInformation) {
                this.invokeHandlePropertyChange((AUE_TimeoutInformation)propertyChangeEvent.getNewValue());
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent);
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught, message (ignored): " + throwable.toString());
            Trace.flushToTraceFile();
        }
    }

    private void invokeHandlePropertyChange(AUE_ProgressInformation aUE_ProgressInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( AUE_ProgressInformation anAUE_ProgressInformation )", "anAUE_ProgressInformation: " + aUE_ProgressInformation);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueProgressInfo(this, aUE_ProgressInformation.getAdditionalInformations(), aUE_ProgressInformation.aueName, TypeOfAUE.C_AUE));
    }

    private void invokeHandlePropertyChange(AUE_ConfirmedInformation aUE_ConfirmedInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( AUE_ConfirmedInformation anAUE_ConfirmedInformation )", "anAUE_ConfirmedInformation: " + aUE_ConfirmedInformation);
        }
    }

    private void invokeHandlePropertyChange(AUE_ConfirmedWithWarningInformation aUE_ConfirmedWithWarningInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( AUE_ConfirmedWithWarningInformation anAUE_ConfirmedWithWarningInformation )", "anAUE_ConfirmedWithWarningInformation: " + aUE_ConfirmedWithWarningInformation);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueCfmWithWarningInfo(this, aUE_ConfirmedWithWarningInformation.getAdditionalInformations(), aUE_ConfirmedWithWarningInformation.aueName, TypeOfAUE.C_AUE));
    }

    private void invokeHandlePropertyChange(AUE_FailureInformation aUE_FailureInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( AUE_FailureInformation anAUE_FailureInformation )", "anAUE_FailureInformation: " + aUE_FailureInformation);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, aUE_FailureInformation.getAdditionalInformations(), aUE_FailureInformation.aueName, TypeOfAUE.C_AUE));
    }

    private void invokeHandlePropertyChange(AUE_TimeoutInformation aUE_TimeoutInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "invokeHandlePropertyChange ( AUE_TimeoutInformation anAUE_TimeoutInformation )", "anAUE_TimeoutInformation: " + aUE_TimeoutInformation);
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, aUE_TimeoutInformation.getAdditionalInformations(), aUE_TimeoutInformation.aueName, TypeOfAUE.C_AUE));
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerIndicated(UpgradeMaster master, String aTriggerName)", "\tmaster: " + upgradeMaster + "\n\taTriggerName: " + string);
        }
        this.master = upgradeMaster;
        this.triggerName = string;
        this.inQueue.enqueue((Object)new Integer(1));
    }

    public String participatorName() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "participatorName()");
        }
        return this.getClass().getName();
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        try {
            int n = (Integer)this.inQueue.dequeue();
            if (n == 1) {
                this.startListeningForPropertiesFromC_AUEs();
                this.sendTriggerRequest();
            } else {
                Trace.warning(this.getClass(), "run()", "Unexpected request received (do not know what to do!!! SHOULD NOT HAPPEN...)\n\ttype: " + n);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "RuntimeError", throwable);
        }
    }

    private void sendTriggerRequest() throws FroNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendTriggerRequest()");
        }
        OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
        osaUpiProxyAccess.sendOsaUpiStartUpgradeTriggReq(this.triggerName, this.timeout, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerResponse(UpgradeTriggerResultInformation upgradeTriggerResultInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerResponse(UpgradeTriggerResultInformation anUpgradeTriggerResultInformation)", "anUpgradeTriggerResultInformation: " + upgradeTriggerResultInformation);
        }
        try {
            boolean bl = true;
            if (upgradeTriggerResultInformation.result == 0) {
                this.master.triggerConfirmed(this, this.triggerName, bl);
            } else if (this.isResultOK_WithWarning(upgradeTriggerResultInformation.result)) {
                this.master.triggerConfirmed(this, this.triggerName, bl);
            } else if (upgradeTriggerResultInformation.result == 1 || upgradeTriggerResultInformation.result == 2) {
                Trace.error(this.getClass(), "triggerResponse(UpgradeTriggerResultInformation anUpgradeTriggerResultInformation)", "\n\tanUpgradeTriggerResultInformation.result: " + upgradeTriggerResultInformation.result + "\n\taNoOfNotReady: " + upgradeTriggerResultInformation.noOfNotReady + "\n\taSizeOfNameList: " + upgradeTriggerResultInformation.sizeOfNameList + "\n\taNameList: [ " + upgradeTriggerResultInformation.nameList + " ]" + "\n\ttriggerName: " + this.triggerName + "\n\taTimeout: " + this.timeout);
                bl = false;
                this.master.triggerConfirmed(this, this.triggerName, bl);
            } else if (upgradeTriggerResultInformation.result == 3) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "triggerResponse(UpgradeTriggerResultInformation anUpgradeTriggerResultInformation)", "Send the trigger request once more time since a RPU switch has occured.\n\tanUpgradeTriggerResultInformation.result: " + upgradeTriggerResultInformation.result + "\n\taNoOfNotReady: " + upgradeTriggerResultInformation.noOfNotReady + "\n\taSizeOfNameList: " + upgradeTriggerResultInformation.sizeOfNameList + "\n\taNameList: [ " + upgradeTriggerResultInformation.nameList + " ]" + "\n\ttriggerName: " + this.triggerName + "\n\taTimeout: " + this.timeout);
                }
                this.sendTriggerRequest();
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "triggerResponse(UpgradeTriggerResultInformation anUpgradeTriggerResultInformation)", "\n\tanUpgradeTriggerResultInformation.result: " + upgradeTriggerResultInformation.result + "\n\taNoOfNotReady: " + upgradeTriggerResultInformation.noOfNotReady + "\n\taSizeOfNameList: " + upgradeTriggerResultInformation.sizeOfNameList + "\n\taNameList: [ " + upgradeTriggerResultInformation.nameList + " ]" + "\n\ttriggerName: " + this.triggerName + "\n\taTimeout: " + this.timeout);
                }
                bl = false;
                this.master.triggerConfirmed(this, this.triggerName, bl);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "triggerResponse(UpgradeTriggerResultInformation anUpgradeTriggerResultInformation)", "Throwable caught. Reporting AUE trigger failure\n\tanUpgradeTriggerResultInformation.result: " + upgradeTriggerResultInformation.result + "\n\taNoOfNotReady: " + upgradeTriggerResultInformation.noOfNotReady + "\n\taSizeOfNameList: " + upgradeTriggerResultInformation.sizeOfNameList + "\n\taNameList: [ " + upgradeTriggerResultInformation.nameList + " ]" + "\n\ttriggerName: " + this.triggerName + "\n\taTimeout: " + this.timeout, throwable);
            this.master.triggerConfirmed(this, this.triggerName, false);
        }
        finally {
            this.stopListeningForPropertiesFromC_AUEs();
        }
    }

    private void startListeningForPropertiesFromC_AUEs() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "startListeningForPropertiesFromC_AUEs()");
        }
        try {
            OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
            osaUpiProxyAccess.addPropertyChangeListener(UPI_ProxyPropertyName.AUE_Progress, this);
            osaUpiProxyAccess.addPropertyChangeListener(UPI_ProxyPropertyName.AUE_Confirmed, this);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "startListeningForPropertiesFromC_AUEs()", "Failed to add upgrade logic as listener for progress indications and confirmation indications from C-AUEs (ignored).Throwable data: " + throwable);
        }
    }

    private void stopListeningForPropertiesFromC_AUEs() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopListeningForPropertiesFromC_AUEs()");
        }
        try {
            OsaUpiProxyAccess osaUpiProxyAccess = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
            osaUpiProxyAccess.removePropertyChangeListener(UPI_ProxyPropertyName.AUE_Progress, this);
            osaUpiProxyAccess.removePropertyChangeListener(UPI_ProxyPropertyName.AUE_Confirmed, this);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "stopListeningForPropertiesFromC_AUEs()", "Failed to remove upgrade logic as listener for progress indications and confirmation indications from C-AUEs (ignored).Throwable data: " + throwable);
        }
    }

    private boolean isResultOK_WithWarning(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUPI_ProxyVersion ()");
        }
        try {
            return n == 4;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "isResultOK_WithWarning ( int aResult )", "Failed to detect if the result code from resource is OK with confirmed (assuming not...).Throwable data: " + throwable);
            return false;
        }
    }
}

